/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class IOTestProvider
implements WALProvider {
    private static final Logger LOG = LoggerFactory.getLogger(IOTestProvider.class);
    private static final String ALLOWED_OPERATIONS = "hbase.wal.iotestprovider.operations";
    private WALFactory factory;
    private Configuration conf;
    private volatile FSHLog log;
    private String providerId;
    private List<WALActionsListener> listeners = new ArrayList<WALActionsListener>();

    public void init(WALFactory factory, Configuration conf, String providerId) throws IOException {
        if (factory != null) {
            throw new IllegalStateException("WALProvider.init should only be called once.");
        }
        this.factory = factory;
        this.conf = conf;
        this.providerId = providerId != null ? providerId : "default";
    }

    public List<WAL> getWALs() {
        return Collections.singletonList(this.log);
    }

    private FSHLog createWAL() throws IOException {
        String logPrefix = this.factory.factoryId + "." + this.providerId;
        return new IOTestWAL(CommonFSUtils.getWALFileSystem((Configuration)this.conf), CommonFSUtils.getWALRootDir((Configuration)this.conf), AbstractFSWALProvider.getWALDirectoryName((String)this.factory.factoryId), "oldWALs", this.conf, this.listeners, true, logPrefix, ".meta".equals(this.providerId) ? ".meta" : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WAL getWAL(RegionInfo region) throws IOException {
        FSHLog log = this.log;
        if (log != null) {
            return log;
        }
        IOTestProvider iOTestProvider = this;
        synchronized (iOTestProvider) {
            log = this.log;
            if (log == null) {
                this.log = log = this.createWAL();
            }
        }
        return log;
    }

    public void close() throws IOException {
        FSHLog log = this.log;
        if (log != null) {
            log.close();
        }
    }

    public void shutdown() throws IOException {
        FSHLog log = this.log;
        if (log != null) {
            log.shutdown();
        }
    }

    public long getNumLogFiles() {
        return this.log.getNumLogFiles();
    }

    public long getLogFileSize() {
        return this.log.getLogFileSize();
    }

    public void addWALActionsListener(WALActionsListener listener) {
    }

    private static class IOTestWriter
    extends ProtobufLogWriter {
        private boolean doAppends;
        private boolean doSyncs;

        private IOTestWriter() {
        }

        public void init(FileSystem fs, Path path, Configuration conf, boolean overwritable, long blocksize) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
            Collection operations = conf.getStringCollection(IOTestProvider.ALLOWED_OPERATIONS);
            if (operations.isEmpty() || operations.contains(AllowedOperations.all.name())) {
                this.doSyncs = true;
                this.doAppends = true;
            } else if (operations.contains(AllowedOperations.none.name())) {
                this.doSyncs = false;
                this.doAppends = false;
            } else {
                this.doAppends = operations.contains(AllowedOperations.append.name());
                this.doSyncs = operations.contains(AllowedOperations.sync.name());
            }
            LOG.info("IOTestWriter initialized with appends " + (this.doAppends ? "enabled" : "disabled") + " and syncs " + (this.doSyncs ? "enabled" : "disabled"));
            super.init(fs, path, conf, overwritable, blocksize);
        }

        protected String getWriterClassName() {
            return ProtobufLogWriter.class.getSimpleName();
        }

        public void append(WAL.Entry entry) throws IOException {
            if (this.doAppends) {
                super.append(entry);
            }
        }

        public void sync(boolean forceSync) throws IOException {
            if (this.doSyncs) {
                super.sync(forceSync);
            }
        }
    }

    private static class IOTestWAL
    extends FSHLog {
        private final boolean doFileRolls;
        private final boolean initialized;
        private WALProvider.Writer noRollsWriter;

        public IOTestWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
            super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix);
            Collection operations = conf.getStringCollection(IOTestProvider.ALLOWED_OPERATIONS);
            this.doFileRolls = operations.isEmpty() || operations.contains(AllowedOperations.all.name()) || operations.contains(AllowedOperations.fileroll.name());
            this.initialized = true;
            LOG.info("Initialized with file rolling " + (this.doFileRolls ? "enabled" : "disabled"));
        }

        protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
            if (!this.initialized || this.doFileRolls) {
                LOG.info("creating new writer instance.");
                IOTestWriter writer = new IOTestWriter();
                try {
                    writer.init(this.fs, path, this.conf, false, this.blocksize);
                }
                catch (CommonFSUtils.StreamLacksCapabilityException exception) {
                    throw new IOException("Can't create writer instance because underlying FileSystem doesn't support needed stream capabilities.", exception);
                }
                if (!this.initialized) {
                    LOG.info("storing initial writer instance in case file rolling isn't allowed.");
                    this.noRollsWriter = writer;
                }
                return writer;
            }
            LOG.info("WAL rolling disabled, returning the first writer.");
            return this.noRollsWriter;
        }
    }

    private static enum AllowedOperations {
        all,
        append,
        sync,
        fileroll,
        none;

    }
}

