/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.generated.master;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.PageContextImpl;
import org.glassfish.jsp.api.ResourceInjector;

public final class table_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static List<String> _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    private RegionMetrics getEmptyRegionMetrics(RegionInfo regionInfo) {
        return RegionMetricsBuilder.toRegionMetrics((ClusterStatusProtos.RegionLoad)ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME).setValue(ByteString.copyFrom((byte[])regionInfo.getRegionName())).build()).build());
    }

    public List<String> getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block108: {
            PageContext pageContext = null;
            HttpSession session = null;
            ServletContext application = null;
            ServletConfig config = null;
            JspWriter out = null;
            table_jsp page = this;
            JspWriter _jspx_out = null;
            PageContext _jspx_page_context = null;
            try {
                boolean showWhole;
                boolean reverseOrder;
                String sortKey;
                String fqtn;
                block106: {
                    response.setContentType("text/html;charset=UTF-8");
                    _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                    application = pageContext.getServletContext();
                    config = pageContext.getServletConfig();
                    session = pageContext.getSession();
                    _jspx_out = out = pageContext.getOut();
                    this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                    out.write("\n\n\n\n\n\n\n\n\n\n\n");
                    out.write(10);
                    HMaster master = (HMaster)this.getServletContext().getAttribute("master");
                    Configuration conf = master.getConfiguration();
                    MetaTableLocator metaTableLocator = new MetaTableLocator();
                    fqtn = request.getParameter("name");
                    String escaped_fqtn = StringEscapeUtils.escapeHtml4((String)fqtn);
                    sortKey = request.getParameter("sort");
                    String reverse = request.getParameter("reverse");
                    reverseOrder = reverse == null || !reverse.equals("false");
                    String showWholeKey = request.getParameter("showwhole");
                    showWhole = showWholeKey != null && showWholeKey.equals("true");
                    boolean withReplica = false;
                    boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
                    boolean readOnly = conf.getBoolean("hbase.master.ui.readonly", false);
                    int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
                    Map<String, Integer> frags = null;
                    if (showFragmentation) {
                        frags = FSUtils.getTableFragmentation(master);
                    }
                    boolean quotasEnabled = conf.getBoolean("hbase.quota.enabled", false);
                    String action = request.getParameter("action");
                    String key = request.getParameter("key");
                    String left = request.getParameter("left");
                    String right = request.getParameter("right");
                    long totalStoreFileSizeMB = 0L;
                    String numRegionsParam = request.getParameter("numRegions");
                    int numRegionsToRender = 10000;
                    if (numRegionsParam != null) {
                        if (numRegionsParam.equals("all")) {
                            numRegionsToRender = -1;
                        } else {
                            try {
                                numRegionsToRender = Integer.parseInt(numRegionsParam);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    int numRegions = 0;
                    String pageTitle = !readOnly && action != null ? "HBase Master: " + StringEscapeUtils.escapeHtml4((String)master.getServerName().toString()) : "Table: " + escaped_fqtn;
                    pageContext.setAttribute("pageTitle", (Object)pageTitle);
                    out.write(10);
                    out.write(10);
                    JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)("header.jsp?" + JspRuntimeLibrary.URLEncode((String)"pageTitle", (String)request.getCharacterEncoding()) + "=" + JspRuntimeLibrary.URLEncode((String)((String)PageContextImpl.evaluateExpression((String)"${pageTitle}", String.class, (PageContext)_jspx_page_context, null)), (String)request.getCharacterEncoding())), (JspWriter)out, (boolean)false);
                    out.write(10);
                    out.write(10);
                    if (fqtn != null) {
                        try {
                            String tableHeader;
                            Table table = master.getConnection().getTable(TableName.valueOf((String)fqtn));
                            if (table.getTableDescriptor().getRegionReplication() > 1) {
                                tableHeader = "<h2>Table Regions</h2><table class=\"table table-striped\" style=\"table-layout: fixed; word-wrap: break-word;\"><tr><th>Name</th><th>Region Server</th><th>ReadRequests</th><th>WriteRequests</th><th>StorefileSize</th><th>Num.Storefiles</th><th>MemSize</th><th>Locality</th><th>Start Key</th><th>End Key</th><th>ReplicaID</th></tr>";
                                withReplica = true;
                            } else {
                                tableHeader = "<h2>Table Regions</h2><table class=\"table table-striped\" style=\"table-layout: fixed; word-wrap: break-word;\"><tr><th>Name</th><th>Region Server</th><th>ReadRequests</th><th>WriteRequests</th><th>StorefileSize</th><th>Num.Storefiles</th><th>MemSize</th><th>Locality</th><th>Start Key</th><th>End Key</th></tr>";
                            }
                            if (!readOnly && action != null) {
                                out.write("\n<div class=\"container-fluid content\">\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Table action request accepted</h1>\n            </div>\n        </div>\n<p><hr><p>\n");
                                try (Admin admin = master.getConnection().getAdmin();){
                                    if (action.equals("split")) {
                                        if (key != null && key.length() > 0) {
                                            admin.split(TableName.valueOf((String)fqtn), Bytes.toBytes((String)key));
                                        } else {
                                            admin.split(TableName.valueOf((String)fqtn));
                                        }
                                        out.write(" Split request accepted. ");
                                    } else if (action.equals("compact")) {
                                        if (key != null && key.length() > 0) {
                                            List regions = admin.getRegions(TableName.valueOf((String)fqtn));
                                            byte[] row = Bytes.toBytes((String)key);
                                            for (RegionInfo region : regions) {
                                                if (!region.containsRow(row)) continue;
                                                admin.compactRegion(region.getRegionName());
                                            }
                                        } else {
                                            admin.compact(TableName.valueOf((String)fqtn));
                                        }
                                        out.write(" Compact request accepted. ");
                                    } else if (action.equals("merge")) {
                                        if (left != null && left.length() > 0 && right != null && right.length() > 0) {
                                            admin.mergeRegions(Bytes.toBytesBinary((String)left), Bytes.toBytesBinary((String)right), false);
                                        }
                                        out.write(" Merge request accepted. ");
                                    }
                                }
                                out.write(10);
                                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                                out.write("\n</div>\n");
                                break block106;
                            }
                            out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Table <small>");
                            out.print(escaped_fqtn);
                            out.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n");
                            if (fqtn.equals(TableName.META_TABLE_NAME.getNameAsString())) {
                                out.write(10);
                                out.print(tableHeader);
                                out.write(10);
                                for (int j = 0; j < numMetaReplicas; ++j) {
                                    RegionInfo meta = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)j);
                                    ServerName metaLocation = metaTableLocator.waitMetaRegionLocation(master.getZooKeeper(), j, 1L);
                                    for (int i = 0; i < 1; ++i) {
                                        String hostAndPort = "";
                                        String readReq = "N/A";
                                        String writeReq = "N/A";
                                        String fileSize = "N/A";
                                        String fileCount = "N/A";
                                        String memSize = "N/A";
                                        float locality = 0.0f;
                                        if (metaLocation != null) {
                                            Map map;
                                            ServerMetrics sl = master.getServerManager().getLoad(metaLocation);
                                            hostAndPort = URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation);
                                            if (sl != null && (map = sl.getRegionMetrics()).containsKey(meta.getRegionName())) {
                                                RegionMetrics load = (RegionMetrics)map.get(meta.getRegionName());
                                                readReq = String.format("%,1d", load.getReadRequestCount());
                                                writeReq = String.format("%,1d", load.getWriteRequestCount());
                                                fileSize = StringUtils.byteDesc((long)((long)load.getStoreFileSize().get(Size.Unit.BYTE)));
                                                fileCount = String.format("%,1d", load.getStoreFileCount());
                                                memSize = StringUtils.byteDesc((long)((long)load.getMemStoreSize().get(Size.Unit.BYTE)));
                                                locality = load.getDataLocality();
                                            }
                                        }
                                        out.write("\n<tr>\n  <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)meta.getRegionNameAsString()));
                                        out.write("</td>\n    <td><a href=\"http://");
                                        out.print(hostAndPort);
                                        out.write("/\">");
                                        out.print(StringEscapeUtils.escapeHtml4((String)hostAndPort));
                                        out.write("</a></td>\n    <td>");
                                        out.print(readReq);
                                        out.write("</td>\n    <td>");
                                        out.print(writeReq);
                                        out.write("</td>\n    <td>");
                                        out.print(fileSize);
                                        out.write("</td>\n    <td>");
                                        out.print(fileCount);
                                        out.write("</td>\n    <td>");
                                        out.print(memSize);
                                        out.write("</td>\n    <td>");
                                        out.print(locality);
                                        out.write("</td>\n    <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)Bytes.toString((byte[])meta.getStartKey())));
                                        out.write("</td>\n    <td>");
                                        out.print(StringEscapeUtils.escapeXml((String)Bytes.toString((byte[])meta.getEndKey())));
                                        out.write("</td>\n");
                                        if (withReplica) {
                                            out.write("\n    <td>");
                                            out.print(meta.getReplicaId());
                                            out.write("</td>\n");
                                        }
                                        out.write("\n</tr>\n");
                                    }
                                    out.write(10);
                                }
                                out.write("\n</table>\n");
                            } else {
                                Admin admin = master.getConnection().getAdmin();
                                RegionLocator r = master.getClusterConnection().getRegionLocator(table.getName());
                                try {
                                    out.write("\n<h2>Table Attributes</h2>\n<table class=\"table table-striped\">\n  <tr>\n      <th>Attribute Name</th>\n      <th>Value</th>\n      <th>Description</th>\n  </tr>\n  <tr>\n      <td>Enabled</td>\n      <td>");
                                    out.print(admin.isTableEnabled(table.getName()));
                                    out.write("</td>\n      <td>Is the table enabled</td>\n  </tr>\n  <tr>\n      <td>Compaction</td>\n      <td>\n");
                                    try {
                                        CompactionState compactionState = admin.getCompactionState(table.getName());
                                        out.write(10);
                                        out.print((Object)compactionState);
                                        out.write(10);
                                    }
                                    catch (Exception e) {
                                        for (StackTraceElement element : e.getStackTrace()) {
                                            out.print(StringEscapeUtils.escapeHtml4((String)element.toString()));
                                        }
                                        out.write(" Unknown ");
                                    }
                                    out.write("\n      </td>\n      <td>Is the table compacting</td>\n  </tr>\n");
                                    if (showFragmentation) {
                                        out.write("\n  <tr>\n      <td>Fragmentation</td>\n      <td>");
                                        out.print(frags.get(fqtn) != null ? frags.get(fqtn) + "%" : "n/a");
                                        out.write("</td>\n      <td>How fragmented is the table. After a major compaction it is 0%.</td>\n  </tr>\n");
                                    }
                                    out.write(10);
                                    if (quotasEnabled) {
                                        TableName tn = TableName.valueOf((String)fqtn);
                                        SpaceQuotaSnapshot masterSnapshot = null;
                                        QuotaProtos.Quotas quota = QuotaTableUtil.getTableQuota((Connection)master.getConnection(), (TableName)tn);
                                        if (quota == null || !quota.hasSpace()) {
                                            quota = QuotaTableUtil.getNamespaceQuota((Connection)master.getConnection(), (String)tn.getNamespaceAsString());
                                            if (quota != null) {
                                                masterSnapshot = QuotaTableUtil.getCurrentSnapshot((Connection)master.getConnection(), (String)tn.getNamespaceAsString());
                                            }
                                        } else {
                                            masterSnapshot = QuotaTableUtil.getCurrentSnapshot((Connection)master.getConnection(), (TableName)tn);
                                        }
                                        if (quota != null && quota.hasSpace()) {
                                            QuotaProtos.SpaceQuota spaceQuota = quota.getSpace();
                                            out.write("\n  <tr>\n    <td>Space Quota</td>\n    <td>\n      <table>\n        <tr>\n          <th>Property</th>\n          <th>Value</th>\n        </tr>\n        <tr>\n          <td>Limit</td>\n          <td>");
                                            out.print(StringUtils.byteDesc((long)spaceQuota.getSoftLimit()));
                                            out.write("</td>\n        </tr>\n        <tr>\n          <td>Policy</td>\n          <td>");
                                            out.print((Object)spaceQuota.getViolationPolicy());
                                            out.write("</td>\n        </tr>\n");
                                            if (masterSnapshot != null) {
                                                out.write("\n        <tr>\n          <td>Usage</td>\n          <td>");
                                                out.print(StringUtils.byteDesc((long)masterSnapshot.getUsage()));
                                                out.write("</td>\n        </tr>\n        <tr>\n          <td>State</td>\n          <td>");
                                                out.print(masterSnapshot.getQuotaStatus().isInViolation() ? "In Violation" : "In Observance");
                                                out.write("</td>\n        </tr>\n");
                                            }
                                            out.write("\n      </table>\n    </td>\n    <td>Information about a Space Quota on this table, if set.</td>\n  </tr>\n");
                                        }
                                    }
                                    out.write("\n</table>\n<h2>Table Schema</h2>\n<table class=\"table table-striped\">\n  <tr>\n      <th>Column Name</th>\n      <th></th>\n  </tr>\n  ");
                                    Collection families = table.getTableDescriptor().getFamilies();
                                    for (HColumnDescriptor family : families) {
                                        out.write("\n  <tr>\n    <td>");
                                        out.print(StringEscapeUtils.escapeHtml4((String)family.getNameAsString()));
                                        out.write("</td>\n    <td>\n    <table class=\"table table-striped\">\n      <tr>\n       <th>Property</th>\n       <th>Value</th>\n      </tr>\n    ");
                                        Map familyValues = family.getValues();
                                        for (Bytes familyKey : familyValues.keySet()) {
                                            out.write("\n      <tr>\n        <td>\n          ");
                                            out.print(StringEscapeUtils.escapeHtml4((String)familyKey.toString()));
                                            out.write("\n\t\t</td>\n        <td>\n          ");
                                            out.print(StringEscapeUtils.escapeHtml4((String)((Bytes)familyValues.get(familyKey)).toString()));
                                            out.write("\n        </td>\n      </tr>\n    ");
                                        }
                                        out.write("\n    </table>\n    </td>\n  </tr>\n  ");
                                    }
                                    out.write("\n</table>\n");
                                    long totalReadReq = 0L;
                                    long totalWriteReq = 0L;
                                    long totalSize = 0L;
                                    long totalStoreFileCount = 0L;
                                    long totalMemSize = 0L;
                                    String urlRegionServer = null;
                                    TreeMap<ServerName, Integer> regDistribution = new TreeMap<ServerName, Integer>();
                                    TreeMap<ServerName, Integer> primaryRegDistribution = new TreeMap<ServerName, Integer>();
                                    List regions = r.getAllRegionLocations();
                                    LinkedHashMap<HRegionInfo, RegionMetrics> regionsToLoad = new LinkedHashMap<HRegionInfo, RegionMetrics>();
                                    LinkedHashMap<HRegionInfo, ServerName> regionsToServer = new LinkedHashMap<HRegionInfo, ServerName>();
                                    for (HRegionLocation hriEntry : regions) {
                                        HRegionInfo regionInfo = hriEntry.getRegionInfo();
                                        ServerName serverName = hriEntry.getServerName();
                                        regionsToServer.put(regionInfo, serverName);
                                        if (serverName != null) {
                                            ServerMetrics sl = master.getServerManager().getLoad(serverName);
                                            if (sl != null) {
                                                RegionMetrics regionMetrics = (RegionMetrics)sl.getRegionMetrics().get(regionInfo.getRegionName());
                                                regionsToLoad.put(regionInfo, regionMetrics);
                                                if (regionMetrics != null) {
                                                    totalReadReq += regionMetrics.getReadRequestCount();
                                                    totalWriteReq += regionMetrics.getWriteRequestCount();
                                                    totalSize = (long)((double)totalSize + regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE));
                                                    totalStoreFileCount += (long)regionMetrics.getStoreFileCount();
                                                    totalMemSize = (long)((double)totalMemSize + regionMetrics.getMemStoreSize().get(Size.Unit.MEGABYTE));
                                                    totalStoreFileSizeMB = (long)((double)totalStoreFileSizeMB + regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE));
                                                    continue;
                                                }
                                                RegionMetrics load0 = this.getEmptyRegionMetrics((RegionInfo)regionInfo);
                                                regionsToLoad.put(regionInfo, load0);
                                                continue;
                                            }
                                            RegionMetrics load0 = this.getEmptyRegionMetrics((RegionInfo)regionInfo);
                                            regionsToLoad.put(regionInfo, load0);
                                            continue;
                                        }
                                        RegionMetrics load0 = this.getEmptyRegionMetrics((RegionInfo)regionInfo);
                                        regionsToLoad.put(regionInfo, load0);
                                    }
                                    if (regions != null && regions.size() > 0) {
                                        out.write("\n<h2>Table Regions</h2>\nSort As\n<select id=\"sel\" style=\"margin-right: 10px\">\n<option value=\"regionName\">RegionName</option>\n<option value=\"readrequest\">ReadRequest</option>\n<option value=\"writerequest\">WriteRequest</option>\n<option value=\"size\">StorefileSize</option>\n<option value=\"filecount\">Num.Storefiles</option>\n<option value=\"memstore\">MemstoreSize</option>\n<option value=\"locality\">Locality</option>\n</select>\nAscending<input type=\"checkbox\" id=\"ascending\" value=\"Ascending\" style=\"margin-right:10px\">\nShowDetailName&Start/End Key<input type=\"checkbox\" id=\"showWhole\" style=\"margin-right:10px\">\n<input type=\"button\" id=\"submit\" value=\"Reorder\" onClick=\"reloadAsSort()\" style=\"font-size: 12pt; width: 5em; margin-bottom: 5px\" class=\"btn\">\n<p>\n\n<table class=\"table table-striped\">\n<tr>\n<th>Name(");
                                        out.print(String.format("%,1d", regions.size()));
                                        out.write(")</th>\n<th>Region Server</th>\n<th>ReadRequests<br>(");
                                        out.print(String.format("%,1d", totalReadReq));
                                        out.write(")</th>\n<th>WriteRequests<br>(");
                                        out.print(String.format("%,1d", totalWriteReq));
                                        out.write(")</th>\n<th>StorefileSize<br>(");
                                        out.print(StringUtils.byteDesc((long)(totalSize * 1024L * 1024L)));
                                        out.write(")</th>\n<th>Num.Storefiles<br>(");
                                        out.print(String.format("%,1d", totalStoreFileCount));
                                        out.write(")</th>\n<th>MemSize<br>(");
                                        out.print(StringUtils.byteDesc((long)(totalMemSize * 1024L * 1024L)));
                                        out.write(")</th>\n<th>Locality</th>\n<th>Start Key</th>\n<th>End Key</th>\n");
                                        if (withReplica) {
                                            out.write("\n<th>ReplicaID</th>\n");
                                        }
                                        out.write("\n</tr>\n\n");
                                        ArrayList entryList = new ArrayList(regionsToLoad.entrySet());
                                        if (sortKey != null) {
                                            if (sortKey.equals("readrequest")) {
                                                Collections.sort(entryList, (entry1, entry2) -> {
                                                    if (entry1 == null || entry1.getValue() == null) {
                                                        return -1;
                                                    }
                                                    if (entry2 == null || entry2.getValue() == null) {
                                                        return 1;
                                                    }
                                                    int result = Long.compare(((RegionMetrics)entry1.getValue()).getReadRequestCount(), ((RegionMetrics)entry2.getValue()).getReadRequestCount());
                                                    if (reverseOrder) {
                                                        result = -1 * result;
                                                    }
                                                    return result;
                                                });
                                            } else if (sortKey.equals("writerequest")) {
                                                Collections.sort(entryList, (entry1, entry2) -> {
                                                    if (entry1 == null || entry1.getValue() == null) {
                                                        return -1;
                                                    }
                                                    if (entry2 == null || entry2.getValue() == null) {
                                                        return 1;
                                                    }
                                                    int result = Long.compare(((RegionMetrics)entry1.getValue()).getWriteRequestCount(), ((RegionMetrics)entry2.getValue()).getWriteRequestCount());
                                                    if (reverseOrder) {
                                                        result = -1 * result;
                                                    }
                                                    return result;
                                                });
                                            } else if (sortKey.equals("size")) {
                                                Collections.sort(entryList, (entry1, entry2) -> {
                                                    if (entry1 == null || entry1.getValue() == null) {
                                                        return -1;
                                                    }
                                                    if (entry2 == null || entry2.getValue() == null) {
                                                        return 1;
                                                    }
                                                    int result = Double.compare(((RegionMetrics)entry1.getValue()).getStoreFileSize().get(), ((RegionMetrics)entry2.getValue()).getStoreFileSize().get());
                                                    if (reverseOrder) {
                                                        result = -1 * result;
                                                    }
                                                    return result;
                                                });
                                            } else if (sortKey.equals("filecount")) {
                                                Collections.sort(entryList, (entry1, entry2) -> {
                                                    if (entry1 == null || entry1.getValue() == null) {
                                                        return -1;
                                                    }
                                                    if (entry2 == null || entry2.getValue() == null) {
                                                        return 1;
                                                    }
                                                    int result = Integer.compare(((RegionMetrics)entry1.getValue()).getStoreCount(), ((RegionMetrics)entry2.getValue()).getStoreCount());
                                                    if (reverseOrder) {
                                                        result = -1 * result;
                                                    }
                                                    return result;
                                                });
                                            } else if (sortKey.equals("memstore")) {
                                                Collections.sort(entryList, (entry1, entry2) -> {
                                                    if (entry1 == null || entry1.getValue() == null) {
                                                        return -1;
                                                    }
                                                    if (entry2 == null || entry2.getValue() == null) {
                                                        return 1;
                                                    }
                                                    int result = Double.compare(((RegionMetrics)entry1.getValue()).getMemStoreSize().get(), ((RegionMetrics)entry2.getValue()).getMemStoreSize().get());
                                                    if (reverseOrder) {
                                                        result = -1 * result;
                                                    }
                                                    return result;
                                                });
                                            } else if (sortKey.equals("locality")) {
                                                Collections.sort(entryList, (entry1, entry2) -> {
                                                    if (entry1 == null || entry1.getValue() == null) {
                                                        return -1;
                                                    }
                                                    if (entry2 == null || entry2.getValue() == null) {
                                                        return 1;
                                                    }
                                                    int result = Double.compare(((RegionMetrics)entry1.getValue()).getDataLocality(), ((RegionMetrics)entry2.getValue()).getDataLocality());
                                                    if (reverseOrder) {
                                                        result = -1 * result;
                                                    }
                                                    return result;
                                                });
                                            }
                                        }
                                        numRegions = regions.size();
                                        int numRegionsRendered = 0;
                                        if (numRegionsToRender < 0) {
                                            numRegionsToRender = numRegions;
                                        }
                                        for (Map.Entry entry : entryList) {
                                            RegionInfo regionInfo = (RegionInfo)entry.getKey();
                                            ServerName addr = (ServerName)regionsToServer.get(regionInfo);
                                            RegionMetrics load = (RegionMetrics)entry.getValue();
                                            String readReq = "N/A";
                                            String writeReq = "N/A";
                                            String regionSize = "N/A";
                                            String fileCount = "N/A";
                                            String memSize = "N/A";
                                            float locality = 0.0f;
                                            if (load != null) {
                                                readReq = String.format("%,1d", load.getReadRequestCount());
                                                writeReq = String.format("%,1d", load.getWriteRequestCount());
                                                regionSize = StringUtils.byteDesc((long)((long)load.getStoreFileSize().get(Size.Unit.BYTE)));
                                                fileCount = String.format("%,1d", load.getStoreFileCount());
                                                memSize = StringUtils.byteDesc((long)((long)load.getMemStoreSize().get(Size.Unit.BYTE)));
                                                locality = load.getDataLocality();
                                            }
                                            if (addr != null) {
                                                ServerMetrics sl = master.getServerManager().getLoad(addr);
                                                urlRegionServer = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/";
                                                if (sl != null) {
                                                    Integer i = (Integer)regDistribution.get(addr);
                                                    if (null == i) {
                                                        i = 0;
                                                    }
                                                    regDistribution.put(addr, i + 1);
                                                    if (withReplica && RegionReplicaUtil.isDefaultReplica((int)regionInfo.getReplicaId())) {
                                                        i = (Integer)primaryRegDistribution.get(addr);
                                                        if (null == i) {
                                                            i = 0;
                                                        }
                                                        primaryRegDistribution.put(addr, i + 1);
                                                    }
                                                }
                                            }
                                            if (numRegionsRendered < numRegionsToRender) {
                                                ++numRegionsRendered;
                                                out.write("\n<tr>\n  <td>");
                                                out.print(StringEscapeUtils.escapeXml((String)(showWhole ? Bytes.toStringBinary((byte[])regionInfo.getRegionName()) : regionInfo.getEncodedName())));
                                                out.write("</td>\n  ");
                                                if (urlRegionServer != null) {
                                                    out.write("\n  <td>\n     <a href=\"");
                                                    out.print(urlRegionServer);
                                                    out.write(34);
                                                    out.write(62);
                                                    out.print(StringEscapeUtils.escapeHtml4((String)addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                                    out.write("</a>\n  </td>\n  ");
                                                } else {
                                                    out.write("\n  <td class=\"undeployed-region\">not deployed</td>\n  ");
                                                }
                                                out.write("\n  <td>");
                                                out.print(readReq);
                                                out.write("</td>\n  <td>");
                                                out.print(writeReq);
                                                out.write("</td>\n  <td>");
                                                out.print(regionSize);
                                                out.write("</td>\n  <td>");
                                                out.print(fileCount);
                                                out.write("</td>\n  <td>");
                                                out.print(memSize);
                                                out.write("</td>\n  <td>");
                                                out.print(locality);
                                                out.write("</td>\n  <td>");
                                                out.print(StringEscapeUtils.escapeXml((String)(showWhole ? Bytes.toStringBinary((byte[])regionInfo.getStartKey()) : "-")));
                                                out.write("</td>\n  <td>");
                                                out.print(StringEscapeUtils.escapeXml((String)(showWhole ? Bytes.toStringBinary((byte[])regionInfo.getEndKey()) : "-")));
                                                out.write("</td>\n  ");
                                                if (withReplica) {
                                                    out.write("\n  <td>");
                                                    out.print(regionInfo.getReplicaId());
                                                    out.write("</td>\n  ");
                                                }
                                                out.write("\n</tr>\n");
                                            }
                                            out.write(10);
                                        }
                                        out.write("\n</table>\n");
                                        if (numRegions > numRegionsRendered) {
                                            String allRegionsUrl = "?name=" + URLEncoder.encode(fqtn, "UTF-8") + "&numRegions=all";
                                            out.write("\n  <p>This table has <b>");
                                            out.print(numRegions);
                                            out.write("</b> regions in total, in order to improve the page load time,\n     only <b>");
                                            out.print(numRegionsRendered);
                                            out.write("</b> regions are displayed here, <a href=\"");
                                            out.print(allRegionsUrl);
                                            out.write("\">click\n     here</a> to see all regions.</p>\n");
                                        }
                                        out.write("\n<h2>Regions by Region Server</h2>\n");
                                        if (withReplica) {
                                            out.write("\n<table class=\"table table-striped\"><tr><th>Region Server</th><th>Region Count</th><th>Primary Region Count</th></tr>\n");
                                        } else {
                                            out.write("\n<table class=\"table table-striped\"><tr><th>Region Server</th><th>Region Count</th></tr>\n");
                                        }
                                        out.write(10);
                                        for (Map.Entry entry : regDistribution.entrySet()) {
                                            ServerName addr = (ServerName)entry.getKey();
                                            String url = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/";
                                            out.write("\n<tr>\n  <td><a href=\"");
                                            out.print(url);
                                            out.write(34);
                                            out.write(62);
                                            out.print(StringEscapeUtils.escapeHtml4((String)addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                            out.write("</a></td>\n  <td>");
                                            out.print(entry.getValue());
                                            out.write("</td>\n");
                                            if (withReplica) {
                                                out.write("\n  <td>");
                                                out.print(primaryRegDistribution.get(addr));
                                                out.write("</td>\n");
                                            }
                                            out.write("\n</tr>\n");
                                        }
                                        out.write("\n</table>\n");
                                    }
                                }
                                catch (Exception ex) {
                                    for (StackTraceElement element : ex.getStackTrace()) {
                                        out.print(StringEscapeUtils.escapeHtml4((String)element.toString()));
                                    }
                                }
                                finally {
                                    admin.close();
                                }
                            }
                            out.write("\n\n<h2>Table Stats</h2>\n<table class=\"table table-striped\">\n  <tr>\n    <th>Name</th>\n    <th>Value</th>\n    <th>Description</th>\n  </tr>\n  <tr>\n    <td>Size</td>\n    <td>");
                            out.print(StringUtils.TraditionalBinaryPrefix.long2String((long)(totalStoreFileSizeMB * 1024L * 1024L), (String)"B", (int)2));
                            out.write("</td>\n    <td>Total size of store files</td>\n  </tr>\n</table>\n\n");
                            if (!readOnly) {
                                out.write("\n<p><hr/></p>\nActions:\n<p>\n<center>\n<table class=\"table\" style=\"border: 0;\" width=\"95%\" >\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"compact\" />\n  <input type=\"hidden\" name=\"name\" value=\"");
                                out.print(escaped_fqtn);
                                out.write("\" />\n  <td class=\"centered\">\n    <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Compact\" class=\"btn\" />\n  </td>\n  <td style=\"text-align: center;\">\n    <input type=\"text\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n  </td>\n  <td>\n    This action will force a compaction of all regions of the table, or,\n    if a key is supplied, only the region containing the\n    given key.\n  </td>\n  </form>\n</tr>\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"split\" />\n  <input type=\"hidden\" name=\"name\" value=\"");
                                out.print(escaped_fqtn);
                                out.write("\" />\n  <td class=\"centered\">\n    <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Split\" class=\"btn\" />\n  </td>\n  <td style=\"text-align: center;\">\n    <input type=\"text\" name=\"key\" size=\"40\" placeholder=\"Row Key (optional)\" />\n  </td>\n  <td>\n\t  This action will force a split of all eligible\n\t  regions of the table, or, if a key is supplied, only the region containing the\n\t  given key. An eligible region is one that does not contain any references to\n\t  other regions. Split requests for noneligible regions will be ignored.\n  </td>\n  </form>\n</tr>\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"merge\" />\n  <input type=\"hidden\" name=\"name\" value=\"");
                                out.print(escaped_fqtn);
                                out.write("\" />\n  <td class=\"centered\">\n    <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Merge\" class=\"btn\" />\n  </td>\n  <td style=\"text-align: center;\">\n    <input type=\"text\" name=\"left\" size=\"40\" placeholder=\"Region Key (required)\" />\n    <input type=\"text\" name=\"right\" size=\"40\" placeholder=\"Region Key (required)\" />\n  </td>\n  <td>\n    This action will merge two regions of the table, Merge requests for\n    noneligible regions will be ignored.\n  </td>\n  </form>\n</tr>\n</table>\n</center>\n</p>\n");
                            }
                            out.write("\n</div>\n</div>\n");
                        }
                        catch (TableNotFoundException e) {
                            out.write("\n  <div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n      <div class=\"page-header\">\n        <h1>Table not found</h1>\n       </div>\n    </div>\n    <p><hr><p>\n    <p>Go <a href=\"javascript:history.back()\">Back</a>\n  </div> ");
                        }
                        catch (IllegalArgumentException e) {
                            out.write("\n  <div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n      <div class=\"page-header\">\n        <h1>Table qualifier must not be empty</h1>\n      </div>\n    </div>\n    <p><hr><p>\n    <p>Go <a href=\"javascript:history.back()\">Back</a>\n  </div> ");
                        }
                    } else {
                        out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Table not ready</h1>\n        </div>\n    </div>\n<p><hr><p>\n");
                        JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"redirect.jsp", (JspWriter)out, (boolean)false);
                        out.write("\n</div>\n");
                    }
                }
                out.write(10);
                out.write(10);
                JspRuntimeLibrary.include((ServletRequest)request, (ServletResponse)response, (String)"footer.jsp", (JspWriter)out, (boolean)false);
                out.write("\n\n<script>\nvar index=0;\nvar sortKeyValue='");
                out.print(StringEscapeUtils.escapeEcmaScript((String)sortKey));
                out.write("';\nif(sortKeyValue==\"readrequest\")index=1;\nelse if(sortKeyValue==\"writerequest\")index=2;\nelse if(sortKeyValue==\"size\")index=3;\nelse if(sortKeyValue==\"filecount\")index=4;\nelse if(sortKeyValue==\"memstore\")index=5;\nelse if(sortKeyValue==\"locality\")index=6;\ndocument.getElementById(\"sel\").selectedIndex=index;\n\n");
                out.write("\nvar reverse='");
                out.print(reverseOrder);
                out.write("';\nif(reverse=='false')document.getElementById(\"ascending\").checked=true;\n\n");
                out.write("\nvar showWhole='");
                out.print(showWhole);
                out.write("';\nif(showWhole=='true')document.getElementById(\"showWhole\").checked=true;\n\nfunction reloadAsSort(){\n  var url=\"?name=\"+'");
                out.print(URLEncoder.encode(fqtn));
                out.write("';\n  if(document.getElementById(\"sel\").selectedIndex>0){\n    url=url+\"&sort=\"+document.getElementById(\"sel\").value;\n  }\n  if(document.getElementById(\"ascending\").checked){\n    url=url+\"&reverse=false\";\n  }\n  if(document.getElementById(\"showWhole\").checked){\n    url=url+\"&showwhole=true\";\n  }\n  location.href=url;\n}\n</script>\n");
            }
            catch (Throwable t) {
                try {
                    if (t instanceof SkipPageException) break block108;
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                    throw new ServletException(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

