/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.replication.regionserver.RefreshPeerCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RefreshPeerProcedure
extends Procedure<MasterProcedureEnv>
implements PeerProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Logger LOG = LoggerFactory.getLogger(RefreshPeerProcedure.class);
    private String peerId;
    private PeerProcedureInterface.PeerOperationType type;
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Will never change after construction")
    private ServerName targetServer;
    private boolean dispatched;
    private ProcedureEvent<?> event;
    private boolean succ;

    public RefreshPeerProcedure() {
    }

    public RefreshPeerProcedure(String peerId, PeerProcedureInterface.PeerOperationType type, ServerName targetServer) {
        this.peerId = peerId;
        this.type = type;
        this.targetServer = targetServer;
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.REFRESH;
    }

    private static MasterProcedureProtos.PeerModificationType toPeerModificationType(PeerProcedureInterface.PeerOperationType type) {
        switch (type) {
            case ADD: {
                return MasterProcedureProtos.PeerModificationType.ADD_PEER;
            }
            case REMOVE: {
                return MasterProcedureProtos.PeerModificationType.REMOVE_PEER;
            }
            case ENABLE: {
                return MasterProcedureProtos.PeerModificationType.ENABLE_PEER;
            }
            case DISABLE: {
                return MasterProcedureProtos.PeerModificationType.DISABLE_PEER;
            }
            case UPDATE_CONFIG: {
                return MasterProcedureProtos.PeerModificationType.UPDATE_PEER_CONFIG;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    private static PeerProcedureInterface.PeerOperationType toPeerOperationType(MasterProcedureProtos.PeerModificationType type) {
        switch (type) {
            case ADD_PEER: {
                return PeerProcedureInterface.PeerOperationType.ADD;
            }
            case REMOVE_PEER: {
                return PeerProcedureInterface.PeerOperationType.REMOVE;
            }
            case ENABLE_PEER: {
                return PeerProcedureInterface.PeerOperationType.ENABLE;
            }
            case DISABLE_PEER: {
                return PeerProcedureInterface.PeerOperationType.DISABLE;
            }
            case UPDATE_PEER_CONFIG: {
                return PeerProcedureInterface.PeerOperationType.UPDATE_CONFIG;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public RemoteProcedureDispatcher.RemoteOperation remoteCallBuild(MasterProcedureEnv env, ServerName remote) {
        assert (this.targetServer.equals((Object)remote));
        return new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), RefreshPeerCallable.class, MasterProcedureProtos.RefreshPeerParameter.newBuilder().setPeerId(this.peerId).setType(RefreshPeerProcedure.toPeerModificationType(this.type)).setTargetServer(ProtobufUtil.toServerName((ServerName)remote)).build().toByteArray());
    }

    private void complete(MasterProcedureEnv env, Throwable error) {
        if (this.event == null) {
            LOG.warn("procedure event for {} is null, maybe the procedure is created when recovery", (Object)this.getProcId());
            return;
        }
        if (error != null) {
            LOG.warn("Refresh peer {} for {} on {} failed", new Object[]{this.peerId, this.type, this.targetServer, error});
            this.succ = false;
        } else {
            LOG.info("Refresh peer {} for {} on {} suceeded", new Object[]{this.peerId, this.type, this.targetServer});
            this.succ = true;
        }
        this.event.wake((AbstractProcedureScheduler)env.getProcedureScheduler());
        this.event = null;
    }

    public synchronized void remoteCallFailed(MasterProcedureEnv env, ServerName remote, IOException exception) {
        this.complete(env, exception);
    }

    public synchronized void remoteOperationCompleted(MasterProcedureEnv env) {
        this.complete(env, null);
    }

    public synchronized void remoteOperationFailed(MasterProcedureEnv env, RemoteProcedureException error) {
        this.complete(env, (Throwable)error);
    }

    protected synchronized Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        if (this.dispatched) {
            if (this.succ) {
                return null;
            }
            this.dispatched = false;
        }
        try {
            env.getRemoteDispatcher().addOperationToNode((Comparable)this.targetServer, this);
        }
        catch (FailedRemoteDispatchException frde) {
            LOG.info("Can not add remote operation for refreshing peer {} for {} to {}, this is usually because the server is already dead, give up and mark the procedure as complete", new Object[]{this.peerId, this.type, this.targetServer, frde});
            return null;
        }
        this.dispatched = true;
        this.event = new ProcedureEvent((Object)this);
        this.event.suspendIfNotReady((Procedure)this);
        throw new ProcedureSuspendedException();
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        serializer.serialize((Message)MasterProcedureProtos.RefreshPeerStateData.newBuilder().setPeerId(this.peerId).setType(RefreshPeerProcedure.toPeerModificationType(this.type)).setTargetServer(ProtobufUtil.toServerName((ServerName)this.targetServer)).build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.RefreshPeerStateData data = (MasterProcedureProtos.RefreshPeerStateData)serializer.deserialize(MasterProcedureProtos.RefreshPeerStateData.class);
        this.peerId = data.getPeerId();
        this.type = RefreshPeerProcedure.toPeerOperationType(data.getType());
        this.targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getTargetServer());
    }
}

