/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultMemStore
extends AbstractMemStore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMemStore.class);
    public static final long DEEP_OVERHEAD = ClassSize.align((long)AbstractMemStore.DEEP_OVERHEAD);
    public static final long FIXED_OVERHEAD = ClassSize.align((long)AbstractMemStore.FIXED_OVERHEAD);

    public DefaultMemStore() {
        this(HBaseConfiguration.create(), CellComparator.getInstance());
    }

    public DefaultMemStore(Configuration conf, CellComparator c) {
        super(conf, c);
    }

    @Override
    public MemStoreSnapshot snapshot() {
        if (!this.snapshot.isEmpty()) {
            LOG.warn("Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            this.snapshotId = EnvironmentEdgeManager.currentTime();
            if (!this.active.isEmpty()) {
                ImmutableSegment immutableSegment;
                this.snapshot = immutableSegment = SegmentFactory.instance().createImmutableSegment(this.active);
                this.resetActive();
            }
        }
        return new MemStoreSnapshot(this.snapshotId, this.snapshot);
    }

    @Override
    public MemStoreSize getFlushableSize() {
        MemStoreSize mss = this.getSnapshotSize();
        return mss.getDataSize() > 0L ? mss : this.active.getMemStoreSize();
    }

    @Override
    protected long keySize() {
        return this.active.getDataSize();
    }

    @Override
    protected long heapSize() {
        return this.active.getHeapSize();
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) throws IOException {
        ArrayList<KeyValueScanner> list = new ArrayList<KeyValueScanner>();
        DefaultMemStore.addToScanners(this.active, readPt, list);
        DefaultMemStore.addToScanners(this.snapshot.getAllSegments(), readPt, list);
        return list;
    }

    @Override
    protected List<Segment> getSegments() throws IOException {
        ArrayList<Segment> list = new ArrayList<Segment>(2);
        list.add(this.active);
        list.add(this.snapshot);
        return list;
    }

    Cell getNextRow(Cell cell) {
        return this.getLowest(this.getNextRow(cell, this.active.getCellSet()), this.getNextRow(cell, this.snapshot.getCellSet()));
    }

    @Override
    public void updateLowestUnflushedSequenceIdInWAL(boolean onlyIfMoreRecent) {
    }

    @Override
    public MemStoreSize size() {
        return this.active.getMemStoreSize();
    }

    @Override
    protected void checkActiveSize() {
    }

    @Override
    public long preFlushSeqIDEstimation() {
        return -1L;
    }

    @Override
    public boolean isSloppy() {
        return false;
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion());
        LOG.info("vmInputArguments=" + runtime.getInputArguments());
        DefaultMemStore memstore1 = new DefaultMemStore();
        int count = 10000;
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] empty = new byte[]{};
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        for (i = 0; i < 10000; ++i) {
            memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty), (MemStoreSizing)memStoreSizing);
        }
        LOG.info("memstore1 estimated size={}", (Object)(memStoreSizing.getMemStoreSize().getDataSize() + memStoreSizing.getMemStoreSize().getHeapSize()));
        for (i = 0; i < 10000; ++i) {
            memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty), (MemStoreSizing)memStoreSizing);
        }
        LOG.info("memstore1 estimated size (2nd loading of same data)={}", (Object)(memStoreSizing.getMemStoreSize().getDataSize() + memStoreSizing.getMemStoreSize().getHeapSize()));
        DefaultMemStore memstore2 = new DefaultMemStore();
        memStoreSizing = new NonThreadSafeMemStoreSizing();
        for (int i2 = 0; i2 < 10000; ++i2) {
            memstore2.add((Cell)new KeyValue(Bytes.toBytes((int)i2), fam, qf, (long)i2, new byte[i2]), (MemStoreSizing)memStoreSizing);
        }
        LOG.info("memstore2 estimated size={}", (Object)(memStoreSizing.getMemStoreSize().getDataSize() + memStoreSizing.getMemStoreSize().getHeapSize()));
        int seconds = 30;
        LOG.info("Waiting 30 seconds while heap dump is taken");
        LOG.info("Exiting.");
    }
}

