/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ThreadSafeMemStoreSizing
implements MemStoreSizing {
    private final AtomicLong dataSize = new AtomicLong();
    private final AtomicLong heapSize = new AtomicLong();
    private final AtomicLong offHeapSize = new AtomicLong();

    ThreadSafeMemStoreSizing() {
        this(0L, 0L, 0L);
    }

    ThreadSafeMemStoreSizing(MemStoreSize mss) {
        this(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize());
    }

    ThreadSafeMemStoreSizing(long dataSize, long heapSize, long offHeapSize) {
        this.incMemStoreSize(dataSize, heapSize, offHeapSize);
    }

    @Override
    public MemStoreSize getMemStoreSize() {
        return new MemStoreSize(this.getDataSize(), this.getHeapSize(), this.getOffHeapSize());
    }

    @Override
    public long incMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta) {
        this.offHeapSize.addAndGet(offHeapSizeDelta);
        this.heapSize.addAndGet(heapSizeDelta);
        return this.dataSize.addAndGet(dataSizeDelta);
    }

    @Override
    public long getDataSize() {
        return this.dataSize.get();
    }

    @Override
    public long getHeapSize() {
        return this.heapSize.get();
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize.get();
    }

    public String toString() {
        return this.getMemStoreSize().toString();
    }
}

