/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestHBaseTestingUtility {
    private static final int NUMTABLES = 1;
    private static final int NUMROWS = 100;
    private static final int NUMREGIONS = 10;
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseTestingUtility.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHBaseTestingUtility.class);
    @Rule
    public TestName name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiClusters() throws Exception {
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        htu1.getConfiguration().set("zookeeper.znode.parent", "/1");
        htu1.startMiniZKCluster();
        HBaseTestingUtility htu2 = new HBaseTestingUtility();
        htu2.getConfiguration().set("zookeeper.znode.parent", "/2");
        htu2.getConfiguration().set("hbase.zookeeper.property.clientPort", htu1.getConfiguration().get("hbase.zookeeper.property.clientPort", "-1"));
        htu2.setZkCluster(htu1.getZkCluster());
        HBaseTestingUtility htu3 = new HBaseTestingUtility();
        htu3.getConfiguration().set("zookeeper.znode.parent", "/3");
        htu3.getConfiguration().set("hbase.zookeeper.property.clientPort", htu1.getConfiguration().get("hbase.zookeeper.property.clientPort", "-1"));
        htu3.setZkCluster(htu1.getZkCluster());
        try {
            htu1.startMiniCluster();
            htu2.startMiniCluster();
            htu3.startMiniCluster();
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            byte[] FAM_NAME = Bytes.toBytes((String)"fam");
            byte[] ROW = Bytes.toBytes((String)"row");
            byte[] QUAL_NAME = Bytes.toBytes((String)"qual");
            byte[] VALUE = Bytes.toBytes((String)"value");
            Table table1 = htu1.createTable(tableName, FAM_NAME);
            Table table2 = htu2.createTable(tableName, FAM_NAME);
            Put put = new Put(ROW);
            put.addColumn(FAM_NAME, QUAL_NAME, VALUE);
            table1.put(put);
            Get get = new Get(ROW);
            get.addColumn(FAM_NAME, QUAL_NAME);
            Result res = table1.get(get);
            Assert.assertEquals((long)1L, (long)res.size());
            res = table2.get(get);
            Assert.assertEquals((long)0L, (long)res.size());
            table1.close();
            table2.close();
        }
        finally {
            htu3.shutdownMiniCluster();
            htu2.shutdownMiniCluster();
            htu1.shutdownMiniCluster();
        }
    }

    @Test
    public void testMiniCluster() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniHBaseCluster cluster = hbt.startMiniCluster();
        try {
            Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
        }
        finally {
            hbt.shutdownMiniCluster();
        }
    }

    @Test
    public void testMiniClusterBindToWildcard() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        hbt.getConfiguration().set("hbase.regionserver.ipc.address", "0.0.0.0");
        MiniHBaseCluster cluster = hbt.startMiniCluster();
        try {
            Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
        }
        finally {
            hbt.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniClusterWithSSLOn() throws Exception {
        String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestHBaseTestingUtility.class.getSimpleName();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestHBaseTestingUtility.class);
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)hbt.getConfiguration(), (boolean)false);
        hbt.getConfiguration().set("hbase.ssl.enabled", "true");
        hbt.getConfiguration().addResource("ssl-server.xml");
        hbt.getConfiguration().addResource("ssl-client.xml");
        MiniHBaseCluster cluster = hbt.startMiniCluster();
        try {
            Assert.assertEquals((long)1L, (long)cluster.getLiveRegionServerThreads().size());
        }
        finally {
            hbt.shutdownMiniCluster();
        }
    }

    @Test
    public void testMultipleStartStop() throws Exception {
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        Path foo = new Path("foo");
        htu1.startMiniCluster();
        htu1.getDFSCluster().getFileSystem().create(foo);
        Assert.assertTrue((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.shutdownMiniCluster();
        htu1.startMiniCluster();
        Assert.assertFalse((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.getDFSCluster().getFileSystem().create(foo);
        Assert.assertTrue((boolean)htu1.getDFSCluster().getFileSystem().exists(foo));
        htu1.shutdownMiniCluster();
    }

    @Test
    public void testMiniZooKeeperWithOneServer() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniZooKeeperCluster cluster1 = hbt.startMiniZKCluster();
        try {
            Assert.assertEquals((long)0L, (long)cluster1.getBackupZooKeeperServerNum());
            Assert.assertTrue((cluster1.killCurrentActiveZooKeeperServer() == -1 ? 1 : 0) != 0);
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniZooKeeperWithMultipleServers() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniZooKeeperCluster cluster2 = hbt.startMiniZKCluster(5, new int[0]);
        int defaultClientPort = 21818;
        cluster2.setDefaultClientPort(defaultClientPort);
        try {
            Assert.assertEquals((long)4L, (long)cluster2.getBackupZooKeeperServerNum());
            int currentActivePort = cluster2.killCurrentActiveZooKeeperServer();
            Assert.assertTrue((currentActivePort >= defaultClientPort ? 1 : 0) != 0);
            Assert.assertTrue((cluster2.getClientPort() == currentActivePort ? 1 : 0) != 0);
            currentActivePort = cluster2.killCurrentActiveZooKeeperServer();
            Assert.assertTrue((currentActivePort >= defaultClientPort ? 1 : 0) != 0);
            Assert.assertTrue((cluster2.getClientPort() == currentActivePort ? 1 : 0) != 0);
            Assert.assertEquals((long)2L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)3L, (long)cluster2.getZooKeeperServerNum());
            cluster2.killOneBackupZooKeeperServer();
            cluster2.killOneBackupZooKeeperServer();
            Assert.assertEquals((long)0L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)1L, (long)cluster2.getZooKeeperServerNum());
            currentActivePort = cluster2.killCurrentActiveZooKeeperServer();
            Assert.assertTrue((currentActivePort == -1 ? 1 : 0) != 0);
            Assert.assertTrue((cluster2.getClientPort() == currentActivePort ? 1 : 0) != 0);
            cluster2.killOneBackupZooKeeperServer();
            Assert.assertEquals((long)-1L, (long)cluster2.getBackupZooKeeperServerNum());
            Assert.assertEquals((long)0L, (long)cluster2.getZooKeeperServerNum());
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiniZooKeeperWithMultipleClientPorts() throws Exception {
        int j;
        int i;
        int defaultClientPort = 8888;
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        int[] clientPortList1 = new int[]{1111, 1112, 1113};
        MiniZooKeeperCluster cluster1 = hbt.startMiniZKCluster(clientPortList1.length, clientPortList1);
        try {
            List clientPortListInCluster = cluster1.getClientPortList();
            for (i = 0; i < clientPortListInCluster.size(); ++i) {
                Assert.assertTrue(((Integer)clientPortListInCluster.get(i) >= clientPortList1[i] ? 1 : 0) != 0);
            }
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        hbt.getConfiguration().setInt("test.hbase.zookeeper.property.clientPort", defaultClientPort);
        int[] clientPortList2 = new int[]{2222, 2223};
        MiniZooKeeperCluster cluster2 = hbt.startMiniZKCluster(clientPortList2.length + 2, clientPortList2);
        try {
            List clientPortListInCluster = cluster2.getClientPortList();
            j = 0;
            for (i = 0; i < clientPortListInCluster.size(); ++i) {
                if (i < clientPortList2.length) {
                    Assert.assertTrue(((Integer)clientPortListInCluster.get(i) >= clientPortList2[i] ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue(((Integer)clientPortListInCluster.get(i) >= defaultClientPort + j ? 1 : 0) != 0);
                ++j;
            }
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        hbt.getConfiguration().setInt("test.hbase.zookeeper.property.clientPort", defaultClientPort);
        int[] clientPortList3 = new int[]{3333, -3334, 3335, 0};
        MiniZooKeeperCluster cluster3 = hbt.startMiniZKCluster(clientPortList3.length + 1, clientPortList3);
        try {
            List clientPortListInCluster = cluster3.getClientPortList();
            j = 0;
            for (i = 0; i < clientPortListInCluster.size(); ++i) {
                if (i < clientPortList3.length && clientPortList3[i] > 0) {
                    Assert.assertTrue(((Integer)clientPortListInCluster.get(i) >= clientPortList3[i] ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue(((Integer)clientPortListInCluster.get(i) >= defaultClientPort + j ? 1 : 0) != 0);
                ++j;
            }
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        hbt.getConfiguration().setInt("test.hbase.zookeeper.property.clientPort", defaultClientPort);
        int[] clientPortList4 = new int[]{-4444, defaultClientPort + 2, 4446, defaultClientPort};
        MiniZooKeeperCluster cluster4 = hbt.startMiniZKCluster(clientPortList4.length + 1, clientPortList4);
        try {
            List clientPortListInCluster = cluster4.getClientPortList();
            j = 1;
            for (i = 0; i < clientPortListInCluster.size(); ++i) {
                if (i < clientPortList4.length && clientPortList4[i] > 0) {
                    Assert.assertTrue(((Integer)clientPortListInCluster.get(i) >= clientPortList4[i] ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue(((Integer)clientPortListInCluster.get(i) >= defaultClientPort + j ? 1 : 0) != 0);
                j += 2;
            }
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
        int[] clientPortList5 = new int[]{5555, 5556, 5556};
        try {
            MiniZooKeeperCluster cluster5 = hbt.startMiniZKCluster(clientPortList5.length, clientPortList5);
            Assert.assertTrue((cluster5.getClientPort() == -1 ? 1 : 0) != 0);
        }
        catch (Exception exception) {
        }
        finally {
            hbt.shutdownMiniZKCluster();
        }
    }

    @Test
    public void testMiniDFSCluster() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        MiniDFSCluster cluster = hbt.startMiniDFSCluster(null);
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path dir = new Path("dir");
        Path qualifiedDir = dfs.makeQualified(dir);
        LOG.info("dir=" + dir + ", qualifiedDir=" + qualifiedDir);
        Assert.assertFalse((boolean)dfs.exists(qualifiedDir));
        Assert.assertTrue((boolean)dfs.mkdirs(qualifiedDir));
        Assert.assertTrue((boolean)dfs.delete(qualifiedDir, true));
        hbt.shutdownMiniCluster();
    }

    @Test
    public void testSetupClusterTestBuildDir() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        Path testdir = hbt.getClusterTestDir();
        LOG.info("uuid-subdir=" + testdir);
        FileSystem fs = hbt.getTestFileSystem();
        Assert.assertFalse((boolean)fs.exists(testdir));
        hbt.startMiniDFSCluster(null);
        Assert.assertTrue((boolean)fs.exists(testdir));
        hbt.shutdownMiniCluster();
        Assert.assertFalse((boolean)fs.exists(testdir));
    }

    @Test
    public void testTestDir() throws Exception {
        HBaseTestingUtility hbt = new HBaseTestingUtility();
        Path testdir = hbt.getDataTestDir();
        LOG.info("testdir=" + testdir);
        FileSystem fs = hbt.getTestFileSystem();
        Assert.assertTrue((!fs.exists(testdir) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.mkdirs(testdir));
        Assert.assertTrue((boolean)hbt.cleanupTestDir());
    }

    @Test
    public void testResolvePortConflict() throws Exception {
        Random random = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)random.nextInt(ArgumentMatchers.anyInt())).thenAnswer((Answer)new Answer<Integer>(){
            int[] numbers = new int[]{1, 1, 2};
            int count = 0;

            public Integer answer(InvocationOnMock invocation) {
                int ret = this.numbers[this.count];
                ++this.count;
                return ret;
            }
        });
        HBaseTestingUtility.PortAllocator.AvailablePortChecker portChecker = (HBaseTestingUtility.PortAllocator.AvailablePortChecker)Mockito.mock(HBaseTestingUtility.PortAllocator.AvailablePortChecker.class);
        Mockito.when((Object)portChecker.available(ArgumentMatchers.anyInt())).thenReturn((Object)true);
        HBaseTestingUtility.PortAllocator portAllocator = new HBaseTestingUtility.PortAllocator(random, portChecker);
        int port1 = portAllocator.randomFreePort();
        int port2 = portAllocator.randomFreePort();
        Assert.assertNotEquals((long)port1, (long)port2);
        ((Random)Mockito.verify((Object)random, (VerificationMode)Mockito.times((int)3))).nextInt(ArgumentMatchers.anyInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverridingOfDefaultPorts() throws Exception {
        Configuration defaultConfig = HBaseConfiguration.create();
        defaultConfig.setInt("hbase.master.info.port", 16010);
        defaultConfig.setInt("hbase.regionserver.info.port", 16030);
        HBaseTestingUtility htu = new HBaseTestingUtility(defaultConfig);
        try {
            MiniHBaseCluster defaultCluster = htu.startMiniCluster();
            Assert.assertNotEquals((long)16010L, (long)defaultCluster.getConfiguration().getInt("hbase.master.info.port", 0));
            Assert.assertNotEquals((long)16030L, (long)defaultCluster.getConfiguration().getInt("hbase.regionserver.info.port", 0));
        }
        finally {
            htu.shutdownMiniCluster();
        }
        Configuration altConfig = HBaseConfiguration.create();
        int nonDefaultMasterInfoPort = 3333;
        int nonDefaultRegionServerPort = 4444;
        altConfig.setInt("hbase.master.info.port", 3333);
        altConfig.setInt("hbase.regionserver.info.port", 4444);
        htu = new HBaseTestingUtility(altConfig);
        try {
            MiniHBaseCluster customCluster = htu.startMiniCluster();
            Assert.assertEquals((long)3333L, (long)customCluster.getConfiguration().getInt("hbase.master.info.port", 0));
            Assert.assertEquals((long)4444L, (long)customCluster.getConfiguration().getInt("hbase.regionserver.info.port", 0));
        }
        finally {
            htu.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKillMiniHBaseCluster() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        htu.startMiniZKCluster();
        try {
            htu.startMiniHBaseCluster();
            for (int i = 0; i < 1; ++i) {
                TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + i));
                byte[] FAM_NAME = Bytes.toBytes((String)("fam" + i));
                try (Table table = htu.createMultiRegionTable(tableName, FAM_NAME, 10);){
                    htu.loadRandomRows(table, FAM_NAME, 100, 100);
                    continue;
                }
            }
        }
        finally {
            htu.killMiniHBaseCluster();
            htu.shutdownMiniZKCluster();
        }
    }
}

