/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableRSCrashPublish {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableRSCrashPublish.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static AsyncConnectionImpl CONN;
    private static TableName TABLE_NAME;
    private static byte[] FAMILY;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        UTIL.startMiniCluster(2);
        UTIL.createTable(TABLE_NAME, FAMILY);
        UTIL.waitTableAvailable(TABLE_NAME);
        CONN = (AsyncConnectionImpl)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws IOException {
        AsyncNonMetaRegionLocator locator = CONN.getLocator().getNonMetaRegionLocator();
        CONN.getTable(TABLE_NAME).get(new Get(Bytes.toBytes((int)0))).join();
        ServerName serverName = locator.getRegionLocationInCache(TABLE_NAME, HConstants.EMPTY_START_ROW).getDefaultRegionLocation().getServerName();
        UTIL.getMiniHBaseCluster().stopRegionServer(serverName);
        UTIL.waitFor(60000L, () -> locator.getRegionLocationInCache(TABLE_NAME, HConstants.EMPTY_START_ROW) == null);
        CONN.getTable(TABLE_NAME).get(new Get(Bytes.toBytes((int)0))).join();
        Assert.assertNotEquals((Object)serverName, (Object)locator.getRegionLocationInCache(TABLE_NAME, HConstants.EMPTY_START_ROW).getDefaultRegionLocation().getServerName());
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"Publish");
        FAMILY = Bytes.toBytes((String)"family");
    }
}

