/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestFromClientSide3 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFromClientSide3.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFromClientSide3.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static Random random = new Random();
    private static int SLAVES = 3;
    private static final byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final byte[] ANOTHERROW = Bytes.toBytes((String)"anotherrow");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static final byte[] VALUE = Bytes.toBytes((String)"testValue");
    private static final byte[] COL_QUAL = Bytes.toBytes((String)"f1");
    private static final byte[] VAL_BYTES = Bytes.toBytes((String)"v1");
    private static final byte[] ROW_BYTES = Bytes.toBytes((String)"r1");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : TEST_UTIL.getAdmin().listTables()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    private void randomCFPuts(Table table, byte[] row, byte[] family, int nPuts) throws Exception {
        Put put = new Put(row);
        for (int i = 0; i < nPuts; ++i) {
            byte[] qualifier = Bytes.toBytes((int)random.nextInt());
            byte[] value = Bytes.toBytes((int)random.nextInt());
            put.addColumn(family, qualifier, value);
        }
        table.put(put);
    }

    private void performMultiplePutAndFlush(HBaseAdmin admin, Table table, byte[] row, byte[] family, int nFlushes, int nPuts) throws Exception {
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(table.getName());){
            HRegionLocation loc = locator.getRegionLocation(row, true);
            AdminProtos.AdminService.BlockingInterface server = ((ClusterConnection)admin.getConnection()).getAdmin(loc.getServerName());
            byte[] regName = loc.getRegionInfo().getRegionName();
            for (int i = 0; i < nFlushes; ++i) {
                this.randomCFPuts(table, row, family, nPuts);
                List sf = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regName, (byte[])FAMILY);
                int sfCount = sf.size();
                admin.flush(table.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Cell> toList(ResultScanner scanner) {
        try {
            ArrayList cells = new ArrayList();
            for (Result r : scanner) {
                cells.addAll(r.listCells());
            }
            ArrayList arrayList = cells;
            return arrayList;
        }
        finally {
            scanner.close();
        }
    }

    @Test
    public void testScanAfterDeletingSpecifiedRow() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        TEST_UTIL.getAdmin().createTable(desc);
        byte[] row = Bytes.toBytes((String)"SpecifiedRow");
        byte[] value0 = Bytes.toBytes((String)"value_0");
        byte[] value1 = Bytes.toBytes((String)"value_1");
        try (Table t = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            t.put(put);
            Delete d = new Delete(row);
            t.delete(d);
            put = new Put(row);
            put.addColumn(FAMILY, null, value0);
            t.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, null, value1);
            t.put(put);
            List<Cell> cells = TestFromClientSide3.toList(t.getScanner(new Scan()));
            Assert.assertEquals((long)1L, (long)cells.size());
            Assert.assertEquals((Object)"value_1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cells.get(0))));
            cells = TestFromClientSide3.toList(t.getScanner(new Scan().addFamily(FAMILY)));
            Assert.assertEquals((long)1L, (long)cells.size());
            Assert.assertEquals((Object)"value_1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cells.get(0))));
            cells = TestFromClientSide3.toList(t.getScanner(new Scan().addColumn(FAMILY, QUALIFIER)));
            Assert.assertEquals((long)0L, (long)cells.size());
            TEST_UTIL.getAdmin().flush(tableName);
            cells = TestFromClientSide3.toList(t.getScanner(new Scan()));
            Assert.assertEquals((long)1L, (long)cells.size());
            Assert.assertEquals((Object)"value_1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cells.get(0))));
            cells = TestFromClientSide3.toList(t.getScanner(new Scan().addFamily(FAMILY)));
            Assert.assertEquals((long)1L, (long)cells.size());
            Assert.assertEquals((Object)"value_1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cells.get(0))));
            cells = TestFromClientSide3.toList(t.getScanner(new Scan().addColumn(FAMILY, QUALIFIER)));
            Assert.assertEquals((long)0L, (long)cells.size());
        }
    }

    @Test
    public void testScanAfterDeletingSpecifiedRowV2() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        TEST_UTIL.getAdmin().createTable(desc);
        byte[] row = Bytes.toBytes((String)"SpecifiedRow");
        byte[] qual0 = Bytes.toBytes((String)"qual0");
        byte[] qual1 = Bytes.toBytes((String)"qual1");
        try (Table t = TEST_UTIL.getConnection().getTable(tableName);){
            Delete d = new Delete(row);
            t.delete(d);
            Put put = new Put(row);
            put.addColumn(FAMILY, null, VALUE);
            t.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qual1, qual1);
            t.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qual0, qual0);
            t.put(put);
            Result r = t.get(new Get(row));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((Object)"testValue", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Assert.assertEquals((Object)"qual0", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[1])));
            Assert.assertEquals((Object)"qual1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[2])));
            TEST_UTIL.getAdmin().flush(tableName);
            r = t.get(new Get(row));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((Object)"testValue", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Assert.assertEquals((Object)"qual0", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[1])));
            Assert.assertEquals((Object)"qual1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[2])));
        }
    }

    @Test
    public void testAdvancedConfigOverride() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compaction.min", 3);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table hTable = TEST_UTIL.createTable(tableName, FAMILY, 10);
        Admin admin = TEST_UTIL.getAdmin();
        ClusterConnection connection = (ClusterConnection)TEST_UTIL.getConnection();
        byte[] row = Bytes.toBytes((int)random.nextInt());
        this.performMultiplePutAndFlush((HBaseAdmin)admin, hTable, row, FAMILY, 3, 100);
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            Pair st;
            HRegionLocation loc = locator.getRegionLocation(row, true);
            byte[] regionName = loc.getRegionInfo().getRegionName();
            AdminProtos.AdminService.BlockingInterface server = connection.getAdmin(loc.getServerName());
            Assert.assertTrue((org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() > 1 ? 1 : 0) != 0);
            admin.compact(tableName);
            for (int i = 0; i < 250; ++i) {
                loc = locator.getRegionLocation(row, true);
                if (!loc.getRegionInfo().isOffline()) {
                    regionName = loc.getRegionInfo().getRegionName();
                    server = connection.getAdmin(loc.getServerName());
                    if (org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() <= 1) break;
                }
                Thread.sleep(40L);
            }
            Assert.assertTrue((org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() <= 1 ? 1 : 0) != 0);
            LOG.info("hbase.hstore.compaction.min should now be 5");
            HTableDescriptor htd = new HTableDescriptor(hTable.getTableDescriptor());
            htd.setValue("hbase.hstore.compaction.min", String.valueOf(5));
            admin.modifyTable(tableName, (TableDescriptor)htd);
            while (null != (st = admin.getAlterStatus(tableName)) && (Integer)st.getFirst() > 0) {
                LOG.debug(st.getFirst() + " regions left to update");
                Thread.sleep(40L);
            }
            LOG.info("alter status finished");
            this.performMultiplePutAndFlush((HBaseAdmin)admin, hTable, row, FAMILY, 3, 10);
            admin.compact(tableName);
            Thread.sleep(10000L);
            loc = locator.getRegionLocation(row, true);
            regionName = loc.getRegionInfo().getRegionName();
            server = connection.getAdmin(loc.getServerName());
            int sfCount = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size();
            Assert.assertTrue((sfCount > 1 ? 1 : 0) != 0);
            LOG.info("hbase.hstore.compaction.min should now be 2");
            HColumnDescriptor hcd = new HColumnDescriptor(htd.getFamily(FAMILY));
            hcd.setValue("hbase.hstore.compaction.min", String.valueOf(2));
            htd.modifyFamily(hcd);
            admin.modifyTable(tableName, (TableDescriptor)htd);
            while (null != (st = admin.getAlterStatus(tableName)) && (Integer)st.getFirst() > 0) {
                LOG.debug(st.getFirst() + " regions left to update");
                Thread.sleep(40L);
            }
            LOG.info("alter status finished");
            admin.compact(tableName);
            for (int i = 0; i < 250; ++i) {
                loc = locator.getRegionLocation(row, true);
                regionName = loc.getRegionInfo().getRegionName();
                try {
                    server = connection.getAdmin(loc.getServerName());
                    if (org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() < sfCount) {
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.debug("Waiting for region to come online: " + Bytes.toString((byte[])regionName));
                }
                Thread.sleep(40L);
            }
            Assert.assertTrue((org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() < sfCount ? 1 : 0) != 0);
            LOG.info("Removing CF config value");
            LOG.info("hbase.hstore.compaction.min should now be 5");
            hcd = new HColumnDescriptor(htd.getFamily(FAMILY));
            hcd.setValue("hbase.hstore.compaction.min", null);
            htd.modifyFamily(hcd);
            admin.modifyTable(tableName, (TableDescriptor)htd);
            while (null != (st = admin.getAlterStatus(tableName)) && (Integer)st.getFirst() > 0) {
                LOG.debug(st.getFirst() + " regions left to update");
                Thread.sleep(40L);
            }
            LOG.info("alter status finished");
            Assert.assertNull((Object)hTable.getTableDescriptor().getFamily(FAMILY).getValue("hbase.hstore.compaction.min"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTableBatchWithEmptyPut() throws Exception {
        try (Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAMILY});){
            ArrayList<Put> actions = new ArrayList<Put>();
            Object[] results = new Object[2];
            Put put1 = new Put(ROW);
            actions.add(put1);
            Put put2 = new Put(ANOTHERROW);
            put2.addColumn(FAMILY, QUALIFIER, VALUE);
            actions.add(put2);
            table.batch(actions, results);
            Assert.fail((String)"Empty Put should have failed the batch call");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTableWithLargeBatch() throws Exception {
        int sixtyFourK = 65536;
        try (Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAMILY});){
            ArrayList<Put> actions = new ArrayList<Put>();
            Object[] results = new Object[(sixtyFourK + 1) * 2];
            for (int i = 0; i < sixtyFourK + 1; ++i) {
                Put put1 = new Put(ROW);
                put1.addColumn(FAMILY, QUALIFIER, VALUE);
                actions.add(put1);
                Put put2 = new Put(ANOTHERROW);
                put2.addColumn(FAMILY, QUALIFIER, VALUE);
                actions.add(put2);
            }
            table.batch(actions, results);
        }
    }

    @Test
    public void testBatchWithRowMutation() throws Exception {
        LOG.info("Starting testBatchWithRowMutation");
        TableName TABLENAME = TableName.valueOf((String)"testBatchWithRowMutation");
        try (Table t = TEST_UTIL.createTable(TABLENAME, FAMILY);){
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b")};
            RowMutations arm = RowMutations.of(Collections.singletonList(new Put(ROW).addColumn(FAMILY, QUALIFIERS[0], VALUE)));
            Object[] batchResult = new Object[1];
            t.batch(Arrays.asList(arm), batchResult);
            Get g = new Get(ROW);
            Result r = t.get(g);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIERS[0])));
            arm = RowMutations.of(Arrays.asList(new Put(ROW).addColumn(FAMILY, QUALIFIERS[1], VALUE), new Delete(ROW).addColumns(FAMILY, QUALIFIERS[0])));
            t.batch(Arrays.asList(arm), batchResult);
            r = t.get(g);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIERS[1])));
            Assert.assertNull((Object)r.getValue(FAMILY, QUALIFIERS[0]));
            try {
                arm = RowMutations.of(Collections.singletonList(new Put(ROW).addColumn(new byte[]{98, 111, 103, 117, 115}, QUALIFIERS[0], VALUE)));
                t.batch(Arrays.asList(arm), batchResult);
                Assert.fail((String)"Expected RetriesExhaustedWithDetailsException with NoSuchColumnFamilyException");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                String msg = e.getMessage();
                Assert.assertTrue((boolean)msg.contains("NoSuchColumnFamilyException"));
            }
        }
    }

    @Test
    public void testHTableExistsMethodSingleRegionSingleGet() throws Exception {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAMILY});
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        Get get = new Get(ROW);
        boolean exist = table.exists(get);
        Assert.assertFalse((boolean)exist);
        table.put(put);
        exist = table.exists(get);
        Assert.assertTrue((boolean)exist);
    }

    @Test
    public void testHTableExistsMethodSingleRegionMultipleGets() throws Exception {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAMILY});
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        ArrayList<Get> gets = new ArrayList<Get>();
        gets.add(new Get(ROW));
        gets.add(new Get(ANOTHERROW));
        boolean[] results = table.exists(gets);
        Assert.assertTrue((boolean)results[0]);
        Assert.assertFalse((boolean)results[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTableExistsBeforeGet() throws Exception {
        try (Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAMILY});){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Get get = new Get(ROW);
            boolean exist = table.exists(get);
            Assert.assertEquals((Object)true, (Object)exist);
            Result result = table.get(get);
            Assert.assertEquals((Object)false, (Object)result.isEmpty());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTableExistsAllBeforeGet() throws Exception {
        byte[] ROW2 = Bytes.add((byte[])ROW, (byte[])Bytes.toBytes((String)"2"));
        try (Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAMILY});){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            put = new Put(ROW2);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Get get = new Get(ROW);
            Get get2 = new Get(ROW2);
            ArrayList<Get> getList = new ArrayList<Get>(2);
            getList.add(get);
            getList.add(get2);
            boolean[] exists = table.existsAll(getList);
            Assert.assertEquals((Object)true, (Object)exists[0]);
            Assert.assertEquals((Object)true, (Object)exists[1]);
            Result[] result = table.get(getList);
            Assert.assertEquals((Object)false, (Object)result[0].isEmpty());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result[0].getValue(FAMILY, QUALIFIER)));
            Assert.assertEquals((Object)false, (Object)result[1].isEmpty());
            Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result[1].getValue(FAMILY, QUALIFIER)));
        }
    }

    @Test
    public void testHTableExistsMethodMultipleRegionsSingleGet() throws Exception {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAMILY}, 1, new byte[]{0}, new byte[]{-1}, 255);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        Get get = new Get(ROW);
        boolean exist = table.exists(get);
        Assert.assertFalse((boolean)exist);
        table.put(put);
        exist = table.exists(get);
        Assert.assertTrue((boolean)exist);
    }

    @Test
    public void testHTableExistsMethodMultipleRegionsMultipleGets() throws Exception {
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])new byte[][]{FAMILY}, 1, new byte[]{0}, new byte[]{-1}, 255);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        ArrayList<Get> gets = new ArrayList<Get>();
        gets.add(new Get(ANOTHERROW));
        gets.add(new Get(Bytes.add((byte[])ROW, (byte[])new byte[]{0})));
        gets.add(new Get(ROW));
        gets.add(new Get(Bytes.add((byte[])ANOTHERROW, (byte[])new byte[]{0})));
        LOG.info("Calling exists");
        boolean[] results = table.existsAll(gets);
        Assert.assertFalse((boolean)results[0]);
        Assert.assertFalse((boolean)results[1]);
        Assert.assertTrue((boolean)results[2]);
        Assert.assertFalse((boolean)results[3]);
        put = new Put(new byte[]{0});
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        gets = new ArrayList();
        gets.add(new Get(new byte[]{0}));
        gets.add(new Get(new byte[]{0, 0}));
        results = table.existsAll(gets);
        Assert.assertTrue((boolean)results[0]);
        Assert.assertFalse((boolean)results[1]);
        put = new Put(new byte[]{-1, -1});
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        gets = new ArrayList();
        gets.add(new Get(new byte[]{-1}));
        gets.add(new Get(new byte[]{-1, -1}));
        gets.add(new Get(new byte[]{-1, -1, -1}));
        results = table.existsAll(gets);
        Assert.assertFalse((boolean)results[0]);
        Assert.assertTrue((boolean)results[1]);
        Assert.assertFalse((boolean)results[2]);
    }

    @Test
    public void testGetEmptyRow() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])Bytes.toBytes((String)this.name.getMethodName())));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        admin.createTable((TableDescriptor)desc);
        Table table = TEST_UTIL.getConnection().getTable(desc.getTableName());
        Put put = new Put(ROW_BYTES);
        put.addColumn(FAMILY, COL_QUAL, VAL_BYTES);
        table.put(put);
        Result res = null;
        try {
            res = table.get(new Get(new byte[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((res == null ? 1 : 0) != 0);
        res = table.get(new Get(Bytes.toBytes((String)"r1-not-exist")));
        Assert.assertTrue((res.isEmpty() ? 1 : 0) != 0);
        res = table.get(new Get(ROW_BYTES));
        Assert.assertTrue((boolean)Arrays.equals(res.getValue(FAMILY, COL_QUAL), VAL_BYTES));
        table.close();
    }

    @Test
    public void testConnectionDefaultUsesCodec() throws Exception {
        ClusterConnection con = (ClusterConnection)TEST_UTIL.getConnection();
        Assert.assertTrue((boolean)con.hasCellBlockSupport());
    }

    @Test
    public void testPutWithPreBatchMutate() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testPreBatchMutate(tableName, () -> {
            try {
                Table t = TEST_UTIL.getConnection().getTable(tableName);
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                t.put(put);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @Test
    public void testRowMutationsWithPreBatchMutate() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.testPreBatchMutate(tableName, () -> {
            try {
                RowMutations rm = new RowMutations(ROW, 1);
                Table t = TEST_UTIL.getConnection().getTable(tableName);
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                rm.add(put);
                t.mutateRow(rm);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void testPreBatchMutate(TableName tableName, Runnable rn) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addCoprocessor(WaitingForScanObserver.class.getName());
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        ExecutorService service = Executors.newFixedThreadPool(2);
        service.execute(rn);
        ArrayList cells = new ArrayList();
        service.execute(() -> {
            try {
                TimeUnit.SECONDS.sleep(3L);
                Table t = TEST_UTIL.getConnection().getTable(tableName);
                Scan scan = new Scan();
                try (ResultScanner scanner = t.getScanner(scan);){
                    for (Result r : scanner) {
                        cells.addAll(Arrays.asList(r.rawCells()));
                    }
                }
            }
            catch (IOException | InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });
        service.shutdown();
        service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        Assert.assertEquals((String)"The write is blocking by RegionObserver#postBatchMutate, so the data is invisible to reader", (long)0L, (long)cells.size());
        TEST_UTIL.deleteTable(tableName);
    }

    @Test
    public void testLockLeakWithDelta() throws Exception, Throwable {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addCoprocessor(WaitingForMultiMutationsObserver.class.getName());
        desc.setConfiguration("hbase.rowlock.wait.duration", String.valueOf(5000));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        Configuration copy = new Configuration(TEST_UTIL.getConfiguration());
        copy.setInt("hbase.client.retries.number", 2);
        try (Connection con = ConnectionFactory.createConnection((Configuration)copy);){
            HRegion region = TestFromClientSide3.find(tableName);
            region.setTimeoutForWriteLock(10L);
            ExecutorService putService = Executors.newSingleThreadExecutor();
            putService.execute(() -> {
                try (Table table = con.getTable(tableName);){
                    Put put = new Put(ROW);
                    put.addColumn(FAMILY, QUALIFIER, VALUE);
                    table.put(put);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            ExecutorService appendService = Executors.newSingleThreadExecutor();
            appendService.execute(() -> {
                Append append = new Append(ROW);
                append.addColumn(FAMILY, QUALIFIER, VALUE);
                try (Table table = con.getTable(tableName);){
                    table.append(append);
                    Assert.fail((String)"The APPEND should fail because the target lock is blocked by previous put");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            appendService.shutdown();
            appendService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            WaitingForMultiMutationsObserver observer = TestFromClientSide3.find(tableName, WaitingForMultiMutationsObserver.class);
            observer.latch.countDown();
            putService.shutdown();
            putService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            try (Table table = con.getTable(tableName);){
                Result r = table.get(new Get(ROW));
                Assert.assertFalse((boolean)r.isEmpty());
                Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])VALUE));
            }
        }
        HRegion region = TestFromClientSide3.find(tableName);
        int readLockCount = region.getReadLockCount();
        LOG.info("readLockCount:" + readLockCount);
        Assert.assertEquals((long)0L, (long)readLockCount);
    }

    @Test
    public void testMultiRowMutations() throws Exception, Throwable {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addCoprocessor(MultiRowMutationEndpoint.class.getName());
        desc.addCoprocessor(WaitingForMultiMutationsObserver.class.getName());
        desc.setConfiguration("hbase.rowlock.wait.duration", String.valueOf(5000));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        Configuration copy = new Configuration(TEST_UTIL.getConfiguration());
        copy.setInt("hbase.client.retries.number", 2);
        try (Connection con = ConnectionFactory.createConnection((Configuration)copy);){
            byte[] row = Bytes.toBytes((String)"ROW-0");
            byte[] rowLocked = Bytes.toBytes((String)"ROW-1");
            byte[] value0 = Bytes.toBytes((String)"VALUE-0");
            byte[] value1 = Bytes.toBytes((String)"VALUE-1");
            byte[] value2 = Bytes.toBytes((String)"VALUE-2");
            TestFromClientSide3.assertNoLocks(tableName);
            ExecutorService putService = Executors.newSingleThreadExecutor();
            putService.execute(() -> {
                try (Table table = con.getTable(tableName);){
                    Put put0 = new Put(rowLocked);
                    put0.addColumn(FAMILY, QUALIFIER, value0);
                    table.put(put0);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            ExecutorService cpService = Executors.newSingleThreadExecutor();
            cpService.execute(() -> {
                boolean threw;
                Put put1 = new Put(row);
                Put put2 = new Put(rowLocked);
                put1.addColumn(FAMILY, QUALIFIER, value1);
                put2.addColumn(FAMILY, QUALIFIER, value2);
                try (Table table = con.getTable(tableName);){
                    MultiRowMutationProtos.MutateRowsRequest request = MultiRowMutationProtos.MutateRowsRequest.newBuilder().addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)put1)).addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)put2)).build();
                    table.coprocessorService(MultiRowMutationProtos.MultiRowMutationService.class, ROW, ROW, exe -> {
                        ServerRpcController controller = new ServerRpcController();
                        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                        exe.mutateRows((RpcController)controller, request, (RpcCallback)rpcCallback);
                        return (MultiRowMutationProtos.MutateRowsResponse)rpcCallback.get();
                    });
                    threw = false;
                }
                catch (Throwable ex) {
                    threw = true;
                }
                if (!threw) {
                    Assert.fail((String)"This cp should fail because the target lock is blocked by previous put");
                }
            });
            cpService.shutdown();
            cpService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            WaitingForMultiMutationsObserver observer = TestFromClientSide3.find(tableName, WaitingForMultiMutationsObserver.class);
            observer.latch.countDown();
            putService.shutdown();
            putService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            try (Table table = con.getTable(tableName);){
                Get g0 = new Get(row);
                Get g1 = new Get(rowLocked);
                Result r0 = table.get(g0);
                Result r1 = table.get(g1);
                Assert.assertTrue((boolean)r0.isEmpty());
                Assert.assertFalse((boolean)r1.isEmpty());
                Assert.assertTrue((boolean)Bytes.equals((byte[])r1.getValue(FAMILY, QUALIFIER), (byte[])value0));
            }
            TestFromClientSide3.assertNoLocks(tableName);
        }
    }

    @Test
    public void testMVCCUsingMVCCPreAssign() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        htd.addFamily(fam);
        Admin admin = TEST_UTIL.getAdmin();
        admin.createTable((TableDescriptor)htd);
        Table table = admin.getConnection().getTable(TableName.valueOf((String)this.name.getMethodName()));
        Put put = new Put(Bytes.toBytes((String)"0"));
        put.addColumn(FAMILY, Bytes.toBytes((String)""), Bytes.toBytes((String)"0"));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"00"));
        put.addColumn(FAMILY, Bytes.toBytes((String)""), Bytes.toBytes((String)"0"));
        table.put(put);
        Scan scan = new Scan();
        scan.setTimeRange(0L, Long.MAX_VALUE);
        scan.setCaching(1);
        ResultScanner scanner = table.getScanner(scan);
        int rowNum = scanner.next() != null ? 1 : 0;
        for (int i = 1; i < 1000; ++i) {
            put = new Put(Bytes.toBytes((String)String.valueOf(i)));
            put.setDurability(Durability.ASYNC_WAL);
            put.addColumn(FAMILY, Bytes.toBytes((String)""), Bytes.toBytes((int)i));
            table.put(put);
        }
        for (Result result : scanner) {
            ++rowNum;
        }
        Assert.assertEquals((long)2L, (long)rowNum);
        scanner = table.getScanner(scan);
        rowNum = 0;
        for (Result result : scanner) {
            ++rowNum;
        }
        Assert.assertEquals((long)1001L, (long)rowNum);
    }

    @Test
    public void testPutThenGetWithMultipleThreads() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int THREAD_NUM = 20;
        int ROUND_NUM = 10;
        for (int round = 0; round < 10; ++round) {
            ArrayList<Thread> threads = new ArrayList<Thread>(20);
            final AtomicInteger successCnt = new AtomicInteger(0);
            final Table ht = TEST_UTIL.createTable(tableName, FAMILY);
            int i = 0;
            while (i < 20) {
                final int index = i++;
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        byte[] row = Bytes.toBytes((String)("row-" + index));
                        byte[] value = Bytes.toBytes((String)("v" + index));
                        try {
                            Put put = new Put(row);
                            put.addColumn(FAMILY, QUALIFIER, value);
                            ht.put(put);
                            Get get = new Get(row);
                            Result result = ht.get(get);
                            byte[] returnedValue = result.getValue(FAMILY, QUALIFIER);
                            if (Bytes.equals((byte[])value, (byte[])returnedValue)) {
                                successCnt.getAndIncrement();
                            } else {
                                LOG.error("Should be equal but not, original value: " + Bytes.toString((byte[])value) + ", returned value: " + (returnedValue == null ? "null" : Bytes.toString((byte[])returnedValue)));
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                threads.add(t);
            }
            for (Thread t : threads) {
                t.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            Assert.assertEquals((String)("Not equal in round " + round), (long)20L, (long)successCnt.get());
            ht.close();
            TEST_UTIL.deleteTable(tableName);
        }
    }

    private static void assertNoLocks(TableName tableName) throws IOException, InterruptedException {
        HRegion region = TestFromClientSide3.find(tableName);
        Assert.assertEquals((long)0L, (long)region.getLockedRows().size());
    }

    private static HRegion find(TableName tableName) throws IOException, InterruptedException {
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(tableName);
        List regions = rs.getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        return (HRegion)regions.get(0);
    }

    private static <T extends RegionObserver> T find(TableName tableName, Class<T> clz) throws IOException, InterruptedException {
        HRegion region = TestFromClientSide3.find(tableName);
        Coprocessor cp = region.getCoprocessorHost().findCoprocessor(clz.getName());
        Assert.assertTrue((String)("The cp instance should be " + clz.getName() + ", current instance is " + cp.getClass().getName()), (boolean)clz.isInstance(cp));
        return (T)((RegionObserver)clz.cast(cp));
    }

    static byte[] generateHugeValue(int size) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        byte[] value = new byte[size];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)((Random)rand).nextInt(256);
        }
        return value;
    }

    @Test
    public void testScanWithBatchSizeReturnIncompleteCells() throws IOException {
        Result result;
        ArrayList<Result> list;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor hd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(3).build()).build();
        Table table = TEST_UTIL.createTable(hd, (byte[][])null);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, Bytes.toBytes((int)0), TestFromClientSide3.generateHugeValue(0x300000));
        table.put(put);
        put = new Put(ROW);
        put.addColumn(FAMILY, Bytes.toBytes((int)1), TestFromClientSide3.generateHugeValue(0x400000));
        table.put(put);
        for (int i = 2; i < 5; ++i) {
            for (int version = 0; version < 2; ++version) {
                put = new Put(ROW);
                put.addColumn(FAMILY, Bytes.toBytes((int)i), TestFromClientSide3.generateHugeValue(1024));
                table.put(put);
            }
        }
        Scan scan = new Scan();
        scan.withStartRow(ROW).withStopRow(ROW, true).addFamily(FAMILY).setBatch(3).setMaxResultSize(0x400000L);
        try (ResultScanner scanner = table.getScanner(scan);){
            list = new ArrayList<Result>();
            while ((result = scanner.next()) != null) {
                list.add(result);
            }
            Assert.assertEquals((long)5L, (long)list.stream().mapToInt(Result::size).sum());
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((long)3L, (long)((Result)list.get(0)).size());
            Assert.assertEquals((long)2L, (long)((Result)list.get(1)).size());
        }
        scan = new Scan();
        scan.withStartRow(ROW).withStopRow(ROW, true).addFamily(FAMILY).setBatch(2).setMaxResultSize(0x400000L);
        scanner = table.getScanner(scan);
        var8_11 = null;
        try {
            list = new ArrayList();
            while ((result = scanner.next()) != null) {
                list.add(result);
            }
            Assert.assertEquals((long)5L, (long)list.stream().mapToInt(Result::size).sum());
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((long)2L, (long)((Result)list.get(0)).size());
            Assert.assertEquals((long)2L, (long)((Result)list.get(1)).size());
            Assert.assertEquals((long)1L, (long)((Result)list.get(2)).size());
        }
        catch (Throwable throwable) {
            var8_11 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var8_11 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var8_11.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    public static class WaitingForScanObserver
    implements RegionCoprocessor,
    RegionObserver {
        private final CountDownLatch latch = new CountDownLatch(1);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }

        public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
            this.latch.countDown();
            return s;
        }
    }

    public static class WaitingForMultiMutationsObserver
    implements RegionCoprocessor,
    RegionObserver {
        final CountDownLatch latch = new CountDownLatch(1);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }
}

