/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.ZKAsyncRegistry;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ReadOnlyZKClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestZKAsyncRegistry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKAsyncRegistry.class);
    static final Logger LOG = LoggerFactory.getLogger(TestZKAsyncRegistry.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZKAsyncRegistry REGISTRY;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        TEST_UTIL.startMiniCluster(3);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.meta.replica.count", 1);
        REGISTRY = new ZKAsyncRegistry(conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOUtils.closeQuietly((Closeable)REGISTRY);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException, ExecutionException, IOException {
        LOG.info("STARTED TEST");
        String clusterId = (String)REGISTRY.getClusterId().get();
        String expectedClusterId = TEST_UTIL.getHBaseCluster().getMaster().getClusterId();
        Assert.assertEquals((String)("Expected " + expectedClusterId + ", found=" + clusterId), (Object)expectedClusterId, (Object)clusterId);
        Assert.assertEquals((long)TEST_UTIL.getHBaseCluster().getClusterMetrics().getLiveServerMetrics().size(), (long)((Integer)REGISTRY.getCurrentNrHRS().get()).intValue());
        Assert.assertEquals((Object)TEST_UTIL.getHBaseCluster().getMaster().getServerName(), REGISTRY.getMasterAddress().get());
        Assert.assertEquals((long)-1L, (long)((Integer)REGISTRY.getMasterInfoPort().get()).intValue());
        RegionReplicaTestHelper.waitUntilAllMetaReplicasHavingRegionLocation(TEST_UTIL.getConfiguration(), (AsyncRegistry)REGISTRY, 3);
        RegionLocations locs = (RegionLocations)REGISTRY.getMetaRegionLocation().get();
        Assert.assertEquals((long)3L, (long)locs.getRegionLocations().length);
        IntStream.range(0, 3).forEach(i -> {
            HRegionLocation loc = locs.getRegionLocation(i);
            Assert.assertNotNull((String)("Replica " + i + " doesn't have location"), (Object)loc);
            Assert.assertEquals((Object)TableName.META_TABLE_NAME, (Object)loc.getRegion().getTable());
            Assert.assertEquals((long)i, (long)loc.getRegion().getReplicaId());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndependentZKConnections() throws IOException {
        try (ReadOnlyZKClient zk1 = REGISTRY.getZKClient();){
            Configuration otherConf = new Configuration(TEST_UTIL.getConfiguration());
            otherConf.set("hbase.zookeeper.quorum", "127.0.0.1");
            try (ZKAsyncRegistry otherRegistry = new ZKAsyncRegistry(otherConf);){
                ReadOnlyZKClient zk2 = otherRegistry.getZKClient();
                Assert.assertNotSame((String)"Using a different configuration / quorum should result in different backing zk connection.", (Object)zk1, (Object)zk2);
                Assert.assertNotEquals((String)"Using a different configrution / quorum should be reflected in the zk connection.", (Object)zk1.getConnectString(), (Object)zk2.getConnectString());
            }
        }
        finally {
            LOG.info("DONE!");
        }
    }

    @Test
    public void testNoMetaAvailable() throws InterruptedException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("zookeeper.znode.metaserver", "whatever");
        try (ZKAsyncRegistry registry = new ZKAsyncRegistry(conf);){
            try {
                registry.getMetaRegionLocation().get();
                Assert.fail((String)"Should have failed since we set an incorrect meta znode prefix");
            }
            catch (ExecutionException e) {
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
            }
        }
    }
}

