/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestActiveMasterManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestActiveMasterManager.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestActiveMasterManager.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testRestartMaster() throws IOException, KeeperException {
        ZKWatcher zk = new ZKWatcher(TEST_UTIL.getConfiguration(), "testActiveMasterManagerFromZK", null, true);
        try {
            ZKUtil.deleteNode((ZKWatcher)zk, (String)zk.getZNodePaths().masterAddressZNode);
            ZKUtil.deleteNode((ZKWatcher)zk, (String)zk.getZNodePaths().clusterStateZNode);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        ServerName master = ServerName.valueOf((String)"localhost", (int)1, (long)System.currentTimeMillis());
        DummyMaster dummyMaster = new DummyMaster(zk, master);
        ClusterStatusTracker clusterStatusTracker = dummyMaster.getClusterStatusTracker();
        ActiveMasterManager activeMasterManager = dummyMaster.getActiveMasterManager();
        Assert.assertFalse((boolean)activeMasterManager.clusterHasActiveMaster.get());
        MonitoredTask status = (MonitoredTask)Mockito.mock(MonitoredTask.class);
        clusterStatusTracker.setClusterUp();
        activeMasterManager.blockUntilBecomingActiveMaster(100, status);
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, master);
        DummyMaster secondDummyMaster = new DummyMaster(zk, master);
        ActiveMasterManager secondActiveMasterManager = secondDummyMaster.getActiveMasterManager();
        Assert.assertFalse((boolean)secondActiveMasterManager.clusterHasActiveMaster.get());
        activeMasterManager.blockUntilBecomingActiveMaster(100, status);
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, master);
    }

    @Test
    public void testActiveMasterManagerFromZK() throws Exception {
        int sleeps;
        ZKWatcher zk = new ZKWatcher(TEST_UTIL.getConfiguration(), "testActiveMasterManagerFromZK", null, true);
        try {
            ZKUtil.deleteNode((ZKWatcher)zk, (String)zk.getZNodePaths().masterAddressZNode);
            ZKUtil.deleteNode((ZKWatcher)zk, (String)zk.getZNodePaths().clusterStateZNode);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        ServerName firstMasterAddress = ServerName.valueOf((String)"localhost", (int)1, (long)System.currentTimeMillis());
        ServerName secondMasterAddress = ServerName.valueOf((String)"localhost", (int)2, (long)System.currentTimeMillis());
        DummyMaster ms1 = new DummyMaster(zk, firstMasterAddress);
        ActiveMasterManager activeMasterManager = ms1.getActiveMasterManager();
        Assert.assertFalse((boolean)activeMasterManager.clusterHasActiveMaster.get());
        ClusterStatusTracker clusterStatusTracker = ms1.getClusterStatusTracker();
        clusterStatusTracker.setClusterUp();
        activeMasterManager.blockUntilBecomingActiveMaster(100, (MonitoredTask)Mockito.mock(MonitoredTask.class));
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, firstMasterAddress);
        WaitToBeMasterThread t = new WaitToBeMasterThread(zk, secondMasterAddress);
        t.start();
        for (sleeps = 0; !t.manager.clusterHasActiveMaster.get() && sleeps < 100; ++sleeps) {
            Thread.sleep(10L);
        }
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        Assert.assertTrue((boolean)t.manager.clusterHasActiveMaster.get());
        Assert.assertFalse((boolean)t.isActiveMaster);
        ms1.stop("stopping first server");
        NodeDeletionListener listener = new NodeDeletionListener(zk, zk.getZNodePaths().masterAddressZNode);
        zk.registerListener((ZKListener)listener);
        LOG.info("Deleting master node");
        ZKUtil.deleteNode((ZKWatcher)zk, (String)zk.getZNodePaths().masterAddressZNode);
        LOG.info("Waiting for active master manager to be notified");
        listener.waitForDeletion();
        LOG.info("Master node deleted");
        for (sleeps = 0; !t.isActiveMaster && sleeps < 100; ++sleeps) {
            Thread.sleep(10L);
        }
        LOG.debug("Slept " + sleeps + " times");
        Assert.assertTrue((boolean)t.manager.clusterHasActiveMaster.get());
        Assert.assertTrue((boolean)t.isActiveMaster);
        LOG.info("Deleting master node");
        ZKUtil.deleteNode((ZKWatcher)zk, (String)zk.getZNodePaths().masterAddressZNode);
    }

    private void assertMaster(ZKWatcher zk, ServerName expectedAddress) throws KeeperException, IOException {
        ServerName readAddress = MasterAddressTracker.getMasterAddress((ZKWatcher)zk);
        Assert.assertNotNull((Object)readAddress);
        Assert.assertTrue((boolean)expectedAddress.equals((Object)readAddress));
    }

    public static class DummyMaster
    implements Server {
        private volatile boolean stopped;
        private ClusterStatusTracker clusterStatusTracker;
        private ActiveMasterManager activeMasterManager;

        public DummyMaster(ZKWatcher zk, ServerName master) {
            this.clusterStatusTracker = new ClusterStatusTracker(zk, (Abortable)this);
            this.clusterStatusTracker.start();
            this.activeMasterManager = new ActiveMasterManager(zk, master, (Server)this);
            zk.registerListener((ZKListener)this.activeMasterManager);
        }

        public void abort(String msg, Throwable t) {
        }

        public boolean isAborted() {
            return false;
        }

        public Configuration getConfiguration() {
            return null;
        }

        public ZKWatcher getZooKeeper() {
            return null;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ServerName getServerName() {
            return null;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public void stop(String why) {
            this.stopped = true;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public ClusterStatusTracker getClusterStatusTracker() {
            return this.clusterStatusTracker;
        }

        public ActiveMasterManager getActiveMasterManager() {
            return this.activeMasterManager;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }

    public static class NodeDeletionListener
    extends ZKListener {
        private static final Logger LOG = LoggerFactory.getLogger(NodeDeletionListener.class);
        private Semaphore lock = new Semaphore(0);
        private String node;

        public NodeDeletionListener(ZKWatcher watcher, String node) {
            super(watcher);
            this.node = node;
        }

        public void nodeDeleted(String path) {
            if (path.equals(this.node)) {
                LOG.debug("nodeDeleted(" + path + ")");
                this.lock.release();
            }
        }

        public void waitForDeletion() throws InterruptedException {
            this.lock.acquire();
        }
    }

    public static class WaitToBeMasterThread
    extends Thread {
        ActiveMasterManager manager;
        DummyMaster dummyMaster;
        boolean isActiveMaster;

        public WaitToBeMasterThread(ZKWatcher zk, ServerName address) {
            this.dummyMaster = new DummyMaster(zk, address);
            this.manager = this.dummyMaster.getActiveMasterManager();
            this.isActiveMaster = false;
        }

        @Override
        public void run() {
            this.manager.blockUntilBecomingActiveMaster(100, (MonitoredTask)Mockito.mock(MonitoredTask.class));
            LOG.info("Second master has become the active master!");
            this.isActiveMaster = true;
        }
    }
}

