/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.AbstractTestRestartCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRetainAssignmentOnRestart
extends AbstractTestRestartCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRetainAssignmentOnRestart.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRetainAssignmentOnRestart.class);

    @Override
    protected boolean splitWALCoordinatedByZk() {
        return true;
    }

    @Test
    public void test() throws Exception {
        boolean found;
        this.UTIL.startMiniCluster(2);
        this.UTIL.getMiniHBaseCluster().getMaster().getMasterRpcServices().synchronousBalanceSwitch(false);
        LOG.info("\n\nCreating tables");
        for (TableName TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        HMaster master = this.UTIL.getMiniHBaseCluster().getMaster();
        this.UTIL.waitUntilNoRegionsInTransition(60000L);
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map regionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        MiniHBaseCluster cluster = this.UTIL.getHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> threads = cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)2L, (long)threads.size());
        int[] rsPorts = new int[3];
        for (int i = 0; i < 2; ++i) {
            rsPorts[i] = threads.get(i).getRegionServer().getServerName().getPort();
        }
        rsPorts[2] = cluster.getMaster().getServerName().getPort();
        for (ServerName serverName : regionToRegionServerMap.values()) {
            found = false;
            for (int k = 0; k < 3 && !found; ++k) {
                found = serverName.getPort() == rsPorts[k];
            }
            Assert.assertTrue((boolean)found);
        }
        LOG.info("\n\nShutting down HBase cluster");
        cluster.stopMaster(0);
        cluster.shutdown();
        cluster.waitUntilShutDown();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting cluster the second time with the same ports");
        cluster.getConf().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        master = cluster.startMaster().getMaster();
        for (int i = 0; i < 3; ++i) {
            cluster.getConf().setInt("hbase.regionserver.port", rsPorts[i]);
            cluster.startRegionServer();
        }
        List localServers = master.getServerManager().getOnlineServersList();
        Assert.assertEquals((long)3L, (long)localServers.size());
        for (int i = 0; i < 3; ++i) {
            found = false;
            for (ServerName serverName : localServers) {
                if (serverName.getPort() != rsPorts[i]) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableAvailable(TABLE);
        }
        this.UTIL.waitUntilNoRegionsInTransition(60000L);
        snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map newRegionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        Assert.assertEquals((long)regionToRegionServerMap.size(), (long)newRegionToRegionServerMap.size());
        for (Map.Entry entry : newRegionToRegionServerMap.entrySet()) {
            ServerName oldServer = (ServerName)regionToRegionServerMap.get(entry.getKey());
            ServerName currentServer = (ServerName)entry.getValue();
            LOG.info("Key=" + entry.getKey() + " oldServer=" + oldServer + ", currentServer=" + currentServer);
            Assert.assertEquals((String)((RegionInfo)entry.getKey()).toString(), (Object)oldServer.getAddress(), (Object)currentServer.getAddress());
            Assert.assertNotEquals((long)oldServer.getStartcode(), (long)currentServer.getStartcode());
        }
    }
}

