/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestModifyTableWhileMerging {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestModifyTableWhileMerging.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestModifyTableWhileMerging.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static Admin admin;
    private static Table client;
    private static byte[] CF;
    private static byte[] SPLITKEY;

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.procedure.threads", 1);
        UTIL.startMiniCluster(1);
        admin = UTIL.getHBaseAdmin();
        byte[][] splitKeys = new byte[][]{SPLITKEY};
        client = UTIL.createTable(TABLE_NAME, CF, (byte[][])splitKeys);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void test() throws Exception {
        TableDescriptor tableDescriptor = client.getDescriptor();
        ProcedureExecutor executor = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        MasterProcedureEnv env = (MasterProcedureEnv)executor.getEnvironment();
        List regionInfos = admin.getRegions(TABLE_NAME);
        MergeTableRegionsProcedure mergeTableRegionsProcedure = new MergeTableRegionsProcedure((MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment(), (RegionInfo)regionInfos.get(0), (RegionInfo)regionInfos.get(1));
        ModifyTableProcedure modifyTableProcedure = new ModifyTableProcedure(env, tableDescriptor);
        long procModify = executor.submitProcedure((Procedure)modifyTableProcedure);
        UTIL.waitFor(30000L, () -> executor.getProcedures().stream().filter(p -> p instanceof ModifyTableProcedure).map(p -> (ModifyTableProcedure)p).anyMatch(p -> TABLE_NAME.equals((Object)p.getTableName())));
        long proc = executor.submitProcedure((Procedure)mergeTableRegionsProcedure);
        UTIL.waitFor(3000000L, () -> UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().isFinished(procModify));
        Assert.assertEquals((String)"Modify Table procedure should success!", (Object)ProcedureProtos.ProcedureState.SUCCESS, (Object)modifyTableProcedure.getState());
    }

    static {
        CF = Bytes.toBytes((String)"cf");
        SPLITKEY = Bytes.toBytes((String)"bbbbbbb");
    }
}

