/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MockNoopMasterServices;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStochasticLoadBalancer
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancer.class);
    private static final String REGION_KEY = "testRegion";
    private float[] expectedLocalities = new float[]{1.0f, 0.0f, 0.5f, 0.25f, 1.0f};
    private int[][][] clusterRegionLocationMocks = new int[][][]{new int[][]{{2, 1, 1}, {2, 0, 0, 100}, {0, 100, 0, 0}, {0, 100, 0, 0}, {1, 0, 100, 0}}, new int[][]{{1, 2, 1}, {0, 0, 0, 100}, {1, 100, 0, 0}, {1, 100, 0, 0}, {2, 0, 100, 0}}, new int[][]{{1, 2, 1}, {0, 25, 0, 50}, {1, 50, 25, 0}, {1, 50, 25, 0}, {2, 0, 50, 25}}, new int[][]{{1, 2, 1}, {0, 25, 0, 100}, {1, 100, 25, 0}, {1, 100, 25, 0}, {2, 0, 100, 25}}, new int[][]{{1, 2, 1}, {0, 75, 75, 75}, {1, 75, 75, 75}, {1, 75, 75, 75}, {2, 75, 75, 75}}};

    @Test
    public void testKeepRegionLoad() throws Exception {
        ServerName sn = ServerName.valueOf((String)"test:8080", (long)100L);
        int numClusterStatusToAdd = 20000;
        for (int i = 0; i < numClusterStatusToAdd; ++i) {
            ServerMetrics sl = (ServerMetrics)Mockito.mock(ServerMetrics.class);
            RegionMetrics rl = (RegionMetrics)Mockito.mock(RegionMetrics.class);
            Mockito.when((Object)rl.getReadRequestCount()).thenReturn((Object)0L);
            Mockito.when((Object)rl.getWriteRequestCount()).thenReturn((Object)0L);
            Mockito.when((Object)rl.getMemStoreSize()).thenReturn((Object)Size.ZERO);
            Mockito.when((Object)rl.getStoreFileSize()).thenReturn((Object)new Size((double)i, Size.Unit.MEGABYTE));
            TreeMap<byte[], RegionMetrics> regionLoadMap = new TreeMap<byte[], RegionMetrics>(Bytes.BYTES_COMPARATOR);
            regionLoadMap.put(Bytes.toBytes((String)REGION_KEY), rl);
            Mockito.when((Object)sl.getRegionMetrics()).thenReturn(regionLoadMap);
            ClusterMetrics clusterStatus = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
            TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
            serverMetricsMap.put(sn, sl);
            Mockito.when((Object)clusterStatus.getLiveServerMetrics()).thenReturn(serverMetricsMap);
            loadBalancer.setClusterMetrics(clusterStatus);
        }
        String regionNameAsString = RegionInfo.getRegionNameAsString((byte[])Bytes.toBytes((String)REGION_KEY));
        Assert.assertTrue((TestStochasticLoadBalancer.loadBalancer.loads.get(regionNameAsString) != null ? 1 : 0) != 0);
        Assert.assertTrue((((Deque)TestStochasticLoadBalancer.loadBalancer.loads.get(regionNameAsString)).size() == 15 ? 1 : 0) != 0);
        Queue loads = (Queue)TestStochasticLoadBalancer.loadBalancer.loads.get(regionNameAsString);
        int i = 0;
        while (loads.size() > 0) {
            BalancerRegionLoad rl = (BalancerRegionLoad)loads.remove();
            Assert.assertEquals((long)(i + (numClusterStatusToAdd - 15)), (long)rl.getStorefileSizeMB());
            ++i;
        }
    }

    @Test
    public void testNeedBalance() {
        float minCost = conf.getFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 0.05f);
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 1.0f);
        loadBalancer.setConf(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            TreeMap<ServerName, List<RegionInfo>> servers = this.mockClusterServers(mockCluster);
            List plans = loadBalancer.balanceCluster(servers);
            Assert.assertNull((Object)plans);
        }
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", minCost);
        loadBalancer.setConf(conf);
    }

    @Test
    public void testLocalityCost() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        MockNoopMasterServices master = new MockNoopMasterServices();
        StochasticLoadBalancer.ServerLocalityCostFunction costFunction = new StochasticLoadBalancer.ServerLocalityCostFunction(conf, (MasterServices)master);
        for (int test = 0; test < this.clusterRegionLocationMocks.length; ++test) {
            int[][] clusterRegionLocations = this.clusterRegionLocationMocks[test];
            MockCluster cluster = new MockCluster(clusterRegionLocations);
            costFunction.init((BaseLoadBalancer.Cluster)cluster);
            double cost = costFunction.cost();
            double expected = 1.0f - this.expectedLocalities[test];
            Assert.assertEquals((double)expected, (double)cost, (double)0.001);
        }
    }

    @Test
    public void testMoveCost() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.MoveCostFunction costFunction = new StochasticLoadBalancer.MoveCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BaseLoadBalancer.Cluster cluster = this.mockCluster(mockCluster);
            costFunction.init(cluster);
            double cost = costFunction.cost();
            Assert.assertEquals((double)0.0, (double)cost, (double)0.001);
            cluster.setNumRegions(200);
            cluster.setNumMovedRegions(10);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.05f, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(100);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.5, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(200);
            cost = costFunction.cost();
            Assert.assertEquals((double)1.0, (double)cost, (double)0.001);
            cluster.setNumRegions(10000);
            cluster.setNumMovedRegions(250);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.1f, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(1250);
            cost = costFunction.cost();
            Assert.assertEquals((double)0.5, (double)cost, (double)0.001);
            cluster.setNumMovedRegions(2500);
            cost = costFunction.cost();
            Assert.assertEquals((double)1.0, (double)cost, (double)0.01);
        }
    }

    @Test
    public void testSkewCost() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.RegionCountSkewCostFunction costFunction = new StochasticLoadBalancer.RegionCountSkewCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            costFunction.init(this.mockCluster(mockCluster));
            double cost = costFunction.cost();
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
        costFunction.init(this.mockCluster(new int[]{0, 0, 0, 0, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{0, 0, 0, 1, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{0, 0, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{0, 1, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{1, 1, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)costFunction.cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{10000, 0, 0, 0, 0}));
        Assert.assertEquals((double)1.0, (double)costFunction.cost(), (double)0.01);
    }

    @Test
    public void testCostAfterUndoAction() {
        int runs = 10;
        loadBalancer.setConf(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BaseLoadBalancer.Cluster cluster = this.mockCluster(mockCluster);
            loadBalancer.initCosts(cluster);
            for (int i = 0; i != 10; ++i) {
                double expectedCost = loadBalancer.computeCost(cluster, Double.MAX_VALUE);
                BaseLoadBalancer.Cluster.Action action = loadBalancer.nextAction(cluster);
                cluster.doAction(action);
                loadBalancer.updateCostsWithAction(cluster, action);
                BaseLoadBalancer.Cluster.Action undoAction = action.undoAction();
                cluster.doAction(undoAction);
                loadBalancer.updateCostsWithAction(cluster, undoAction);
                double actualCost = loadBalancer.computeCost(cluster, Double.MAX_VALUE);
                Assert.assertEquals((double)expectedCost, (double)actualCost, (double)0.0);
            }
        }
    }

    @Test
    public void testTableSkewCost() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.TableSkewCostFunction costFunction = new StochasticLoadBalancer.TableSkewCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BaseLoadBalancer.Cluster cluster = this.mockCluster(mockCluster);
            costFunction.init(cluster);
            double cost = costFunction.cost();
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRegionLoadCost() {
        ArrayList<BalancerRegionLoad> regionLoads = new ArrayList<BalancerRegionLoad>();
        for (int i = 1; i < 5; ++i) {
            BalancerRegionLoad regionLoad = (BalancerRegionLoad)Mockito.mock(BalancerRegionLoad.class);
            Mockito.when((Object)regionLoad.getReadRequestsCount()).thenReturn((Object)new Long(i));
            Mockito.when((Object)regionLoad.getStorefileSizeMB()).thenReturn((Object)i);
            regionLoads.add(regionLoad);
        }
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.ReadRequestCostFunction readCostFunction = new StochasticLoadBalancer.ReadRequestCostFunction(conf);
        double rateResult = readCostFunction.getRegionLoadCost(regionLoads);
        Assert.assertEquals((double)1.0, (double)rateResult, (double)0.01);
        StochasticLoadBalancer.StoreFileCostFunction storeFileCostFunction = new StochasticLoadBalancer.StoreFileCostFunction(conf);
        double result = storeFileCostFunction.getRegionLoadCost(regionLoads);
        Assert.assertEquals((double)2.5, (double)result, (double)0.01);
    }

    @Test
    public void testCostFromArray() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.MemStoreSizeCostFunction costFunction = new StochasticLoadBalancer.MemStoreSizeCostFunction(conf);
        costFunction.init(this.mockCluster(new int[]{0, 0, 0, 0, 1}));
        double[] statOne = new double[100];
        for (int i = 0; i < 100; ++i) {
            statOne[i] = 10.0;
        }
        Assert.assertEquals((double)0.0, (double)costFunction.costFromArray(statOne), (double)0.01);
        double[] statTwo = new double[101];
        for (int i = 0; i < 100; ++i) {
            statTwo[i] = 0.0;
        }
        statTwo[100] = 100.0;
        Assert.assertEquals((double)1.0, (double)costFunction.costFromArray(statTwo), (double)0.01);
        double[] statThree = new double[200];
        for (int i = 0; i < 100; ++i) {
            statThree[i] = 0.0;
            statThree[i + 100] = 100.0;
        }
        Assert.assertEquals((double)0.5, (double)costFunction.costFromArray(statThree), (double)0.01);
    }

    @Test
    public void testLosingRs() throws Exception {
        int numNodes = 3;
        int numRegions = 20;
        int numRegionsPerServer = 3;
        int replication = 1;
        int numTables = 2;
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        List<ServerAndLoad> list = this.convertToList(serverMap);
        List plans = loadBalancer.balanceCluster(serverMap);
        Assert.assertNotNull((Object)plans);
        List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, serverMap);
        this.assertClusterAsBalanced(balancedCluster);
        ServerName sn = serverMap.keySet().toArray(new ServerName[serverMap.size()])[0];
        ServerName deadSn = ServerName.valueOf((String)sn.getHostname(), (int)sn.getPort(), (long)(sn.getStartcode() - 100L));
        serverMap.put(deadSn, new ArrayList(0));
        plans = loadBalancer.balanceCluster(serverMap);
        Assert.assertNull((Object)plans);
    }

    private class MockCluster
    extends BaseLoadBalancer.Cluster {
        private int[][] localities;

        public MockCluster(int[][] regions) {
            super(TestStochasticLoadBalancer.this.mockClusterServers(regions[0], 1), null, null, null);
            this.localities = null;
            this.localities = new int[regions.length - 1][];
            for (int i = 1; i < regions.length; ++i) {
                int regionIndex = i - 1;
                this.localities[regionIndex] = new int[regions[i].length - 1];
                this.regionIndexToServerIndex[regionIndex] = regions[i][0];
                for (int j = 1; j < regions[i].length; ++j) {
                    int serverIndex = j - 1;
                    this.localities[regionIndex][serverIndex] = regions[i][j] > 100 ? regions[i][j] % 100 : regions[i][j];
                }
            }
        }

        float getLocalityOfRegion(int region, int server) {
            return (float)this.localities[region][server] / 100.0f;
        }

        public int getRegionSizeMB(int region) {
            return 1;
        }
    }
}

