/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSCPBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestSCPBase.class);
    protected HBaseTestingUtility util;

    protected void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.set("hbase.balancer.tablesOnMaster", "none");
        conf.setInt("hbase.client.retries.number", 3);
        conf.setInt("hbase.client.serverside.retries.multiplier", 3);
        conf.setBoolean("hbase.split.writer.creation.bounded", true);
        conf.setInt("hbase.regionserver.hlog.splitlog.writer.threads", 8);
        conf.setBoolean("hbase.split.wal.zk.coordinated", true);
    }

    @Before
    public void setup() throws Exception {
        this.util = new HBaseTestingUtility();
        this.setupConf(this.util.getConfiguration());
        this.startMiniCluster();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)this.util.getHBaseCluster().getMaster().getMasterProcedureExecutor(), (boolean)false);
    }

    protected void startMiniCluster() throws Exception {
        this.util.startMiniCluster(3);
    }

    @After
    public void tearDown() throws Exception {
        HMaster master;
        MiniHBaseCluster cluster = this.util.getHBaseCluster();
        HMaster hMaster = master = cluster == null ? null : cluster.getMaster();
        if (master != null && master.getMasterProcedureExecutor() != null) {
            ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)master.getMasterProcedureExecutor(), (boolean)false);
        }
        this.util.shutdownMiniCluster();
    }

    protected void testRecoveryAndDoubleExecution(boolean carryingMeta, boolean doubleExecution) throws Exception {
        TableName tableName = TableName.valueOf((String)("testRecoveryAndDoubleExecution-carryingMeta-" + carryingMeta + "-doubleExecution-" + doubleExecution));
        try (Table t = this.createTable(tableName);){
            this.util.loadTable(t, HBaseTestingUtility.COLUMNS[0]);
            int count = this.util.countRows(t);
            Assert.assertTrue((String)"expected some rows", (count > 0 ? 1 : 0) != 0);
            String checksum = this.util.checksumRows(t);
            HMaster master = this.util.getHBaseCluster().getMaster();
            ProcedureExecutor procExec = master.getMasterProcedureExecutor();
            ServerName rsToKill = null;
            for (RegionInfo hri : this.util.getAdmin().getRegions(tableName)) {
                ServerName serverName = AssignmentTestingUtil.getServerHoldingRegion(this.util, hri);
                if (AssignmentTestingUtil.isServerHoldingMeta(this.util, serverName) != carryingMeta) continue;
                rsToKill = serverName;
                break;
            }
            ProcedureTestingUtility.waitNoProcedureRunning((ProcedureExecutor)procExec);
            if (doubleExecution) {
                ProcedureTestingUtility.setKillIfHasParent((ProcedureExecutor)procExec, (boolean)false);
                ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)procExec, (boolean)true);
                AssignmentTestingUtil.killRs(this.util, rsToKill);
                long procId = this.getSCPProcId(procExec);
                MasterProcedureTestingUtility.testRecoveryAndDoubleExecution((ProcedureExecutor<MasterProcedureEnv>)procExec, procId);
            } else {
                AssignmentTestingUtil.killRs(this.util, rsToKill);
                long procId = this.getSCPProcId(procExec);
                ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
            }
            this.assertReplicaDistributed(t);
            Assert.assertEquals((long)count, (long)this.util.countRows(t));
            Assert.assertEquals((Object)checksum, (Object)this.util.checksumRows(t));
        }
    }

    protected long getSCPProcId(ProcedureExecutor<?> procExec) {
        this.util.waitFor(30000L, () -> !procExec.getProcedures().isEmpty());
        return procExec.getActiveProcIds().stream().mapToLong(Long::longValue).min().getAsLong();
    }

    private void assertReplicaDistributed(Table t) throws IOException {
        if (t.getDescriptor().getRegionReplication() <= 1) {
            return;
        }
        ArrayList<RegionInfo> regionInfos = new ArrayList<RegionInfo>();
        for (JVMClusterUtil.RegionServerThread rs : this.util.getMiniHBaseCluster().getRegionServerThreads()) {
            regionInfos.clear();
            for (Region r : rs.getRegionServer().getRegions(t.getName())) {
                LOG.info("The region is " + r.getRegionInfo() + " the location is " + rs.getRegionServer().getServerName());
                if (this.contains(regionInfos, r.getRegionInfo())) {
                    LOG.error("Am exiting");
                    Assert.fail((String)"Crashed replica regions should not be assigned to same region server");
                    continue;
                }
                regionInfos.add(r.getRegionInfo());
            }
        }
    }

    private boolean contains(List<RegionInfo> regionInfos, RegionInfo regionInfo) {
        for (RegionInfo info : regionInfos) {
            if (!RegionReplicaUtil.isReplicasForSameRegion((RegionInfo)info, (RegionInfo)regionInfo)) continue;
            return true;
        }
        return false;
    }

    protected Table createTable(TableName tableName) throws IOException {
        Table t = this.util.createTable(tableName, HBaseTestingUtility.COLUMNS, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE, this.getRegionReplication());
        return t;
    }

    protected int getRegionReplication() {
        return 1;
    }
}

