/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestClearRegionBlockCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClearRegionBlockCache.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestClearRegionBlockCache.class);
    private static final TableName TABLE_NAME = TableName.valueOf((String)"testClearRegionBlockCache");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[][] SPLIT_KEY = new byte[][]{Bytes.toBytes((String)"5")};
    private static final int NUM_RS = 2;
    private final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private Configuration CONF = this.HTU.getConfiguration();
    private Table table;
    private HRegionServer rs1;
    private HRegionServer rs2;
    private MiniHBaseCluster cluster;
    @Parameterized.Parameter
    public String cacheType;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Object[] data() {
        return new Object[]{"lru", "bucket"};
    }

    @Before
    public void setup() throws Exception {
        if (this.cacheType.equals("bucket")) {
            this.CONF.set("hbase.bucketcache.ioengine", "offheap");
            this.CONF.setInt("hbase.bucketcache.size", 30);
        }
        this.cluster = this.HTU.startMiniCluster(2);
        this.rs1 = this.cluster.getRegionServer(0);
        this.rs2 = this.cluster.getRegionServer(1);
        this.table = this.HTU.createTable(TABLE_NAME, FAMILY, SPLIT_KEY);
        this.HTU.loadNumericRows(this.table, FAMILY, 1, 10);
        this.HTU.flush(TABLE_NAME);
    }

    @After
    public void teardown() throws Exception {
        this.HTU.shutdownMiniCluster();
    }

    @Test
    public void testClearBlockCache() throws Exception {
        BlockCache blockCache1 = (BlockCache)this.rs1.getBlockCache().get();
        BlockCache blockCache2 = (BlockCache)this.rs2.getBlockCache().get();
        long initialBlockCount1 = blockCache1.getBlockCount();
        long initialBlockCount2 = blockCache2.getBlockCount();
        this.scanAllRegionsForRS(this.rs1);
        Assert.assertEquals((long)(blockCache1.getBlockCount() - initialBlockCount1), (long)this.HTU.getNumHFilesForRS(this.rs1, TABLE_NAME, FAMILY));
        this.clearRegionBlockCache(this.rs1);
        this.scanAllRegionsForRS(this.rs2);
        Assert.assertEquals((long)(blockCache2.getBlockCount() - initialBlockCount2), (long)this.HTU.getNumHFilesForRS(this.rs2, TABLE_NAME, FAMILY));
        this.clearRegionBlockCache(this.rs2);
        Assert.assertEquals((long)initialBlockCount1, (long)blockCache1.getBlockCount());
        Assert.assertEquals((long)initialBlockCount2, (long)blockCache2.getBlockCount());
    }

    @Test
    public void testClearBlockCacheFromAdmin() throws Exception {
        Admin admin = this.HTU.getAdmin();
        BlockCache blockCache1 = (BlockCache)this.rs1.getBlockCache().get();
        BlockCache blockCache2 = (BlockCache)this.rs2.getBlockCache().get();
        long initialBlockCount1 = blockCache1.getBlockCount();
        long initialBlockCount2 = blockCache2.getBlockCount();
        this.scanAllRegionsForRS(this.rs1);
        Assert.assertEquals((long)(blockCache1.getBlockCount() - initialBlockCount1), (long)this.HTU.getNumHFilesForRS(this.rs1, TABLE_NAME, FAMILY));
        this.scanAllRegionsForRS(this.rs2);
        Assert.assertEquals((long)(blockCache2.getBlockCount() - initialBlockCount2), (long)this.HTU.getNumHFilesForRS(this.rs2, TABLE_NAME, FAMILY));
        CacheEvictionStats stats = admin.clearBlockCache(TABLE_NAME);
        Assert.assertEquals((long)stats.getEvictedBlocks(), (long)(this.HTU.getNumHFilesForRS(this.rs1, TABLE_NAME, FAMILY) + this.HTU.getNumHFilesForRS(this.rs2, TABLE_NAME, FAMILY)));
        Assert.assertEquals((long)initialBlockCount1, (long)blockCache1.getBlockCount());
        Assert.assertEquals((long)initialBlockCount2, (long)blockCache2.getBlockCount());
    }

    @Test
    public void testClearBlockCacheFromAsyncAdmin() throws Exception {
        AsyncAdmin admin = ((AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)this.HTU.getConfiguration()).get()).getAdmin();
        BlockCache blockCache1 = (BlockCache)this.rs1.getBlockCache().get();
        BlockCache blockCache2 = (BlockCache)this.rs2.getBlockCache().get();
        long initialBlockCount1 = blockCache1.getBlockCount();
        long initialBlockCount2 = blockCache2.getBlockCount();
        this.scanAllRegionsForRS(this.rs1);
        Assert.assertEquals((long)(blockCache1.getBlockCount() - initialBlockCount1), (long)this.HTU.getNumHFilesForRS(this.rs1, TABLE_NAME, FAMILY));
        this.scanAllRegionsForRS(this.rs2);
        Assert.assertEquals((long)(blockCache2.getBlockCount() - initialBlockCount2), (long)this.HTU.getNumHFilesForRS(this.rs2, TABLE_NAME, FAMILY));
        CacheEvictionStats stats = (CacheEvictionStats)admin.clearBlockCache(TABLE_NAME).get();
        Assert.assertEquals((long)stats.getEvictedBlocks(), (long)(this.HTU.getNumHFilesForRS(this.rs1, TABLE_NAME, FAMILY) + this.HTU.getNumHFilesForRS(this.rs2, TABLE_NAME, FAMILY)));
        Assert.assertEquals((long)initialBlockCount1, (long)blockCache1.getBlockCount());
        Assert.assertEquals((long)initialBlockCount2, (long)blockCache2.getBlockCount());
    }

    private void scanAllRegionsForRS(HRegionServer rs) throws IOException {
        for (Region region : rs.getRegions(TABLE_NAME)) {
            RegionScanner scanner = region.getScanner(new Scan());
            while (scanner.next(new ArrayList())) {
            }
        }
    }

    private void clearRegionBlockCache(HRegionServer rs) {
        for (Region region : rs.getRegions(TABLE_NAME)) {
            rs.clearRegionBlockCache(region);
        }
    }
}

