/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellArrayImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellChunkImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreMergerSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.TestCompactingMemStore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestCompactingToCellFlatMapMemStore
extends TestCompactingMemStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactingToCellFlatMapMemStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCompactingToCellFlatMapMemStore.class);
    public final boolean toCellChunkMap;
    Configuration conf;

    @Parameterized.Parameters
    public static Object[] data() {
        return new Object[]{"CHUNK_MAP", "ARRAY_MAP"};
    }

    public TestCompactingToCellFlatMapMemStore(String type) {
        this.toCellChunkMap = type == "CHUNK_MAP";
    }

    @Override
    public void tearDown() throws Exception {
        chunkCreator.clearChunksInPool();
    }

    @Override
    public void setUp() throws Exception {
        this.compactingSetUp();
        this.conf = HBaseConfiguration.create();
        this.conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(MemoryCompactionPolicy.EAGER));
        this.conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.02);
        this.memstore = new TestCompactingMemStore.MyCompactingMemStore(this.conf, (CellComparator)CellComparatorImpl.COMPARATOR, this.store, this.regionServicesForStores, MemoryCompactionPolicy.EAGER);
    }

    @Override
    public void testCompaction1Bucket() throws IOException {
        int counter = 0;
        String[] keys1 = new String[]{"A", "A", "B", "C"};
        if (this.toCellChunkMap) {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        } else {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.ARRAY_MAP);
        }
        long totalCellsLen = this.addRowsByKeysDataSize(this.memstore, keys1);
        long cellBeforeFlushSize = this.cellBeforeFlushSize();
        long cellAfterFlushSize = this.cellAfterFlushSize();
        long totalHeapSize = MutableSegment.DEEP_OVERHEAD + 4L * cellBeforeFlushSize;
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        Assert.assertEquals((long)4L, (long)this.memstore.getActive().getCellsCount());
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        totalCellsLen = totalCellsLen * 3L / 4L;
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        totalHeapSize = 3L * cellAfterFlushSize + MutableSegment.DEEP_OVERHEAD + (this.toCellChunkMap ? CellChunkImmutableSegment.DEEP_OVERHEAD_CCM : CellArrayImmutableSegment.DEEP_OVERHEAD_CAM);
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        for (Segment s : this.memstore.getSegments()) {
            counter += s.getCellsCount();
        }
        Assert.assertEquals((long)3L, (long)counter);
        MemStoreSize mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss);
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)3L, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Override
    public void testCompaction2Buckets() throws IOException {
        if (this.toCellChunkMap) {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        } else {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.ARRAY_MAP);
        }
        String[] keys1 = new String[]{"A", "A", "B", "C"};
        String[] keys2 = new String[]{"A", "B", "D"};
        long totalCellsLen1 = this.addRowsByKeysDataSize(this.memstore, keys1);
        long cellBeforeFlushSize = this.cellBeforeFlushSize();
        long cellAfterFlushSize = this.cellAfterFlushSize();
        long totalHeapSize1 = MutableSegment.DEEP_OVERHEAD + 4L * cellBeforeFlushSize;
        Assert.assertEquals((long)totalCellsLen1, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize1, (long)((CompactingMemStore)this.memstore).heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        int counter = 0;
        for (Segment s : this.memstore.getSegments()) {
            counter += s.getCellsCount();
        }
        Assert.assertEquals((long)3L, (long)counter);
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        totalCellsLen1 = totalCellsLen1 * 3L / 4L;
        totalHeapSize1 = 3L * cellAfterFlushSize + MutableSegment.DEEP_OVERHEAD + (this.toCellChunkMap ? CellChunkImmutableSegment.DEEP_OVERHEAD_CCM : CellArrayImmutableSegment.DEEP_OVERHEAD_CAM);
        Assert.assertEquals((long)totalCellsLen1, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize1, (long)((CompactingMemStore)this.memstore).heapSize());
        long totalCellsLen2 = this.addRowsByKeysDataSize(this.memstore, keys2);
        long totalHeapSize2 = 3L * cellBeforeFlushSize;
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)(totalHeapSize1 + totalHeapSize2), (long)((CompactingMemStore)this.memstore).heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        counter = 0;
        for (Segment s : this.memstore.getSegments()) {
            counter += s.getCellsCount();
        }
        Assert.assertEquals((long)4L, (long)counter);
        Assert.assertEquals((long)(totalCellsLen1 + (totalCellsLen2 /= 3L)), (long)this.regionServicesForStores.getMemStoreSize());
        totalHeapSize2 = 1L * cellAfterFlushSize;
        Assert.assertEquals((long)(totalHeapSize1 + totalHeapSize2), (long)((CompactingMemStore)this.memstore).heapSize());
        MemStoreSize mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss);
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)4L, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Override
    public void testCompaction3Buckets() throws IOException {
        if (this.toCellChunkMap) {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        } else {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.ARRAY_MAP);
        }
        String[] keys1 = new String[]{"A", "A", "B", "C"};
        String[] keys2 = new String[]{"A", "B", "D"};
        String[] keys3 = new String[]{"D", "B", "B"};
        long totalCellsLen1 = this.addRowsByKeysDataSize(this.memstore, keys1);
        long cellBeforeFlushSize = this.cellBeforeFlushSize();
        long cellAfterFlushSize = this.cellAfterFlushSize();
        long totalHeapSize1 = MutableSegment.DEEP_OVERHEAD + 4L * cellBeforeFlushSize;
        Assert.assertEquals((long)totalCellsLen1, (long)this.region.getMemStoreDataSize());
        Assert.assertEquals((long)totalHeapSize1, (long)((CompactingMemStore)this.memstore).heapSize());
        MemStoreSize mss = this.memstore.getFlushableSize();
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        totalCellsLen1 = totalCellsLen1 * 3L / 4L;
        totalHeapSize1 = 3L * cellAfterFlushSize + MutableSegment.DEEP_OVERHEAD + (this.toCellChunkMap ? CellChunkImmutableSegment.DEEP_OVERHEAD_CCM : CellArrayImmutableSegment.DEEP_OVERHEAD_CAM);
        Assert.assertEquals((long)totalCellsLen1, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize1, (long)((CompactingMemStore)this.memstore).heapSize());
        long totalCellsLen2 = this.addRowsByKeysDataSize(this.memstore, keys2);
        long totalHeapSize2 = 3L * cellBeforeFlushSize;
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)(totalHeapSize1 + totalHeapSize2), (long)((CompactingMemStore)this.memstore).heapSize());
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).disableCompaction();
        mss = this.memstore.getFlushableSize();
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)(totalHeapSize1 + (totalHeapSize2 += CSLMImmutableSegment.DEEP_OVERHEAD_CSLM)), (long)((CompactingMemStore)this.memstore).heapSize());
        long totalCellsLen3 = this.addRowsByKeysDataSize(this.memstore, keys3);
        long totalHeapSize3 = 3L * cellBeforeFlushSize;
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2 + totalCellsLen3), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)(totalHeapSize1 + totalHeapSize2 + totalHeapSize3), (long)((CompactingMemStore)this.memstore).heapSize());
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).enableCompaction();
        mss = this.memstore.getFlushableSize();
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        totalCellsLen3 = 0L;
        Assert.assertEquals((long)(totalCellsLen1 + (totalCellsLen2 /= 3L) + totalCellsLen3), (long)this.regionServicesForStores.getMemStoreSize());
        long totalHeapSize4 = 4L * cellAfterFlushSize + MutableSegment.DEEP_OVERHEAD + (this.toCellChunkMap ? CellChunkImmutableSegment.DEEP_OVERHEAD_CCM : CellArrayImmutableSegment.DEEP_OVERHEAD_CAM);
        Assert.assertEquals((long)totalHeapSize4, (long)((CompactingMemStore)this.memstore).heapSize());
        mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)4L, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Test
    public void testMerging() throws IOException {
        Segment s5;
        if (this.toCellChunkMap) {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        }
        String[] keys1 = new String[]{"A", "A", "B", "C", "F", "H"};
        String[] keys2 = new String[]{"A", "B", "D", "G", "I", "J"};
        String[] keys3 = new String[]{"D", "B", "B", "E"};
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.BASIC;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        this.addRowsByKeysDataSize(this.memstore, keys1);
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        this.addRowsByKeysDataSize(this.memstore, keys2);
        int counter2 = 0;
        for (Object s2 : this.memstore.getSegments()) {
            counter2 += s2.getCellsCount();
        }
        Assert.assertEquals((long)12L, (long)counter2);
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).disableCompaction();
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        int counter3 = 0;
        for (Object s3 : this.memstore.getSegments()) {
            counter3 += s3.getCellsCount();
        }
        Assert.assertEquals((long)12L, (long)counter3);
        this.addRowsByKeysDataSize(this.memstore, keys3);
        int counter4 = 0;
        for (Object s4 : this.memstore.getSegments()) {
            counter4 += s4.getCellsCount();
        }
        Assert.assertEquals((long)16L, (long)counter4);
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).enableCompaction();
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        int counter = 0;
        for (Segment s5 : this.memstore.getSegments()) {
            counter += s5.getCellsCount();
        }
        Assert.assertEquals((long)16L, (long)counter);
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        s5 = this.memstore.getSnapshot();
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Test
    public void testTimeRangeAfterCompaction() throws IOException {
        if (this.toCellChunkMap) {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        }
        this.testTimeRange(true);
    }

    @Test
    public void testTimeRangeAfterMerge() throws IOException {
        if (this.toCellChunkMap) {
            ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        }
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.BASIC;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        this.testTimeRange(false);
    }

    private void testTimeRange(boolean isCompaction) throws IOException {
        long initTs = 100L;
        long currentTs = 100L;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] qf1 = Bytes.toBytes((String)"qf1");
        this.memstore.add((Cell)new KeyValue(row, family, qf1, ++currentTs, (byte[])null), null);
        long minTs = currentTs++;
        this.memstore.add((Cell)new KeyValue(row, family, qf1, currentTs, (byte[])null), null);
        long numberOfCell = 2L;
        Assert.assertEquals((long)numberOfCell, (long)this.memstore.getSegments().stream().mapToInt(Segment::getCellsCount).sum());
        Assert.assertEquals((long)minTs, (long)this.memstore.getSegments().stream().mapToLong(m -> m.getTimeRangeTracker().getMin()).min().getAsLong());
        Assert.assertEquals((long)currentTs, (long)this.memstore.getSegments().stream().mapToLong(m -> m.getTimeRangeTracker().getMax()).max().getAsLong());
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        if (isCompaction) {
            numberOfCell = 1L;
            minTs = currentTs;
        }
        this.memstore.add((Cell)new KeyValue(row, family, qf1, ++currentTs, (byte[])null), null);
        this.memstore.add((Cell)new KeyValue(row, family, qf1, ++currentTs, (byte[])null), null);
        Assert.assertEquals((long)(numberOfCell += 2L), (long)this.memstore.getSegments().stream().mapToInt(Segment::getCellsCount).sum());
        Assert.assertEquals((long)minTs, (long)this.memstore.getSegments().stream().mapToLong(m -> m.getTimeRangeTracker().getMin()).min().getAsLong());
        Assert.assertEquals((long)currentTs, (long)this.memstore.getSegments().stream().mapToLong(m -> m.getTimeRangeTracker().getMax()).max().getAsLong());
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        if (isCompaction) {
            numberOfCell = 1L;
            minTs = currentTs;
        }
        Assert.assertEquals((long)numberOfCell, (long)this.memstore.getSegments().stream().mapToInt(Segment::getCellsCount).sum());
        Assert.assertEquals((long)minTs, (long)this.memstore.getSegments().stream().mapToLong(m -> m.getTimeRangeTracker().getMin()).min().getAsLong());
        Assert.assertEquals((long)currentTs, (long)this.memstore.getSegments().stream().mapToLong(m -> m.getTimeRangeTracker().getMax()).max().getAsLong());
    }

    @Test
    public void testCountOfCellsAfterFlatteningByScan() throws IOException {
        int i;
        String[] keys1 = new String[]{"A", "B", "C"};
        this.addRowsByKeysWith50Cols(this.memstore, keys1);
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        List scanners = this.memstore.getScanners(Long.MAX_VALUE);
        int count = 0;
        for (i = 0; i < scanners.size(); ++i) {
            ((KeyValueScanner)scanners.get(i)).seek((Cell)KeyValue.LOWESTKEY);
            while (((KeyValueScanner)scanners.get(i)).next() != null) {
                ++count;
            }
        }
        Assert.assertEquals((String)"the count should be ", (long)150L, (long)count);
        for (i = 0; i < scanners.size(); ++i) {
            ((KeyValueScanner)scanners.get(i)).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountOfCellsAfterFlatteningByIterator() throws IOException {
        String[] keys1 = new String[]{"A", "B", "C"};
        this.addRowsByKeysWith50Cols(this.memstore, keys1);
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        int cnt = 0;
        try (MemStoreMergerSegmentsIterator itr = new MemStoreMergerSegmentsIterator(((CompactingMemStore)this.memstore).getImmutableSegments().getStoreSegments(), (CellComparator)CellComparatorImpl.COMPARATOR, 10);){
            while (itr.next() != null) {
                ++cnt;
            }
        }
        Assert.assertEquals((String)"the count should be ", (long)150L, (long)cnt);
    }

    private void addRowsByKeysWith50Cols(AbstractMemStore hmc, String[] keys) {
        byte[] fam = Bytes.toBytes((String)"testfamily");
        for (int i = 0; i < keys.length; ++i) {
            long timestamp = System.currentTimeMillis();
            Threads.sleep((long)1L);
            byte[] row = Bytes.toBytes((String)keys[i]);
            for (int j = 0; j < 50; ++j) {
                byte[] qf = Bytes.toBytes((String)("testqualifier" + j));
                byte[] val = Bytes.toBytes((String)(keys[i] + j));
                KeyValue kv = new KeyValue(row, fam, qf, timestamp, val);
                hmc.add((Cell)kv, null);
            }
        }
    }

    @Override
    @Test
    public void testPuttingBackChunksWithOpeningScanner() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] qf6 = Bytes.toBytes((String)"testqualifier6");
        byte[] qf7 = Bytes.toBytes((String)"testqualifier7");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        Assert.assertEquals((long)3L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)this.memstore.getActive().getCellsCount());
        this.memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        List scanners = this.memstore.getScanners(0L);
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        this.memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() == 0 ? 1 : 0) != 0);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
        chunkCreator.clearChunksInPool();
        snapshot = this.memstore.snapshot();
        this.memstore.add((Cell)new KeyValue(row, fam, qf6, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf7, val), null);
        scanners = this.memstore.getScanners(0L);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        this.memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testPuttingBackChunksAfterFlushing() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        Assert.assertEquals((long)3L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)this.memstore.getActive().getCellsCount());
        this.memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        this.memstore.clearSnapshot(snapshot.getId());
        int chunkCount = chunkCreator.getPoolSize();
        Assert.assertTrue((chunkCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFlatteningToCellChunkMap() throws IOException {
        if (!this.toCellChunkMap) {
            return;
        }
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.BASIC;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        int numOfCells = 8;
        String[] keys1 = new String[]{"A", "A", "B", "C", "D", "D", "E", "F"};
        byte[] row = Bytes.toBytes((String)keys1[0]);
        byte[] val = Bytes.toBytes((String)(keys1[0] + 0));
        KeyValue kv = new KeyValue(row, Bytes.toBytes((String)"testfamily"), Bytes.toBytes((String)"testqualifier"), System.currentTimeMillis(), val);
        int totalCellsLen = this.addRowsByKeys(this.memstore, keys1);
        long oneCellOnCSLMHeapSize = ClassSize.align((int)(ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + KeyValue.FIXED_OVERHEAD + kv.getSerializedSize()));
        long totalHeapSize = (long)numOfCells * oneCellOnCSLMHeapSize + MutableSegment.DEEP_OVERHEAD;
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        long oneCellOnCCMHeapSize = ClassSize.CELL_CHUNK_MAP_ENTRY + ClassSize.align((int)kv.getSerializedSize());
        totalHeapSize = MutableSegment.DEEP_OVERHEAD + CellChunkImmutableSegment.DEEP_OVERHEAD_CCM + (long)numOfCells * oneCellOnCCMHeapSize;
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        MemStoreSize mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss);
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)numOfCells, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Test
    public void testFlatteningToBigCellChunkMap() throws IOException {
        if (!this.toCellChunkMap) {
            return;
        }
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.BASIC;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        int numOfCells = 4;
        char[] chars = new char[262144];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 65;
        }
        String bigVal = new String(chars);
        String[] keys1 = new String[]{"A", "B", "C", "D"};
        byte[] row = Bytes.toBytes((String)keys1[0]);
        byte[] val = Bytes.toBytes((String)bigVal);
        KeyValue kv = new KeyValue(row, Bytes.toBytes((String)"testfamily"), Bytes.toBytes((String)"testqualifier"), System.currentTimeMillis(), val);
        int totalCellsLen = this.addRowsByKeys(this.memstore, keys1, val);
        long oneCellOnCSLMHeapSize = ClassSize.align((long)((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + kv.heapSize()));
        long totalHeapSize = (long)numOfCells * oneCellOnCSLMHeapSize + MutableSegment.DEEP_OVERHEAD;
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        long oneCellOnCCMHeapSize = ClassSize.CELL_CHUNK_MAP_ENTRY + ClassSize.align((int)kv.getSerializedSize());
        totalHeapSize = MutableSegment.DEEP_OVERHEAD + CellChunkImmutableSegment.DEEP_OVERHEAD_CCM + (long)numOfCells * oneCellOnCCMHeapSize;
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        MemStoreSize mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss);
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)numOfCells, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Test
    public void testFlatteningToJumboCellChunkMap() throws IOException {
        if (!this.toCellChunkMap) {
            return;
        }
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.BASIC;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        int numOfCells = 1;
        char[] chars = new char[0x200000];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 65;
        }
        String bigVal = new String(chars);
        String[] keys1 = new String[]{"A"};
        byte[] row = Bytes.toBytes((String)keys1[0]);
        byte[] val = Bytes.toBytes((String)bigVal);
        KeyValue kv = new KeyValue(row, Bytes.toBytes((String)"testfamily"), Bytes.toBytes((String)"testqualifier"), System.currentTimeMillis(), val);
        int totalCellsLen = this.addRowsByKeys(this.memstore, keys1, val);
        long oneCellOnCSLMHeapSize = ClassSize.align((long)((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + kv.heapSize()));
        long totalHeapSize = (long)numOfCells * oneCellOnCSLMHeapSize + MutableSegment.DEEP_OVERHEAD;
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        long oneCellOnCCMHeapSize = (long)ClassSize.CELL_CHUNK_MAP_ENTRY + (long)ClassSize.align((int)kv.getSerializedSize());
        totalHeapSize = MutableSegment.DEEP_OVERHEAD + CellChunkImmutableSegment.DEEP_OVERHEAD_CCM + (long)numOfCells * oneCellOnCCMHeapSize;
        Assert.assertEquals((long)(totalCellsLen + 4), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        MemStoreSize mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss);
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)numOfCells, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
        String[] keys2 = new String[]{"C", "D"};
        this.addRowsByKeys(this.memstore, keys2, val);
        while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
            Threads.sleep((long)10L);
        }
        totalHeapSize = MutableSegment.DEEP_OVERHEAD + CellChunkImmutableSegment.DEEP_OVERHEAD_CCM + 1L * oneCellOnCSLMHeapSize + 1L * oneCellOnCCMHeapSize;
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
    }

    @Test
    public void testForceCopyOfBigCellIntoImmutableSegment() throws IOException {
        if (!this.toCellChunkMap) {
            return;
        }
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.BASIC;
        this.memstore.getConfiguration().setInt("hbase.hregion.compacting.pipeline.segments.limit", 4);
        this.memstore.getConfiguration().setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.014);
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((TestCompactingMemStore.MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.CHUNK_MAP);
        char[] chars = new char[0x200000];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 65;
        }
        String bigVal = new String(chars);
        byte[] val = Bytes.toBytes((String)bigVal);
        ArrayList<String[]> keysList = new ArrayList<String[]>();
        keysList.add(new String[]{"A", "B"});
        keysList.add(new String[]{"C", "D"});
        keysList.add(new String[]{"E", "F"});
        keysList.add(new String[]{"G", "H"});
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"A"), Bytes.toBytes((String)"testfamily"), Bytes.toBytes((String)"testqualifier"), System.currentTimeMillis(), val);
        long oneCellOnCCMHeapSize = (long)ClassSize.CELL_CHUNK_MAP_ENTRY + (long)ClassSize.align((int)kv.getSerializedSize());
        long oneCellOnCSLMHeapSize = ClassSize.align((long)((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + kv.heapSize()));
        long totalHeapSize = MutableSegment.DEEP_OVERHEAD;
        for (int i = 0; i < keysList.size(); ++i) {
            this.addRowsByKeys(this.memstore, (String[])keysList.get(i), val);
            while (((CompactingMemStore)this.memstore).isMemStoreFlushingInMemory()) {
                Threads.sleep((long)10L);
            }
            totalHeapSize = i == 0 ? (totalHeapSize += CellChunkImmutableSegment.DEEP_OVERHEAD_CCM + oneCellOnCCMHeapSize + oneCellOnCSLMHeapSize) : (totalHeapSize += 2L * (CellChunkImmutableSegment.DEEP_OVERHEAD_CCM + oneCellOnCCMHeapSize));
            if (i == 2) {
                totalHeapSize -= 4L * CellChunkImmutableSegment.DEEP_OVERHEAD_CCM;
                totalHeapSize = ClassSize.align((long)totalHeapSize);
            }
            Assert.assertEquals((String)("i=" + i), (long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        }
    }

    private long addRowsByKeysDataSize(AbstractMemStore hmc, String[] keys) {
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf = Bytes.toBytes((String)"testqualifier");
        NonThreadSafeMemStoreSizing memstoreSizing = new NonThreadSafeMemStoreSizing();
        for (int i = 0; i < keys.length; ++i) {
            long timestamp = System.currentTimeMillis();
            Threads.sleep((long)1L);
            byte[] row = Bytes.toBytes((String)keys[i]);
            byte[] val = Bytes.toBytes((String)(keys[i] + i));
            KeyValue kv = new KeyValue(row, fam, qf, timestamp, val);
            hmc.add((Cell)kv, (MemStoreSizing)memstoreSizing);
            LOG.debug("added kv: " + kv.getKeyString() + ", timestamp" + kv.getTimestamp());
        }
        MemStoreSize mss = memstoreSizing.getMemStoreSize();
        this.regionServicesForStores.addMemStoreSize(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
        return mss.getDataSize();
    }

    private long cellBeforeFlushSize() {
        byte[] row = Bytes.toBytes((String)"A");
        byte[] val = Bytes.toBytes((String)"A0");
        KeyValue kv = new KeyValue(row, Bytes.toBytes((String)"testfamily"), Bytes.toBytes((String)"testqualifier"), System.currentTimeMillis(), val);
        return ClassSize.align((int)(ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + KeyValue.FIXED_OVERHEAD + kv.getSerializedSize()));
    }

    private long cellAfterFlushSize() {
        byte[] row = Bytes.toBytes((String)"A");
        byte[] val = Bytes.toBytes((String)"A0");
        KeyValue kv = new KeyValue(row, Bytes.toBytes((String)"testfamily"), Bytes.toBytes((String)"testqualifier"), System.currentTimeMillis(), val);
        return this.toCellChunkMap ? (long)ClassSize.align((int)(ClassSize.CELL_CHUNK_MAP_ENTRY + kv.getSerializedSize())) : (long)ClassSize.align((int)(ClassSize.CELL_ARRAY_MAP_ENTRY + KeyValue.FIXED_OVERHEAD + kv.getSerializedSize()));
    }
}

