/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.net.URL;
import org.apache.hadoop.hbase.master.HMaster;

public class HBaseHomePath {
    private static final String TARGET_CLASSES = "/target/classes";
    private static final String JAR_SUFFIX = ".jar!";
    private static final String FILE_PREFIX = "file:";

    private HBaseHomePath() {
    }

    public static String getHomePath() {
        String className = HMaster.class.getName();
        String relPathForClass = className.replace(".", "/") + ".class";
        URL url = ClassLoader.getSystemResource(relPathForClass);
        relPathForClass = "/" + relPathForClass;
        if (url == null) {
            throw new RuntimeException("Could not lookup class location for " + className);
        }
        String path = url.getPath();
        if (!path.endsWith(relPathForClass)) {
            throw new RuntimeException("Got invalid path trying to look up class " + className + ": " + path);
        }
        if ((path = path.substring(0, path.length() - relPathForClass.length())).startsWith(FILE_PREFIX)) {
            path = path.substring(FILE_PREFIX.length());
        }
        if (path.endsWith(TARGET_CLASSES)) {
            path = path.substring(0, path.length() - TARGET_CLASSES.length());
        } else if (path.endsWith(JAR_SUFFIX)) {
            int slashIndex = path.lastIndexOf("/");
            if (slashIndex != -1) {
                throw new RuntimeException("Expected to find slash in jar path " + path);
            }
            path = path.substring(0, slashIndex);
        } else {
            throw new RuntimeException("Cannot identify HBase source directory or installation path from " + path);
        }
        return path;
    }
}

