/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadedWriterWithACL
extends MultiThreadedWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MultiThreadedWriterWithACL.class);
    private User userOwner;

    public MultiThreadedWriterWithACL(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, User userOwner) throws IOException {
        super(dataGen, conf, tableName);
        this.userOwner = userOwner;
    }

    @Override
    public void start(long startKey, long endKey, int numThreads) throws IOException {
        super.start(startKey, endKey, numThreads);
    }

    @Override
    protected void createWriterThreads(int numThreads) throws IOException {
        for (int i = 0; i < numThreads; ++i) {
            HBaseWriterThreadWithACL writer = new HBaseWriterThreadWithACL(i);
            this.writers.add(writer);
        }
    }

    private void recordFailure(Table table, Put put, long keyBase, long start, IOException e) {
        String exceptionInfo;
        this.failedKeySet.add(keyBase);
        if (e instanceof RetriesExhaustedWithDetailsException) {
            RetriesExhaustedWithDetailsException aggEx = (RetriesExhaustedWithDetailsException)e;
            exceptionInfo = aggEx.getExhaustiveDescription();
        } else {
            StringWriter stackWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stackWriter);
            e.printStackTrace(pw);
            pw.flush();
            exceptionInfo = StringUtils.stringifyException((Throwable)e);
        }
        LOG.error("Failed to insert: " + keyBase + " after " + (System.currentTimeMillis() - start) + "ms; region information: " + this.getRegionDebugInfoSafe(table, put.getRow()) + "; errors: " + exceptionInfo);
    }

    public class HBaseWriterThreadWithACL
    extends MultiThreadedWriter.HBaseWriterThread {
        private Table table;
        private WriteAccessAction writerAction;

        public HBaseWriterThreadWithACL(int writerId) throws IOException {
            super(MultiThreadedWriterWithACL.this, writerId);
            this.writerAction = new WriteAccessAction();
        }

        @Override
        protected Table createTable() throws IOException {
            return null;
        }

        @Override
        protected void closeHTable() {
            if (this.table != null) {
                try {
                    this.table.close();
                }
                catch (Exception e) {
                    LOG.error("Error in closing the table " + this.table.getName(), (Throwable)e);
                }
            }
        }

        @Override
        public void insert(Table table, Put put, long keyBase) {
            long start = System.currentTimeMillis();
            try {
                put = (Put)MultiThreadedWriterWithACL.this.dataGenerator.beforeMutate(keyBase, (Mutation)put);
                this.writerAction.setPut(put);
                this.writerAction.setKeyBase(keyBase);
                this.writerAction.setStartTime(start);
                MultiThreadedWriterWithACL.this.userOwner.runAs((PrivilegedExceptionAction)this.writerAction);
            }
            catch (IOException e) {
                MultiThreadedWriterWithACL.this.recordFailure(table, put, keyBase, start, e);
            }
            catch (InterruptedException e) {
                MultiThreadedWriterWithACL.this.failedKeySet.add(keyBase);
            }
        }

        class WriteAccessAction
        implements PrivilegedExceptionAction<Object> {
            private Put put;
            private long keyBase;
            private long start;

            public void setPut(Put put) {
                this.put = put;
            }

            public void setKeyBase(long keyBase) {
                this.keyBase = keyBase;
            }

            public void setStartTime(long start) {
                this.start = start;
            }

            @Override
            public Object run() throws Exception {
                try {
                    if (HBaseWriterThreadWithACL.this.table == null) {
                        HBaseWriterThreadWithACL.this.table = MultiThreadedWriterWithACL.this.connection.getTable(MultiThreadedWriterWithACL.this.tableName);
                    }
                    HBaseWriterThreadWithACL.this.table.put(this.put);
                }
                catch (IOException e) {
                    MultiThreadedWriterWithACL.this.recordFailure(HBaseWriterThreadWithACL.this.table, this.put, this.keyBase, this.start, e);
                }
                return null;
            }
        }
    }
}

