/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestRootPath
extends TestCase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRootPath.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRootPath.class);

    public void testRootPath() {
        try {
            FSUtils.validateRootPath((Path)new Path("file:///tmp/hbase/hbase"));
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Unexpected exception checking valid path:", (Throwable)e);
            TestRootPath.fail();
        }
        try {
            FSUtils.validateRootPath((Path)new Path("hdfs://a:9000/hbase"));
        }
        catch (IOException e) {
            LOG.error(HBaseMarkers.FATAL, "Unexpected exception checking valid path:", (Throwable)e);
            TestRootPath.fail();
        }
        try {
            FSUtils.validateRootPath((Path)new Path("/hbase"));
            TestRootPath.fail();
        }
        catch (IOException e) {
            LOG.info("Got expected exception when checking invalid path:", (Throwable)e);
        }
    }
}

