/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.ClusterLoadState;
import org.apache.hadoop.hbase.master.balancer.MetricsBalancer;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class BaseLoadBalancer
implements LoadBalancer {
    protected static final int MIN_SERVER_BALANCE = 2;
    private volatile boolean stopped = false;
    private static final List<RegionInfo> EMPTY_REGION_LIST = Collections.emptyList();
    static final Predicate<ServerMetrics> IDLE_SERVER_PREDICATOR = load -> load.getRegionMetrics().isEmpty();
    protected RegionLocationFinder regionFinder;
    protected boolean useRegionFinder;
    protected float slop;
    protected float overallSlop;
    protected Configuration config = HBaseConfiguration.create();
    protected RackManager rackManager;
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final Logger LOG = LoggerFactory.getLogger(BaseLoadBalancer.class);
    protected MetricsBalancer metricsBalancer = null;
    protected ClusterMetrics clusterStatus = null;
    protected ServerName masterServerName;
    protected MasterServices services;
    protected boolean onlySystemTablesOnMaster;
    protected boolean maintenanceMode;

    protected BaseLoadBalancer() {
        this.metricsBalancer = new MetricsBalancer();
        this.createRegionFinder();
    }

    protected BaseLoadBalancer(MetricsBalancer metricsBalancer) {
        this.metricsBalancer = metricsBalancer != null ? metricsBalancer : new MetricsBalancer();
        this.createRegionFinder();
    }

    private void createRegionFinder() {
        this.useRegionFinder = this.config.getBoolean("hbase.master.balancer.uselocality", true);
        if (this.useRegionFinder) {
            this.regionFinder = new RegionLocationFinder();
        }
    }

    public void setConf(Configuration conf) {
        this.config = conf;
        this.setSlop(conf);
        if (this.slop < 0.0f) {
            this.slop = 0.0f;
        } else if (this.slop > 1.0f) {
            this.slop = 1.0f;
        }
        if (this.overallSlop < 0.0f) {
            this.overallSlop = 0.0f;
        } else if (this.overallSlop > 1.0f) {
            this.overallSlop = 1.0f;
        }
        this.onlySystemTablesOnMaster = LoadBalancer.isSystemTablesOnlyOnMaster(this.config);
        this.rackManager = new RackManager(this.getConf());
        if (this.useRegionFinder) {
            this.regionFinder.setConf(conf);
        }
        LOG.info("slop={}, systemTablesOnMaster={}", (Object)Float.valueOf(this.slop), (Object)this.onlySystemTablesOnMaster);
    }

    protected void setSlop(Configuration conf) {
        this.slop = conf.getFloat("hbase.regions.slop", 0.2f);
        this.overallSlop = conf.getFloat("hbase.regions.overallSlop", this.slop);
    }

    public boolean shouldBeOnMaster(RegionInfo region) {
        return (this.maintenanceMode || this.onlySystemTablesOnMaster) && region.getTable().isSystemTable();
    }

    protected List<RegionPlan> balanceMasterRegions(Map<ServerName, List<RegionInfo>> clusterMap) {
        RegionPlan plan;
        if (this.masterServerName == null || clusterMap == null || clusterMap.size() <= 1) {
            return null;
        }
        ArrayList<RegionPlan> plans = null;
        List<RegionInfo> regions = clusterMap.get(this.masterServerName);
        if (regions != null) {
            Iterator<ServerName> keyIt = null;
            for (RegionInfo region : regions) {
                ServerName dest;
                if (this.shouldBeOnMaster(region)) continue;
                if (keyIt == null || !keyIt.hasNext()) {
                    keyIt = clusterMap.keySet().iterator();
                }
                if (this.masterServerName.equals((Object)(dest = keyIt.next()))) {
                    if (!keyIt.hasNext()) {
                        keyIt = clusterMap.keySet().iterator();
                    }
                    dest = keyIt.next();
                }
                plan = new RegionPlan(region, this.masterServerName, dest);
                if (plans == null) {
                    plans = new ArrayList<RegionPlan>();
                }
                plans.add(plan);
            }
        }
        for (Map.Entry<ServerName, List<RegionInfo>> server : clusterMap.entrySet()) {
            if (this.masterServerName.equals((Object)server.getKey())) continue;
            for (RegionInfo region : server.getValue()) {
                if (!this.shouldBeOnMaster(region)) continue;
                plan = new RegionPlan(region, server.getKey(), this.masterServerName);
                if (plans == null) {
                    plans = new ArrayList();
                }
                plans.add(plan);
            }
        }
        return plans;
    }

    protected Map<ServerName, List<RegionInfo>> assignMasterSystemRegions(Collection<RegionInfo> regions, List<ServerName> servers) {
        if (servers == null || regions == null || regions.isEmpty()) {
            return null;
        }
        TreeMap<ServerName, List<RegionInfo>> assignments = new TreeMap<ServerName, List<RegionInfo>>();
        if ((this.maintenanceMode || this.onlySystemTablesOnMaster) && this.masterServerName != null && servers.contains(this.masterServerName)) {
            assignments.put(this.masterServerName, new ArrayList());
            for (RegionInfo region : regions) {
                if (!this.shouldBeOnMaster(region)) continue;
                ((List)assignments.get(this.masterServerName)).add(region);
            }
        }
        return assignments;
    }

    public Configuration getConf() {
        return this.config;
    }

    @Override
    public synchronized void setClusterMetrics(ClusterMetrics st) {
        this.clusterStatus = st;
        if (this.useRegionFinder) {
            this.regionFinder.setClusterMetrics(st);
        }
    }

    @Override
    public void setClusterLoad(Map<TableName, Map<ServerName, List<RegionInfo>>> clusterLoad) {
    }

    @Override
    public void setMasterServices(MasterServices masterServices) {
        this.masterServerName = masterServices.getServerName();
        this.services = masterServices;
        if (this.useRegionFinder) {
            this.regionFinder.setServices(masterServices);
        }
        if (this.services.isInMaintenanceMode()) {
            this.maintenanceMode = true;
        }
    }

    @Override
    public void postMasterStartupInitialize() {
        if (this.services != null && this.regionFinder != null) {
            try {
                Set<RegionInfo> regions = this.services.getAssignmentManager().getRegionStates().getRegionAssignments().keySet();
                this.regionFinder.refreshAndWait(regions);
            }
            catch (Exception e) {
                LOG.warn("Refreshing region HDFS Block dist failed with exception, ignoring", (Throwable)e);
            }
        }
    }

    public void setRackManager(RackManager rackManager) {
        this.rackManager = rackManager;
    }

    protected boolean needsBalance(Cluster c) {
        ClusterLoadState cs = new ClusterLoadState(c.clusterState);
        if (cs.getNumServers() < 2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not running balancer because only " + cs.getNumServers() + " active regionserver(s)");
            }
            return false;
        }
        if (this.areSomeRegionReplicasColocated(c)) {
            return true;
        }
        float average = cs.getLoadAverage();
        int floor = (int)Math.floor(average * (1.0f - this.slop));
        int ceiling = (int)Math.ceil(average * (1.0f + this.slop));
        if (cs.getMaxLoad() <= ceiling && cs.getMinLoad() >= floor) {
            NavigableMap<ServerAndLoad, List<RegionInfo>> serversByLoad = cs.getServersByLoad();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Skipping load balancing because balanced cluster; servers=" + cs.getNumServers() + " regions=" + cs.getNumRegions() + " average=" + average + " mostloaded=" + ((ServerAndLoad)serversByLoad.lastKey()).getLoad() + " leastloaded=" + ((ServerAndLoad)serversByLoad.firstKey()).getLoad());
            }
            return false;
        }
        return true;
    }

    protected boolean areSomeRegionReplicasColocated(Cluster c) {
        return false;
    }

    @Override
    public Map<ServerName, List<RegionInfo>> roundRobinAssignment(List<RegionInfo> regions, List<ServerName> servers) throws HBaseIOException {
        int numServers;
        this.metricsBalancer.incrMiscInvocations();
        Map<ServerName, List<RegionInfo>> assignments = this.assignMasterSystemRegions(regions, servers);
        if (assignments != null && !assignments.isEmpty()) {
            servers = new ArrayList<ServerName>(servers);
            servers.remove(this.masterServerName);
            List<RegionInfo> masterRegions = assignments.get(this.masterServerName);
            if (!masterRegions.isEmpty()) {
                regions = new ArrayList<RegionInfo>(regions);
                regions.removeAll(masterRegions);
            }
        }
        if (this.maintenanceMode || regions == null || regions.isEmpty()) {
            return assignments;
        }
        int n = numServers = servers == null ? 0 : servers.size();
        if (numServers == 0) {
            LOG.warn("Wanted to do round robin assignment but no servers to assign to");
            return null;
        }
        if (numServers == 1) {
            ServerName server = servers.get(0);
            assignments.put(server, new ArrayList<RegionInfo>(regions));
            return assignments;
        }
        Cluster cluster = this.createCluster(servers, regions, false);
        ArrayList<RegionInfo> unassignedRegions = new ArrayList<RegionInfo>();
        this.roundRobinAssignment(cluster, regions, unassignedRegions, servers, assignments);
        ArrayList<RegionInfo> lastFewRegions = new ArrayList<RegionInfo>();
        int serverIdx = RANDOM.nextInt(numServers);
        for (RegionInfo region : unassignedRegions) {
            boolean assigned = false;
            block1: for (int j = 0; j < numServers; ++j) {
                ServerName serverName = servers.get((j + serverIdx) % numServers);
                if (cluster.wouldLowerAvailability(region, serverName)) continue;
                List serverRegions = assignments.computeIfAbsent(serverName, k -> new ArrayList());
                if (!RegionReplicaUtil.isDefaultReplica((int)region.getReplicaId())) {
                    for (RegionInfo hri : serverRegions) {
                        if (!RegionReplicaUtil.isReplicasForSameRegion((RegionInfo)region, (RegionInfo)hri)) continue;
                        if (!LOG.isTraceEnabled()) continue block1;
                        LOG.trace("Skipping the server, " + serverName + " , got the same server for the region " + region);
                        continue block1;
                    }
                }
                serverRegions.add(region);
                cluster.doAssignRegion(region, serverName);
                serverIdx = (j + serverIdx + 1) % numServers;
                assigned = true;
                break;
            }
            if (assigned) continue;
            lastFewRegions.add(region);
        }
        for (RegionInfo region : lastFewRegions) {
            int i = RANDOM.nextInt(numServers);
            ServerName server = servers.get(i);
            List serverRegions = assignments.computeIfAbsent(server, k -> new ArrayList());
            serverRegions.add(region);
            cluster.doAssignRegion(region, server);
        }
        return assignments;
    }

    protected Cluster createCluster(List<ServerName> servers, Collection<RegionInfo> regions, boolean hasRegionReplica) {
        Map<ServerName, List<RegionInfo>> clusterState = null;
        clusterState = !hasRegionReplica ? this.getRegionAssignmentsByServer(regions) : this.getRegionAssignmentsByServer(null);
        for (ServerName server : servers) {
            if (clusterState.containsKey(server)) continue;
            clusterState.put(server, EMPTY_REGION_LIST);
        }
        return new Cluster(regions, clusterState, null, this.regionFinder, this.rackManager);
    }

    private List<ServerName> findIdleServers(List<ServerName> servers) {
        return this.services.getServerManager().getOnlineServersListWithPredicator(servers, IDLE_SERVER_PREDICATOR);
    }

    @Override
    public ServerName randomAssignment(RegionInfo regionInfo, List<ServerName> servers) throws HBaseIOException {
        int numServers;
        this.metricsBalancer.incrMiscInvocations();
        if (servers != null && servers.contains(this.masterServerName)) {
            if (this.shouldBeOnMaster(regionInfo)) {
                return this.masterServerName;
            }
            if (!LoadBalancer.isTablesOnMaster(this.getConf())) {
                servers = new ArrayList<ServerName>(servers);
                servers.remove(this.masterServerName);
            }
        }
        int n = numServers = servers == null ? 0 : servers.size();
        if (numServers == 0) {
            LOG.warn("Wanted to retain assignment but no servers to assign to");
            return null;
        }
        if (numServers == 1) {
            return servers.get(0);
        }
        List<ServerName> idleServers = this.findIdleServers(servers);
        if (idleServers.size() == 1) {
            return idleServers.get(0);
        }
        List<ServerName> finalServers = idleServers.isEmpty() ? servers : idleServers;
        ArrayList regions = Lists.newArrayList((Object[])new RegionInfo[]{regionInfo});
        Cluster cluster = this.createCluster(finalServers, regions, false);
        return this.randomAssignment(cluster, regionInfo, finalServers);
    }

    @Override
    public Map<ServerName, List<RegionInfo>> retainAssignment(Map<RegionInfo, ServerName> regions, List<ServerName> servers) throws HBaseIOException {
        int numServers;
        this.metricsBalancer.incrMiscInvocations();
        Map<ServerName, List<RegionInfo>> assignments = this.assignMasterSystemRegions(regions.keySet(), servers);
        if (assignments != null && !assignments.isEmpty()) {
            servers = new ArrayList<ServerName>(servers);
            servers.remove(this.masterServerName);
            List<RegionInfo> masterRegions = assignments.get(this.masterServerName);
            regions = regions.entrySet().stream().filter(e -> !masterRegions.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (this.maintenanceMode || regions.isEmpty()) {
            return assignments;
        }
        int n = numServers = servers == null ? 0 : servers.size();
        if (numServers == 0) {
            LOG.warn("Wanted to do retain assignment but no servers to assign to");
            return null;
        }
        if (numServers == 1) {
            ServerName server = servers.get(0);
            assignments.put(server, new ArrayList<RegionInfo>(regions.keySet()));
            return assignments;
        }
        ArrayListMultimap serversByHostname = ArrayListMultimap.create();
        for (ServerName server : servers) {
            assignments.put(server, new ArrayList());
            serversByHostname.put((Object)server.getHostnameLowerCase(), (Object)server);
        }
        TreeSet oldHostsNoLongerPresent = Sets.newTreeSet();
        ArrayList randomAssignRegions = Lists.newArrayList();
        int numRandomAssignments = 0;
        int numRetainedAssigments = 0;
        boolean hasRegionReplica = false;
        for (Map.Entry<RegionInfo, ServerName> entry : regions.entrySet()) {
            ServerName target;
            AssignmentManager am;
            RegionInfo region = entry.getKey();
            ServerName oldServerName = entry.getValue();
            if (this.services != null && (am = this.services.getAssignmentManager()) != null) {
                RegionStates states = am.getRegionStates();
                if (!hasRegionReplica && states != null && states.isReplicaAvailableForRegion(region)) {
                    hasRegionReplica = true;
                }
            }
            List localServers = new ArrayList();
            if (oldServerName != null) {
                localServers = serversByHostname.get((Object)oldServerName.getHostnameLowerCase());
            }
            if (localServers.isEmpty()) {
                randomAssignRegions.add(region);
                if (oldServerName == null) continue;
                oldHostsNoLongerPresent.add(oldServerName.getHostnameLowerCase());
                continue;
            }
            if (localServers.size() == 1) {
                target = (ServerName)localServers.get(0);
                assignments.get(target).add(region);
                ++numRetainedAssigments;
                continue;
            }
            if (localServers.contains(oldServerName)) {
                assignments.get(oldServerName).add(region);
                ++numRetainedAssigments;
                continue;
            }
            target = null;
            for (ServerName tmp : localServers) {
                if (tmp.getPort() != oldServerName.getPort()) continue;
                target = tmp;
                assignments.get(tmp).add(region);
                ++numRetainedAssigments;
                break;
            }
            if (target != null) continue;
            randomAssignRegions.add(region);
        }
        if (randomAssignRegions.size() > 0) {
            Cluster cluster = this.createCluster(servers, regions.keySet(), hasRegionReplica);
            for (Map.Entry<ServerName, List<RegionInfo>> entry : assignments.entrySet()) {
                ServerName sn = entry.getKey();
                for (RegionInfo region : entry.getValue()) {
                    cluster.doAssignRegion(region, sn);
                }
            }
            for (RegionInfo region : randomAssignRegions) {
                ServerName target = this.randomAssignment(cluster, region, servers);
                assignments.get(target).add(region);
                ++numRandomAssignments;
            }
        }
        String randomAssignMsg = "";
        if (numRandomAssignments > 0) {
            randomAssignMsg = numRandomAssignments + " regions were assigned to random hosts, since the old hosts for these regions are no longer present in the cluster. These hosts were:\n  " + Joiner.on((String)"\n  ").join((Iterable)oldHostsNoLongerPresent);
        }
        LOG.info("Reassigned " + regions.size() + " regions. " + numRetainedAssigments + " retained the pre-restart assignment. " + randomAssignMsg);
        return assignments;
    }

    @Override
    public void initialize() throws HBaseIOException {
    }

    @Override
    public void regionOnline(RegionInfo regionInfo, ServerName sn) {
    }

    @Override
    public void regionOffline(RegionInfo regionInfo) {
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop(String why) {
        LOG.info("Load Balancer stop requested: " + why);
        this.stopped = true;
    }

    @Override
    public void updateBalancerStatus(boolean status) {
        this.metricsBalancer.balancerStatus(status);
    }

    private ServerName randomAssignment(Cluster cluster, RegionInfo regionInfo, List<ServerName> servers) {
        int numServers = servers.size();
        ServerName sn = null;
        int maxIterations = numServers * 4;
        int iterations = 0;
        ArrayList<ServerName> usedSNs = new ArrayList<ServerName>(servers.size());
        do {
            int i;
            if (usedSNs.contains(sn = servers.get(i = RANDOM.nextInt(numServers)))) continue;
            usedSNs.add(sn);
        } while (cluster.wouldLowerAvailability(regionInfo, sn) && iterations++ < maxIterations);
        if (iterations >= maxIterations) {
            for (ServerName unusedServer : servers) {
                if (usedSNs.contains(unusedServer) || cluster.wouldLowerAvailability(regionInfo, unusedServer)) continue;
                sn = unusedServer;
                break;
            }
        }
        cluster.doAssignRegion(regionInfo, sn);
        return sn;
    }

    private void roundRobinAssignment(Cluster cluster, List<RegionInfo> regions, List<RegionInfo> unassignedRegions, List<ServerName> servers, Map<ServerName, List<RegionInfo>> assignments) {
        int numServers = servers.size();
        int numRegions = regions.size();
        int max = (int)Math.ceil((float)numRegions / (float)numServers);
        int serverIdx = 0;
        if (numServers > 1) {
            serverIdx = RANDOM.nextInt(numServers);
        }
        int regionIdx = 0;
        for (int j = 0; j < numServers; ++j) {
            ServerName server = servers.get((j + serverIdx) % numServers);
            ArrayList<RegionInfo> serverRegions = new ArrayList<RegionInfo>(max);
            for (int i = regionIdx; i < numRegions; i += numServers) {
                RegionInfo region = regions.get(i % numRegions);
                if (cluster.wouldLowerAvailability(region, server)) {
                    unassignedRegions.add(region);
                    continue;
                }
                serverRegions.add(region);
                cluster.doAssignRegion(region, server);
            }
            assignments.put(server, serverRegions);
            ++regionIdx;
        }
    }

    protected Map<ServerName, List<RegionInfo>> getRegionAssignmentsByServer(Collection<RegionInfo> regions) {
        if (this.services != null && this.services.getAssignmentManager() != null) {
            return this.services.getAssignmentManager().getSnapShotOfAssignment(regions);
        }
        return new HashMap<ServerName, List<RegionInfo>>();
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
    }

    protected static class Cluster {
        ServerName[] servers;
        String[] hosts;
        String[] racks;
        boolean multiServersPerHost = false;
        ArrayList<String> tables;
        RegionInfo[] regions;
        Deque<BalancerRegionLoad>[] regionLoads;
        private RegionLocationFinder regionFinder;
        int[][] regionLocations;
        int[] serverIndexToHostIndex;
        int[] serverIndexToRackIndex;
        int[][] regionsPerServer;
        int[][] regionsPerHost;
        int[][] regionsPerRack;
        int[][] primariesOfRegionsPerServer;
        int[][] primariesOfRegionsPerHost;
        int[][] primariesOfRegionsPerRack;
        int[][] serversPerHost;
        int[][] serversPerRack;
        int[] regionIndexToServerIndex;
        int[] initialRegionIndexToServerIndex;
        int[] regionIndexToTableIndex;
        int[][] numRegionsPerServerPerTable;
        int[] numMaxRegionsPerTable;
        int[] regionIndexToPrimaryIndex;
        boolean hasRegionReplicas = false;
        Integer[] serverIndicesSortedByRegionCount;
        Integer[] serverIndicesSortedByLocality;
        Map<String, Integer> serversToIndex;
        Map<String, Integer> hostsToIndex;
        Map<String, Integer> racksToIndex;
        Map<String, Integer> tablesToIndex;
        Map<RegionInfo, Integer> regionsToIndex;
        float[] localityPerServer;
        int numServers;
        int numHosts;
        int numRacks;
        int numTables;
        int numRegions;
        int numMovedRegions = 0;
        Map<ServerName, List<RegionInfo>> clusterState;
        protected final RackManager rackManager;
        private float[][] rackLocalities;
        private int[][] regionsToMostLocalEntities;
        @SuppressWarnings(value={"NM_FIELD_NAMING_CONVENTION"}, justification="Mistake. Too disruptive to change now")
        public static final Action NullAction = new Action(Action.Type.NULL);
        private Comparator<Integer> numRegionsComparator = Comparator.comparingInt(this::getNumRegions);

        protected Cluster(Map<ServerName, List<RegionInfo>> clusterState, Map<String, Deque<BalancerRegionLoad>> loads, RegionLocationFinder regionFinder, RackManager rackManager) {
            this(null, clusterState, loads, regionFinder, rackManager);
        }

        /*
         * WARNING - void declaration
         */
        protected Cluster(Collection<RegionInfo> unassignedRegions, Map<ServerName, List<RegionInfo>> clusterState, Map<String, Deque<BalancerRegionLoad>> loads, RegionLocationFinder regionFinder, RackManager rackManager) {
            int region;
            int i;
            int i2;
            int serverIndex;
            if (unassignedRegions == null) {
                unassignedRegions = EMPTY_REGION_LIST;
            }
            this.serversToIndex = new HashMap<String, Integer>();
            this.hostsToIndex = new HashMap<String, Integer>();
            this.racksToIndex = new HashMap<String, Integer>();
            this.tablesToIndex = new HashMap<String, Integer>();
            this.tables = new ArrayList();
            this.rackManager = rackManager != null ? rackManager : new DefaultRackManager();
            this.numRegions = 0;
            ArrayList serversPerHostList = new ArrayList();
            ArrayList serversPerRackList = new ArrayList();
            this.clusterState = clusterState;
            this.regionFinder = regionFinder;
            for (ServerName serverName : clusterState.keySet()) {
                if (serverName == null) {
                    LOG.warn("TODO: Enable TRACE on BaseLoadBalancer. Empty servername); skipping; unassigned regions?");
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("EMPTY SERVERNAME " + clusterState.toString());
                    continue;
                }
                if (this.serversToIndex.get(serverName.getAddress().toString()) == null) {
                    this.serversToIndex.put(serverName.getHostAndPort(), this.numServers++);
                }
                if (!this.hostsToIndex.containsKey(serverName.getHostname())) {
                    this.hostsToIndex.put(serverName.getHostname(), this.numHosts++);
                    serversPerHostList.add(new ArrayList(1));
                }
                int serverIndex2 = this.serversToIndex.get(serverName.getHostAndPort());
                int hostIndex = this.hostsToIndex.get(serverName.getHostname());
                ((List)serversPerHostList.get(hostIndex)).add(serverIndex2);
                String string = this.rackManager.getRack(serverName);
                if (!this.racksToIndex.containsKey(string)) {
                    this.racksToIndex.put(string, this.numRacks++);
                    serversPerRackList.add(new ArrayList());
                }
                int rackIndex = this.racksToIndex.get(string);
                ((List)serversPerRackList.get(rackIndex)).add(serverIndex2);
            }
            for (Map.Entry entry : clusterState.entrySet()) {
                this.numRegions += ((List)entry.getValue()).size();
            }
            this.numRegions += unassignedRegions.size();
            this.regionsToIndex = new HashMap<RegionInfo, Integer>(this.numRegions);
            this.servers = new ServerName[this.numServers];
            this.serversPerHost = new int[this.numHosts][];
            this.serversPerRack = new int[this.numRacks][];
            this.regions = new RegionInfo[this.numRegions];
            this.regionIndexToServerIndex = new int[this.numRegions];
            this.initialRegionIndexToServerIndex = new int[this.numRegions];
            this.regionIndexToTableIndex = new int[this.numRegions];
            this.regionIndexToPrimaryIndex = new int[this.numRegions];
            this.regionLoads = new Deque[this.numRegions];
            this.regionLocations = new int[this.numRegions][];
            this.serverIndicesSortedByRegionCount = new Integer[this.numServers];
            this.serverIndicesSortedByLocality = new Integer[this.numServers];
            this.localityPerServer = new float[this.numServers];
            this.serverIndexToHostIndex = new int[this.numServers];
            this.serverIndexToRackIndex = new int[this.numServers];
            this.regionsPerServer = new int[this.numServers][];
            this.regionsPerHost = new int[this.numHosts][];
            this.regionsPerRack = new int[this.numRacks][];
            this.primariesOfRegionsPerServer = new int[this.numServers][];
            this.primariesOfRegionsPerHost = new int[this.numHosts][];
            this.primariesOfRegionsPerRack = new int[this.numRacks][];
            int tableIndex = 0;
            boolean bl = false;
            int regionPerServerIndex = 0;
            for (Map.Entry<ServerName, List<RegionInfo>> entry : clusterState.entrySet()) {
                if (entry.getKey() == null) {
                    LOG.warn("SERVERNAME IS NULL, skipping " + entry.getValue());
                    continue;
                }
                serverIndex = this.serversToIndex.get(entry.getKey().getHostAndPort());
                if (this.servers[serverIndex] == null || this.servers[serverIndex].getStartcode() < entry.getKey().getStartcode()) {
                    this.servers[serverIndex] = entry.getKey();
                }
                this.regionsPerServer[serverIndex] = this.regionsPerServer[serverIndex] != null ? new int[entry.getValue().size() + this.regionsPerServer[serverIndex].length] : new int[entry.getValue().size()];
                this.primariesOfRegionsPerServer[serverIndex] = new int[this.regionsPerServer[serverIndex].length];
                this.serverIndicesSortedByRegionCount[serverIndex] = serverIndex;
                this.serverIndicesSortedByLocality[serverIndex] = serverIndex;
            }
            this.hosts = new String[this.numHosts];
            for (Map.Entry<Object, Object> entry : this.hostsToIndex.entrySet()) {
                this.hosts[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
            }
            this.racks = new String[this.numRacks];
            for (Map.Entry<Object, Object> entry : this.racksToIndex.entrySet()) {
                this.racks[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
            }
            for (Map.Entry<Object, Object> entry : clusterState.entrySet()) {
                int rackIndex;
                int hostIndex;
                serverIndex = this.serversToIndex.get(((ServerName)entry.getKey()).getHostAndPort());
                regionPerServerIndex = 0;
                this.serverIndexToHostIndex[serverIndex] = hostIndex = this.hostsToIndex.get(((ServerName)entry.getKey()).getHostname()).intValue();
                this.serverIndexToRackIndex[serverIndex] = rackIndex = this.racksToIndex.get(this.rackManager.getRack((ServerName)entry.getKey())).intValue();
                for (RegionInfo region2 : (List)entry.getValue()) {
                    void var9_14;
                    this.registerRegion(region2, (int)var9_14, serverIndex, loads, regionFinder);
                    this.regionsPerServer[serverIndex][regionPerServerIndex++] = var9_14++;
                }
            }
            for (RegionInfo regionInfo : unassignedRegions) {
                void var9_15;
                this.registerRegion(regionInfo, (int)var9_15, -1, loads, regionFinder);
                ++var9_15;
            }
            for (int i22 = 0; i22 < serversPerHostList.size(); ++i22) {
                void var12_34;
                this.serversPerHost[i22] = new int[((List)serversPerHostList.get(i22)).size()];
                boolean bl2 = false;
                while (var12_34 < this.serversPerHost[i22].length) {
                    this.serversPerHost[i22][var12_34] = (Integer)((List)serversPerHostList.get(i22)).get((int)var12_34);
                    ++var12_34;
                }
                if (this.serversPerHost[i22].length <= 1) continue;
                this.multiServersPerHost = true;
            }
            for (i2 = 0; i2 < serversPerRackList.size(); ++i2) {
                this.serversPerRack[i2] = new int[((List)serversPerRackList.get(i2)).size()];
                for (int j = 0; j < this.serversPerRack[i2].length; ++j) {
                    this.serversPerRack[i2][j] = (Integer)((List)serversPerRackList.get(i2)).get(j);
                }
            }
            this.numTables = this.tables.size();
            this.numRegionsPerServerPerTable = new int[this.numServers][this.numTables];
            for (i2 = 0; i2 < this.numServers; ++i2) {
                for (int j = 0; j < this.numTables; ++j) {
                    this.numRegionsPerServerPerTable[i2][j] = 0;
                }
            }
            for (i2 = 0; i2 < this.regionIndexToServerIndex.length; ++i2) {
                if (this.regionIndexToServerIndex[i2] < 0) continue;
                int[] nArray = this.numRegionsPerServerPerTable[this.regionIndexToServerIndex[i2]];
                int n = this.regionIndexToTableIndex[i2];
                nArray[n] = nArray[n] + 1;
            }
            this.numMaxRegionsPerTable = new int[this.numTables];
            for (int[] aNumRegionsPerServerPerTable : this.numRegionsPerServerPerTable) {
                for (tableIndex = 0; tableIndex < aNumRegionsPerServerPerTable.length; ++tableIndex) {
                    if (aNumRegionsPerServerPerTable[tableIndex] <= this.numMaxRegionsPerTable[tableIndex]) continue;
                    this.numMaxRegionsPerTable[tableIndex] = aNumRegionsPerServerPerTable[tableIndex];
                }
            }
            for (i = 0; i < this.regions.length; ++i) {
                RegionInfo regionInfo = this.regions[i];
                if (RegionReplicaUtil.isDefaultReplica((RegionInfo)regionInfo)) {
                    this.regionIndexToPrimaryIndex[i] = i;
                    continue;
                }
                this.hasRegionReplicas = true;
                RegionInfo primaryInfo = RegionReplicaUtil.getRegionInfoForDefaultReplica((RegionInfo)regionInfo);
                this.regionIndexToPrimaryIndex[i] = this.regionsToIndex.getOrDefault(primaryInfo, -1);
            }
            for (i = 0; i < this.regionsPerServer.length; ++i) {
                void var12_40;
                this.primariesOfRegionsPerServer[i] = new int[this.regionsPerServer[i].length];
                boolean bl3 = false;
                while (var12_40 < this.regionsPerServer[i].length) {
                    int primaryIndex;
                    this.primariesOfRegionsPerServer[i][var12_40] = primaryIndex = this.regionIndexToPrimaryIndex[this.regionsPerServer[i][var12_40]];
                    ++var12_40;
                }
                Arrays.sort(this.primariesOfRegionsPerServer[i]);
            }
            if (this.multiServersPerHost) {
                for (i = 0; i < this.serversPerHost.length; ++i) {
                    void var12_42;
                    boolean bl4 = false;
                    for (int j = 0; j < this.serversPerHost[i].length; ++j) {
                        var12_42 += this.regionsPerServer[this.serversPerHost[i][j]].length;
                    }
                    this.regionsPerHost[i] = new int[var12_42];
                    this.primariesOfRegionsPerHost[i] = new int[var12_42];
                }
                for (i = 0; i < this.serversPerHost.length; ++i) {
                    boolean bl5 = false;
                    for (int j = 0; j < this.serversPerHost[i].length; ++j) {
                        for (int k = 0; k < this.regionsPerServer[this.serversPerHost[i][j]].length; ++k) {
                            void var12_44;
                            int primaryIndex;
                            this.regionsPerHost[i][var12_44] = region = this.regionsPerServer[this.serversPerHost[i][j]][k];
                            this.primariesOfRegionsPerHost[i][var12_44] = primaryIndex = this.regionIndexToPrimaryIndex[region];
                            ++var12_44;
                        }
                    }
                    Arrays.sort(this.primariesOfRegionsPerHost[i]);
                }
            }
            if (this.numRacks > 1) {
                for (i = 0; i < this.serversPerRack.length; ++i) {
                    void var12_46;
                    boolean bl6 = false;
                    for (int j = 0; j < this.serversPerRack[i].length; ++j) {
                        var12_46 += this.regionsPerServer[this.serversPerRack[i][j]].length;
                    }
                    this.regionsPerRack[i] = new int[var12_46];
                    this.primariesOfRegionsPerRack[i] = new int[var12_46];
                }
                for (i = 0; i < this.serversPerRack.length; ++i) {
                    boolean bl7 = false;
                    for (int j = 0; j < this.serversPerRack[i].length; ++j) {
                        for (int k = 0; k < this.regionsPerServer[this.serversPerRack[i][j]].length; ++k) {
                            void var12_48;
                            int primaryIndex;
                            this.regionsPerRack[i][var12_48] = region = this.regionsPerServer[this.serversPerRack[i][j]][k];
                            this.primariesOfRegionsPerRack[i][var12_48] = primaryIndex = this.regionIndexToPrimaryIndex[region];
                            ++var12_48;
                        }
                    }
                    Arrays.sort(this.primariesOfRegionsPerRack[i]);
                }
            }
        }

        private void registerRegion(RegionInfo region, int regionIndex, int serverIndex, Map<String, Deque<BalancerRegionLoad>> loads, RegionLocationFinder regionFinder) {
            String tableName = region.getTable().getNameAsString();
            if (!this.tablesToIndex.containsKey(tableName)) {
                this.tables.add(tableName);
                this.tablesToIndex.put(tableName, this.tablesToIndex.size());
            }
            int tableIndex = this.tablesToIndex.get(tableName);
            this.regionsToIndex.put(region, regionIndex);
            this.regions[regionIndex] = region;
            this.regionIndexToServerIndex[regionIndex] = serverIndex;
            this.initialRegionIndexToServerIndex[regionIndex] = serverIndex;
            this.regionIndexToTableIndex[regionIndex] = tableIndex;
            if (loads != null) {
                Deque<BalancerRegionLoad> rl = loads.get(region.getRegionNameAsString());
                if (rl == null) {
                    rl = loads.get(region.getEncodedName());
                }
                this.regionLoads[regionIndex] = rl;
            }
            if (regionFinder != null) {
                List<ServerName> loc = regionFinder.getTopBlockLocations(region);
                this.regionLocations[regionIndex] = new int[loc.size()];
                for (int i = 0; i < loc.size(); ++i) {
                    this.regionLocations[regionIndex][i] = loc.get(i) == null ? -1 : (this.serversToIndex.get(loc.get(i).getHostAndPort()) == null ? -1 : this.serversToIndex.get(loc.get(i).getHostAndPort()));
                }
            }
        }

        public boolean serverHasTooFewRegions(int server) {
            int minLoad = this.numRegions / this.numServers;
            int numRegions = this.getNumRegions(server);
            return numRegions < minLoad;
        }

        public float[][] getOrComputeRackLocalities() {
            if (this.rackLocalities == null || this.regionsToMostLocalEntities == null) {
                this.computeCachedLocalities();
            }
            return this.rackLocalities;
        }

        public int[] getOrComputeRegionsToMostLocalEntities(LocalityType type) {
            if (this.rackLocalities == null || this.regionsToMostLocalEntities == null) {
                this.computeCachedLocalities();
            }
            return this.regionsToMostLocalEntities[type.ordinal()];
        }

        public float getOrComputeLocality(int region, int entity, LocalityType type) {
            switch (type) {
                case SERVER: {
                    return this.getLocalityOfRegion(region, entity);
                }
                case RACK: {
                    return this.getOrComputeRackLocalities()[region][entity];
                }
            }
            throw new IllegalArgumentException("Unsupported LocalityType: " + (Object)((Object)type));
        }

        public double getOrComputeWeightedLocality(int region, int server, LocalityType type) {
            return (float)this.getRegionSizeMB(region) * this.getOrComputeLocality(region, server, type);
        }

        public int getRegionSizeMB(int region) {
            Deque<BalancerRegionLoad> load = this.regionLoads[region];
            if (load == null) {
                return 0;
            }
            return this.regionLoads[region].getLast().getStorefileSizeMB();
        }

        private void computeCachedLocalities() {
            this.rackLocalities = new float[this.numRegions][this.numRacks];
            this.regionsToMostLocalEntities = new int[LocalityType.values().length][this.numRegions];
            for (int region = 0; region < this.numRegions; ++region) {
                int rack;
                int serverWithBestLocality = 0;
                float bestLocalityForRegion = 0.0f;
                for (int server = 0; server < this.numServers; ++server) {
                    float locality = this.getLocalityOfRegion(region, server);
                    rack = this.serverIndexToRackIndex[server];
                    int numServersInRack = this.serversPerRack[rack].length;
                    float[] fArray = this.rackLocalities[region];
                    int n = rack;
                    fArray[n] = fArray[n] + locality / (float)numServersInRack;
                    if (!(locality > bestLocalityForRegion)) continue;
                    serverWithBestLocality = server;
                    bestLocalityForRegion = locality;
                }
                this.regionsToMostLocalEntities[LocalityType.SERVER.ordinal()][region] = serverWithBestLocality;
                int rackWithBestLocality = 0;
                float bestRackLocalityForRegion = 0.0f;
                for (rack = 0; rack < this.numRacks; ++rack) {
                    float rackLocality = this.rackLocalities[region][rack];
                    if (!(rackLocality > bestRackLocalityForRegion)) continue;
                    bestRackLocalityForRegion = rackLocality;
                    rackWithBestLocality = rack;
                }
                this.regionsToMostLocalEntities[LocalityType.RACK.ordinal()][region] = rackWithBestLocality;
            }
        }

        public int getRackForRegion(int region) {
            return this.serverIndexToRackIndex[this.regionIndexToServerIndex[region]];
        }

        public void doAction(Action action) {
            switch (action.type) {
                case NULL: {
                    break;
                }
                case ASSIGN_REGION: {
                    assert (action instanceof AssignRegionAction) : action.getClass();
                    AssignRegionAction ar = (AssignRegionAction)action;
                    this.regionsPerServer[ar.server] = this.addRegion(this.regionsPerServer[ar.server], ar.region);
                    this.regionMoved(ar.region, -1, ar.server);
                    break;
                }
                case MOVE_REGION: {
                    assert (action instanceof MoveRegionAction) : action.getClass();
                    MoveRegionAction mra = (MoveRegionAction)action;
                    this.regionsPerServer[mra.fromServer] = this.removeRegion(this.regionsPerServer[mra.fromServer], mra.region);
                    this.regionsPerServer[mra.toServer] = this.addRegion(this.regionsPerServer[mra.toServer], mra.region);
                    this.regionMoved(mra.region, mra.fromServer, mra.toServer);
                    break;
                }
                case SWAP_REGIONS: {
                    assert (action instanceof SwapRegionsAction) : action.getClass();
                    SwapRegionsAction a = (SwapRegionsAction)action;
                    this.regionsPerServer[a.fromServer] = this.replaceRegion(this.regionsPerServer[a.fromServer], a.fromRegion, a.toRegion);
                    this.regionsPerServer[a.toServer] = this.replaceRegion(this.regionsPerServer[a.toServer], a.toRegion, a.fromRegion);
                    this.regionMoved(a.fromRegion, a.fromServer, a.toServer);
                    this.regionMoved(a.toRegion, a.toServer, a.fromServer);
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown action:" + (Object)((Object)action.type));
                }
            }
        }

        boolean wouldLowerAvailability(RegionInfo regionInfo, ServerName serverName) {
            int rack;
            int host;
            int region;
            int primary;
            if (!this.serversToIndex.containsKey(serverName.getHostAndPort())) {
                return false;
            }
            int server = this.serversToIndex.get(serverName.getHostAndPort());
            if (this.contains(this.primariesOfRegionsPerServer[server], primary = this.regionIndexToPrimaryIndex[region = this.regionsToIndex.get(regionInfo).intValue()])) {
                for (int i = 0; i < this.primariesOfRegionsPerServer.length; ++i) {
                    if (i == server || this.contains(this.primariesOfRegionsPerServer[i], primary)) continue;
                    return true;
                }
                return false;
            }
            if (this.multiServersPerHost && this.contains(this.primariesOfRegionsPerHost[host = this.serverIndexToHostIndex[server]], primary)) {
                for (int i = 0; i < this.primariesOfRegionsPerHost.length; ++i) {
                    if (i == host || this.contains(this.primariesOfRegionsPerHost[i], primary)) continue;
                    return true;
                }
                return false;
            }
            if (this.numRacks > 1 && this.contains(this.primariesOfRegionsPerRack[rack = this.serverIndexToRackIndex[server]], primary)) {
                for (int i = 0; i < this.primariesOfRegionsPerRack.length; ++i) {
                    if (i == rack || this.contains(this.primariesOfRegionsPerRack[i], primary)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        void doAssignRegion(RegionInfo regionInfo, ServerName serverName) {
            if (!this.serversToIndex.containsKey(serverName.getHostAndPort())) {
                return;
            }
            int server = this.serversToIndex.get(serverName.getHostAndPort());
            int region = this.regionsToIndex.get(regionInfo);
            this.doAction(new AssignRegionAction(region, server));
        }

        void regionMoved(int region, int oldServer, int newServer) {
            int oldRack;
            int newRack;
            int oldHost;
            int newHost;
            this.regionIndexToServerIndex[region] = newServer;
            if (this.initialRegionIndexToServerIndex[region] == newServer) {
                --this.numMovedRegions;
            } else if (oldServer >= 0 && this.initialRegionIndexToServerIndex[region] == oldServer) {
                ++this.numMovedRegions;
            }
            int tableIndex = this.regionIndexToTableIndex[region];
            if (oldServer >= 0) {
                int[] nArray = this.numRegionsPerServerPerTable[oldServer];
                int n = tableIndex;
                nArray[n] = nArray[n] - 1;
            }
            int[] nArray = this.numRegionsPerServerPerTable[newServer];
            int n = tableIndex;
            nArray[n] = nArray[n] + 1;
            if (this.numRegionsPerServerPerTable[newServer][tableIndex] > this.numMaxRegionsPerTable[tableIndex]) {
                this.numMaxRegionsPerTable[tableIndex] = this.numRegionsPerServerPerTable[newServer][tableIndex];
            } else if (oldServer >= 0 && this.numRegionsPerServerPerTable[oldServer][tableIndex] + 1 == this.numMaxRegionsPerTable[tableIndex]) {
                this.numMaxRegionsPerTable[tableIndex] = 0;
                for (int[] aNumRegionsPerServerPerTable : this.numRegionsPerServerPerTable) {
                    if (aNumRegionsPerServerPerTable[tableIndex] <= this.numMaxRegionsPerTable[tableIndex]) continue;
                    this.numMaxRegionsPerTable[tableIndex] = aNumRegionsPerServerPerTable[tableIndex];
                }
            }
            int primary = this.regionIndexToPrimaryIndex[region];
            if (oldServer >= 0) {
                this.primariesOfRegionsPerServer[oldServer] = this.removeRegion(this.primariesOfRegionsPerServer[oldServer], primary);
            }
            this.primariesOfRegionsPerServer[newServer] = this.addRegionSorted(this.primariesOfRegionsPerServer[newServer], primary);
            if (this.multiServersPerHost && (newHost = this.serverIndexToHostIndex[newServer]) != (oldHost = oldServer >= 0 ? this.serverIndexToHostIndex[oldServer] : -1)) {
                this.regionsPerHost[newHost] = this.addRegion(this.regionsPerHost[newHost], region);
                this.primariesOfRegionsPerHost[newHost] = this.addRegionSorted(this.primariesOfRegionsPerHost[newHost], primary);
                if (oldHost >= 0) {
                    this.regionsPerHost[oldHost] = this.removeRegion(this.regionsPerHost[oldHost], region);
                    this.primariesOfRegionsPerHost[oldHost] = this.removeRegion(this.primariesOfRegionsPerHost[oldHost], primary);
                }
            }
            if (this.numRacks > 1 && (newRack = this.serverIndexToRackIndex[newServer]) != (oldRack = oldServer >= 0 ? this.serverIndexToRackIndex[oldServer] : -1)) {
                this.regionsPerRack[newRack] = this.addRegion(this.regionsPerRack[newRack], region);
                this.primariesOfRegionsPerRack[newRack] = this.addRegionSorted(this.primariesOfRegionsPerRack[newRack], primary);
                if (oldRack >= 0) {
                    this.regionsPerRack[oldRack] = this.removeRegion(this.regionsPerRack[oldRack], region);
                    this.primariesOfRegionsPerRack[oldRack] = this.removeRegion(this.primariesOfRegionsPerRack[oldRack], primary);
                }
            }
        }

        int[] removeRegion(int[] regions, int regionIndex) {
            int[] newRegions = new int[regions.length - 1];
            int i = 0;
            for (i = 0; i < regions.length && regions[i] != regionIndex; ++i) {
                newRegions[i] = regions[i];
            }
            System.arraycopy(regions, i + 1, newRegions, i, newRegions.length - i);
            return newRegions;
        }

        int[] addRegion(int[] regions, int regionIndex) {
            int[] newRegions = new int[regions.length + 1];
            System.arraycopy(regions, 0, newRegions, 0, regions.length);
            newRegions[newRegions.length - 1] = regionIndex;
            return newRegions;
        }

        int[] addRegionSorted(int[] regions, int regionIndex) {
            int[] newRegions = new int[regions.length + 1];
            int i = 0;
            for (i = 0; i < regions.length && regions[i] <= regionIndex; ++i) {
            }
            System.arraycopy(regions, 0, newRegions, 0, i);
            System.arraycopy(regions, i, newRegions, i + 1, regions.length - i);
            newRegions[i] = regionIndex;
            return newRegions;
        }

        int[] replaceRegion(int[] regions, int regionIndex, int newRegionIndex) {
            int i = 0;
            for (i = 0; i < regions.length; ++i) {
                if (regions[i] != regionIndex) continue;
                regions[i] = newRegionIndex;
                break;
            }
            return regions;
        }

        void sortServersByRegionCount() {
            Arrays.sort(this.serverIndicesSortedByRegionCount, this.numRegionsComparator);
        }

        int getNumRegions(int server) {
            return this.regionsPerServer[server].length;
        }

        boolean contains(int[] arr, int val) {
            return Arrays.binarySearch(arr, val) >= 0;
        }

        int getLowestLocalityRegionOnServer(int serverIndex) {
            if (this.regionFinder != null) {
                float lowestLocality = 1.0f;
                int lowestLocalityRegionIndex = -1;
                if (this.regionsPerServer[serverIndex].length == 0) {
                    return -1;
                }
                for (int j = 0; j < this.regionsPerServer[serverIndex].length; ++j) {
                    int regionIndex = this.regionsPerServer[serverIndex][j];
                    HDFSBlocksDistribution distribution = this.regionFinder.getBlockDistribution(this.regions[regionIndex]);
                    float locality = distribution.getBlockLocalityIndex(this.servers[serverIndex].getHostname());
                    if (distribution.getUniqueBlocksTotalWeight() == 0L || !(locality < lowestLocality)) continue;
                    lowestLocality = locality;
                    lowestLocalityRegionIndex = j;
                }
                if (lowestLocalityRegionIndex == -1) {
                    return -1;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Lowest locality region is " + this.regions[this.regionsPerServer[serverIndex][lowestLocalityRegionIndex]].getRegionNameAsString() + " with locality " + lowestLocality + " and its region server contains " + this.regionsPerServer[serverIndex].length + " regions");
                }
                return this.regionsPerServer[serverIndex][lowestLocalityRegionIndex];
            }
            return -1;
        }

        float getLocalityOfRegion(int region, int server) {
            if (this.regionFinder != null) {
                HDFSBlocksDistribution distribution = this.regionFinder.getBlockDistribution(this.regions[region]);
                return distribution.getBlockLocalityIndex(this.servers[server].getHostname());
            }
            return 0.0f;
        }

        @VisibleForTesting
        protected void setNumRegions(int numRegions) {
            this.numRegions = numRegions;
        }

        @VisibleForTesting
        protected void setNumMovedRegions(int numMovedRegions) {
            this.numMovedRegions = numMovedRegions;
        }

        @SuppressWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="Not important but should be fixed")
        public String toString() {
            StringBuilder desc = new StringBuilder("Cluster={servers=[");
            for (ServerName sn : this.servers) {
                desc.append(sn.getHostAndPort()).append(", ");
            }
            desc.append("], serverIndicesSortedByRegionCount=").append(Arrays.toString((Object[])this.serverIndicesSortedByRegionCount)).append(", regionsPerServer=").append(Arrays.deepToString((Object[])this.regionsPerServer));
            desc.append(", numMaxRegionsPerTable=").append(Arrays.toString(this.numMaxRegionsPerTable)).append(", numRegions=").append(this.numRegions).append(", numServers=").append(this.numServers).append(", numTables=").append(this.numTables).append(", numMovedRegions=").append(this.numMovedRegions).append('}');
            return desc.toString();
        }

        public static class SwapRegionsAction
        extends Action {
            public int fromServer;
            public int fromRegion;
            public int toServer;
            public int toRegion;

            public SwapRegionsAction(int fromServer, int fromRegion, int toServer, int toRegion) {
                super(Action.Type.SWAP_REGIONS);
                this.fromServer = fromServer;
                this.fromRegion = fromRegion;
                this.toServer = toServer;
                this.toRegion = toRegion;
            }

            @Override
            public Action undoAction() {
                return new SwapRegionsAction(this.fromServer, this.toRegion, this.toServer, this.fromRegion);
            }

            @Override
            public String toString() {
                return (Object)((Object)this.type) + ": " + this.fromRegion + ":" + this.fromServer + " <-> " + this.toRegion + ":" + this.toServer;
            }
        }

        public static class MoveRegionAction
        extends Action {
            public int region;
            public int fromServer;
            public int toServer;

            public MoveRegionAction(int region, int fromServer, int toServer) {
                super(Action.Type.MOVE_REGION);
                this.fromServer = fromServer;
                this.region = region;
                this.toServer = toServer;
            }

            @Override
            public Action undoAction() {
                return new MoveRegionAction(this.region, this.toServer, this.fromServer);
            }

            @Override
            public String toString() {
                return (Object)((Object)this.type) + ": " + this.region + ":" + this.fromServer + " -> " + this.toServer;
            }
        }

        public static class AssignRegionAction
        extends Action {
            public int region;
            public int server;

            public AssignRegionAction(int region, int server) {
                super(Action.Type.ASSIGN_REGION);
                this.region = region;
                this.server = server;
            }

            @Override
            public Action undoAction() {
                throw new NotImplementedException("Not implemented");
            }

            @Override
            public String toString() {
                return (Object)((Object)this.type) + ": " + this.region + ":" + this.server;
            }
        }

        public static class Action {
            public Type type;

            public Action(Type type) {
                this.type = type;
            }

            public Action undoAction() {
                return this;
            }

            public String toString() {
                return (Object)((Object)this.type) + ":";
            }

            public static enum Type {
                ASSIGN_REGION,
                MOVE_REGION,
                SWAP_REGIONS,
                NULL;

            }
        }

        static enum LocalityType {
            SERVER,
            RACK;

        }
    }

    private static class DefaultRackManager
    extends RackManager {
        private DefaultRackManager() {
        }

        @Override
        public String getRack(ServerName server) {
            return "Unknown Rack";
        }
    }
}

