/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFilePathAccessor;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DirectSnapshotFileManager
implements SnapshotFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(DirectSnapshotFileManager.class);
    private static final int SHUTDOWN_TIMEOUT_MS = 500;
    private static final int COMMIT_RESTORE_THREADPOOL_SIZE = 100;
    private static final int DELETE_REGIONS_THREADPOOL_SIZE = 10;
    private StoreFilePathAccessor storeFilePathAccessor;
    private ExecutorService commitRestoreExecutorService;
    private ExecutorService deleteRegionsExecutorService;

    public DirectSnapshotFileManager(StoreFilePathAccessor storeFilePathAccessor) {
        this.storeFilePathAccessor = storeFilePathAccessor;
        this.commitRestoreExecutorService = Executors.newFixedThreadPool(100);
        this.deleteRegionsExecutorService = Executors.newFixedThreadPool(10);
    }

    private final boolean isExpectedPath(MasterFileSystem masterFileSystem, Path path, TableName destinationTableName) {
        return path.equals((Object)FSUtils.getTableDir((Path)this.getWorkingCloneRootDirectory(masterFileSystem), (TableName)destinationTableName));
    }

    @Override
    public Path getWorkingCloneRootDirectory(MasterFileSystem masterFileSystem) {
        return masterFileSystem.getRootDir();
    }

    @Override
    public void commitClone(MasterFileSystem masterFileSystem, TableName destinationTableName, Path workingCloneTableDir) {
        assert (this.isExpectedPath(masterFileSystem, workingCloneTableDir, destinationTableName)) : "Unexpected directory path " + workingCloneTableDir;
    }

    @Override
    public void commitRestore(String destinationTableName, RestoreSnapshotHelper.RestoreFileChanges fileChanges, RestoreSnapshotHelper.RestoreMetaChanges metaChanges) throws IOException {
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.commitRestoreExecutorService);
        completionService.submit(() -> {
            try {
                this.updateFiles(destinationTableName, fileChanges.getFilesToAddAndDelete());
            }
            catch (Throwable t) {
                LOG.error("Failed to update files for table: {}", (Object)destinationTableName, (Object)t);
                throw t;
            }
            return null;
        });
        completionService.submit(() -> {
            try {
                this.deleteFamilies(destinationTableName, fileChanges.getFamiliesToDelete());
            }
            catch (Throwable t) {
                LOG.error("Failed to delete families for table: {}", (Object)destinationTableName, (Object)t);
                throw t;
            }
            return null;
        });
        this.validateCompletion(2, completionService);
        if (metaChanges.getRegionsToRemove() != null) {
            this.deleteRegions(destinationTableName, metaChanges.getRegionsToRemove());
        }
    }

    private void updateFiles(String tableName, Map<Pair<String, String>, Pair<Set<Path>, Set<Path>>> filesToUpdateAndDelete) throws IOException {
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.commitRestoreExecutorService);
        for (Map.Entry<Pair<String, String>, Pair<Set<Path>, Set<Path>>> entry : filesToUpdateAndDelete.entrySet()) {
            completionService.submit(() -> {
                try {
                    this.storeFilePathAccessor.updateIncludedAndExcludedStoreFilePaths(tableName, (String)((Pair)entry.getKey()).getLeft(), (String)((Pair)entry.getKey()).getRight(), (Set)((Pair)entry.getValue()).getLeft(), (Set)((Pair)entry.getValue()).getRight());
                }
                catch (Throwable t) {
                    LOG.error("Failed to update files. Table: {} Region: {} Family: {}", new Object[]{tableName, ((Pair)entry.getKey()).getLeft(), ((Pair)entry.getKey()).getRight(), t});
                    throw t;
                }
                return null;
            });
        }
        this.validateCompletion(filesToUpdateAndDelete.size(), completionService);
    }

    private void deleteFamilies(String tableName, Set<Pair<String, String>> familiesToDelete) throws IOException {
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.commitRestoreExecutorService);
        for (Pair<String, String> regionFamilyPair : familiesToDelete) {
            completionService.submit(() -> {
                try {
                    this.storeFilePathAccessor.deleteStoreFilePaths(tableName, (String)regionFamilyPair.getLeft(), (String)regionFamilyPair.getRight());
                }
                catch (Throwable t) {
                    LOG.error("Failed to delete family. Table: {} Region: {} Family: {}", new Object[]{tableName, regionFamilyPair.getLeft(), regionFamilyPair.getRight(), t});
                    throw t;
                }
                return null;
            });
        }
        this.validateCompletion(familiesToDelete.size(), completionService);
    }

    private void validateCompletion(int totalFutures, ExecutorCompletionService completionService) throws IOException {
        for (int futureCount = 0; futureCount < totalFutures; ++futureCount) {
            try {
                completionService.take().get();
                continue;
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException(ex.getMessage());
            }
            catch (ExecutionException ex) {
                IOException e = new IOException();
                e.initCause(ex.getCause());
                throw e;
            }
        }
    }

    private void deleteRegions(String tableName, List<RegionInfo> regionsToDelete) {
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(this.deleteRegionsExecutorService);
        List regionNames = regionsToDelete.stream().map(regionInfo -> regionInfo.getEncodedName()).collect(Collectors.toList());
        for (String regionName : regionNames) {
            completionService.submit(() -> {
                this.storeFilePathAccessor.deleteRegion(tableName, regionName);
                return null;
            });
        }
    }

    @Override
    public boolean overWriteExistingFiles() {
        return true;
    }

    @Override
    public void close() throws IOException {
        try {
            this.commitRestoreExecutorService.awaitTermination(500L, TimeUnit.MILLISECONDS);
            this.deleteRegionsExecutorService.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while awaiting termination of resources in DirectSnapshotFileManager");
        }
    }
}

