/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileManager;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFileComparators;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DateTieredStoreEngine
extends StoreEngine<DefaultStoreFlusher, DateTieredCompactionPolicy, DateTieredCompactor, DefaultStoreFileManager> {
    @Override
    public boolean needsCompaction(List<HStoreFile> filesCompacting) {
        return ((DateTieredCompactionPolicy)this.compactionPolicy).needsCompaction(((DefaultStoreFileManager)this.storeFileManager).getStorefiles(), filesCompacting);
    }

    @Override
    public CompactionContext createCompaction() throws IOException {
        return new DateTieredCompactionContext();
    }

    @Override
    protected void createComponents(Configuration conf, HStore store, CellComparator kvComparator) throws IOException {
        this.compactionPolicy = new DateTieredCompactionPolicy(conf, store);
        this.storeFileManager = new DefaultStoreFileManager(kvComparator, StoreFileComparators.SEQ_ID_MAX_TIMESTAMP, conf, ((DateTieredCompactionPolicy)this.compactionPolicy).getConf(), store.getRegionFileSystem(), store.getColumnFamilyName());
        this.storeFlusher = new DefaultStoreFlusher(conf, store);
        this.compactor = new DateTieredCompactor(conf, store);
    }

    private final class DateTieredCompactionContext
    extends CompactionContext {
        private DateTieredCompactionContext() {
        }

        @Override
        public List<HStoreFile> preSelect(List<HStoreFile> filesCompacting) {
            return ((DateTieredCompactionPolicy)DateTieredStoreEngine.this.compactionPolicy).preSelectCompactionForCoprocessor(((DefaultStoreFileManager)DateTieredStoreEngine.this.storeFileManager).getStorefiles(), filesCompacting);
        }

        @Override
        public boolean select(List<HStoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
            this.request = ((DateTieredCompactionPolicy)DateTieredStoreEngine.this.compactionPolicy).selectCompaction(((DefaultStoreFileManager)DateTieredStoreEngine.this.storeFileManager).getStorefiles(), filesCompacting, isUserCompaction, mayUseOffPeak, forceMajor);
            return this.request != null;
        }

        @Override
        public void forceSelect(CompactionRequestImpl request) {
            if (!(request instanceof DateTieredCompactionRequest)) {
                throw new IllegalArgumentException("DateTieredCompactionRequest is expected. Actual: " + request.getClass().getCanonicalName());
            }
            super.forceSelect(request);
        }

        @Override
        public List<Path> compact(ThroughputController throughputController, User user) throws IOException {
            if (this.request instanceof DateTieredCompactionRequest) {
                return ((DateTieredCompactor)DateTieredStoreEngine.this.compactor).compact(this.request, ((DateTieredCompactionRequest)this.request).getBoundaries(), throughputController, user);
            }
            throw new IllegalArgumentException("DateTieredCompactionRequest is expected. Actual: " + this.request.getClass().getCanonicalName());
        }

        @Override
        public List<HStoreFile> commitCompaction(User user, List<Path> newFiles) throws IOException {
            return ((DateTieredCompactor)DateTieredStoreEngine.this.compactor).commit(this.request, user, newFiles);
        }
    }
}

