/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.HStoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileCommitter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DirectStoreFileCommitter
implements StoreFileCommitter {
    private HStoreContext storeContext;

    public DirectStoreFileCommitter(HStoreContext storeContext) {
        this.storeContext = storeContext;
    }

    private final boolean isExpectedPath(Path path) {
        return path.getParent().equals((Object)this.storeContext.getStoreDirectory());
    }

    @Override
    public Path commitStoreFile(Path filePath, long seqNum, boolean generateNewName) {
        assert (this.isExpectedPath(filePath)) : "Unexpected storefile path" + filePath;
        return filePath;
    }
}

