/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemHelper;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class HRegionFileSystemMergeHandler {
    protected final Configuration conf;
    protected final FileSystem fs;
    protected final HRegionFileSystemHelper hrfsHelper;

    HRegionFileSystemMergeHandler(HRegionFileSystemHelper hrfsHelper) {
        this.hrfsHelper = hrfsHelper;
        this.fs = hrfsHelper.getFileSystem();
        this.conf = hrfsHelper.getConf();
    }

    abstract Path getMergesDir();

    abstract void cleanupMergesDir() throws IOException;

    abstract void createMergesDir() throws IOException;

    abstract void commitMergedRegion(RegionInfo var1) throws IOException;

    Path getMergesDir(RegionInfo hri) {
        return new Path(this.getMergesDir(), hri.getEncodedName());
    }

    void cleanupMergedRegion(RegionInfo mergedRegion) throws IOException {
        Path mergedRegionDir = new Path(this.hrfsHelper.getTableDir(), mergedRegion.getEncodedName());
        if (this.fs.exists(mergedRegionDir) && !this.fs.delete(mergedRegionDir, true)) {
            throw new IOException("Failed delete of " + mergedRegionDir);
        }
    }

    Path mergeStoreFile(RegionInfo mergedRegion, String familyName, HStoreFile f, Path mergedDir) throws IOException {
        Path referenceDir = new Path(new Path(mergedDir, mergedRegion.getEncodedName()), familyName);
        Reference r = Reference.createTopReference(this.hrfsHelper.getRegionInfoForFS().getStartKey());
        String mergingRegionName = this.hrfsHelper.getRegionInfoForFS().getEncodedName();
        Path p = new Path(referenceDir, f.getPath().getName() + "." + mergingRegionName);
        return r.write(this.fs, p);
    }
}

