/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HStoreContext {
    private final HFileContext defaultFileContext;
    private final CacheConfig cacheConf;
    private final HRegionFileSystem regionFileSystem;
    private final CellComparator comparator;
    private final BloomType bloomFilterType;
    private final Supplier<Collection<HStoreFile>> compactedFilesSupplier;
    private final Supplier<InetSocketAddress[]> favoredNodesSupplier;
    private final ColumnFamilyDescriptor family;
    private final Path storeDirectory;
    private final RegionCoprocessorHost coprocessorHost;

    private HStoreContext(Builder builder) {
        this.defaultFileContext = builder.defaultFileContext;
        this.cacheConf = builder.cacheConf;
        this.regionFileSystem = builder.regionFileSystem;
        this.comparator = builder.comparator;
        this.bloomFilterType = builder.bloomFilterType;
        this.compactedFilesSupplier = builder.compactedFilesSupplier;
        this.favoredNodesSupplier = builder.favoredNodesSupplier;
        this.family = builder.family;
        this.storeDirectory = builder.storeDirectory;
        this.coprocessorHost = builder.coprocessorHost;
    }

    public HFileContext getDefaultFileContext() {
        return this.defaultFileContext;
    }

    public CacheConfig getCacheConf() {
        return this.cacheConf;
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.regionFileSystem;
    }

    public CellComparator getComparator() {
        return this.comparator;
    }

    public BloomType getBloomFilterType() {
        return this.bloomFilterType;
    }

    public Supplier<Collection<HStoreFile>> getCompactedFilesSupplier() {
        return this.compactedFilesSupplier;
    }

    public Supplier<InetSocketAddress[]> getFavoredNodesSupplier() {
        return this.favoredNodesSupplier;
    }

    public ColumnFamilyDescriptor getFamily() {
        return this.family;
    }

    public Path getStoreDirectory() {
        return this.storeDirectory;
    }

    public RegionCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private HFileContext defaultFileContext;
        private CacheConfig cacheConf;
        private HRegionFileSystem regionFileSystem;
        private CellComparator comparator;
        private BloomType bloomFilterType;
        private Supplier<Collection<HStoreFile>> compactedFilesSupplier;
        private Supplier<InetSocketAddress[]> favoredNodesSupplier;
        private ColumnFamilyDescriptor family;
        private Path storeDirectory;
        private RegionCoprocessorHost coprocessorHost;

        public Builder withDefaultHFileContext(HFileContext defaultFileContext) {
            this.defaultFileContext = defaultFileContext;
            return this;
        }

        public Builder withCacheConfig(CacheConfig cacheConf) {
            this.cacheConf = cacheConf;
            return this;
        }

        public Builder withRegionFileSystem(HRegionFileSystem regionFileSystem) {
            this.regionFileSystem = regionFileSystem;
            return this;
        }

        public Builder withCellComparator(CellComparator comparator) {
            this.comparator = comparator;
            return this;
        }

        public Builder withBloomType(BloomType bloomFilterType) {
            this.bloomFilterType = bloomFilterType;
            return this;
        }

        public Builder withCompactedFilesSupplier(Supplier<Collection<HStoreFile>> compactedFilesSupplier) {
            this.compactedFilesSupplier = compactedFilesSupplier;
            return this;
        }

        public Builder withFavoredNodesSupplier(Supplier<InetSocketAddress[]> favoredNodesSupplier) {
            this.favoredNodesSupplier = favoredNodesSupplier;
            return this;
        }

        public Builder withColumnFamilyDescriptor(ColumnFamilyDescriptor family) {
            this.family = family;
            return this;
        }

        public Builder withStoreDirectory(Path storeDirectory) {
            this.storeDirectory = storeDirectory;
            return this;
        }

        public Builder withRegionCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
            this.coprocessorHost = coprocessorHost;
            return this;
        }

        public HStoreContext build() {
            return new HStoreContext(this);
        }
    }
}

