/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.AbstractStoreFilePathAccessor;
import org.apache.hadoop.hbase.regionserver.StorefileTrackingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HTableStoreFilePathAccessor
extends AbstractStoreFilePathAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(HTableStoreFilePathAccessor.class);
    public static final byte[] STOREFILE_FAMILY_INCLUDED = Bytes.toBytes((String)"included");
    public static final byte[] STOREFILE_FAMILY_EXCLUDED = Bytes.toBytes((String)"excluded");
    private static final String DASH_SEPARATOR = "-";
    private static final String STOREFILE_QUALIFIER_STR = "filepaths";
    private static final byte[] STOREFILE_QUALIFIER = Bytes.toBytes((String)"filepaths");
    private static final int STOREFILE_TABLE_VERSIONS = 3;
    public static final TableDescriptor STOREFILE_TABLE_DESC = TableDescriptorBuilder.newBuilder((TableName)TableName.STOREFILE_TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])STOREFILE_FAMILY_INCLUDED).setMaxVersions(3).setInMemory(true).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])STOREFILE_FAMILY_EXCLUDED).setMaxVersions(3).setInMemory(true).build()).build();
    private Connection connection;

    public HTableStoreFilePathAccessor(Configuration conf, Connection connection) {
        super(conf);
        Preconditions.checkNotNull((Object)connection, (Object)"connection cannot be null");
        this.connection = connection;
    }

    @Override
    @VisibleForTesting
    public void initialize(MasterServices masterServices) throws IOException {
        StorefileTrackingUtils.init(masterServices);
    }

    @Override
    public void updateIncludedAndExcludedStoreFilePaths(String tableName, String regionName, String storeName, Set<Path> storeFilePathsToAdd, Set<Path> storeFilePathsToDelete) throws IOException {
        List<Path> existingIncludedPaths = this.getStoreFilePaths(tableName, regionName, storeName, "included");
        List<Path> existingExcludedPaths = this.getStoreFilePaths(tableName, regionName, storeName, "excluded");
        HashSet newIncludedPaths = Sets.newHashSet(existingIncludedPaths);
        HashSet newExcludedPaths = Sets.newHashSet(existingExcludedPaths);
        newIncludedPaths.addAll(storeFilePathsToAdd);
        newIncludedPaths.removeAll(storeFilePathsToDelete);
        newExcludedPaths.addAll(storeFilePathsToDelete);
        if (newIncludedPaths.equals(existingIncludedPaths) && newExcludedPaths.equals(existingExcludedPaths)) {
            LOG.info("No new paths to update. existingIncludedPaths: {}, existingExcludedPaths: {}", existingIncludedPaths, existingExcludedPaths);
            return;
        }
        byte[] rowKey = Bytes.toBytes((String)this.getKey(tableName, regionName, storeName));
        Put targetPut = this.generatePutForStoreFilePaths(tableName, regionName, storeName, Lists.newArrayList((Iterable)newIncludedPaths), (List<Path>)Lists.newArrayList((Iterable)newExcludedPaths));
        boolean result = this.checkAndMutate(rowKey, Bytes.toBytes((String)"included"), STOREFILE_QUALIFIER, HTableStoreFilePathAccessor.storeFileListToByteArray(existingIncludedPaths), targetPut);
        if (!result) {
            String msg = String.format("Failed to update included and excluded store file paths as the existing paths check failed. table: %s + region: %s storeName: %s storeFilePathsToAdd: %s storeFilePathsToDelete: %s existingIncludedPaths: %sexistingExcludedPaths: %s", tableName, regionName, storeName, storeFilePathsToAdd, storeFilePathsToDelete, existingIncludedPaths, existingExcludedPaths);
            LOG.error(msg);
            throw new IOException(msg);
        }
    }

    @Override
    List<Path> getStoreFilePaths(String tableName, String regionName, String storeName, String colFamily) throws IOException {
        HTableStoreFilePathAccessor.validate(tableName, regionName, storeName, colFamily);
        byte[] colFamilyBytes = Bytes.toBytes((String)colFamily);
        Get get = new Get(Bytes.toBytes((String)this.getKey(tableName, regionName, storeName)));
        get.addColumn(colFamilyBytes, STOREFILE_QUALIFIER);
        Result result = this.doGet(get);
        if (result == null || result.isEmpty()) {
            return new ArrayList<Path>();
        }
        return HTableStoreFilePathAccessor.byteToStoreFileList(result.getValue(colFamilyBytes, STOREFILE_QUALIFIER));
    }

    @Override
    void writeStoreFilePaths(String tableName, String regionName, String storeName, String colFamily, List<Path> storeFilePaths) throws IOException {
        HTableStoreFilePathAccessor.validate(tableName, regionName, storeName, colFamily);
        Preconditions.checkNotNull(storeFilePaths, (Object)"storeFilePaths cannot be null");
        Put put = this.generatePutForStoreFilePaths(tableName, regionName, storeName, colFamily, storeFilePaths);
        this.doPut(put);
    }

    @Override
    public void writeIncludedAndExcludedStoreFilePaths(String tableName, String regionName, String storeName, List<Path> includedStoreFilePaths, List<Path> excludedStoreFilePaths) throws IOException {
        HTableStoreFilePathAccessor.validate(tableName, regionName, storeName);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(includedStoreFilePaths) ? 1 : 0) != 0, (Object)"includedStoreFilePaths cannot be empty");
        Preconditions.checkNotNull(excludedStoreFilePaths, (Object)"excludedStoreFilePaths cannot be null");
        Put put = this.generatePutForStoreFilePaths(tableName, regionName, storeName, includedStoreFilePaths, excludedStoreFilePaths);
        this.doPut(put);
    }

    private Put generatePutForStoreFilePaths(String tableName, String regionName, String storeName, List<Path> includedStoreFilePaths, List<Path> excludedStoreFilePaths) {
        Put put = new Put(Bytes.toBytes((String)this.getKey(tableName, regionName, storeName)));
        put.addColumn(Bytes.toBytes((String)"included"), STOREFILE_QUALIFIER, HTableStoreFilePathAccessor.storeFileListToByteArray(includedStoreFilePaths));
        put.addColumn(Bytes.toBytes((String)"excluded"), STOREFILE_QUALIFIER, HTableStoreFilePathAccessor.storeFileListToByteArray(excludedStoreFilePaths));
        return put;
    }

    private Put generatePutForStoreFilePaths(String tableName, String regionName, String storeName, String colFamily, List<Path> storeFilePaths) {
        if (colFamily.equals("included")) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(storeFilePaths), (Object)("Storefile paths should not be empty when writing to " + colFamily + " data set"));
        }
        byte[] colFamilyBytes = Bytes.toBytes((String)colFamily);
        Put put = new Put(Bytes.toBytes((String)this.getKey(tableName, regionName, storeName)));
        put.addColumn(colFamilyBytes, STOREFILE_QUALIFIER, HTableStoreFilePathAccessor.storeFileListToByteArray(storeFilePaths));
        return put;
    }

    @Override
    public void deleteStoreFilePaths(String tableName, String regionName, String storeName) throws IOException {
        HTableStoreFilePathAccessor.validate(tableName, regionName, storeName);
        Delete delete = new Delete(Bytes.toBytes((String)this.getKey(tableName, regionName, storeName)));
        delete.addColumns(STOREFILE_FAMILY_INCLUDED, STOREFILE_QUALIFIER);
        delete.addColumns(STOREFILE_FAMILY_EXCLUDED, STOREFILE_QUALIFIER);
        this.doDelete(Lists.newArrayList((Object[])new Delete[]{delete}));
    }

    @Override
    public void deleteRegion(String tableName, String regionName) throws IOException {
        String regionPrefixForKey = this.getRegionPrefixForKey(tableName, regionName);
        Scan scan = new Scan();
        scan.setRowPrefixFilter(Bytes.toBytes((String)regionPrefixForKey));
        scan.addColumn(STOREFILE_FAMILY_INCLUDED, STOREFILE_QUALIFIER);
        ArrayList<Delete> familiesToDelete = new ArrayList<Delete>();
        for (Result result : this.getResultScanner(scan)) {
            String rowKey = Bytes.toString((byte[])result.getRow());
            Delete delete = new Delete(Bytes.toBytes((String)rowKey));
            familiesToDelete.add(delete);
        }
        this.doDelete(familiesToDelete);
    }

    @Override
    String getSeparator() {
        return DASH_SEPARATOR;
    }

    private Result doGet(Get get) throws IOException {
        try (Table table = this.getConnection().getTable(TableName.STOREFILE_TABLE_NAME);){
            Result result = table.get(get);
            return result;
        }
    }

    private void doPut(Put put) throws IOException {
        try (Table table = this.getConnection().getTable(TableName.STOREFILE_TABLE_NAME);){
            table.put(put);
        }
    }

    private void doDelete(List<Delete> delete) throws IOException {
        try (Table table = this.getConnection().getTable(TableName.STOREFILE_TABLE_NAME);){
            table.delete(delete);
        }
    }

    private ResultScanner getResultScanner(Scan scan) throws IOException {
        try (Table table = this.getConnection().getTable(TableName.STOREFILE_TABLE_NAME);){
            ResultScanner resultScanner = table.getScanner(scan);
            return resultScanner;
        }
    }

    private boolean checkAndMutate(byte[] rowKey, byte[] colFamily, byte[] qualifier, byte[] expectedValue, Put targetPut) throws IOException {
        try (Table table = this.getConnection().getTable(TableName.STOREFILE_TABLE_NAME);){
            boolean bl = table.checkAndMutate(rowKey, colFamily).qualifier(qualifier).ifEquals(expectedValue).thenPut(targetPut);
            return bl;
        }
    }

    private Connection getConnection() throws IOException {
        if (this.connection == null) {
            throw new IOException("Connection should be provided by region server and should not be null after initialized.");
        }
        return this.connection;
    }
}

