/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class StoreFlusher {
    protected Configuration conf;
    protected HStore store;
    protected StoreFileWriterFactory storeFileWriterFactory;
    protected StoreFileCommitter storeFileCommitter;
    private static final Logger LOG = LoggerFactory.getLogger(StoreFlusher.class);

    public StoreFlusher(Configuration conf, HStore store, StoreFileWriterFactory storeFileWriterFactory, StoreFileCommitter storeFileCommitter) {
        this.conf = conf;
        this.store = store;
        this.storeFileWriterFactory = storeFileWriterFactory;
        this.storeFileCommitter = storeFileCommitter;
    }

    public abstract List<Path> flushSnapshot(MemStoreSnapshot var1, long var2, MonitoredTask var4, ThroughputController var5, FlushLifeCycleTracker var6) throws IOException;

    protected void finalizeWriter(StoreFileWriter writer, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        status.setStatus("Flushing " + this.store + ": appending metadata");
        writer.appendMetadata(cacheFlushSeqNum, false);
        status.setStatus("Flushing " + this.store + ": closing flushed file");
        writer.close();
    }

    protected final InternalScanner createScanner(List<KeyValueScanner> snapshotScanners, long smallestReadPoint, FlushLifeCycleTracker tracker) throws IOException {
        ScanInfo scanInfo = this.store.getCoprocessorHost() != null ? this.store.getCoprocessorHost().preFlushScannerOpen(this.store, tracker) : this.store.getScanInfo();
        StoreScanner scanner = new StoreScanner(this.store, scanInfo, snapshotScanners, ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, Long.MIN_VALUE);
        assert (scanner != null);
        if (this.store.getCoprocessorHost() != null) {
            try {
                return this.store.getCoprocessorHost().preFlush(this.store, scanner, tracker);
            }
            catch (IOException ioe) {
                scanner.close();
                throw ioe;
            }
        }
        return scanner;
    }

    protected StoreFileWriter createWriter(MemStoreSnapshot snapshot) throws IOException {
        return this.storeFileWriterFactory.createWriter(snapshot.getCellsCount(), false, true, snapshot.isTagsPresent(), false);
    }

    protected void performFlush(InternalScanner scanner, CellSink sink, long smallestReadPoint, ThroughputController throughputController) throws IOException {
        boolean control;
        int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(compactionKVMax).build();
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        String flushName = ThroughputControlUtil.getNameForThrottling(this.store, "flush");
        boolean bl = control = throughputController != null && !this.store.getRegionInfo().getTable().isSystemTable();
        if (control) {
            throughputController.start(flushName);
        }
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(kvs, scannerContext);
                if (kvs.isEmpty()) continue;
                for (Cell c : kvs) {
                    sink.append(c);
                    if (!control) continue;
                    throughputController.control(flushName, c.getSerializedSize());
                }
                kvs.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while control throughput of flushing " + flushName);
        }
        finally {
            if (control) {
                throughputController.finish(flushName);
            }
        }
    }

    private HStoreFile commitFile(Path storeFilePath, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        Path dstPath = this.storeFileCommitter.commitStoreFile(storeFilePath, -1L, false);
        return this.store.createStoreFileAndReaderAndUpdateSizingInfo(dstPath, cacheFlushSeqNum, status);
    }

    protected final List<HStoreFile> commit(List<Path> flushedFiles, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        if (CollectionUtils.isEmpty(flushedFiles)) {
            return Collections.emptyList();
        }
        ArrayList<HStoreFile> storeFiles = new ArrayList<HStoreFile>(flushedFiles.size());
        for (Path storeFilePath : flushedFiles) {
            boolean isCommitSuccessful = false;
            try {
                HStoreFile sf = this.commitFile(storeFilePath, cacheFlushSeqNum, status);
                isCommitSuccessful = true;
                storeFiles.add(sf);
            }
            catch (IOException ex) {
                LOG.error("Failed to commit store file {}", (Object)storeFilePath, (Object)ex);
                throw new IOException("Failed to commit the flush", ex);
            }
            finally {
                if (isCommitSuccessful) continue;
                for (HStoreFile sf : storeFiles) {
                    Path pathToDelete = sf.getPath();
                    try {
                        sf.deleteStoreFile();
                    }
                    catch (IOException deleteEx) {
                        LOG.error(HBaseMarkers.FATAL, "Failed to delete store file we committed, halting {}", (Object)pathToDelete, (Object)deleteEx);
                        Runtime.getRuntime().halt(1);
                    }
                }
            }
        }
        return storeFiles;
    }

    protected final void postCommit(long snapshotId, List<HStoreFile> storeFiles, FlushLifeCycleTracker tracker) throws IOException {
        this.runPostFlushCoprocessor(storeFiles, tracker);
        this.updateStoreFiles(storeFiles, snapshotId);
    }

    private void updateStoreFiles(List<HStoreFile> storeFiles, long snapshotId) throws IOException {
        this.store.updateStorefiles(storeFiles, snapshotId);
    }

    private void runPostFlushCoprocessor(List<HStoreFile> storeFiles, FlushLifeCycleTracker tracker) throws IOException {
        for (HStoreFile sf : storeFiles) {
            if (this.store.getCoprocessorHost() == null) continue;
            this.store.getCoprocessorHost().postFlush(this.store, sf, tracker);
        }
    }
}

