/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.StoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StripeMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StripeStoreFlusher
extends StoreFlusher {
    private static final Logger LOG = LoggerFactory.getLogger(StripeStoreFlusher.class);
    private final Object flushLock = new Object();
    private final StripeCompactionPolicy policy;
    private final StripeCompactionPolicy.StripeInformationProvider stripes;

    public StripeStoreFlusher(Configuration conf, HStore store, StripeCompactionPolicy policy, StripeStoreFileManager stripes, StoreFileWriterFactory storeFileWriterFactory, StoreFileCommitter storeFileCommitter) {
        super(conf, store, storeFileWriterFactory, storeFileCommitter);
        this.policy = policy;
        this.stripes = stripes;
    }

    public StripeStoreFlusher(Configuration conf, HStore store, StripeCompactionPolicy policy, StripeStoreFileManager stripes) {
        this(conf, store, policy, stripes, new DefaultStoreFileWriterFactory(store.getStoreContext(), conf), new DefaultStoreFileCommitter(store.getStoreContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushSeqNum, MonitoredTask status, ThroughputController throughputController, FlushLifeCycleTracker tracker) throws IOException {
        InternalScanner scanner;
        List<Path> result;
        block16: {
            Object factory;
            result = new ArrayList<Path>();
            int cellsCount = snapshot.getCellsCount();
            if (cellsCount == 0) {
                return result;
            }
            long smallestReadPoint = this.store.getSmallestReadPoint();
            scanner = this.createScanner(snapshot.getScanners(), smallestReadPoint, tracker);
            StripeFlushRequest req = this.policy.selectFlush(this.store.getComparator(), this.stripes, cellsCount);
            boolean success = false;
            StripeMultiFileWriter mw = null;
            try {
                mw = req.createWriter();
                factory = this.createWriterFactory(cellsCount);
                StoreScanner storeScanner = scanner instanceof StoreScanner ? (StoreScanner)scanner : null;
                mw.init(storeScanner, (AbstractMultiFileWriter.WriterFactory)factory);
                Object object = this.flushLock;
                synchronized (object) {
                    this.performFlush(scanner, mw, smallestReadPoint, throughputController);
                    result = mw.commitWriters(cacheFlushSeqNum, false);
                    success = true;
                    if (success || mw == null) break block16;
                }
                factory = mw.abortWriters().iterator();
            }
            catch (Throwable throwable) {
                if (!success && mw != null) {
                    for (Path leftoverFile : mw.abortWriters()) {
                        try {
                            this.store.getFileSystem().delete(leftoverFile, false);
                        }
                        catch (Exception e) {
                            LOG.error("Failed to delete a file after failed flush: " + e);
                        }
                    }
                }
                try {
                    scanner.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    LOG.warn("Failed to close flush scanner, ignoring", (Throwable)ex);
                }
                throw throwable;
            }
            while (factory.hasNext()) {
                Path leftoverFile = (Path)factory.next();
                try {
                    this.store.getFileSystem().delete(leftoverFile, false);
                }
                catch (Exception e) {
                    LOG.error("Failed to delete a file after failed flush: " + e);
                }
            }
        }
        try {
            scanner.close();
            return result;
        }
        catch (IOException ex) {
            LOG.warn("Failed to close flush scanner, ignoring", (Throwable)ex);
            return result;
        }
    }

    private AbstractMultiFileWriter.WriterFactory createWriterFactory(final long kvCount) {
        return new AbstractMultiFileWriter.WriterFactory(){

            @Override
            public StoreFileWriter createWriter() throws IOException {
                return StripeStoreFlusher.this.storeFileWriterFactory.createWriter(kvCount, false, true, true, false);
            }
        };
    }

    public static class SizeStripeFlushRequest
    extends StripeFlushRequest {
        private final int targetCount;
        private final long targetKvs;

        public SizeStripeFlushRequest(CellComparator comparator, int targetCount, long targetKvs) {
            super(comparator);
            this.targetCount = targetCount;
            this.targetKvs = targetKvs;
        }

        @Override
        public StripeMultiFileWriter createWriter() throws IOException {
            return new StripeMultiFileWriter.SizeMultiWriter(this.comparator, this.targetCount, this.targetKvs, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY);
        }
    }

    public static class BoundaryStripeFlushRequest
    extends StripeFlushRequest {
        private final List<byte[]> targetBoundaries;

        public BoundaryStripeFlushRequest(CellComparator comparator, List<byte[]> targetBoundaries) {
            super(comparator);
            this.targetBoundaries = targetBoundaries;
        }

        @Override
        public StripeMultiFileWriter createWriter() throws IOException {
            return new StripeMultiFileWriter.BoundaryMultiWriter(this.comparator, this.targetBoundaries, null, null);
        }
    }

    public static class StripeFlushRequest {
        protected final CellComparator comparator;

        public StripeFlushRequest(CellComparator comparator) {
            this.comparator = comparator;
        }

        @VisibleForTesting
        public StripeMultiFileWriter createWriter() throws IOException {
            StripeMultiFileWriter.SizeMultiWriter writer = new StripeMultiFileWriter.SizeMultiWriter(this.comparator, 1, Long.MAX_VALUE, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY);
            writer.setNoStripeMetadata();
            return writer;
        }
    }
}

