/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultCompactor
extends Compactor<StoreFileWriter> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompactor.class);
    private final Compactor.CellSinkFactory<StoreFileWriter> writerFactory = new Compactor.CellSinkFactory<StoreFileWriter>(){

        @Override
        public StoreFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind) throws IOException {
            return DefaultCompactor.this.createStoreFileWriter(fd, shouldDropBehind, fd.maxMVCCReadpoint > 0L, fd.maxTagsLength > 0);
        }
    };

    public DefaultCompactor(Configuration conf, HStore store) {
        this(conf, store, new DefaultStoreFileWriterFactory(store.getStoreContext(), conf), new DefaultStoreFileCommitter(store.getStoreContext()));
    }

    public DefaultCompactor(Configuration conf, HStore store, StoreFileWriterFactory storeFileWriterFactory, StoreFileCommitter storeFileCommitter) {
        super(conf, store, storeFileWriterFactory, storeFileCommitter);
    }

    public List<Path> compact(CompactionRequestImpl request, ThroughputController throughputController, User user) throws IOException {
        return this.compact(request, this.defaultScannerFactory, this.writerFactory, throughputController, user);
    }

    @Override
    protected List<Path> commitWriter(StoreFileWriter writer, Compactor.FileDetails fd, CompactionRequestImpl request) throws IOException {
        ArrayList newFiles = Lists.newArrayList((Object[])new Path[]{writer.getPath()});
        writer.appendMetadata(fd.maxSeqId, request.isAllFiles(), request.getFiles());
        writer.close();
        return newFiles;
    }

    @Override
    protected void abortWriter(StoreFileWriter writer) throws IOException {
        Path leftoverFile = writer.getPath();
        try {
            writer.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close the writer after an unfinished compaction.", (Throwable)e);
        }
        try {
            this.store.getFileSystem().delete(leftoverFile, false);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete the leftover file " + leftoverFile + " after an unfinished compaction.", (Throwable)e);
        }
    }
}

