/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.OutputSink;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LogRecoveredEditsOutputSink
extends OutputSink {
    private static final Logger LOG = LoggerFactory.getLogger(LogRecoveredEditsOutputSink.class);
    private WALSplitter walSplitter;
    private FileSystem walFS;
    private Configuration conf;

    public LogRecoveredEditsOutputSink(WALSplitter walSplitter, WALSplitter.PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
        super(controller, entryBuffers, numWriters);
        this.walSplitter = walSplitter;
        this.walFS = walSplitter.walFS;
        this.conf = walSplitter.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> finishWritingAndClose() throws IOException {
        boolean isSuccessful = false;
        List<Path> result = null;
        try {
            isSuccessful = this.finishWriting(false);
        }
        finally {
            result = this.close();
            List<IOException> thrown = this.closeLogWriters(null);
            if (CollectionUtils.isNotEmpty(thrown)) {
                throw MultipleIOException.createIOException(thrown);
            }
        }
        if (isSuccessful) {
            this.splits = result;
        }
        return this.splits;
    }

    private void deleteOneWithFewerEntries(WALSplitter.WriterAndPath wap, Path dst) throws IOException {
        String msg;
        String errorMsg;
        long dstMinLogSeqNum = -1L;
        try (WAL.Reader reader = this.walSplitter.getWalFactory().createReader(this.walSplitter.walFS, dst);){
            WAL.Entry entry = reader.next();
            if (entry != null) {
                dstMinLogSeqNum = entry.getKey().getSequenceId();
            }
        }
        catch (EOFException e) {
            LOG.debug("Got EOF when reading first WAL entry from {}, an empty or broken WAL file?", (Object)dst, (Object)e);
        }
        if (wap.minLogSeqNum < dstMinLogSeqNum) {
            errorMsg = "Found existing old edits file. It could be the result of a previous failed split attempt or we have duplicated wal entries. Deleting " + dst + ", length=" + this.walFS.getFileStatus(dst).getLen();
            LOG.warn(errorMsg);
            this.updateStatusWithMsg(errorMsg);
            if (!this.walFS.delete(dst, false)) {
                msg = "Failed deleting of old " + dst;
                LOG.warn(msg);
                this.updateStatusWithMsg(msg);
                throw new IOException("Failed deleting of old " + dst);
            }
        } else {
            errorMsg = "Found existing old edits file and we have less entries. Deleting " + wap.path + ", length=" + this.walFS.getFileStatus(wap.path).getLen();
            LOG.warn(errorMsg);
            this.updateStatusWithMsg(errorMsg);
            if (!this.walFS.delete(wap.path, false)) {
                msg = "Failed deleting of " + wap.path;
                LOG.warn(msg);
                this.updateStatusWithMsg(msg);
                throw new IOException(msg);
            }
        }
    }

    List<Path> close() throws IOException {
        boolean progress_failed;
        Preconditions.checkState((!this.closeAndCleanCompleted ? 1 : 0) != 0);
        ArrayList<Path> paths = new ArrayList<Path>();
        ArrayList thrown = Lists.newArrayList();
        ThreadPoolExecutor closeThreadPool = Threads.getBoundedCachedThreadPool((int)this.numThreads, (long)30L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "split-log-closeStream-" + this.count++);
                return t;
            }
        });
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(closeThreadPool);
        try {
            progress_failed = this.executeCloseTask(completionService, thrown, paths);
        }
        catch (InterruptedException e) {
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(e);
            throw iie;
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        finally {
            closeThreadPool.shutdownNow();
        }
        if (!thrown.isEmpty()) {
            throw MultipleIOException.createIOException((List)thrown);
        }
        this.writersClosed = true;
        this.closeAndCleanCompleted = true;
        if (progress_failed) {
            return null;
        }
        return paths;
    }

    boolean executeCloseTask(CompletionService<Void> completionService, final List<IOException> thrown, final List<Path> paths) throws InterruptedException, ExecutionException {
        for (final Map.Entry writersEntry : this.writers.entrySet()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting close of " + ((WALSplitter.WriterAndPath)writersEntry.getValue()).path);
            }
            completionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    WALSplitter.WriterAndPath wap = (WALSplitter.WriterAndPath)writersEntry.getValue();
                    Path dst = LogRecoveredEditsOutputSink.this.closeWriter((String)writersEntry.getKey(), wap, thrown);
                    paths.add(dst);
                    return null;
                }
            });
        }
        boolean progress_failed = false;
        int n = this.writers.size();
        for (int i = 0; i < n; ++i) {
            Future<Void> future = completionService.take();
            future.get();
            if (progress_failed || this.reporter == null || this.reporter.progress()) continue;
            progress_failed = true;
        }
        return progress_failed;
    }

    Path closeWriter(String encodedRegionName, WALSplitter.WriterAndPath wap, List<IOException> thrown) throws IOException {
        LOG.trace("Closing {}", (Object)wap.path);
        try {
            wap.writer.close();
        }
        catch (IOException ioe) {
            String errorMsg = "Could not close log at " + wap.path;
            LOG.error(errorMsg, (Throwable)ioe);
            this.updateStatusWithMsg(errorMsg);
            thrown.add(ioe);
            return null;
        }
        String updateLog = "Closed wap " + wap.path + " (wrote " + wap.editsWritten + " edits, skipped " + wap.editsSkipped + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms";
        if (LOG.isDebugEnabled()) {
            LOG.debug(updateLog);
        }
        this.updateStatusWithMsg(updateLog);
        if (wap.editsWritten == 0L) {
            if (this.walFS.exists(wap.path) && !this.walFS.delete(wap.path, false)) {
                String errorMsg = "Failed deleting empty " + wap.path;
                LOG.warn(errorMsg);
                this.updateStatusWithMsg(errorMsg);
                throw new IOException(errorMsg);
            }
            return null;
        }
        Path dst = WALSplitUtil.getCompletedRecoveredEditsFilePath(wap.path, (Long)this.regionMaximumEditLogSeqNum.get(encodedRegionName));
        try {
            if (!dst.equals((Object)wap.path) && this.walFS.exists(dst)) {
                this.deleteOneWithFewerEntries(wap, dst);
            }
            if (this.walFS.exists(wap.path)) {
                if (!this.walFS.rename(wap.path, dst)) {
                    String errorMsg = "Failed renaming " + wap.path + " to " + dst;
                    this.updateStatusWithMsg(errorMsg);
                    throw new IOException(errorMsg);
                }
                String msg = "Rename " + wap.path + " to " + dst;
                LOG.info(msg);
                this.updateStatusWithMsg(msg);
            }
        }
        catch (IOException ioe) {
            LOG.error("Could not rename {} to {}", new Object[]{wap.path, dst, ioe});
            thrown.add(ioe);
            return null;
        }
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IOException> closeLogWriters(List<IOException> thrown) throws IOException {
        WALSplitter.WriterAndPath wap;
        if (this.writersClosed) {
            return thrown;
        }
        if (thrown == null) {
            thrown = Lists.newArrayList();
        }
        try {
            for (OutputSink.WriterThread writerThread : this.writerThreads) {
                while (writerThread.isAlive()) {
                    writerThread.setShouldStop(true);
                    writerThread.interrupt();
                    try {
                        writerThread.join(10L);
                    }
                    catch (InterruptedException e) {
                        InterruptedIOException iie = new InterruptedIOException();
                        iie.initCause(e);
                        throw iie;
                    }
                }
            }
            wap = null;
        }
        catch (Throwable throwable) {
            WALSplitter.WriterAndPath wap2 = null;
            for (WALSplitter.SinkWriter tmpWAP : this.writers.values()) {
                try {
                    wap2 = (WALSplitter.WriterAndPath)tmpWAP;
                    wap2.writer.close();
                }
                catch (IOException ioe) {
                    String errorMsg = "Couldn't close log at " + wap2.path;
                    LOG.error(errorMsg, (Throwable)ioe);
                    this.updateStatusWithMsg(errorMsg);
                    thrown.add(ioe);
                    continue;
                }
                String msg = "Closed log " + wap2.path + " (wrote " + wap2.editsWritten + " edits in " + wap2.nanosSpent / 1000L / 1000L + "ms)";
                LOG.info(msg);
                this.updateStatusWithMsg(msg);
            }
            this.writersClosed = true;
            throw throwable;
        }
        for (WALSplitter.SinkWriter tmpWAP : this.writers.values()) {
            try {
                wap = (WALSplitter.WriterAndPath)tmpWAP;
                wap.writer.close();
            }
            catch (IOException ioe) {
                String errorMsg = "Couldn't close log at " + wap.path;
                LOG.error(errorMsg, (Throwable)ioe);
                this.updateStatusWithMsg(errorMsg);
                thrown.add(ioe);
                continue;
            }
            String msg = "Closed log " + wap.path + " (wrote " + wap.editsWritten + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms)";
            LOG.info(msg);
            this.updateStatusWithMsg(msg);
        }
        this.writersClosed = true;
        return thrown;
    }

    WALSplitter.WriterAndPath getWriterAndPath(WAL.Entry entry, boolean reusable) throws IOException {
        byte[] region = entry.getKey().getEncodedRegionName();
        String regionName = Bytes.toString((byte[])region);
        WALSplitter.WriterAndPath ret = (WALSplitter.WriterAndPath)this.writers.get(regionName);
        if (ret != null) {
            return ret;
        }
        if (this.blacklistedRegions.contains(region)) {
            return null;
        }
        ret = this.createWAP(region, entry);
        if (ret == null) {
            this.blacklistedRegions.add(region);
            return null;
        }
        if (reusable) {
            this.writers.put(regionName, ret);
        }
        return ret;
    }

    WALSplitter.WriterAndPath createWAP(byte[] region, WAL.Entry entry) throws IOException {
        String tmpDirName = this.walSplitter.conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
        Path regionedits = WALSplitUtil.getRegionSplitEditsPath(entry, this.walSplitter.getFileBeingSplit().getPath().getName(), tmpDirName, this.conf);
        if (regionedits == null) {
            return null;
        }
        FileSystem walFs = FSUtils.getWALFileSystem((Configuration)this.conf);
        if (walFs.exists(regionedits)) {
            String errorMsg = "Found old edits file. It could be the result of a previous failed split attempt. Deleting " + regionedits + ", length=" + walFs.getFileStatus(regionedits).getLen();
            LOG.warn(errorMsg);
            this.updateStatusWithMsg(errorMsg);
            if (!walFs.delete(regionedits, false)) {
                String failureMsg = "Failed delete of old " + regionedits;
                LOG.warn(failureMsg);
                this.updateStatusWithMsg(failureMsg);
            }
        }
        WALProvider.Writer w = this.walSplitter.createWriter(regionedits);
        String msg = "Creating writer path=" + regionedits;
        LOG.debug(msg);
        this.updateStatusWithMsg(msg);
        return new WALSplitter.WriterAndPath(regionedits, w, entry.getKey().getSequenceId());
    }

    void filterCellByStore(WAL.Entry logEntry) {
        Map<byte[], Long> maxSeqIdInStores = this.walSplitter.getRegionMaxSeqIdInStores().get(Bytes.toString((byte[])logEntry.getKey().getEncodedRegionName()));
        if (MapUtils.isEmpty(maxSeqIdInStores)) {
            return;
        }
        ArrayList<Cell> keptCells = new ArrayList<Cell>(logEntry.getEdit().getCells().size());
        for (Cell cell : logEntry.getEdit().getCells()) {
            if (WALEdit.isMetaEditFamily(cell)) {
                keptCells.add(cell);
                continue;
            }
            byte[] family = CellUtil.cloneFamily((Cell)cell);
            Long maxSeqId = maxSeqIdInStores.get(family);
            if (maxSeqId != null && maxSeqId >= logEntry.getKey().getSequenceId()) continue;
            keptCells.add(cell);
        }
        logEntry.getEdit().setCells(keptCells);
    }

    @Override
    public void append(WALSplitter.RegionEntryBuffer buffer) throws IOException {
        this.appendBuffer(buffer, true);
    }

    WALSplitter.WriterAndPath appendBuffer(WALSplitter.RegionEntryBuffer buffer, boolean reusable) throws IOException {
        List<WAL.Entry> entries = buffer.entryBuffer;
        if (entries.isEmpty()) {
            LOG.warn("got an empty buffer, skipping");
            return null;
        }
        WALSplitter.SinkWriter wap = null;
        long startTime = System.nanoTime();
        int editsCount = 0;
        for (WAL.Entry logEntry : entries) {
            try {
                if (wap == null && (wap = this.getWriterAndPath(logEntry, reusable)) == null) {
                    LOG.trace("getWriterAndPath decided we don't need to write edits for {}", (Object)logEntry);
                    return null;
                }
                this.filterCellByStore(logEntry);
                if (!logEntry.getEdit().isEmpty()) {
                    ((WALSplitter.WriterAndPath)wap).writer.append(logEntry);
                    this.updateRegionMaximumEditLogSeqNum(logEntry);
                    ++editsCount;
                    continue;
                }
                wap.incrementSkippedEdits(1);
            }
            catch (IOException e) {
                return this.logAndThrowWriterAppendFailure(logEntry, e);
            }
        }
        wap.incrementEdits(editsCount);
        wap.incrementNanoTime(System.nanoTime() - startTime);
        return wap;
    }

    private WALSplitter.WriterAndPath logAndThrowWriterAppendFailure(WAL.Entry logEntry, IOException e) throws IOException {
        e = e instanceof RemoteException ? ((RemoteException)((Object)e)).unwrapRemoteException() : e;
        String errorMsg = "Failed to write log entry " + logEntry.toString() + " to log";
        LOG.error(HBaseMarkers.FATAL, errorMsg, (Throwable)e);
        this.updateStatusWithMsg(errorMsg);
        throw e;
    }

    @Override
    public boolean keepRegionEvent(WAL.Entry entry) {
        ArrayList<Cell> cells = entry.getEdit().getCells();
        for (Cell cell : cells) {
            if (!WALEdit.isCompactionMarker(cell)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<byte[], Long> getOutputCounts() {
        TreeMap<byte[], Long> ret = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry entry : this.writers.entrySet()) {
            ret.put(Bytes.toBytes((String)((String)entry.getKey())), ((WALSplitter.SinkWriter)entry.getValue()).editsWritten);
        }
        return ret;
    }

    @Override
    public int getNumberOfRecoveredRegions() {
        return this.writers.size();
    }
}

