/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.JMXListener;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MetaTableMetrics;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={CoprocessorTests.class, LargeTests.class})
public class TestMetaTableMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaTableMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaTableMetrics.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName NAME1 = TableName.valueOf((String)"TestExampleMetaTableMetricsOne");
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final ColumnFamilyDescriptor CFD = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build();
    private static final int NUM_ROWS = 5;
    private static final String value = "foo";
    private static final String METRICS_ATTRIBUTE_NAME_PREFIX = "MetaTable_";
    private static final List<String> METRICS_ATTRIBUTE_NAME_POSTFIXES = Arrays.asList("_count", "_mean_rate", "_1min_rate", "_5min_rate", "_15min_rate");
    private static int connectorPort = 61120;
    private final byte[] cf = Bytes.toBytes((String)"info");
    private final byte[] col = Bytes.toBytes((String)"any");
    private byte[] tablename;
    private final int nthreads = 20;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        UTIL.getConfiguration().set("hbase.coprocessor.region.classes", MetaTableMetrics.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", JMXListener.class.getName());
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int sign;
            while (!HBaseTestingUtility.available(connectorPort += (sign = i % 2 == 0 ? 1 : -1) * rand.nextInt(100))) {
            }
            try {
                conf.setInt("regionserver.rmi.registry.port", connectorPort);
                UTIL.startMiniCluster(1);
                break;
            }
            catch (Exception e) {
                LOG.debug("Encountered exception when starting cluster. Trying port {}", (Object)connectorPort, (Object)e);
                try {
                    UTIL.shutdownMiniCluster();
                }
                catch (Exception ex) {
                    LOG.debug("Encountered exception shutting down cluster", (Throwable)ex);
                }
                continue;
            }
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaTableMetricsInJmx() throws Exception {
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME1).setColumnFamily(CFD).build());
        this.writeData(NAME1);
        UTIL.deleteTable(NAME1);
        UTIL.waitFor(30000L, 2000L, true, () -> {
            Map<String, Double> jmxMetrics = this.readMetaTableJmxMetrics();
            boolean allMetricsFound = AllOf.allOf((Matcher[])new Matcher[]{this.containsPositiveJmxAttributesFor("MetaTable_get_request"), this.containsPositiveJmxAttributesFor("MetaTable_put_request"), this.containsPositiveJmxAttributesFor("MetaTable_delete_request"), this.containsPositiveJmxAttributesFor("MetaTable_region_.+_lossy_request"), this.containsPositiveJmxAttributesFor("MetaTable_table_" + NAME1 + "_request"), this.containsPositiveJmxAttributesFor("MetaTable_client_.+_put_request"), this.containsPositiveJmxAttributesFor("MetaTable_client_.+_get_request"), this.containsPositiveJmxAttributesFor("MetaTable_client_.+_delete_request"), this.containsPositiveJmxAttributesFor("MetaTable_client_.+_lossy_request")}).matches(jmxMetrics);
            if (allMetricsFound) {
                LOG.info("all the meta table metrics found with positive values: {}", jmxMetrics);
            } else {
                LOG.warn("couldn't find all the meta table metrics with positive values: {}", jmxMetrics);
            }
            return allMetricsFound;
        });
    }

    @Test
    public void testConcurrentAccess() {
        try {
            this.tablename = Bytes.toBytes((String)"hbase:meta");
            int numRows = 3000;
            int numRowsInTableBefore = UTIL.countRows(TableName.valueOf((byte[])this.tablename));
            this.putData(numRows);
            Thread.sleep(2000L);
            int numRowsInTableAfter = UTIL.countRows(TableName.valueOf((byte[])this.tablename));
            Assert.assertTrue((numRowsInTableAfter >= numRowsInTableBefore + numRows ? 1 : 0) != 0);
            this.getData(numRows);
        }
        catch (InterruptedException e) {
            LOG.info("Caught InterruptedException while testConcurrentAccess: {}", (Object)e.getMessage());
            Assert.fail();
        }
        catch (IOException e) {
            LOG.info("Caught IOException while testConcurrentAccess: {}", (Object)e.getMessage());
            Assert.fail();
        }
    }

    private void writeData(TableName tableName) throws IOException {
        try (Table t = UTIL.getConnection().getTable(tableName);){
            ArrayList<Put> puts = new ArrayList<Put>(5);
            for (int i = 0; i < 5; ++i) {
                Put p = new Put(Bytes.toBytes((int)(i + 1)));
                p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)value));
                puts.add(p);
            }
            t.put(puts);
        }
    }

    private Matcher<Map<String, Double>> containsPositiveJmxAttributesFor(final String regexp) {
        return new CustomTypeSafeMatcher<Map<String, Double>>("failed to find all the 5 positive JMX attributes for: " + regexp){

            protected boolean matchesSafely(Map<String, Double> values) {
                for (String key : values.keySet()) {
                    for (String metricsNamePostfix : METRICS_ATTRIBUTE_NAME_POSTFIXES) {
                        if (!key.matches(regexp + metricsNamePostfix) || !(values.get(key) > 0.0)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Double> readMetaTableJmxMetrics() throws IOException {
        JMXConnector connector = null;
        ObjectName target = null;
        MBeanServerConnection mb = null;
        try {
            connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)connectorPort, (int)connectorPort));
            mb = connector.getMBeanServerConnection();
            Hashtable<String, String> pairs = new Hashtable<String, String>();
            pairs.put("service", "HBase");
            pairs.put("name", "RegionServer");
            pairs.put("sub", "Coprocessor.Region.CP_org.apache.hadoop.hbase.coprocessor.MetaTableMetrics");
            target = new ObjectName("Hadoop", pairs);
            MBeanInfo beanInfo = mb.getMBeanInfo(target);
            HashMap<String, Double> existingAttrs = new HashMap<String, Double>();
            for (MBeanAttributeInfo attrInfo : beanInfo.getAttributes()) {
                Object value = mb.getAttribute(target, attrInfo.getName());
                if (!attrInfo.getName().startsWith(METRICS_ATTRIBUTE_NAME_PREFIX) || !(value instanceof Number)) continue;
                existingAttrs.put(attrInfo.getName(), Double.parseDouble(value.toString()));
            }
            LOG.info("MBean Found: {}", (Object)target);
            HashMap<String, Double> hashMap = existingAttrs;
            return hashMap;
        }
        catch (Exception e) {
            LOG.warn("Failed to get Meta Table Metrics bean (will retry later): {}", target, (Object)e);
            if (mb != null) {
                Set<ObjectInstance> instances = mb.queryMBeans(null, null);
                Iterator<ObjectInstance> iterator = instances.iterator();
                LOG.debug("All the MBeans we found:");
                while (iterator.hasNext()) {
                    ObjectInstance objectInstance = iterator.next();
                    LOG.debug("Class and object name: {} [{}]", (Object)objectInstance.getClassName(), (Object)objectInstance.getObjectName());
                }
            }
        }
        finally {
            if (connector != null) {
                try {
                    connector.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Collections.emptyMap();
    }

    private void putData(int nrows) throws InterruptedException {
        LOG.info("Putting {} rows in hbase:meta", (Object)nrows);
        Thread[] threads = new Thread[20];
        for (int i = 1; i <= 20; ++i) {
            threads[i - 1] = new PutThread(1, nrows);
        }
        this.startThreadsAndWaitToJoin(threads);
    }

    private void getData(int nrows) throws InterruptedException {
        LOG.info("Getting {} rows from hbase:meta", (Object)nrows);
        Thread[] threads = new Thread[20];
        for (int i = 1; i <= 20; ++i) {
            threads[i - 1] = new GetThread(1, nrows);
        }
        this.startThreadsAndWaitToJoin(threads);
    }

    private void startThreadsAndWaitToJoin(Thread[] threads) throws InterruptedException {
        int i;
        for (i = 1; i <= 20; ++i) {
            threads[i - 1].start();
        }
        for (i = 1; i <= 20; ++i) {
            threads[i - 1].join();
        }
    }

    private class GetThread
    extends Thread {
        int start;
        int end;

        GetThread(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void run() {
            try (Table table = UTIL.getConnection().getTable(TableName.valueOf((byte[])TestMetaTableMetrics.this.tablename));){
                for (int i = this.start; i <= this.end; ++i) {
                    Get get = new Get(Bytes.toBytes((String)String.format("tableName,rowKey%d,region%d", i, i)));
                    table.get(get);
                }
            }
            catch (IOException e) {
                LOG.warn("Caught IOException while GetThread operation", (Throwable)e);
            }
        }
    }

    private class PutThread
    extends Thread {
        int start;
        int end;

        PutThread(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void run() {
            try (Table table = UTIL.getConnection().getTable(TableName.valueOf((byte[])TestMetaTableMetrics.this.tablename));){
                for (int i = this.start; i <= this.end; ++i) {
                    Put p = new Put(Bytes.toBytes((String)String.format("tableName,rowKey%d,region%d", i, i)));
                    p.addColumn(TestMetaTableMetrics.this.cf, TestMetaTableMetrics.this.col, Bytes.toBytes((String)("Value" + i)));
                    table.put(p);
                }
            }
            catch (IOException e) {
                LOG.warn("Caught IOException while PutThread operation", (Throwable)e);
            }
        }
    }
}

