/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.ExclusiveMemHFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruCachedBlock;
import org.apache.hadoop.hbase.io.hfile.SharedMemHFileBlock;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellArrayImmutableSegment;
import org.apache.hadoop.hbase.regionserver.CellArrayMap;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.CompactionPipeline;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactor;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.throttle.StoreHotnessProtector;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ClassSize;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestHeapSize {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHeapSize.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHeapSize.class);

    @BeforeClass
    public static void beforeClass() throws Exception {
        RuntimeMXBean b = ManagementFactory.getRuntimeMXBean();
        LOG.info("name=" + b.getName());
        LOG.info("specname=" + b.getSpecName());
        LOG.info("specvendor=" + b.getSpecVendor());
        LOG.info("vmname=" + b.getVmName());
        LOG.info("vmversion=" + b.getVmVersion());
        LOG.info("vmvendor=" + b.getVmVendor());
        Map<String, String> p = b.getSystemProperties();
        LOG.info("properties=" + p);
    }

    @Test
    public void testNativeSizes() throws IOException {
        long actual;
        Class cl = ArrayList.class;
        long expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != (actual = (long)ClassSize.ARRAYLIST)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ByteBuffer.class, (boolean)false)) != (actual = (long)ClassSize.BYTE_BUFFER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = Integer.class, (boolean)false)) != (actual = (long)ClassSize.INTEGER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = Object.class, (boolean)false)) != (actual = (long)ClassSize.align((int)ClassSize.OBJECT))) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = TreeMap.class, (boolean)false)) != (actual = (long)ClassSize.TREEMAP)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = String.class, (boolean)false)) != (actual = (long)ClassSize.STRING)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ConcurrentHashMap.class, (boolean)false)) != (actual = (long)ClassSize.CONCURRENT_HASHMAP)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ConcurrentSkipListMap.class, (boolean)false)) != (actual = (long)ClassSize.CONCURRENT_SKIPLISTMAP)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = CellArrayMap.class, (boolean)false)) != (actual = (long)ClassSize.CELL_ARRAY_MAP)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = ReentrantReadWriteLock.class, (boolean)false)) != (actual = (long)ClassSize.REENTRANT_LOCK)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicLong.class, (boolean)false)) != (actual = (long)ClassSize.ATOMIC_LONG)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicInteger.class, (boolean)false)) != (actual = (long)ClassSize.ATOMIC_INTEGER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = AtomicBoolean.class, (boolean)false)) != (actual = (long)ClassSize.ATOMIC_BOOLEAN)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = CopyOnWriteArraySet.class, (boolean)false)) != (actual = (long)ClassSize.COPYONWRITE_ARRAYSET)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = CopyOnWriteArrayList.class, (boolean)false)) != (actual = (long)ClassSize.COPYONWRITE_ARRAYLIST)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = TimeRangeTracker.SyncTimeRangeTracker.class, (boolean)false)) != (actual = (long)ClassSize.SYNC_TIMERANGE_TRACKER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = TimeRangeTracker.NonSyncTimeRangeTracker.class, (boolean)false)) != (actual = (long)ClassSize.NON_SYNC_TIMERANGE_TRACKER)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        if ((expected = ClassSize.estimateBase(cl = CellSet.class, (boolean)false)) != (actual = (long)ClassSize.CELL_SET)) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    public void testSizes() throws IOException {
        KeyValue kv;
        long actual;
        Class<KeyValue> cl = KeyValue.class;
        long expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != (actual = (kv = new KeyValue()).heapSize())) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = LruBlockCache.class;
        actual = LruBlockCache.CACHE_FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = LruCachedBlock.class;
        actual = LruCachedBlock.PER_BLOCK_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += ClassSize.estimateBase(String.class, (boolean)false);
        if ((expected += ClassSize.estimateBase(ByteBuffer.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(String.class, (boolean)true);
            ClassSize.estimateBase(ByteBuffer.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = DefaultMemStore.class;
        actual = DefaultMemStore.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        actual = DefaultMemStore.DEEP_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = CompactingMemStore.class;
        actual = CompactingMemStore.DEEP_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += ClassSize.estimateBase(AtomicBoolean.class, (boolean)false);
        expected += ClassSize.estimateBase(AtomicBoolean.class, (boolean)false);
        expected += ClassSize.estimateBase(CompactionPipeline.class, (boolean)false);
        expected += ClassSize.estimateBase(LinkedList.class, (boolean)false);
        expected += ClassSize.estimateBase(LinkedList.class, (boolean)false);
        expected += ClassSize.estimateBase(MemStoreCompactor.class, (boolean)false);
        if ((expected += ClassSize.estimateBase(AtomicBoolean.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(AtomicBoolean.class, (boolean)true);
            ClassSize.estimateBase(AtomicBoolean.class, (boolean)true);
            ClassSize.estimateBase(CompactionPipeline.class, (boolean)true);
            ClassSize.estimateBase(LinkedList.class, (boolean)true);
            ClassSize.estimateBase(LinkedList.class, (boolean)true);
            ClassSize.estimateBase(MemStoreCompactor.class, (boolean)true);
            ClassSize.estimateBase(AtomicBoolean.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = Segment.class;
        actual = Segment.DEEP_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += 2L * ClassSize.estimateBase(AtomicLong.class, (boolean)false);
        expected += ClassSize.estimateBase(AtomicReference.class, (boolean)false);
        expected += ClassSize.estimateBase(CellSet.class, (boolean)false);
        if ((expected += ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicReference.class, (boolean)true);
            ClassSize.estimateBase(CellSet.class, (boolean)true);
            ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = MutableSegment.class;
        actual = MutableSegment.DEEP_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += 2L * ClassSize.estimateBase(AtomicLong.class, (boolean)false);
        expected += ClassSize.estimateBase(AtomicReference.class, (boolean)false);
        expected += ClassSize.estimateBase(CellSet.class, (boolean)false);
        expected += ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)false);
        expected += ClassSize.estimateBase(TimeRangeTracker.SyncTimeRangeTracker.class, (boolean)false);
        expected += ClassSize.estimateBase(ConcurrentSkipListMap.class, (boolean)false);
        if ((expected += ClassSize.estimateBase(AtomicBoolean.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicReference.class, (boolean)true);
            ClassSize.estimateBase(CellSet.class, (boolean)true);
            ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)true);
            ClassSize.estimateBase(TimeRangeTracker.SyncTimeRangeTracker.class, (boolean)true);
            ClassSize.estimateBase(ConcurrentSkipListMap.class, (boolean)true);
            ClassSize.estimateBase(AtomicBoolean.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = ImmutableSegment.class;
        actual = ImmutableSegment.DEEP_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += 2L * ClassSize.estimateBase(AtomicLong.class, (boolean)false);
        expected += ClassSize.estimateBase(AtomicReference.class, (boolean)false);
        expected += ClassSize.estimateBase(CellSet.class, (boolean)false);
        expected += ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)false);
        if ((expected += ClassSize.estimateBase(TimeRangeTracker.NonSyncTimeRangeTracker.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicReference.class, (boolean)true);
            ClassSize.estimateBase(CellSet.class, (boolean)true);
            ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)true);
            ClassSize.estimateBase(TimeRangeTracker.NonSyncTimeRangeTracker.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = CSLMImmutableSegment.class;
        actual = CSLMImmutableSegment.DEEP_OVERHEAD_CSLM;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += 2L * ClassSize.estimateBase(AtomicLong.class, (boolean)false);
        expected += ClassSize.estimateBase(AtomicReference.class, (boolean)false);
        expected += ClassSize.estimateBase(CellSet.class, (boolean)false);
        expected += ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)false);
        expected += ClassSize.estimateBase(TimeRangeTracker.NonSyncTimeRangeTracker.class, (boolean)false);
        if ((expected += ClassSize.estimateBase(ConcurrentSkipListMap.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicReference.class, (boolean)true);
            ClassSize.estimateBase(CellSet.class, (boolean)true);
            ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)true);
            ClassSize.estimateBase(TimeRangeTracker.NonSyncTimeRangeTracker.class, (boolean)true);
            ClassSize.estimateBase(ConcurrentSkipListMap.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = CellArrayImmutableSegment.class;
        actual = CellArrayImmutableSegment.DEEP_OVERHEAD_CAM;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += 2L * ClassSize.estimateBase(AtomicLong.class, (boolean)false);
        expected += ClassSize.estimateBase(AtomicReference.class, (boolean)false);
        expected += ClassSize.estimateBase(CellSet.class, (boolean)false);
        expected += ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)false);
        expected += ClassSize.estimateBase(TimeRangeTracker.NonSyncTimeRangeTracker.class, (boolean)false);
        if ((expected += ClassSize.estimateBase(CellArrayMap.class, (boolean)false)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicLong.class, (boolean)true);
            ClassSize.estimateBase(AtomicReference.class, (boolean)true);
            ClassSize.estimateBase(CellSet.class, (boolean)true);
            ClassSize.estimateBase(ReentrantReadWriteLock.class, (boolean)true);
            ClassSize.estimateBase(TimeRangeTracker.NonSyncTimeRangeTracker.class, (boolean)true);
            ClassSize.estimateBase(CellArrayMap.class, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = HStore.class;
        actual = HStore.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = HRegion.class;
        actual = HRegion.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = StoreHotnessProtector.class;
        actual = StoreHotnessProtector.FIXED_SIZE;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = BlockCacheKey.class;
        actual = BlockCacheKey.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    public void testHFileBlockSize() throws IOException {
        long actual = HFileContext.FIXED_OVERHEAD;
        long expected = ClassSize.estimateBase(HFileContext.class, (boolean)false);
        Assert.assertEquals((long)expected, (long)actual);
        actual = HFileBlock.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(HFileBlock.class, (boolean)false);
        Assert.assertEquals((long)expected, (long)actual);
        actual = ExclusiveMemHFileBlock.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(ExclusiveMemHFileBlock.class, (boolean)false);
        Assert.assertEquals((long)expected, (long)actual);
        actual = SharedMemHFileBlock.FIXED_OVERHEAD;
        expected = ClassSize.estimateBase(SharedMemHFileBlock.class, (boolean)false);
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testMutations() {
        Class<TimeRange> cl = TimeRange.class;
        long actual = ClassSize.TIMERANGE;
        long expected = ClassSize.estimateBase(cl, (boolean)false);
        if (expected != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        byte[] row = new byte[]{0};
        cl = Put.class;
        actual = Mutation.MUTATION_OVERHEAD + (long)ClassSize.align((int)ClassSize.ARRAY);
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += (long)ClassSize.align((int)ClassSize.TREEMAP);
        if ((expected += (long)ClassSize.align((int)ClassSize.INTEGER)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
        cl = Delete.class;
        actual = Mutation.MUTATION_OVERHEAD + (long)ClassSize.align((int)ClassSize.ARRAY);
        expected = ClassSize.estimateBase(cl, (boolean)false);
        expected += (long)ClassSize.align((int)ClassSize.TREEMAP);
        if ((expected += (long)ClassSize.align((int)ClassSize.INTEGER)) != actual) {
            ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    public void testReferenceSize() {
        LOG.info("ClassSize.REFERENCE is " + ClassSize.REFERENCE);
        Assert.assertTrue((ClassSize.REFERENCE == 4 || ClassSize.REFERENCE == 8 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectSize() throws IOException {
        LOG.info("header:" + ClassSize.OBJECT);
        LOG.info("array header:" + ClassSize.ARRAY);
        if (ClassSize.is32BitJVM()) {
            Assert.assertEquals((long)ClassSize.OBJECT, (long)8L);
        } else {
            Assert.assertTrue((ClassSize.OBJECT == 12 || ClassSize.OBJECT == 16 ? 1 : 0) != 0);
        }
        if (ClassSize.useUnsafeLayout()) {
            Assert.assertEquals((long)ClassSize.ARRAY, (long)(ClassSize.OBJECT + 4));
        } else {
            Assert.assertEquals((long)ClassSize.ARRAY, (long)(ClassSize.OBJECT + 8));
        }
    }
}

