/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.time.Instant;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.SimpleRegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSimpleRegionNormalizer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSimpleRegionNormalizer.class);
    private Configuration conf;
    private SimpleRegionNormalizer normalizer;
    private MasterServices masterServices;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @Before
    public void before() {
        this.conf = HBaseConfiguration.create();
    }

    @Test
    public void testNoNormalizationForMetaTable() {
        TableName testTable = TableName.META_TABLE_NAME;
        ArrayList<RegionInfo> RegionInfo2 = new ArrayList<RegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        this.setupMocksForNormalizer(regionSizes, RegionInfo2);
        List plans = this.normalizer.computePlansForTable(testTable);
        MatcherAssert.assertThat((Object)plans, (Matcher)Matchers.empty());
    }

    @Test
    public void testNoNormalizationIfTooFewRegions() {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 2);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 10, 15);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = this.normalizer.computePlansForTable(tableName);
        MatcherAssert.assertThat((Object)plans, (Matcher)Matchers.empty());
    }

    @Test
    public void testNoNormalizationOnNormalizedCluster() {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 4);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 10, 15, 8, 10);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = this.normalizer.computePlansForTable(tableName);
        MatcherAssert.assertThat((Object)plans, (Matcher)Matchers.empty());
    }

    private void noNormalizationOnTransitioningRegions(RegionState.State state) {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 3);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 10, 1, 100);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Mockito.when((Object)this.masterServices.getAssignmentManager().getRegionStates().getRegionState((RegionInfo)ArgumentMatchers.any(RegionInfo.class))).thenReturn((Object)RegionState.createForTesting(null, (RegionState.State)state));
        MatcherAssert.assertThat((Object)this.normalizer.getMinRegionCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(regionInfos.size())));
        List plans = this.normalizer.computePlansForTable(tableName);
        MatcherAssert.assertThat((String)String.format("Unexpected plans for RegionState %s", state), (Object)plans, (Matcher)Matchers.empty());
    }

    @Test
    public void testNoNormalizationOnMergingNewRegions() {
        this.noNormalizationOnTransitioningRegions(RegionState.State.MERGING_NEW);
    }

    @Test
    public void testNoNormalizationOnMergingRegions() {
        this.noNormalizationOnTransitioningRegions(RegionState.State.MERGING);
    }

    @Test
    public void testNoNormalizationOnMergedRegions() {
        this.noNormalizationOnTransitioningRegions(RegionState.State.MERGED);
    }

    @Test
    public void testNoNormalizationOnSplittingNewRegions() {
        this.noNormalizationOnTransitioningRegions(RegionState.State.SPLITTING_NEW);
    }

    @Test
    public void testNoNormalizationOnSplittingRegions() {
        this.noNormalizationOnTransitioningRegions(RegionState.State.SPLITTING);
    }

    @Test
    public void testNoNormalizationOnSplitRegions() {
        this.noNormalizationOnTransitioningRegions(RegionState.State.SPLIT);
    }

    @Test
    public void testMergeOfSmallRegions() {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 15, 5, 5, 15, 16);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new MergeNormalizationPlan(regionInfos.get(1), regionInfos.get(2))}));
    }

    @Test
    public void testMergeOfSecondSmallestRegions() {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 6);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 1, 10000, 10000, 10000, 2700, 2700);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new MergeNormalizationPlan(regionInfos.get(4), regionInfos.get(5))}));
    }

    @Test
    public void testMergeOfSmallNonAdjacentRegions() {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 15, 5, 16, 15, 5);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = this.normalizer.computePlansForTable(tableName);
        MatcherAssert.assertThat((Object)plans, (Matcher)Matchers.empty());
    }

    @Test
    public void testSplitOfLargeRegion() {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 4);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 8, 6, 10, 30);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new SplitNormalizationPlan(regionInfos.get(3))}));
    }

    @Test
    public void testSplitWithTargetRegionSize() throws Exception {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 6);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 20, 40, 60, 80, 100, 120);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Mockito.when((Object)this.masterServices.getTableDescriptors().get((TableName)ArgumentMatchers.any()).getNormalizerTargetRegionSize()).thenReturn((Object)20L);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new SplitNormalizationPlan(regionInfos.get(2)), new SplitNormalizationPlan(regionInfos.get(3)), new SplitNormalizationPlan(regionInfos.get(4)), new SplitNormalizationPlan(regionInfos.get(5))}));
        Mockito.when((Object)this.masterServices.getTableDescriptors().get((TableName)ArgumentMatchers.any()).getNormalizerTargetRegionSize()).thenReturn((Object)200L);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new MergeNormalizationPlan(regionInfos.get(0), regionInfos.get(1)), new MergeNormalizationPlan(regionInfos.get(2), regionInfos.get(3))}));
    }

    @Test
    public void testSplitWithTargetRegionCount() throws Exception {
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 4);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 20, 40, 60, 80);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Mockito.when((Object)this.masterServices.getTableDescriptors().get((TableName)ArgumentMatchers.any()).getNormalizerTargetRegionCount()).thenReturn((Object)8);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new SplitNormalizationPlan(regionInfos.get(2)), new SplitNormalizationPlan(regionInfos.get(3))}));
        Mockito.when((Object)this.masterServices.getTableDescriptors().get((TableName)ArgumentMatchers.any()).getNormalizerTargetRegionCount()).thenReturn((Object)3);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new MergeNormalizationPlan(regionInfos.get(0), regionInfos.get(1))}));
    }

    @Test
    public void testHonorsSplitEnabled() {
        this.conf.setBoolean("hbase.normalizer.split.enabled", true);
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 5, 5, 20, 5, 5);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(SplitNormalizationPlan.class)));
        this.conf.setBoolean("hbase.normalizer.split.enabled", false);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.empty());
    }

    @Test
    public void testHonorsMergeEnabled() {
        this.conf.setBoolean("hbase.normalizer.merge.enabled", true);
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 20, 5, 5, 20, 20);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(MergeNormalizationPlan.class)));
        this.conf.setBoolean("hbase.normalizer.merge.enabled", false);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.empty());
    }

    @Test
    public void testHonorsMinimumRegionCount() {
        this.conf.setInt("hbase.normalizer.min.region.count", 1);
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 3);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 1, 1, 10);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = this.normalizer.computePlansForTable(tableName);
        MatcherAssert.assertThat((Object)plans, (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new SplitNormalizationPlan(regionInfos.get(2)), new MergeNormalizationPlan(regionInfos.get(0), regionInfos.get(1))}));
        this.conf.setInt("hbase.normalizer.min.region.count", 4);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new SplitNormalizationPlan(regionInfos.get(2))}));
    }

    @Test
    public void testHonorsMergeMinRegionAge() {
        this.conf.setInt("hbase.normalizer.merge.min_region_age.days", 7);
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 4);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 1, 1, 10, 10);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertEquals((Object)Period.ofDays(7), (Object)this.normalizer.getMergeMinRegionAge());
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.everyItem((Matcher)Matchers.not((Matcher)Matchers.instanceOf(MergeNormalizationPlan.class))));
        this.conf.unset("hbase.normalizer.merge.min_region_age.days");
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertEquals((Object)Period.ofDays(3), (Object)this.normalizer.getMergeMinRegionAge());
        List plans = this.normalizer.computePlansForTable(tableName);
        MatcherAssert.assertThat((Object)plans, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)plans, (Matcher)Matchers.everyItem((Matcher)Matchers.instanceOf(MergeNormalizationPlan.class)));
    }

    @Test
    public void testHonorsMergeMinRegionSize() {
        this.conf.setBoolean("hbase.normalizer.split.enabled", false);
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 1, 2, 0, 10, 10);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertFalse((boolean)this.normalizer.isSplitEnabled());
        Assert.assertEquals((long)1L, (long)this.normalizer.getMergeMinRegionSizeMb());
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new MergeNormalizationPlan(regionInfos.get(0), regionInfos.get(1))}));
        this.conf.setInt("hbase.normalizer.merge.min_region_size.mb", 3);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertEquals((long)3L, (long)this.normalizer.getMergeMinRegionSizeMb());
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.empty());
    }

    @Test
    public void testMergeEmptyRegions() {
        this.conf.setBoolean("hbase.normalizer.split.enabled", false);
        this.conf.setInt("hbase.normalizer.merge.min_region_size.mb", 0);
        TableName tableName = this.name.getTableName();
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 7);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 0, 1, 10, 0, 9, 10, 0);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertFalse((boolean)this.normalizer.isSplitEnabled());
        Assert.assertEquals((long)0L, (long)this.normalizer.getMergeMinRegionSizeMb());
        MatcherAssert.assertThat((Object)this.normalizer.computePlansForTable(tableName), (Matcher)Matchers.contains((Object[])new NormalizationPlan[]{new MergeNormalizationPlan(regionInfos.get(0), regionInfos.get(1)), new MergeNormalizationPlan(regionInfos.get(2), regionInfos.get(3)), new MergeNormalizationPlan(regionInfos.get(5), regionInfos.get(6))}));
    }

    @Test
    public void testNormalizerCannotMergeNonAdjacentRegions() {
        TableName tableName = this.name.getTableName();
        byte[][] keys = new byte[][]{null, Bytes.toBytes((String)"aa"), Bytes.toBytes((String)"aa1!"), Bytes.toBytes((String)"aa1"), Bytes.toBytes((String)"aa2"), null};
        List<RegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, keys);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 3, 1, 1, 3, 5);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = this.normalizer.computePlansForTable(tableName);
        MatcherAssert.assertThat((Object)plans, (Matcher)Matchers.empty());
    }

    private void setupMocksForNormalizer(Map<byte[], Integer> regionSizes, List<RegionInfo> regionInfoList) {
        this.masterServices = (MasterServices)Mockito.mock(MasterServices.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ServerName sn = ServerName.valueOf((String)"localhost", (int)0, (long)0L);
        Mockito.when((Object)this.masterServices.getAssignmentManager().getRegionStates().getRegionsOfTable((TableName)ArgumentMatchers.any())).thenReturn(regionInfoList);
        Mockito.when((Object)this.masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion((RegionInfo)ArgumentMatchers.any())).thenReturn((Object)sn);
        Mockito.when((Object)this.masterServices.getAssignmentManager().getRegionStates().getRegionState((RegionInfo)ArgumentMatchers.any(RegionInfo.class))).thenReturn((Object)RegionState.createForTesting(null, (RegionState.State)RegionState.State.OPEN));
        for (Map.Entry<byte[], Integer> region : regionSizes.entrySet()) {
            RegionMetrics regionLoad = (RegionMetrics)Mockito.mock(RegionMetrics.class);
            Mockito.when((Object)regionLoad.getRegionName()).thenReturn((Object)region.getKey());
            Mockito.when((Object)regionLoad.getStoreFileSize()).thenReturn((Object)new Size((double)region.getValue().intValue(), Size.Unit.MEGABYTE));
            Mockito.when(this.masterServices.getServerManager().getLoad(sn).getRegionMetrics().get(region.getKey())).thenReturn((Object)regionLoad);
        }
        Mockito.when((Object)this.masterServices.isSplitOrMergeEnabled((MasterSwitchType)ArgumentMatchers.any())).thenReturn((Object)true);
        this.normalizer = new SimpleRegionNormalizer();
        this.normalizer.setConf(this.conf);
        this.normalizer.setMasterServices(this.masterServices);
    }

    private static List<RegionInfo> createRegionInfos(TableName tableName, int length) {
        if (length < 1) {
            throw new IllegalStateException("length must be greater than or equal to 1.");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        if (length == 1) {
            return Collections.singletonList(TestSimpleRegionNormalizer.createRegionInfo(tableName, startKey, endKey));
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(length - 1));
        ArrayList<RegionInfo> ret = new ArrayList<RegionInfo>(length);
        for (int i = 0; i < splitKeys.length - 1; ++i) {
            ret.add(TestSimpleRegionNormalizer.createRegionInfo(tableName, splitKeys[i], splitKeys[i + 1]));
        }
        return ret;
    }

    private static RegionInfo createRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) {
        return RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).setEndKey(endKey).setRegionId(TestSimpleRegionNormalizer.generateRegionId()).build();
    }

    private static long generateRegionId() {
        return Instant.ofEpochMilli(EnvironmentEdgeManager.currentTime()).minus(Period.ofDays(4)).toEpochMilli();
    }

    private static List<RegionInfo> createRegionInfos(TableName tableName, byte[][] splitKeys) {
        ArrayList<RegionInfo> ret = new ArrayList<RegionInfo>(splitKeys.length);
        for (int i = 0; i < splitKeys.length - 1; ++i) {
            ret.add(TestSimpleRegionNormalizer.createRegionInfo(tableName, splitKeys[i], splitKeys[i + 1]));
        }
        return ret;
    }

    private static Map<byte[], Integer> createRegionSizesMap(List<RegionInfo> regionInfos, int ... sizes) {
        if (regionInfos.size() != sizes.length) {
            throw new IllegalStateException("Parameter lengths must match.");
        }
        HashMap<byte[], Integer> ret = new HashMap<byte[], Integer>(regionInfos.size());
        for (int i = 0; i < regionInfos.size(); ++i) {
            ret.put(regionInfos.get(i).getRegionName(), sizes[i]);
        }
        return ret;
    }
}

