/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.region;

import java.io.IOException;
import java.lang.management.MemoryType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStorePerformanceEvaluation;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStore;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;

public class RegionProcedureStorePerformanceEvaluation
extends ProcedureStorePerformanceEvaluation<RegionProcedureStore> {
    private MasterRegion region;

    protected RegionProcedureStore createProcedureStore(Path storeDir) throws IOException {
        Pair pair = MemorySizeUtil.getGlobalMemStoreSize((Configuration)this.conf);
        long globalMemStoreSize = (Long)pair.getFirst();
        boolean offheap = pair.getSecond() == MemoryType.NON_HEAP;
        float poolSizePercentage = offheap ? 1.0f : this.conf.getFloat("hbase.hregion.memstore.chunkpool.maxsize", 1.0f);
        float initialCountPercentage = this.conf.getFloat("hbase.hregion.memstore.chunkpool.initialsize", 0.0f);
        int chunkSize = this.conf.getInt("hbase.hregion.memstore.mslab.chunksize", 0x200000);
        ChunkCreator.initialize((int)chunkSize, (boolean)offheap, (long)globalMemStoreSize, (float)poolSizePercentage, (float)initialCountPercentage, null);
        this.conf.setBoolean("hbase.master.store.region.wal.hsync", "hsync".equals(this.syncType));
        CommonFSUtils.setRootDir((Configuration)this.conf, (Path)storeDir);
        MockServer server = new MockServer(this.conf);
        this.region = MasterRegionFactory.create((Server)server);
        return new RegionProcedureStore((Server)server, this.region, (fs, apth) -> {});
    }

    protected void printRawFormatResult(long timeTakenNs) {
        System.out.println(String.format("RESULT [%s=%s, %s=%s, %s=%s, %s=%s, total_time_ms=%s]", NUM_PROCS_OPTION.getOpt(), this.numProcs, STATE_SIZE_OPTION.getOpt(), this.stateSize, SYNC_OPTION.getOpt(), this.syncType, NUM_THREADS_OPTION.getOpt(), this.numThreads, timeTakenNs));
    }

    protected void preWrite(long procId) throws IOException {
    }

    protected void postStop(RegionProcedureStore store) throws IOException {
        this.region.close(true);
    }

    public static void main(String[] args) throws IOException {
        RegionProcedureStorePerformanceEvaluation tool = new RegionProcedureStorePerformanceEvaluation();
        tool.setConf(HBaseConfiguration.create());
        tool.run(args);
    }

    private static final class MockServer
    implements Server {
        private final Configuration conf;
        private final ServerName serverName = ServerName.valueOf((String)"localhost", (int)12345, (long)System.currentTimeMillis());
        private volatile boolean abort = false;

        public MockServer(Configuration conf) {
            this.conf = conf;
        }

        public void abort(String why, Throwable e) {
            this.abort = true;
        }

        public boolean isAborted() {
            return this.abort;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public ZKWatcher getZooKeeper() {
            throw new UnsupportedOperationException();
        }

        public Connection getConnection() {
            throw new UnsupportedOperationException();
        }

        public Connection createConnection(Configuration conf) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ClusterConnection getClusterConnection() {
            throw new UnsupportedOperationException();
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            throw new UnsupportedOperationException();
        }

        public ChoreService getChoreService() {
            throw new UnsupportedOperationException();
        }
    }
}

