/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.region;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestBase;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestProcedure;
import org.apache.hadoop.hbase.procedure2.store.region.WALProcedurePrettyPrinter;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestWALProcedurePrettyPrinter
extends RegionProcedureStoreTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALProcedurePrettyPrinter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWALProcedurePrettyPrinter.class);

    @Test
    public void test() throws Exception {
        int i;
        ArrayList<RegionProcedureStoreTestProcedure> procs = new ArrayList<RegionProcedureStoreTestProcedure>();
        for (i = 0; i < 10; ++i) {
            RegionProcedureStoreTestProcedure proc = new RegionProcedureStoreTestProcedure();
            this.store.insert((Procedure)proc, null);
            procs.add(proc);
        }
        this.store.region.flush(true);
        for (i = 0; i < 5; ++i) {
            this.store.delete(((RegionProcedureStoreTestProcedure)((Object)procs.get(i))).getProcId());
        }
        this.store.cleanup();
        Path walParentDir = new Path(this.htu.getDataTestDir(), "MasterData/WALs");
        FileSystem fs = walParentDir.getFileSystem(this.htu.getConfiguration());
        Path walDir = fs.listStatus(walParentDir)[0].getPath();
        Path walFile = fs.listStatus(walDir)[0].getPath();
        this.store.region.requestRollAll();
        this.store.region.waitUntilWalRollFinished();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        WALProcedurePrettyPrinter printer = new WALProcedurePrettyPrinter(out);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.htu.getConfiguration(), (Tool)printer, (String[])new String[]{fs.makeQualified(walFile).toString()}));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), StandardCharsets.UTF_8));){
            long inserted = 0L;
            long markedDeleted = 0L;
            long deleted = 0L;
            while (true) {
                String line = reader.readLine();
                LOG.info(line);
                if (line == null) break;
                if (line.startsWith("\t")) {
                    if (line.startsWith("\tpid=")) {
                        ++inserted;
                        continue;
                    }
                    Assert.assertEquals((Object)"\tmark deleted", (Object)line);
                    ++markedDeleted;
                    continue;
                }
                if (!line.contains("type=DeleteFamily")) continue;
                ++deleted;
            }
            Assert.assertEquals((long)10L, (long)inserted);
            Assert.assertEquals((long)5L, (long)markedDeleted);
            Assert.assertEquals((long)5L, (long)deleted);
        }
    }
}

