/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.quotas.RegionSizeStoreImpl;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.CSLMImmutableSegment;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactor;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestHStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHStore.class);
    @Rule
    public TestName name = new TestName();
    HRegion region;
    HStore store;
    byte[] table = Bytes.toBytes((String)"table");
    byte[] family = Bytes.toBytes((String)"family");
    byte[] row = Bytes.toBytes((String)"row");
    byte[] row2 = Bytes.toBytes((String)"row2");
    byte[] qf1 = Bytes.toBytes((String)"qf1");
    byte[] qf2 = Bytes.toBytes((String)"qf2");
    byte[] qf3 = Bytes.toBytes((String)"qf3");
    byte[] qf4 = Bytes.toBytes((String)"qf4");
    byte[] qf5 = Bytes.toBytes((String)"qf5");
    byte[] qf6 = Bytes.toBytes((String)"qf6");
    NavigableSet<byte[]> qualifiers = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
    List<Cell> expected = new ArrayList<Cell>();
    List<Cell> result = new ArrayList<Cell>();
    long id = System.currentTimeMillis();
    Get get = new Get(this.row);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String DIR = TEST_UTIL.getDataTestDir("TestStore").toString();
    private static final int BLOCKSIZE_SMALL = 8192;

    @Before
    public void setUp() throws IOException {
        this.qualifiers.clear();
        this.qualifiers.add(this.qf1);
        this.qualifiers.add(this.qf3);
        this.qualifiers.add(this.qf5);
        for (byte[] next : this.qualifiers) {
            this.expected.add((Cell)new KeyValue(this.row, this.family, next, 1L, (byte[])null));
            this.get.addColumn(this.family, next);
        }
    }

    private void init(String methodName) throws IOException {
        this.init(methodName, TEST_UTIL.getConfiguration());
    }

    private HStore init(String methodName, Configuration conf) throws IOException {
        return this.init(methodName, conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(4).build());
    }

    private HStore init(String methodName, Configuration conf, ColumnFamilyDescriptor hcd) throws IOException {
        return this.init(methodName, conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), hcd);
    }

    private HStore init(String methodName, Configuration conf, TableDescriptorBuilder builder, ColumnFamilyDescriptor hcd) throws IOException {
        return this.init(methodName, conf, builder, hcd, null);
    }

    private HStore init(String methodName, Configuration conf, TableDescriptorBuilder builder, ColumnFamilyDescriptor hcd, MyStoreHook hook) throws IOException {
        return this.init(methodName, conf, builder, hcd, hook, false);
    }

    private void initHRegion(String methodName, Configuration conf, TableDescriptorBuilder builder, ColumnFamilyDescriptor hcd, MyStoreHook hook, boolean switchToPread) throws IOException {
        TableDescriptor htd = builder.setColumnFamily(hcd).build();
        Path basedir = new Path(DIR + methodName);
        Path tableDir = CommonFSUtils.getTableDir((Path)basedir, (TableName)htd.getTableName());
        Path logdir = new Path(basedir, AbstractFSWALProvider.getWALDirectoryName((String)methodName));
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(logdir, true);
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0x200000L, (float)1.0f, (float)0.0f, null);
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        Configuration walConf = new Configuration(conf);
        CommonFSUtils.setRootDir((Configuration)walConf, (Path)basedir);
        WALFactory wals = new WALFactory(walConf, methodName);
        this.region = new HRegion(new HRegionFileSystem(conf, fs, tableDir, info), wals.getWAL(info), conf, htd, null);
        this.region.regionServicesForStores = (RegionServicesForStores)Mockito.spy((Object)this.region.regionServicesForStores);
        ThreadPoolExecutor pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        Mockito.when((Object)this.region.regionServicesForStores.getInMemoryCompactionPool()).thenReturn((Object)pool);
    }

    private HStore init(String methodName, Configuration conf, TableDescriptorBuilder builder, ColumnFamilyDescriptor hcd, MyStoreHook hook, boolean switchToPread) throws IOException {
        this.initHRegion(methodName, conf, builder, hcd, hook, switchToPread);
        this.store = hook == null ? new HStore(this.region, hcd, conf, false) : new MyStore(this.region, hcd, conf, hook, switchToPread);
        return this.store;
    }

    @Test
    public void testFlushSizeSizing() throws Exception {
        LOG.info("Setting up a faulty file system that cannot write in " + this.name.getMethodName());
        final Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        conf.setInt("hbase.hstore.flush.retries.number", 1);
        User user = User.createUserForTesting((Configuration)conf, (String)this.name.getMethodName(), (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                FaultyFileSystem ffs = (FaultyFileSystem)fs;
                TestHStore.this.init(TestHStore.this.name.getMethodName(), conf);
                MemStoreSize mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)0L, (long)mss.getDataSize());
                LOG.info("Adding some data");
                NonThreadSafeMemStoreSizing kvSize = new NonThreadSafeMemStoreSizing();
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf1, 1L, (byte[])null), (MemStoreSizing)kvSize);
                kvSize.incMemStoreSize(0L, MutableSegment.DEEP_OVERHEAD, 0L, 0);
                mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((Object)kvSize.getMemStoreSize(), (Object)mss);
                try {
                    LOG.info("Flushing");
                    TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                kvSize.incMemStoreSize(0L, CSLMImmutableSegment.DEEP_OVERHEAD_CSLM - MutableSegment.DEEP_OVERHEAD, 0L, 0);
                mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((Object)kvSize.getMemStoreSize(), (Object)mss);
                NonThreadSafeMemStoreSizing kvSize2 = new NonThreadSafeMemStoreSizing();
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf2, 2L, (byte[])null), (MemStoreSizing)kvSize2);
                kvSize2.incMemStoreSize(0L, MutableSegment.DEEP_OVERHEAD, 0L, 0);
                Assert.assertEquals((Object)kvSize.getMemStoreSize(), (Object)mss);
                ffs.fault.set(false);
                TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((Object)kvSize2.getMemStoreSize(), (Object)mss);
                TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                mss = TestHStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)0L, (long)mss.getDataSize());
                Assert.assertEquals((long)MutableSegment.DEEP_OVERHEAD, (long)mss.getHeapSize());
                return null;
            }
        });
    }

    @Test
    public void testCreateWriter() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setCompressionType(Compression.Algorithm.GZ).setDataBlockEncoding(DataBlockEncoding.DIFF).build();
        this.init(this.name.getMethodName(), conf, hcd);
        StoreFileWriter writer = this.store.createWriterInTmp(4L, hcd.getCompressionType(), false, true, false, false);
        Path path = writer.getPath();
        writer.append((Cell)new KeyValue(this.row, this.family, this.qf1, Bytes.toBytes((int)1)));
        writer.append((Cell)new KeyValue(this.row, this.family, this.qf2, Bytes.toBytes((int)2)));
        writer.append((Cell)new KeyValue(this.row2, this.family, this.qf1, Bytes.toBytes((int)3)));
        writer.append((Cell)new KeyValue(this.row2, this.family, this.qf2, Bytes.toBytes((int)4)));
        writer.close();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);
        Assert.assertEquals((Object)hcd.getCompressionType(), (Object)reader.getTrailer().getCompressionCodec());
        Assert.assertEquals((Object)hcd.getDataBlockEncoding(), (Object)reader.getDataBlockEncoding());
        reader.close();
    }

    @Test
    public void testDeleteExpiredStoreFiles() throws Exception {
        this.testDeleteExpiredStoreFiles(0);
        this.testDeleteExpiredStoreFiles(1);
    }

    public void testDeleteExpiredStoreFiles(int minVersions) throws Exception {
        long ts;
        int i;
        int storeFileNum = 4;
        int ttl = 4;
        IncrementingEnvironmentEdge edge = new IncrementingEnvironmentEdge();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)edge);
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.store.delete.expired.storefile", true);
        conf.setInt("hbase.hstore.compaction.min", 5);
        this.init(this.name.getMethodName() + "-" + minVersions, conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMinVersions(minVersions).setTimeToLive(ttl).build());
        long storeTtl = this.store.getScanInfo().getTtl();
        long sleepTime = storeTtl / (long)storeFileNum;
        for (i = 1; i <= storeFileNum; ++i) {
            LOG.info("Adding some data for the store file #" + i);
            long timeStamp = EnvironmentEdgeManager.currentTime();
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, timeStamp, (byte[])null), null);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, timeStamp, (byte[])null), null);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, timeStamp, (byte[])null), null);
            this.flush(i);
            edge.incrementTime(sleepTime);
        }
        Assert.assertEquals((long)storeFileNum, (long)this.store.getStorefiles().size());
        for (i = 1; i <= storeFileNum - 1; ++i) {
            Assert.assertFalse((boolean)this.store.requestCompaction().isPresent());
            Collection sfs = this.store.getStorefiles();
            if (minVersions == 0) {
                Assert.assertEquals((long)(storeFileNum - i), (long)sfs.size());
                for (HStoreFile sf : sfs) {
                    Assert.assertTrue((sf.getReader().getMaxTimestamp() >= edge.currentTime() - storeTtl ? 1 : 0) != 0);
                }
            } else {
                Assert.assertEquals((long)storeFileNum, (long)sfs.size());
            }
            edge.incrementTime(sleepTime);
        }
        Assert.assertFalse((boolean)this.store.requestCompaction().isPresent());
        Collection sfs = this.store.getStorefiles();
        if (minVersions == 0) {
            Assert.assertEquals((long)1L, (long)sfs.size());
        }
        Assert.assertTrue(((ts = ((HStoreFile)sfs.iterator().next()).getReader().getMaxTimestamp()) < edge.currentTime() - storeTtl ? 1 : 0) != 0);
        for (HStoreFile sf : sfs) {
            sf.closeStoreFile(true);
        }
    }

    @Test
    public void testLowestModificationTime() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.init(this.name.getMethodName(), conf);
        int storeFileNum = 4;
        for (int i = 1; i <= storeFileNum; ++i) {
            LOG.info("Adding some data for the store file #" + i);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, (long)i, (byte[])null), null);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, (long)i, (byte[])null), null);
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, (long)i, (byte[])null), null);
            this.flush(i);
        }
        long lowestTimeStampFromManager = StoreUtils.getLowestTimestamp((Collection)this.store.getStorefiles());
        long lowestTimeStampFromFS = TestHStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        Assert.assertEquals((long)lowestTimeStampFromManager, (long)lowestTimeStampFromFS);
        this.store.compact((CompactionContext)this.store.requestCompaction().get(), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        lowestTimeStampFromManager = StoreUtils.getLowestTimestamp((Collection)this.store.getStorefiles());
        lowestTimeStampFromFS = TestHStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        Assert.assertEquals((long)lowestTimeStampFromManager, (long)lowestTimeStampFromFS);
    }

    private static long getLowestTimeStampFromFS(FileSystem fs, Collection<HStoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        if (candidates.isEmpty()) {
            return minTs;
        }
        Path[] p = new Path[candidates.size()];
        int i = 0;
        for (HStoreFile sf : candidates) {
            p[i] = sf.getPath();
            ++i;
        }
        FileStatus[] stats = fs.listStatus(p);
        if (stats == null || stats.length == 0) {
            return minTs;
        }
        for (FileStatus s : stats) {
            minTs = Math.min(minTs, s.getModificationTime());
        }
        return minTs;
    }

    @Test
    public void testEmptyStoreFile() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null), null);
        this.flush(1);
        HStoreFile f = (HStoreFile)this.store.getStorefiles().iterator().next();
        Path storedir = f.getPath().getParent();
        long seqid = f.getMaxSequenceId();
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter w = new StoreFileWriter.Builder(c, new CacheConfig(c), fs).withOutputDir(storedir).withFileContext(meta).build();
        w.appendMetadata(seqid + 1L, false);
        w.close();
        this.store.close();
        this.store = new HStore(this.store.getHRegion(), this.store.getColumnFamilyDescriptor(), c, false);
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Assert.assertEquals((long)1L, (long)this.result.size());
    }

    @Test
    public void testGet_FromMemStoreOnly() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null), null);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        this.assertCheck();
    }

    @Test
    public void testTimeRangeIfSomeCellsAreDroppedInFlush() throws IOException {
        this.testTimeRangeIfSomeCellsAreDroppedInFlush(1);
        this.testTimeRangeIfSomeCellsAreDroppedInFlush(3);
        this.testTimeRangeIfSomeCellsAreDroppedInFlush(5);
    }

    private void testTimeRangeIfSomeCellsAreDroppedInFlush(int maxVersion) throws IOException {
        long currentTs;
        this.init(this.name.getMethodName(), TEST_UTIL.getConfiguration(), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(maxVersion).build());
        long minTs = currentTs = 100L;
        for (int i = 0; i != maxVersion + 1; ++i) {
            this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, ++currentTs, (byte[])null), null);
            if (i != 1) continue;
            minTs = currentTs;
        }
        TestHStore.flushStore(this.store, this.id++);
        Collection files = this.store.getStorefiles();
        Assert.assertEquals((long)1L, (long)files.size());
        HStoreFile f = (HStoreFile)files.iterator().next();
        f.initReader();
        StoreFileReader reader = f.getReader();
        Assert.assertEquals((long)minTs, (long)reader.timeRange.getMin());
        Assert.assertEquals((long)currentTs, (long)reader.timeRange.getMax());
    }

    @Test
    public void testGet_FromFilesOnly() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null), null);
        this.flush(2);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null), null);
        this.flush(3);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, CellComparatorImpl.COMPARATOR);
        this.assertCheck();
    }

    @Test
    public void testGet_FromMemStoreAndFiles() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null), null);
        this.flush(1);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null), null);
        this.flush(2);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null), null);
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null), null);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, CellComparatorImpl.COMPARATOR);
        this.assertCheck();
    }

    private void flush(int storeFilessize) throws IOException {
        this.store.snapshot();
        TestHStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)storeFilessize, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)0L, (long)((AbstractMemStore)this.store.memstore).getActive().getCellsCount());
    }

    private void assertCheck() {
        Assert.assertEquals((long)this.expected.size(), (long)this.result.size());
        for (int i = 0; i < this.expected.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), (Object)this.result.get(i));
        }
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.store = null;
        }
        if (this.region != null) {
            this.region.close();
            this.region = null;
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testHandleErrorsInFlush() throws Exception {
        LOG.info("Setting up a faulty file system that cannot write");
        final Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        User user = User.createUserForTesting((Configuration)conf, (String)"testhandleerrorsinflush", (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                TestHStore.this.init(TestHStore.this.name.getMethodName(), conf);
                LOG.info("Adding some data");
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf1, 1L, (byte[])null), null);
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf2, 1L, (byte[])null), null);
                TestHStore.this.store.add((Cell)new KeyValue(TestHStore.this.row, TestHStore.this.family, TestHStore.this.qf3, 1L, (byte[])null), null);
                LOG.info("Before flush, we should have no files");
                Collection files = TestHStore.this.store.getRegionFileSystem().getStoreFiles(TestHStore.this.store.getColumnFamilyName());
                Assert.assertEquals((long)0L, (long)(files != null ? (long)files.size() : 0L));
                try {
                    LOG.info("Flushing");
                    TestHStore.this.flush(1);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                LOG.info("After failed flush, we should still have no files!");
                files = TestHStore.this.store.getRegionFileSystem().getStoreFiles(TestHStore.this.store.getColumnFamilyName());
                Assert.assertEquals((long)0L, (long)(files != null ? (long)files.size() : 0L));
                TestHStore.this.store.getHRegion().getWAL().close();
                return null;
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)user.getUGI());
    }

    private static void flushStore(HStore store, long id) throws IOException {
        StoreFlushContext storeFlushCtx = store.createFlushContext(id, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
        storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
    }

    List<Cell> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<Cell> kvList = new ArrayList<Cell>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            for (long timestamp : timestamps) {
                kvList.add((Cell)new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    @Test
    public void testMultipleTimestamps() throws IOException {
        int numRows = 1;
        long[] timestamps1 = new long[]{1L, 5L, 10L, 20L};
        long[] timestamps2 = new long[]{30L, 80L};
        this.init(this.name.getMethodName());
        List<Cell> kvList1 = this.getKeyValueSet(timestamps1, numRows, this.qf1, this.family);
        for (Cell cell : kvList1) {
            this.store.add(cell, null);
        }
        this.store.snapshot();
        TestHStore.flushStore(this.store, this.id++);
        List<Cell> kvList2 = this.getKeyValueSet(timestamps2, numRows, this.qf1, this.family);
        for (Cell kv : kvList2) {
            this.store.add(kv, null);
        }
        Get get = new Get(Bytes.toBytes((int)1));
        get.addColumn(this.family, this.qf1);
        get.setTimeRange(0L, 15L);
        List<Cell> list = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(40L, 90L);
        List<Cell> list2 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(10L, 45L);
        List<Cell> list3 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list3.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(80L, 145L);
        List<Cell> list4 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list4.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(1L, 2L);
        List<Cell> list5 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list5.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(90L, 200L);
        List<Cell> list6 = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((list6.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitWithEmptyColFam() throws IOException {
        this.init(this.name.getMethodName());
        Assert.assertFalse((boolean)this.store.getSplitPoint().isPresent());
        this.store.getHRegion().forceSplit(null);
        Assert.assertFalse((boolean)this.store.getSplitPoint().isPresent());
        this.store.getHRegion().clearSplit();
    }

    @Test
    public void testStoreUsesConfigurationFromHcdAndHtd() throws Exception {
        String CONFIG_KEY = "hbase.regionserver.thread.compaction.throttle";
        long anyValue = 10L;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.regionserver.thread.compaction.throttle", anyValue);
        this.init(this.name.getMethodName() + "-xml", conf);
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
        this.init(this.name.getMethodName() + "-htd", conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)).setValue("hbase.regionserver.thread.compaction.throttle", Long.toString(--anyValue)), ColumnFamilyDescriptorBuilder.of((byte[])this.family));
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
        this.init(this.name.getMethodName() + "-hcd", conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)).setValue("hbase.regionserver.thread.compaction.throttle", Long.toString(--anyValue)), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setValue("hbase.regionserver.thread.compaction.throttle", Long.toString(anyValue)).build());
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
    }

    @Test
    public void testStoreUsesSearchEngineOverride() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.engine.class", DummyStoreEngine.class.getName());
        this.init(this.name.getMethodName(), conf);
        Assert.assertEquals((Object)DummyStoreEngine.lastCreatedCompactor, (Object)this.store.storeEngine.getCompactor());
    }

    private void addStoreFile() throws IOException {
        HStoreFile f = (HStoreFile)this.store.getStorefiles().iterator().next();
        Path storedir = f.getPath().getParent();
        long seqid = this.store.getMaxSequenceId().orElse(0L);
        Configuration c = TEST_UTIL.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)c);
        HFileContext fileContext = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter w = new StoreFileWriter.Builder(c, new CacheConfig(c), fs).withOutputDir(storedir).withFileContext(fileContext).build();
        w.appendMetadata(seqid + 1L, false);
        w.close();
        LOG.info("Added store file:" + w.getPath());
    }

    private void archiveStoreFile(int index) throws IOException {
        Collection files = this.store.getStorefiles();
        HStoreFile sf = null;
        Iterator it = files.iterator();
        for (int i = 0; i <= index; ++i) {
            sf = (HStoreFile)it.next();
        }
        this.store.getRegionFileSystem().removeStoreFiles(this.store.getColumnFamilyName(), (Collection)Lists.newArrayList((Object[])new HStoreFile[]{sf}));
    }

    private void closeCompactedFile(int index) throws IOException {
        Collection files = this.store.getStoreEngine().getStoreFileManager().getCompactedfiles();
        HStoreFile sf = null;
        Iterator it = files.iterator();
        for (int i = 0; i <= index; ++i) {
            sf = (HStoreFile)it.next();
        }
        sf.closeStoreFile(true);
        this.store.getStoreEngine().getStoreFileManager().removeCompactedFiles((Collection)Lists.newArrayList((Object[])new HStoreFile[]{sf}));
    }

    @Test
    public void testRefreshStoreFiles() throws Exception {
        this.init(this.name.getMethodName());
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.flush(1);
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.addStoreFile();
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.addStoreFile();
        this.addStoreFile();
        this.addStoreFile();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)5L, (long)this.store.getStorefilesCount());
        this.closeCompactedFile(0);
        this.archiveStoreFile(0);
        Assert.assertEquals((long)5L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)4L, (long)this.store.getStorefilesCount());
        this.archiveStoreFile(0);
        this.archiveStoreFile(1);
        this.archiveStoreFile(2);
        Assert.assertEquals((long)4L, (long)this.store.getStorefilesCount());
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)1L, (long)this.store.getStorefilesCount());
        this.archiveStoreFile(0);
        this.store.refreshStoreFiles();
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
    }

    @Test
    public void testRefreshStoreFilesNotChanged() throws IOException {
        this.init(this.name.getMethodName());
        Assert.assertEquals((long)0L, (long)this.store.getStorefilesCount());
        this.store.add((Cell)new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null), null);
        this.flush(1);
        this.addStoreFile();
        HStore spiedStore = (HStore)Mockito.spy((Object)this.store);
        spiedStore.refreshStoreFiles();
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        ((HStore)Mockito.verify((Object)spiedStore, (VerificationMode)Mockito.times((int)1))).replaceStoreFiles((Collection)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        spiedStore.refreshStoreFiles();
        ((HStore)Mockito.verify((Object)spiedStore, (VerificationMode)Mockito.times((int)0))).replaceStoreFiles(null, null);
    }

    private long countMemStoreScanner(StoreScanner scanner) {
        if (scanner.currentScanners == null) {
            return 0L;
        }
        return scanner.currentScanners.stream().filter(s -> !s.isFileScanner()).count();
    }

    @Test
    public void testNumberOfMemStoreScannersAfterFlush() throws IOException {
        long seqId = 100L;
        long timestamp = System.currentTimeMillis();
        Cell cell0 = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(this.row).setFamily(this.family).setQualifier(this.qf1).setTimestamp(timestamp).setType(Cell.Type.Put).setValue(this.qf1).build();
        PrivateCellUtil.setSequenceId((Cell)cell0, (long)seqId);
        this.testNumberOfMemStoreScannersAfterFlush(Arrays.asList(cell0), Collections.emptyList());
        Cell cell1 = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(this.row).setFamily(this.family).setQualifier(this.qf2).setTimestamp(timestamp).setType(Cell.Type.Put).setValue(this.qf1).build();
        PrivateCellUtil.setSequenceId((Cell)cell1, (long)seqId);
        this.testNumberOfMemStoreScannersAfterFlush(Arrays.asList(cell0), Arrays.asList(cell1));
        seqId = 101L;
        timestamp = System.currentTimeMillis();
        Cell cell2 = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(this.row2).setFamily(this.family).setQualifier(this.qf2).setTimestamp(timestamp).setType(Cell.Type.Put).setValue(this.qf1).build();
        PrivateCellUtil.setSequenceId((Cell)cell2, (long)seqId);
        this.testNumberOfMemStoreScannersAfterFlush(Arrays.asList(cell0), Arrays.asList(cell1, cell2));
    }

    private void testNumberOfMemStoreScannersAfterFlush(List<Cell> inputCellsBeforeSnapshot, List<Cell> inputCellsAfterSnapshot) throws IOException {
        this.init(this.name.getMethodName() + "-" + inputCellsBeforeSnapshot.size());
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        long seqId = Long.MIN_VALUE;
        for (Cell c2 : inputCellsBeforeSnapshot) {
            quals.add(CellUtil.cloneQualifier((Cell)c2));
            seqId = Math.max(seqId, c2.getSequenceId());
        }
        for (Cell c2 : inputCellsAfterSnapshot) {
            quals.add(CellUtil.cloneQualifier((Cell)c2));
            seqId = Math.max(seqId, c2.getSequenceId());
        }
        inputCellsBeforeSnapshot.forEach(c -> this.store.add(c, null));
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(this.id++, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        inputCellsAfterSnapshot.forEach(c -> this.store.add(c, null));
        int numberOfMemScannersBeforeFlush = inputCellsAfterSnapshot.isEmpty() ? 1 : 2;
        try (StoreScanner s = (StoreScanner)this.store.getScanner(new Scan(), quals, seqId);){
            boolean more;
            Assert.assertEquals((long)numberOfMemScannersBeforeFlush, (long)this.countMemStoreScanner(s));
            storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
            storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
            int numberOfMemScannersAfterFlush = inputCellsAfterSnapshot.isEmpty() ? 0 : 1;
            int cellCount = 0;
            do {
                ArrayList cells = new ArrayList();
                more = s.next(cells);
                cellCount += cells.size();
                Assert.assertEquals((long)(more ? (long)numberOfMemScannersAfterFlush : 0L), (long)this.countMemStoreScanner(s));
            } while (more);
            Assert.assertEquals((String)("The number of cells added before snapshot is " + inputCellsBeforeSnapshot.size() + ", The number of cells added after snapshot is " + inputCellsAfterSnapshot.size()), (long)(inputCellsBeforeSnapshot.size() + inputCellsAfterSnapshot.size()), (long)cellCount);
            Assert.assertEquals((long)0L, (long)this.countMemStoreScanner(s));
        }
    }

    private Cell createCell(byte[] qualifier, long ts, long sequenceId, byte[] value) throws IOException {
        return this.createCell(this.row, qualifier, ts, sequenceId, value);
    }

    private Cell createCell(byte[] row, byte[] qualifier, long ts, long sequenceId, byte[] value) throws IOException {
        Cell c = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(this.family).setQualifier(qualifier).setTimestamp(ts).setType(Cell.Type.Put).setValue(value).build();
        PrivateCellUtil.setSequenceId((Cell)c, (long)sequenceId);
        return c;
    }

    @Test
    public void testFlushBeforeCompletingScanWoFilter() throws IOException, InterruptedException {
        final AtomicBoolean timeToGoNextRow = new AtomicBoolean(false);
        int expectedSize = 3;
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 2) {
                    try {
                        TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                        timeToGoNextRow.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, (Filter)new FilterBase(){

            public Filter.ReturnCode filterCell(Cell c) throws IOException {
                return Filter.ReturnCode.INCLUDE;
            }
        }, 3);
    }

    @Test
    public void testFlushBeforeCompletingScanWithFilter() throws IOException, InterruptedException {
        final AtomicBoolean timeToGoNextRow = new AtomicBoolean(false);
        int expectedSize = 2;
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 1) {
                    try {
                        TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                        timeToGoNextRow.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, (Filter)new FilterBase(){

            public Filter.ReturnCode filterCell(Cell c) throws IOException {
                if (timeToGoNextRow.get()) {
                    timeToGoNextRow.set(false);
                    return Filter.ReturnCode.NEXT_ROW;
                }
                return Filter.ReturnCode.INCLUDE;
            }
        }, 2);
    }

    @Test
    public void testFlushBeforeCompletingScanWithFilterHint() throws IOException, InterruptedException {
        final AtomicBoolean timeToGetHint = new AtomicBoolean(false);
        int expectedSize = 2;
        this.testFlushBeforeCompletingScan(new MyListHook(){

            @Override
            public void hook(int currentSize) {
                if (currentSize == 1) {
                    try {
                        TestHStore.flushStore(TestHStore.this.store, TestHStore.this.id++);
                        timeToGetHint.set(true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, (Filter)new FilterBase(){

            public Filter.ReturnCode filterCell(Cell c) throws IOException {
                if (timeToGetHint.get()) {
                    timeToGetHint.set(false);
                    return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
                }
                return Filter.ReturnCode.INCLUDE;
            }

            public Cell getNextCellHint(Cell currentCell) throws IOException {
                return currentCell;
            }
        }, 2);
    }

    private void testFlushBeforeCompletingScan(MyListHook hook, Filter filter, int expectedSize) throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        byte[] r0 = Bytes.toBytes((String)"row0");
        byte[] r1 = Bytes.toBytes((String)"row1");
        byte[] r2 = Bytes.toBytes((String)"row2");
        byte[] value0 = Bytes.toBytes((String)"value0");
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] value2 = Bytes.toBytes((String)"value2");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        final long seqId = 100L;
        this.init(this.name.getMethodName(), conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(1).build(), new MyStoreHook(){

            @Override
            public long getSmallestReadPoint(HStore store) {
                return seqId + 3L;
            }
        });
        this.store.add(this.createCell(r0, this.qf1, ts, seqId, value0), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r0, this.qf2, ts, seqId, value0), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r0, this.qf3, ts, seqId, value0), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf1, ts + 1L, seqId + 1L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf2, ts + 1L, seqId + 1L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf3, ts + 1L, seqId + 1L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf1, ts + 2L, seqId + 2L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf2, ts + 2L, seqId + 2L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r2, this.qf3, ts + 2L, seqId + 2L, value2), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf1, ts + 3L, seqId + 3L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf2, ts + 3L, seqId + 3L, value1), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(r1, this.qf3, ts + 3L, seqId + 3L, value1), (MemStoreSizing)memStoreSizing);
        MyList myList = new MyList(hook);
        Scan scan = new Scan().withStartRow(r1).setFilter(filter);
        try (InternalScanner scanner = (InternalScanner)this.store.getScanner(scan, null, seqId + 3L);){
            scanner.next(myList);
            Assert.assertEquals((long)expectedSize, (long)myList.size());
            for (Cell c : myList) {
                byte[] actualValue = CellUtil.cloneValue((Cell)c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])value1) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])value1));
            }
            ArrayList normalList = new ArrayList(3);
            scanner.next(normalList);
            Assert.assertEquals((long)3L, (long)normalList.size());
            for (Cell c : normalList) {
                byte[] actualValue = CellUtil.cloneValue((Cell)c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])value2) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])value2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateScannerAndSnapshotConcurrently() throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.regionserver.memstore.class", MyCompactingMemStore.class.getName());
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        byte[] value = Bytes.toBytes((String)"value");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        this.store.add(this.createCell(this.qf1, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf2, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf3, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(this.id++, FlushLifeCycleTracker.DUMMY);
        MyCompactingMemStore.START_TEST.set(true);
        Runnable flush = () -> storeFlushCtx.prepare();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.submit(flush);
        InternalScanner scanner = (InternalScanner)this.store.getScanner(new Scan(new Get(this.row)), quals, seqId + 1L);
        service.shutdown();
        service.awaitTermination(20L, TimeUnit.SECONDS);
        try {
            try {
                ArrayList results = new ArrayList();
                scanner.next(results);
                Assert.assertEquals((long)3L, (long)results.size());
                for (Cell c : results) {
                    byte[] actualValue = CellUtil.cloneValue((Cell)c);
                    Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])value) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])value));
                }
            }
            finally {
                scanner.close();
            }
        }
        finally {
            MyCompactingMemStore.START_TEST.set(false);
            storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
            storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
        }
    }

    @Test
    public void testScanWithDoubleFlush() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        MyStore myStore = this.initMyStore(this.name.getMethodName(), conf, new MyStoreHook(){

            @Override
            public void getScanners(MyStore store) throws IOException {
                long tmpId = TestHStore.this.id++;
                ExecutorService s = Executors.newSingleThreadExecutor();
                s.submit(() -> {
                    try {
                        TestHStore.flushStore(store, tmpId);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                });
                s.shutdown();
                try {
                    s.awaitTermination(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        byte[] oldValue = Bytes.toBytes((String)"oldValue");
        byte[] currentValue = Bytes.toBytes((String)"currentValue");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        myStore.add(this.createCell(this.qf1, ts, seqId, oldValue), (MemStoreSizing)memStoreSizing);
        myStore.add(this.createCell(this.qf2, ts, seqId, oldValue), (MemStoreSizing)memStoreSizing);
        myStore.add(this.createCell(this.qf3, ts, seqId, oldValue), (MemStoreSizing)memStoreSizing);
        long snapshotId = this.id++;
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(snapshotId, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        myStore.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, currentValue), (MemStoreSizing)memStoreSizing);
        myStore.add(this.createCell(this.qf2, ts + 1L, seqId + 1L, currentValue), (MemStoreSizing)memStoreSizing);
        myStore.add(this.createCell(this.qf3, ts + 1L, seqId + 1L, currentValue), (MemStoreSizing)memStoreSizing);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        try (InternalScanner scanner = (InternalScanner)myStore.getScanner(new Scan(new Get(this.row)), quals, seqId + 1L);){
            storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
            storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
            ArrayList results = new ArrayList();
            scanner.next(results);
            Assert.assertEquals((long)3L, (long)results.size());
            for (Cell c : results) {
                byte[] actualValue = CellUtil.cloneValue((Cell)c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])currentValue) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])currentValue));
            }
        }
    }

    @Test
    public void testReclaimChunkWhenScaning() throws IOException {
        this.init("testReclaimChunkWhenScaning");
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        byte[] value = Bytes.toBytes((String)"value");
        this.store.add(this.createCell(this.qf1, ts, seqId, value), null);
        this.store.add(this.createCell(this.qf2, ts, seqId, value), null);
        this.store.add(this.createCell(this.qf3, ts, seqId, value), null);
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(this.qf1);
        quals.add(this.qf2);
        quals.add(this.qf3);
        try (InternalScanner scanner = (InternalScanner)this.store.getScanner(new Scan(new Get(this.row)), quals, seqId);){
            MyList results = new MyList(size -> {
                switch (size) {
                    case 1: {
                        try {
                            TestHStore.flushStore(this.store, this.id++);
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 2: {
                        try {
                            byte[] newValue = Bytes.toBytes((String)"newValue");
                            this.store.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, newValue), null);
                            this.store.add(this.createCell(this.qf2, ts + 1L, seqId + 1L, newValue), null);
                            this.store.add(this.createCell(this.qf3, ts + 1L, seqId + 1L, newValue), null);
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            scanner.next(results);
            Assert.assertEquals((long)3L, (long)results.size());
            for (Cell c : results) {
                byte[] actualValue = CellUtil.cloneValue((Cell)c);
                Assert.assertTrue((String)("expected:" + Bytes.toStringBinary((byte[])value) + ", actual:" + Bytes.toStringBinary((byte[])actualValue)), (boolean)Bytes.equals((byte[])actualValue, (byte[])value));
            }
        }
    }

    @Test
    public void testRunDoubleMemStoreCompactors() throws IOException, InterruptedException {
        int flushSize = 500;
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.regionserver.memstore.class", MyCompactingMemStoreWithCustomCompactor.class.getName());
        conf.setDouble("hbase.memstore.inmemoryflush.threshold.factor", 0.25);
        MyCompactingMemStoreWithCustomCompactor.RUNNER_COUNT.set(0);
        conf.set("hbase.hregion.memstore.flush.size", String.valueOf(flushSize));
        conf.set("hbase.hregion.compacting.pipeline.segments.limit", String.valueOf(0));
        this.init(this.name.getMethodName(), conf, ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.BASIC).build());
        byte[] value = Bytes.toBytes((String)"thisisavarylargevalue");
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = EnvironmentEdgeManager.currentTime();
        long seqId = 100L;
        this.store.add(this.createCell(this.qf1, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf2, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf3, ts, seqId, value), (MemStoreSizing)memStoreSizing);
        Assert.assertEquals((long)1L, (long)MyCompactingMemStoreWithCustomCompactor.RUNNER_COUNT.get());
        StoreFlushContext storeFlushCtx = this.store.createFlushContext(this.id++, FlushLifeCycleTracker.DUMMY);
        storeFlushCtx.prepare();
        this.store.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf1, ts + 1L, seqId + 1L, value), (MemStoreSizing)memStoreSizing);
        Assert.assertEquals((long)1L, (long)MyCompactingMemStoreWithCustomCompactor.RUNNER_COUNT.get());
        MyMemStoreCompactor.START_COMPACTOR_LATCH.countDown();
        CompactingMemStore mem = (CompactingMemStore)this.store.memstore;
        while (mem.isMemStoreFlushingInMemory()) {
            TimeUnit.SECONDS.sleep(1L);
        }
        this.store.add(this.createCell(this.qf1, ts + 2L, seqId + 2L, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf1, ts + 2L, seqId + 2L, value), (MemStoreSizing)memStoreSizing);
        this.store.add(this.createCell(this.qf1, ts + 2L, seqId + 2L, value), (MemStoreSizing)memStoreSizing);
        Assert.assertEquals((long)2L, (long)MyCompactingMemStoreWithCustomCompactor.RUNNER_COUNT.get());
        conf.set("hbase.hregion.memstore.flush.size", String.valueOf(0x8000000L));
        storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
        storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
    }

    @Test
    public void testAge() throws IOException {
        final long currentTime = System.currentTimeMillis();
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        edge.setValue(currentTime);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        Configuration conf = TEST_UTIL.getConfiguration();
        ColumnFamilyDescriptor hcd = ColumnFamilyDescriptorBuilder.of((byte[])this.family);
        this.initHRegion(this.name.getMethodName(), conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), hcd, null, false);
        HStore store = new HStore(this.region, hcd, conf, false){

            protected StoreEngine<?, ?, ?, ?> createStoreEngine(HStore store, Configuration conf, CellComparator kvComparator) throws IOException {
                List<HStoreFile> storefiles = Arrays.asList(TestHStore.this.mockStoreFile(currentTime - 10L), TestHStore.this.mockStoreFile(currentTime - 100L), TestHStore.this.mockStoreFile(currentTime - 1000L), TestHStore.this.mockStoreFile(currentTime - 10000L));
                StoreFileManager sfm = (StoreFileManager)Mockito.mock(StoreFileManager.class);
                Mockito.when((Object)sfm.getStorefiles()).thenReturn(storefiles);
                StoreEngine storeEngine = (StoreEngine)Mockito.mock(StoreEngine.class);
                Mockito.when((Object)storeEngine.getStoreFileManager()).thenReturn((Object)sfm);
                return storeEngine;
            }
        };
        Assert.assertEquals((long)10L, (long)store.getMinStoreFileAge().getAsLong());
        Assert.assertEquals((long)10000L, (long)store.getMaxStoreFileAge().getAsLong());
        Assert.assertEquals((double)2777.5, (double)store.getAvgStoreFileAge().getAsDouble(), (double)1.0E-4);
    }

    private HStoreFile mockStoreFile(long createdTime) {
        StoreFileInfo info = (StoreFileInfo)Mockito.mock(StoreFileInfo.class);
        Mockito.when((Object)info.getCreatedTimestamp()).thenReturn((Object)createdTime);
        HStoreFile sf = (HStoreFile)Mockito.mock(HStoreFile.class);
        Mockito.when((Object)sf.getReader()).thenReturn(Mockito.mock(StoreFileReader.class));
        Mockito.when((Object)sf.isHFile()).thenReturn((Object)true);
        Mockito.when((Object)sf.getFileInfo()).thenReturn((Object)info);
        return sf;
    }

    private MyStore initMyStore(String methodName, Configuration conf, MyStoreHook hook) throws IOException {
        return (MyStore)this.init(methodName, conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])this.table)), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setMaxVersions(5).build(), hook);
    }

    @Test
    public void testSwitchingPreadtoStreamParallelyWithCompactionDischarger() throws Exception {
        int i;
        int i2;
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.engine.class", DummyStoreEngine.class.getName());
        conf.setLong("hbase.storescanner.pread.max.bytes", 0L);
        MyStore store = this.initMyStore(this.name.getMethodName(), conf, new MyStoreHook(){});
        NonThreadSafeMemStoreSizing memStoreSizing = new NonThreadSafeMemStoreSizing();
        long ts = System.currentTimeMillis();
        long seqID = 1L;
        for (i2 = 1; i2 < 10; ++i2) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i2)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        for (i2 = 11; i2 < 20; ++i2) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i2)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        for (i2 = 21; i2 < 30; ++i2) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i2)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
        Scan scan = new Scan();
        scan.addFamily(this.family);
        Collection storefiles2 = store.getStorefiles();
        ArrayList actualStorefiles = Lists.newArrayList((Iterable)storefiles2);
        StoreScanner storeScanner = (StoreScanner)store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(this.family), Long.MAX_VALUE);
        KeyValueHeap heap = storeScanner.heap;
        for (i = 31; i < 40; ++i) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        for (i = 41; i < 50; ++i) {
            store.add(this.createCell(Bytes.toBytes((String)("row" + i)), this.qf1, ts, seqID++, Bytes.toBytes((String)"")), (MemStoreSizing)memStoreSizing);
        }
        TestHStore.flushStore(store, seqID);
        storefiles2 = store.getStorefiles();
        ArrayList actualStorefiles1 = Lists.newArrayList((Iterable)storefiles2);
        actualStorefiles1.removeAll(actualStorefiles);
        MyThread thread = new MyThread(storeScanner);
        thread.start();
        store.replaceStoreFiles(actualStorefiles, actualStorefiles1);
        thread.join();
        KeyValueHeap heap2 = thread.getHeap();
        Assert.assertFalse((boolean)heap.equals(heap2));
    }

    @Test
    public void testInMemoryCompactionTypeWithLowerCase() throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.systemtables.compacting.memstore.type", "eager");
        this.init(this.name.getMethodName(), conf, TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])NamespaceDescriptor.SYSTEM_NAMESPACE_NAME, (byte[])"meta".getBytes())), ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setInMemoryCompaction(MemoryCompactionPolicy.NONE).build());
        Assert.assertTrue((boolean)((CompactingMemStore)this.store.memstore).compactor.toString().startsWith("eager".toUpperCase()));
    }

    @Test
    public void testSpaceQuotaChangeAfterReplacement() throws IOException {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        this.init(this.name.getMethodName());
        RegionSizeStoreImpl sizeStore = new RegionSizeStoreImpl();
        HStoreFile sf1 = this.mockStoreFileWithLength(1024L);
        HStoreFile sf2 = this.mockStoreFileWithLength(2048L);
        HStoreFile sf3 = this.mockStoreFileWithLength(4096L);
        HStoreFile sf4 = this.mockStoreFileWithLength(8192L);
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build();
        sizeStore.put(regionInfo, 5120L);
        this.store.updateSpaceQuotaAfterFileReplacement((RegionSizeStore)sizeStore, regionInfo, Arrays.asList(sf1, sf3), Arrays.asList(sf2));
        Assert.assertEquals((long)2048L, (long)sizeStore.getRegionSize(regionInfo).getSize());
        this.store.updateSpaceQuotaAfterFileReplacement((RegionSizeStore)sizeStore, regionInfo, Arrays.asList(sf2), Arrays.asList(sf2));
        Assert.assertEquals((long)2048L, (long)sizeStore.getRegionSize(regionInfo).getSize());
        this.store.updateSpaceQuotaAfterFileReplacement((RegionSizeStore)sizeStore, regionInfo, Arrays.asList(sf2), Arrays.asList(sf3));
        Assert.assertEquals((long)4096L, (long)sizeStore.getRegionSize(regionInfo).getSize());
        RegionInfo regionInfo2 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"b")).setEndKey(Bytes.toBytes((String)"c")).build();
        this.store.updateSpaceQuotaAfterFileReplacement((RegionSizeStore)sizeStore, regionInfo2, null, Arrays.asList(sf4));
        Assert.assertEquals((long)8192L, (long)sizeStore.getRegionSize(regionInfo2).getSize());
    }

    @Test
    public void testHFileContextSetWithCFAndTable() throws Exception {
        this.init(this.name.getMethodName());
        StoreFileWriter writer = this.store.createWriterInTmp(10000L, Compression.Algorithm.NONE, false, true, false, true);
        HFileContext hFileContext = writer.getHFileWriter().getFileContext();
        Assert.assertArrayEquals((byte[])this.family, (byte[])hFileContext.getColumnFamily());
        Assert.assertArrayEquals((byte[])this.table, (byte[])hFileContext.getTableName());
    }

    private HStoreFile mockStoreFileWithLength(long length) {
        HStoreFile sf = (HStoreFile)Mockito.mock(HStoreFile.class);
        StoreFileReader sfr = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        Mockito.when((Object)sf.isHFile()).thenReturn((Object)true);
        Mockito.when((Object)sf.getReader()).thenReturn((Object)sfr);
        Mockito.when((Object)sfr.length()).thenReturn((Object)length);
        return sf;
    }

    private static class MyList<T>
    implements List<T> {
        private final List<T> delegatee = new ArrayList<T>();
        private final MyListHook hookAtAdd;

        MyList(MyListHook hookAtAdd) {
            this.hookAtAdd = hookAtAdd;
        }

        @Override
        public int size() {
            return this.delegatee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegatee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegatee.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegatee.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegatee.toArray();
        }

        @Override
        public <R> R[] toArray(R[] a) {
            return this.delegatee.toArray(a);
        }

        @Override
        public boolean add(T e) {
            this.hookAtAdd.hook(this.size());
            return this.delegatee.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegatee.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegatee.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return this.delegatee.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            return this.delegatee.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegatee.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegatee.retainAll(c);
        }

        @Override
        public void clear() {
            this.delegatee.clear();
        }

        @Override
        public T get(int index) {
            return this.delegatee.get(index);
        }

        @Override
        public T set(int index, T element) {
            return this.delegatee.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            this.delegatee.add(index, element);
        }

        @Override
        public T remove(int index) {
            return this.delegatee.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegatee.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegatee.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.delegatee.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.delegatee.listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.delegatee.subList(fromIndex, toIndex);
        }
    }

    static interface MyListHook {
        public void hook(int var1);
    }

    public static class MyCompactingMemStore
    extends CompactingMemStore {
        private static final AtomicBoolean START_TEST = new AtomicBoolean(false);
        private final CountDownLatch getScannerLatch = new CountDownLatch(1);
        private final CountDownLatch snapshotLatch = new CountDownLatch(1);

        public MyCompactingMemStore(Configuration conf, CellComparatorImpl c, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)c, store, regionServices, compactionPolicy);
        }

        protected List<KeyValueScanner> createList(int capacity) {
            if (START_TEST.get()) {
                try {
                    this.getScannerLatch.countDown();
                    this.snapshotLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return new ArrayList<KeyValueScanner>(capacity);
        }

        protected void pushActiveToPipeline(MutableSegment active) {
            if (START_TEST.get()) {
                try {
                    this.getScannerLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            super.pushActiveToPipeline(active);
            if (START_TEST.get()) {
                this.snapshotLatch.countDown();
            }
        }
    }

    public static class MyCompactingMemStoreWithCustomCompactor
    extends CompactingMemStore {
        private static final AtomicInteger RUNNER_COUNT = new AtomicInteger(0);

        public MyCompactingMemStoreWithCustomCompactor(Configuration conf, CellComparatorImpl c, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, (CellComparator)c, store, regionServices, compactionPolicy);
        }

        protected MemStoreCompactor createMemStoreCompactor(MemoryCompactionPolicy compactionPolicy) throws IllegalArgumentIOException {
            return new MyMemStoreCompactor(this, compactionPolicy);
        }

        protected boolean setInMemoryCompactionFlag() {
            boolean rval = super.setInMemoryCompactionFlag();
            if (rval) {
                RUNNER_COUNT.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("runner count: " + RUNNER_COUNT.get());
                }
            }
            return rval;
        }
    }

    private static class MyMemStoreCompactor
    extends MemStoreCompactor {
        private static final AtomicInteger RUNNER_COUNT = new AtomicInteger(0);
        private static final CountDownLatch START_COMPACTOR_LATCH = new CountDownLatch(1);

        public MyMemStoreCompactor(CompactingMemStore compactingMemStore, MemoryCompactionPolicy compactionPolicy) throws IllegalArgumentIOException {
            super(compactingMemStore, compactionPolicy);
        }

        public boolean start() throws IOException {
            boolean isFirst;
            boolean bl = isFirst = RUNNER_COUNT.getAndIncrement() == 0;
            if (isFirst) {
                try {
                    START_COMPACTOR_LATCH.await();
                    return super.start();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return super.start();
        }
    }

    private static class MyThread
    extends Thread {
        private StoreScanner scanner;
        private KeyValueHeap heap;

        public MyThread(StoreScanner scanner) {
            this.scanner = scanner;
        }

        public KeyValueHeap getHeap() {
            return this.heap;
        }

        @Override
        public void run() {
            this.scanner.trySwitchToStreamRead();
            this.heap = this.scanner.heap;
        }
    }

    private static abstract class MyStoreHook {
        private MyStoreHook() {
        }

        void getScanners(MyStore store) throws IOException {
        }

        long getSmallestReadPoint(HStore store) {
            return store.getHRegion().getSmallestReadPoint();
        }
    }

    private static class MyStore
    extends HStore {
        private final MyStoreHook hook;

        MyStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam, MyStoreHook hook, boolean switchToPread) throws IOException {
            super(region, family, confParam, false);
            this.hook = hook;
        }

        public List<KeyValueScanner> getScanners(List<HStoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
            this.hook.getScanners(this);
            return super.getScanners(files, cacheBlocks, usePread, isCompaction, matcher, startRow, true, stopRow, false, readPt, includeMemstoreScanner);
        }

        public long getSmallestReadPoint() {
            return this.hook.getSmallestReadPoint(this);
        }
    }

    public static class DummyStoreEngine
    extends DefaultStoreEngine {
        public static DefaultCompactor lastCreatedCompactor = null;

        protected void createComponents(Configuration conf, HStore store, CellComparator comparator) throws IOException {
            super.createComponents(conf, store, comparator);
            lastCreatedCompactor = (DefaultCompactor)this.compactor;
        }
    }

    static class FaultyOutputStream
    extends FSDataOutputStream {
        volatile long faultPos = Long.MAX_VALUE;
        private final AtomicBoolean fault;

        public FaultyOutputStream(FSDataOutputStream out, long faultPos, AtomicBoolean fault) throws IOException {
            super((OutputStream)out, null);
            this.faultPos = faultPos;
            this.fault = fault;
        }

        public synchronized void write(byte[] buf, int offset, int length) throws IOException {
            System.err.println("faulty stream write at pos " + this.getPos());
            this.injectFault();
            super.write(buf, offset, length);
        }

        private void injectFault() throws IOException {
            if (this.fault.get() && this.getPos() >= this.faultPos) {
                throw new IOException("Fault injected");
            }
        }
    }

    static class FaultyFileSystem
    extends FilterFileSystem {
        List<SoftReference<FaultyOutputStream>> outStreams = new ArrayList<SoftReference<FaultyOutputStream>>();
        private long faultPos = 200L;
        AtomicBoolean fault = new AtomicBoolean(true);

        public FaultyFileSystem() {
            super((FileSystem)new LocalFileSystem());
            System.err.println("Creating faulty!");
        }

        public FSDataOutputStream create(Path p) throws IOException {
            return new FaultyOutputStream(super.create(p), this.faultPos, this.fault);
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return new FaultyOutputStream(super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress), this.faultPos, this.fault);
        }

        public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return this.create(f, overwrite, bufferSize, replication, blockSize, progress);
        }
    }
}

