/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.ResizableBlockCache;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushRequestListener;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.FlushType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.HeapMemoryTuner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestHeapMemoryManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHeapMemoryManager.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private long maxHeapSize = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();

    @Test
    public void testAutoTunerShouldBeOffWhenMaxMinRangesForMemstoreIsNotGiven() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size", 0.02f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.75f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.03f);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        HeapMemoryManager manager = new HeapMemoryManager((BlockCache)new BlockCacheStub(0L), (FlushRequester)new MemstoreFlusherStub(0L), (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        Assert.assertFalse((boolean)manager.isTunerOn());
    }

    @Test
    public void testAutoTunerShouldBeOffWhenMaxMinRangesForBlockCacheIsNotGiven() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hfile.block.cache.size", 0.02f);
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.03f);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        HeapMemoryManager manager = new HeapMemoryManager((BlockCache)new BlockCacheStub(0L), (FlushRequester)new MemstoreFlusherStub(0L), (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        Assert.assertFalse((boolean)manager.isTunerOn());
    }

    @Test
    public void testWhenMemstoreAndBlockCacheMaxMinChecksFails() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub(0L);
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.06f);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub(0L);
        try {
            new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.2f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        try {
            new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testWhenClusterIsWriteHeavyWithEmptyMemstore() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        blockCache.setTestBlockSize(0L);
        regionServerAccounting.setTestMemstoreSize(0L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_HIGHER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_LOWER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        Thread.sleep(1500L);
        Assert.assertEquals((long)oldMemstoreHeapSize, (long)memStoreFlusher.memstoreSize);
        Assert.assertEquals((long)oldBlockCacheSize, (long)blockCache.maxSize);
    }

    @Test
    public void testHeapMemoryManagerWhenOffheapFlushesHappenUnderReadHeavyCase() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.lower.limit", 0.7f);
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf, true);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        blockCache.setTestBlockSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        regionServerAccounting.setTestMemstoreSize(0L);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        float maxStepValue = 0.00125f;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        memStoreFlusher.flushType = FlushType.ABOVE_OFFHEAP_HIGHER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-maxStepValue, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(maxStepValue, oldBlockCacheSize, blockCache.maxSize);
        oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        oldBlockCacheSize = blockCache.maxSize;
        blockCache.evictBlock(null);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-maxStepValue, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(maxStepValue, oldBlockCacheSize, blockCache.maxSize);
    }

    @Test
    public void testHeapMemoryManagerWithOffheapMemstoreAndMixedWorkload() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.lower.limit", 0.7f);
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf, true);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        blockCache.setTestBlockSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        regionServerAccounting.setTestMemstoreSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        float maxStepValue = 0.00125f;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        memStoreFlusher.flushType = FlushType.ABOVE_OFFHEAP_HIGHER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-maxStepValue, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(maxStepValue, oldBlockCacheSize, blockCache.maxSize);
        oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        oldBlockCacheSize = blockCache.maxSize;
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_HIGHER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(maxStepValue, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-maxStepValue, oldBlockCacheSize, blockCache.maxSize);
    }

    @Test
    public void testWhenClusterIsReadHeavyWithEmptyBlockCache() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        blockCache.setTestBlockSize(0L);
        regionServerAccounting.setTestMemstoreSize(0L);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        Thread.sleep(1500L);
        Assert.assertEquals((long)oldMemstoreHeapSize, (long)memStoreFlusher.memstoreSize);
        Assert.assertEquals((long)oldBlockCacheSize, (long)blockCache.maxSize);
    }

    @Test
    public void testWhenClusterIsWriteHeavy() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        blockCache.setTestBlockSize(0L);
        regionServerAccounting.setTestMemstoreSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_LOWER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(0.04f, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-0.04f, oldBlockCacheSize, blockCache.maxSize);
        oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        oldBlockCacheSize = blockCache.maxSize;
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_LOWER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(0.04f, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-0.04f, oldBlockCacheSize, blockCache.maxSize);
    }

    @Test
    public void testWhenClusterIsWriteHeavyWithOffheapMemstore() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        blockCache.setTestBlockSize(0L);
        regionServerAccounting.setTestMemstoreSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        memStoreFlusher.flushType = FlushType.ABOVE_OFFHEAP_HIGHER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        Thread.sleep(1500L);
        Assert.assertEquals((long)oldMemstoreHeapSize, (long)memStoreFlusher.memstoreSize);
        Assert.assertEquals((long)oldBlockCacheSize, (long)blockCache.maxSize);
    }

    @Test
    public void testWhenClusterIsReadHeavy() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.lower.limit", 0.7f);
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        blockCache.setTestBlockSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        regionServerAccounting.setTestMemstoreSize(0L);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)new RegionServerAccountingStub(conf));
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        long oldMemstoreLowerMarkSize = 7L * oldMemstoreHeapSize / 10L;
        long maxTuneSize = oldMemstoreHeapSize - (oldMemstoreLowerMarkSize + oldMemstoreHeapSize) / 2L;
        float maxStepValue = (float)maxTuneSize * 1.0f / (float)oldMemstoreHeapSize;
        maxStepValue = maxStepValue > 0.04f ? 0.04f : maxStepValue;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-maxStepValue, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(maxStepValue, oldBlockCacheSize, blockCache.maxSize);
        oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        oldBlockCacheSize = blockCache.maxSize;
        oldMemstoreLowerMarkSize = 7L * oldMemstoreHeapSize / 10L;
        maxTuneSize = oldMemstoreHeapSize - (oldMemstoreLowerMarkSize + oldMemstoreHeapSize) / 2L;
        maxStepValue = (float)maxTuneSize * 1.0f / (float)oldMemstoreHeapSize;
        maxStepValue = maxStepValue > 0.04f ? 0.04f : maxStepValue;
        blockCache.evictBlock(null);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-maxStepValue, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(maxStepValue, oldBlockCacheSize, blockCache.maxSize);
    }

    @Test
    public void testWhenClusterIsHavingMoreWritesThanReads() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        blockCache.setTestBlockSize(0L);
        regionServerAccounting.setTestMemstoreSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        blockCache.setTestBlockSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_LOWER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        blockCache.evictBlock(null);
        Thread.sleep(1500L);
        Assert.assertEquals((long)oldMemstoreHeapSize, (long)memStoreFlusher.memstoreSize);
        Assert.assertEquals((long)oldBlockCacheSize, (long)blockCache.maxSize);
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_LOWER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(0.04f, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-0.04f, oldBlockCacheSize, blockCache.maxSize);
    }

    @Test
    public void testBlockedFlushesIncreaseMemstoreInSteadyState() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.75f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.05f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        RegionServerAccountingStub regionServerAccounting = new RegionServerAccountingStub(conf);
        blockCache.setTestBlockSize(0L);
        regionServerAccounting.setTestMemstoreSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        blockCache.setTestBlockSize((long)((double)this.maxHeapSize * 0.4 * 0.8));
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)regionServerAccounting);
        long oldMemstoreHeapSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_LOWER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        Thread.sleep(1500L);
        Assert.assertEquals((long)oldMemstoreHeapSize, (long)memStoreFlusher.memstoreSize);
        Assert.assertEquals((long)oldBlockCacheSize, (long)blockCache.maxSize);
        memStoreFlusher.flushType = FlushType.ABOVE_ONHEAP_HIGHER_MARK;
        memStoreFlusher.requestFlush(null, false, FlushLifeCycleTracker.DUMMY);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        blockCache.evictBlock(null);
        Thread.sleep(1500L);
        this.assertHeapSpaceDelta(0.04f, oldMemstoreHeapSize, memStoreFlusher.memstoreSize);
        this.assertHeapSpaceDelta(-0.04f, oldBlockCacheSize, blockCache.maxSize);
    }

    @Test
    public void testPluggingInHeapMemoryTuner() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.78f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.05f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.75f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.02f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        conf.setClass("hbase.regionserver.heapmemory.tuner.class", CustomHeapMemoryTuner.class, HeapMemoryTuner.class);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)new RegionServerAccountingStub(conf));
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        CustomHeapMemoryTuner.memstoreSize = 0.78f;
        CustomHeapMemoryTuner.blockCacheSize = 0.02f;
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpace(0.78f, memStoreFlusher.memstoreSize);
        this.assertHeapSpace(0.02f, blockCache.maxSize);
        CustomHeapMemoryTuner.blockCacheSize = 0.75f;
        CustomHeapMemoryTuner.memstoreSize = 0.05f;
        this.waitForTune(memStoreFlusher, memStoreFlusher.memstoreSize);
        this.assertHeapSpace(0.75f, blockCache.maxSize);
        this.assertHeapSpace(0.05f, memStoreFlusher.memstoreSize);
    }

    @Test
    public void testWhenSizeGivenByHeapTunerGoesOutsideRange() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.7f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.1f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        conf.setClass("hbase.regionserver.heapmemory.tuner.class", CustomHeapMemoryTuner.class, HeapMemoryTuner.class);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)new RegionServerAccountingStub(conf));
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        CustomHeapMemoryTuner.memstoreSize = 0.78f;
        CustomHeapMemoryTuner.blockCacheSize = 0.02f;
        Thread.sleep(1500L);
        this.assertHeapSpace(0.7f, memStoreFlusher.memstoreSize);
        this.assertHeapSpace(0.1f, blockCache.maxSize);
    }

    @Test
    public void testWhenCombinedHeapSizesFromTunerGoesOutSideMaxLimit() throws Exception {
        BlockCacheStub blockCache = new BlockCacheStub((long)((double)this.maxHeapSize * 0.4));
        MemstoreFlusherStub memStoreFlusher = new MemstoreFlusherStub((long)((double)this.maxHeapSize * 0.4));
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.regionserver.global.memstore.size.max.range", 0.7f);
        conf.setFloat("hbase.regionserver.global.memstore.size.min.range", 0.1f);
        conf.setFloat("hfile.block.cache.size.max.range", 0.7f);
        conf.setFloat("hfile.block.cache.size.min.range", 0.1f);
        conf.setLong("hbase.regionserver.heapmemory.tuner.period", 1000L);
        conf.setInt("hbase.regionserver.heapmemory.autotuner.ignored.periods", 0);
        conf.setClass("hbase.regionserver.heapmemory.tuner.class", CustomHeapMemoryTuner.class, HeapMemoryTuner.class);
        HeapMemoryManager heapMemoryManager = new HeapMemoryManager((BlockCache)blockCache, (FlushRequester)memStoreFlusher, (Server)new RegionServerStub(conf), (RegionServerAccounting)new RegionServerAccountingStub(conf));
        long oldMemstoreSize = memStoreFlusher.memstoreSize;
        long oldBlockCacheSize = blockCache.maxSize;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        heapMemoryManager.start(choreService);
        CustomHeapMemoryTuner.memstoreSize = 0.7f;
        CustomHeapMemoryTuner.blockCacheSize = 0.3f;
        Thread.sleep(1500L);
        Assert.assertEquals((long)oldMemstoreSize, (long)memStoreFlusher.memstoreSize);
        Assert.assertEquals((long)oldBlockCacheSize, (long)blockCache.maxSize);
    }

    private void assertHeapSpace(float expectedHeapPercentage, long currentHeapSpace) {
        long expected = (long)((float)this.maxHeapSize * expectedHeapPercentage);
        Assert.assertEquals((long)expected, (long)currentHeapSpace);
    }

    private void assertHeapSpaceDelta(double expectedDeltaPercent, long oldHeapSpace, long newHeapSpace) {
        double expctedMinDelta = (double)this.maxHeapSize * expectedDeltaPercent;
        double error = 0.95;
        if (expectedDeltaPercent > 0.0) {
            Assert.assertTrue((expctedMinDelta * error <= (double)(newHeapSpace - oldHeapSpace) ? 1 : 0) != 0);
            Assert.assertTrue((expctedMinDelta / error >= (double)(newHeapSpace - oldHeapSpace) ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((-expctedMinDelta * error <= (double)(oldHeapSpace - newHeapSpace) ? 1 : 0) != 0);
            Assert.assertTrue((-expctedMinDelta / error >= (double)(oldHeapSpace - newHeapSpace) ? 1 : 0) != 0);
        }
    }

    private void waitForTune(final MemstoreFlusherStub memStoreFlusher, final long oldMemstoreHeapSize) throws Exception {
        UTIL.waitFor(10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return oldMemstoreHeapSize != memStoreFlusher.memstoreSize;
            }
        });
    }

    private static class RegionServerAccountingStub
    extends RegionServerAccounting {
        boolean offheap;
        private long testMemstoreSize = 0L;

        public RegionServerAccountingStub(Configuration conf) {
            super(conf);
        }

        public RegionServerAccountingStub(Configuration conf, boolean offheap) {
            super(conf);
            this.offheap = offheap;
        }

        public long getGlobalMemStoreDataSize() {
            return this.testMemstoreSize;
        }

        public long getGlobalMemStoreHeapSize() {
            return this.testMemstoreSize;
        }

        public boolean isOffheap() {
            return this.offheap;
        }

        public void setTestMemstoreSize(long testMemstoreSize) {
            this.testMemstoreSize = testMemstoreSize;
        }
    }

    static class CustomHeapMemoryTuner
    implements HeapMemoryTuner {
        static float blockCacheSize = 0.4f;
        static float memstoreSize = 0.4f;

        CustomHeapMemoryTuner() {
        }

        public Configuration getConf() {
            return null;
        }

        public void setConf(Configuration arg0) {
        }

        public HeapMemoryManager.TunerResult tune(HeapMemoryManager.TunerContext context) {
            HeapMemoryManager.TunerResult result = new HeapMemoryManager.TunerResult(true);
            result.setBlockCacheSize(blockCacheSize);
            result.setMemStoreSize(memstoreSize);
            return result;
        }
    }

    private static class RegionServerStub
    implements Server {
        private Configuration conf;
        private boolean stopped = false;

        public RegionServerStub(Configuration conf) {
            this.conf = conf;
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public ZKWatcher getZooKeeper() {
            return null;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"server1", (int)4000, (long)12345L);
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }

    private static class MemstoreFlusherStub
    implements FlushRequester {
        long memstoreSize;
        FlushRequestListener listener;
        FlushType flushType = FlushType.NORMAL;

        public MemstoreFlusherStub(long memstoreSize) {
            this.memstoreSize = memstoreSize;
        }

        public boolean requestFlush(HRegion region, boolean forceFlushAllStores, FlushLifeCycleTracker tracker) {
            this.listener.flushRequested(this.flushType, (Region)region);
            return true;
        }

        public boolean requestDelayedFlush(HRegion region, long delay, boolean forceFlushAllStores) {
            return true;
        }

        public void registerFlushRequestListener(FlushRequestListener listener) {
            this.listener = listener;
        }

        public boolean unregisterFlushRequestListener(FlushRequestListener listener) {
            return false;
        }

        public void setGlobalMemStoreLimit(long globalMemStoreSize) {
            this.memstoreSize = globalMemStoreSize;
        }
    }

    private static class BlockCacheStub
    implements ResizableBlockCache {
        CacheStats stats = new CacheStats("test");
        long maxSize = 0L;
        private long testBlockSize = 0L;

        public BlockCacheStub(long size) {
            this.maxSize = size;
        }

        public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        }

        public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        }

        public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
            return null;
        }

        public boolean evictBlock(BlockCacheKey cacheKey) {
            this.stats.evicted(0L, cacheKey != null ? cacheKey.isPrimary() : true);
            return false;
        }

        public int evictBlocksByHfileName(String hfileName) {
            this.stats.evicted(0L, true);
            return 0;
        }

        public CacheStats getStats() {
            return this.stats;
        }

        public void shutdown() {
        }

        public long size() {
            return 0L;
        }

        public long getMaxSize() {
            return 0L;
        }

        public long getFreeSize() {
            return 0L;
        }

        public long getCurrentSize() {
            return this.testBlockSize;
        }

        public long getCurrentDataSize() {
            return 0L;
        }

        public long getBlockCount() {
            return 0L;
        }

        public long getDataBlockCount() {
            return 0L;
        }

        public void setMaxSize(long size) {
            this.maxSize = size;
        }

        public Iterator<CachedBlock> iterator() {
            return null;
        }

        public BlockCache[] getBlockCaches() {
            return null;
        }

        public void setTestBlockSize(long testBlockSize) {
            this.testBlockSize = testBlockSize;
        }
    }
}

