/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.CustomAsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALDurabilityTestBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerServices.class, SmallTests.class})
public class TestAsyncFSWALDurability
extends WALDurabilityTestBase<CustomAsyncFSWAL> {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncFSWALDurability.class);
    private static NioEventLoopGroup GROUP;

    @BeforeClass
    public static void setUpBeforeClass() {
        GROUP = new NioEventLoopGroup();
    }

    @AfterClass
    public static void tearDownAfterClass() {
        GROUP.shutdownGracefully();
    }

    @Override
    protected CustomAsyncFSWAL getWAL(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
        CustomAsyncFSWAL wal = new CustomAsyncFSWAL(fs, root, logDir, conf, (EventLoopGroup)GROUP, NioSocketChannel.class);
        wal.init();
        return wal;
    }

    @Override
    protected void resetSyncFlag(CustomAsyncFSWAL wal) {
        wal.resetSyncFlag();
    }

    @Override
    protected Boolean getSyncFlag(CustomAsyncFSWAL wal) {
        return wal.getSyncFlag();
    }

    @Override
    protected Boolean getWriterSyncFlag(CustomAsyncFSWAL wal) {
        return wal.getWriterSyncFlag();
    }
}

