/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class WALDurabilityTestBase<T extends WAL> {
    private static final String COLUMN_FAMILY = "MyCF";
    private static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"MyCF");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private String dir;
    @Rule
    public TestName name = new TestName();
    protected TableName tableName;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.dir = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws IOException {
        TEST_UTIL.cleanupTestDir();
    }

    protected abstract T getWAL(FileSystem var1, Path var2, String var3, Configuration var4) throws IOException;

    protected abstract void resetSyncFlag(T var1);

    protected abstract Boolean getSyncFlag(T var1);

    protected abstract Boolean getWriterSyncFlag(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALDurability() throws IOException {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        Put put = new Put(bytes);
        put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), bytes);
        this.conf.set("hbase.wal.hsync", "false");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path rootDir = new Path(this.dir + this.getName());
        T wal = this.getWAL(fs, rootDir, this.getName(), this.conf);
        HRegion region = WALDurabilityTestBase.initHRegion(this.tableName, null, null, wal);
        try {
            this.resetSyncFlag(wal);
            Assert.assertNull((Object)this.getSyncFlag(wal));
            Assert.assertNull((Object)this.getWriterSyncFlag(wal));
            region.put(put);
            Assert.assertFalse((boolean)this.getSyncFlag(wal));
            Assert.assertFalse((boolean)this.getWriterSyncFlag(wal));
            put.setDurability(Durability.FSYNC_WAL);
            this.resetSyncFlag(wal);
            Assert.assertNull((Object)this.getSyncFlag(wal));
            Assert.assertNull((Object)this.getWriterSyncFlag(wal));
            region.put(put);
            Assert.assertTrue((boolean)this.getSyncFlag(wal));
            Assert.assertTrue((boolean)this.getWriterSyncFlag(wal));
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
        this.conf.set("hbase.wal.hsync", "true");
        fs = FileSystem.get((Configuration)this.conf);
        wal = this.getWAL(fs, rootDir, this.getName(), this.conf);
        region = WALDurabilityTestBase.initHRegion(this.tableName, null, null, wal);
        try {
            this.resetSyncFlag(wal);
            Assert.assertNull((Object)this.getSyncFlag(wal));
            Assert.assertNull((Object)this.getWriterSyncFlag(wal));
            region.put(put);
            Assert.assertTrue((boolean)this.getSyncFlag(wal));
            Assert.assertTrue((boolean)this.getWriterSyncFlag(wal));
            put.setDurability(Durability.FSYNC_WAL);
            this.resetSyncFlag(wal);
            Assert.assertNull((Object)this.getSyncFlag(wal));
            Assert.assertNull((Object)this.getWriterSyncFlag(wal));
            region.put(put);
            Assert.assertTrue((boolean)this.getSyncFlag(wal));
            Assert.assertTrue((boolean)this.getWriterSyncFlag(wal));
            put = new Put(bytes);
            put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), bytes);
            put.setDurability(Durability.SYNC_WAL);
            this.resetSyncFlag(wal);
            Assert.assertNull((Object)this.getSyncFlag(wal));
            Assert.assertNull((Object)this.getWriterSyncFlag(wal));
            region.put(put);
            Assert.assertFalse((boolean)this.getSyncFlag(wal));
            Assert.assertFalse((boolean)this.getWriterSyncFlag(wal));
        }
        finally {
            HBaseTestingUtility.closeRegionAndWAL(region);
        }
    }

    private String getName() {
        return this.name.getMethodName();
    }

    public static HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, WAL wal) throws IOException {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        return TEST_UTIL.createLocalHRegion(tableName, startKey, stopKey, false, Durability.USE_DEFAULT, wal, new byte[][]{COLUMN_FAMILY_BYTES});
    }
}

