/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ReplicationPeerNotFoundException;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.regionserver.RegionReplicaReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.FlakeyTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FlakeyTests.class, LargeTests.class})
public class TestRegionReplicaReplicationEndpoint {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicaReplicationEndpoint.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionReplicaReplicationEndpoint.class);
    private static final int NB_SERVERS = 2;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setFloat("hbase.regionserver.logroll.multiplier", 3.0E-4f);
        conf.setInt("replication.source.size.capacity", 10240);
        conf.setLong("replication.source.sleepforretries", 100L);
        conf.setInt("hbase.regionserver.maxlogs", 10);
        conf.setLong("hbase.master.logcleaner.ttl", 10L);
        conf.setInt("zookeeper.recovery.retry", 1);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setLong("hbase.server.thread.wakefrequency", 100L);
        conf.setInt("replication.stats.thread.period.seconds", 5);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf.setInt("hbase.client.retries.number", 5);
        conf.setInt("hbase.client.serverside.retries.multiplier", 1);
        HTU.startMiniCluster(2);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    @Test
    public void testRegionReplicaReplicationPeerIsCreated() throws IOException, ReplicationException {
        ReplicationAdmin admin = new ReplicationAdmin(HTU.getConfiguration());
        String peerId = "region_replica_replication";
        ReplicationPeerConfig peerConfig = null;
        try {
            peerConfig = admin.getPeerConfig(peerId);
        }
        catch (ReplicationPeerNotFoundException e) {
            LOG.warn("Region replica replication peer id=" + peerId + " not exist", (Throwable)e);
        }
        if (peerConfig != null) {
            admin.removePeer(peerId);
            peerConfig = null;
        }
        HTableDescriptor htd = HTU.createTableDescriptor("testReplicationPeerIsCreated_no_region_replicas");
        HTU.getAdmin().createTable((TableDescriptor)htd);
        try {
            peerConfig = admin.getPeerConfig(peerId);
            Assert.fail((String)("Should throw ReplicationException, because replication peer id=" + peerId + " not exist"));
        }
        catch (ReplicationPeerNotFoundException replicationPeerNotFoundException) {
            // empty catch block
        }
        Assert.assertNull((Object)peerConfig);
        htd = HTU.createTableDescriptor("testReplicationPeerIsCreated");
        htd.setRegionReplication(2);
        HTU.getAdmin().createTable((TableDescriptor)htd);
        peerConfig = admin.getPeerConfig(peerId);
        Assert.assertNotNull((Object)peerConfig);
        Assert.assertEquals((Object)peerConfig.getClusterKey(), (Object)ZKConfig.getZooKeeperClusterKey((Configuration)HTU.getConfiguration()));
        Assert.assertEquals((Object)RegionReplicaReplicationEndpoint.class.getName(), (Object)peerConfig.getReplicationEndpointImpl());
        admin.close();
    }

    @Test
    public void testRegionReplicaReplicationPeerIsCreatedForModifyTable() throws Exception {
        ReplicationAdmin admin = new ReplicationAdmin(HTU.getConfiguration());
        String peerId = "region_replica_replication";
        ReplicationPeerConfig peerConfig = null;
        try {
            peerConfig = admin.getPeerConfig(peerId);
        }
        catch (ReplicationPeerNotFoundException e) {
            LOG.warn("Region replica replication peer id=" + peerId + " not exist", (Throwable)e);
        }
        if (peerConfig != null) {
            admin.removePeer(peerId);
            peerConfig = null;
        }
        HTableDescriptor htd = HTU.createTableDescriptor("testRegionReplicaReplicationPeerIsCreatedForModifyTable");
        HTU.getAdmin().createTable((TableDescriptor)htd);
        try {
            peerConfig = admin.getPeerConfig(peerId);
            Assert.fail((String)("Should throw ReplicationException, because replication peer id=" + peerId + " not exist"));
        }
        catch (ReplicationPeerNotFoundException replicationPeerNotFoundException) {
            // empty catch block
        }
        Assert.assertNull((Object)peerConfig);
        HTU.getAdmin().disableTable(htd.getTableName());
        htd.setRegionReplication(2);
        HTU.getAdmin().modifyTable(htd.getTableName(), (TableDescriptor)htd);
        HTU.getAdmin().enableTable(htd.getTableName());
        peerConfig = admin.getPeerConfig(peerId);
        Assert.assertNotNull((Object)peerConfig);
        Assert.assertEquals((Object)peerConfig.getClusterKey(), (Object)ZKConfig.getZooKeeperClusterKey((Configuration)HTU.getConfiguration()));
        Assert.assertEquals((Object)RegionReplicaReplicationEndpoint.class.getName(), (Object)peerConfig.getReplicationEndpointImpl());
        admin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionReplicaReplication(int regionReplication) throws Exception {
        TableName tableName = TableName.valueOf((String)("testRegionReplicaReplicationWithReplicas_" + regionReplication));
        HTableDescriptor htd = HTU.createTableDescriptor(tableName.toString());
        htd.setRegionReplication(regionReplication);
        HTU.getAdmin().createTable((TableDescriptor)htd);
        TableName tableNameNoReplicas = TableName.valueOf((String)"testRegionReplicaReplicationWithReplicas_NO_REPLICAS");
        HTU.deleteTableIfAny(tableNameNoReplicas);
        HTU.createTable(tableNameNoReplicas, HBaseTestingUtility.fam1);
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        Table tableNoReplicas = connection.getTable(tableNameNoReplicas);
        try {
            HTU.loadNumericRows(tableNoReplicas, HBaseTestingUtility.fam1, 6000, 7000);
            HTU.loadNumericRows(table, HBaseTestingUtility.fam1, 0, 1000);
            this.verifyReplication(tableName, regionReplication, 0, 1000);
        }
        finally {
            table.close();
            tableNoReplicas.close();
            HTU.deleteTableIfAny(tableNameNoReplicas);
            connection.close();
        }
    }

    private void verifyReplication(TableName tableName, int regionReplication, int startRow, int endRow) throws Exception {
        this.verifyReplication(tableName, regionReplication, startRow, endRow, true);
    }

    private void verifyReplication(TableName tableName, int regionReplication, final int startRow, final int endRow, final boolean present) throws Exception {
        Region[] regions = new Region[regionReplication];
        for (int i = 0; i < 2; ++i) {
            HRegionServer rs = HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getRegions(tableName);
            for (HRegion region : onlineRegions) {
                regions[region.getRegionInfo().getReplicaId()] = region;
            }
        }
        for (Region region : regions) {
            Assert.assertNotNull((Object)region);
        }
        for (int i = 1; i < regionReplication; ++i) {
            final Region region = regions[i];
            Waiter.waitFor((Configuration)HTU.getConfiguration(), (long)90000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    LOG.info("verifying replication for region replica:" + region.getRegionInfo());
                    try {
                        HTU.verifyNumericRows(region, HBaseTestingUtility.fam1, startRow, endRow, present);
                    }
                    catch (Throwable ex) {
                        LOG.warn("Verification from secondary region is not complete yet", ex);
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    @Test
    public void testRegionReplicaReplicationWith2Replicas() throws Exception {
        this.testRegionReplicaReplication(2);
    }

    @Test
    public void testRegionReplicaReplicationWith3Replicas() throws Exception {
        this.testRegionReplicaReplication(3);
    }

    @Test
    public void testRegionReplicaReplicationWith10Replicas() throws Exception {
        this.testRegionReplicaReplication(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicaWithoutMemstoreReplication() throws Exception {
        int regionReplication = 3;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = HTU.createTableDescriptor(tableName);
        htd.setRegionReplication(regionReplication);
        htd.setRegionMemstoreReplication(false);
        HTU.getAdmin().createTable((TableDescriptor)htd);
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        try {
            int STEP = 100;
            for (int i = 0; i < 3; ++i) {
                int startRow = i * 100;
                int endRow = (i + 1) * 100;
                LOG.info("Writing data from " + startRow + " to " + endRow);
                HTU.loadNumericRows(table, HBaseTestingUtility.fam1, startRow, endRow);
                this.verifyReplication(tableName, regionReplication, startRow, endRow, false);
                LOG.info("flushing table");
                HTU.flush(tableName);
                this.verifyReplication(tableName, regionReplication, 0, endRow, true);
            }
        }
        finally {
            table.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicaReplicationForFlushAndCompaction() throws Exception {
        int regionReplication = 3;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = HTU.createTableDescriptor(tableName);
        htd.setRegionReplication(regionReplication);
        HTU.getAdmin().createTable((TableDescriptor)htd);
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        try {
            for (int i = 0; i < 6000; i += 1000) {
                LOG.info("Writing data from " + i + " to " + (i + 1000));
                HTU.loadNumericRows(table, HBaseTestingUtility.fam1, i, i + 1000);
                LOG.info("flushing table");
                HTU.flush(tableName);
                LOG.info("compacting table");
                HTU.compact(tableName, false);
            }
            this.verifyReplication(tableName, regionReplication, 0, 1000);
        }
        finally {
            table.close();
            connection.close();
        }
    }

    @Test
    public void testRegionReplicaReplicationIgnoresDisabledTables() throws Exception {
        this.testRegionReplicaReplicationIgnores(false, false);
    }

    @Test
    public void testRegionReplicaReplicationIgnoresDroppedTables() throws Exception {
        this.testRegionReplicaReplicationIgnores(true, false);
    }

    @Test
    public void testRegionReplicaReplicationIgnoresNonReplicatedTables() throws Exception {
        this.testRegionReplicaReplicationIgnores(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionReplicaReplicationIgnores(boolean dropTable, boolean disableReplication) throws Exception {
        TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + "_drop_" + dropTable + "_disabledReplication_" + disableReplication));
        HTableDescriptor htd = HTU.createTableDescriptor(tableName);
        int regionReplication = 3;
        htd.setRegionReplication(regionReplication);
        HTU.deleteTableIfAny(tableName);
        HTU.getAdmin().createTable((TableDescriptor)htd);
        TableName toBeDisabledTable = TableName.valueOf((String)(dropTable ? "droppedTable" : (disableReplication ? "disableReplication" : "disabledTable")));
        HTU.deleteTableIfAny(toBeDisabledTable);
        htd = HTU.createTableDescriptor(toBeDisabledTable.toString());
        htd.setRegionReplication(regionReplication);
        HTU.getAdmin().createTable((TableDescriptor)htd);
        ReplicationAdmin admin = new ReplicationAdmin(HTU.getConfiguration());
        admin.disablePeer(ServerRegionReplicaUtil.getReplicationPeerId());
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        Table tableToBeDisabled = connection.getTable(toBeDisabledTable);
        HTU.loadNumericRows(tableToBeDisabled, HBaseTestingUtility.fam1, 6000, 7000);
        AtomicLong skippedEdits = new AtomicLong();
        RegionReplicaReplicationEndpoint.RegionReplicaOutputSink sink = (RegionReplicaReplicationEndpoint.RegionReplicaOutputSink)Mockito.mock(RegionReplicaReplicationEndpoint.RegionReplicaOutputSink.class);
        Mockito.when((Object)sink.getSkippedEditsCounter()).thenReturn((Object)skippedEdits);
        FSTableDescriptors fstd = new FSTableDescriptors(FileSystem.get((Configuration)HTU.getConfiguration()), HTU.getDefaultRootDirPath());
        RegionReplicaReplicationEndpoint.RegionReplicaSinkWriter sinkWriter = new RegionReplicaReplicationEndpoint.RegionReplicaSinkWriter(sink, (ClusterConnection)connection, Executors.newSingleThreadExecutor(), Integer.MAX_VALUE, (TableDescriptors)fstd);
        RegionLocator rl = connection.getRegionLocator(toBeDisabledTable);
        HRegionLocation hrl = rl.getRegionLocation(HConstants.EMPTY_BYTE_ARRAY);
        byte[] encodedRegionName = hrl.getRegionInfo().getEncodedNameAsBytes();
        Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(Bytes.toBytes((String)"A")).setFamily(HBaseTestingUtility.fam1).setValue(Bytes.toBytes((String)"VAL")).setType(Cell.Type.Put).build();
        WAL.Entry entry = new WAL.Entry(new WALKeyImpl(encodedRegionName, toBeDisabledTable, 1L), new WALEdit().add(cell));
        HTU.getAdmin().disableTable(toBeDisabledTable);
        if (dropTable) {
            HTU.getAdmin().deleteTable(toBeDisabledTable);
        } else if (disableReplication) {
            htd.setRegionReplication(regionReplication - 2);
            HTU.getAdmin().modifyTable(toBeDisabledTable, (TableDescriptor)htd);
            HTU.getAdmin().enableTable(toBeDisabledTable);
        }
        sinkWriter.append(toBeDisabledTable, encodedRegionName, HConstants.EMPTY_BYTE_ARRAY, (List)Lists.newArrayList((Object[])new WAL.Entry[]{entry, entry}));
        Assert.assertEquals((long)2L, (long)skippedEdits.get());
        if (disableReplication) {
            HTU.getAdmin().disableTable(toBeDisabledTable);
            htd.setRegionReplication(regionReplication);
            HTU.getAdmin().modifyTable(toBeDisabledTable, (TableDescriptor)htd);
            HTU.getAdmin().enableTable(toBeDisabledTable);
        }
        try {
            HTU.loadNumericRows(table, HBaseTestingUtility.fam1, 0, 1000);
            admin.enablePeer(ServerRegionReplicaUtil.getReplicationPeerId());
            this.verifyReplication(tableName, regionReplication, 0, 1000);
        }
        finally {
            admin.close();
            table.close();
            rl.close();
            tableToBeDisabled.close();
            HTU.deleteTableIfAny(toBeDisabledTable);
            connection.close();
        }
    }
}

