/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DeleteTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.DeleteTableState> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteTableProcedure.class);
    private List<RegionInfo> regions;
    private TableName tableName;

    public DeleteTableProcedure() {
    }

    public DeleteTableProcedure(MasterProcedureEnv env, TableName tableName) {
        this(env, tableName, null);
    }

    public DeleteTableProcedure(MasterProcedureEnv env, TableName tableName, ProcedurePrepareLatch syncLatch) {
        super(env, syncLatch);
        this.tableName = tableName;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.DeleteTableState state) throws InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " execute state=" + state);
        }
        try {
            switch (state) {
                case DELETE_TABLE_PRE_OPERATION: {
                    boolean deletable = this.prepareDelete(env);
                    this.releaseSyncLatch();
                    if (!deletable) {
                        assert (this.isFailed()) : "the delete should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    LOG.debug("Waiting for RIT for {}", (Object)this);
                    this.regions = env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.getTableName());
                    assert (this.regions != null && !this.regions.isEmpty()) : "unexpected 0 regions";
                    ProcedureSyncWait.waitRegionInTransition(env, this.regions);
                    this.preDelete(env);
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_CLEAR_FS_LAYOUT);
                    break;
                }
                case DELETE_TABLE_CLEAR_FS_LAYOUT: {
                    LOG.debug("Deleting regions from filesystem for {}", (Object)this);
                    DeleteTableProcedure.deleteFromFs(env, this.getTableName(), this.regions, true);
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_REMOVE_FROM_META);
                    break;
                }
                case DELETE_TABLE_REMOVE_FROM_META: {
                    LOG.debug("Deleting regions from META for {}", (Object)this);
                    DeleteTableProcedure.deleteFromMeta(env, this.getTableName(), this.regions);
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_UNASSIGN_REGIONS);
                    this.regions = null;
                    break;
                }
                case DELETE_TABLE_UNASSIGN_REGIONS: {
                    LOG.debug("Deleting assignment state for {}", (Object)this);
                    DeleteTableProcedure.deleteAssignmentState(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_POST_OPERATION);
                    break;
                }
                case DELETE_TABLE_POST_OPERATION: {
                    this.postDelete(env);
                    LOG.debug("Finished {}", (Object)this);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-delete-table", e);
            }
            LOG.warn("Retriable error trying to delete table=" + this.getTableName() + " state=" + state, (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected boolean abort(MasterProcedureEnv env) {
        return this.isRollbackSupported((MasterProcedureProtos.DeleteTableState)this.getCurrentState()) ? super.abort((Object)env) : false;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.DeleteTableState state) {
        if (state == MasterProcedureProtos.DeleteTableState.DELETE_TABLE_PRE_OPERATION) {
            this.releaseSyncLatch();
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.DeleteTableState state) {
        switch (state) {
            case DELETE_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.DeleteTableState getState(int stateId) {
        return MasterProcedureProtos.DeleteTableState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.DeleteTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.DeleteTableState getInitialState() {
        return MasterProcedureProtos.DeleteTableState.DELETE_TABLE_PRE_OPERATION;
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.DELETE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.DeleteTableStateData.Builder state = MasterProcedureProtos.DeleteTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName));
        if (this.regions != null) {
            for (RegionInfo hri : this.regions) {
                state.addRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)hri));
            }
        }
        serializer.serialize((Message)state.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.DeleteTableStateData state = (MasterProcedureProtos.DeleteTableStateData)serializer.deserialize(MasterProcedureProtos.DeleteTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(state.getUserInfo()));
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)state.getTableName());
        if (state.getRegionInfoCount() == 0) {
            this.regions = null;
        } else {
            this.regions = new ArrayList<RegionInfo>(state.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : state.getRegionInfoList()) {
                this.regions.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)hri));
            }
        }
    }

    private boolean prepareDelete(MasterProcedureEnv env) throws IOException {
        try {
            env.getMasterServices().checkTableModifiable(this.tableName);
        }
        catch (TableNotDisabledException | TableNotFoundException e) {
            this.setFailure("master-delete-table", e);
            return false;
        }
        return true;
    }

    private boolean preDelete(MasterProcedureEnv env) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            TableName tableName = this.tableName;
            cpHost.preDeleteTableAction(tableName, this.getUser());
        }
        return true;
    }

    private void postDelete(MasterProcedureEnv env) throws IOException, InterruptedException {
        DeleteTableProcedure.deleteTableStates(env, this.tableName);
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            TableName tableName = this.tableName;
            cpHost.postCompletedDeleteTableAction(tableName, this.getUser());
        }
    }

    protected static void deleteFromFs(MasterProcedureEnv env, TableName tableName, List<RegionInfo> regions, boolean archive) throws IOException {
        Path tableWALDir;
        Path mobTableDir;
        Path regionDir;
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        FileSystem fs = mfs.getFileSystem();
        Path tempdir = mfs.getTempDir();
        Path tableDir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        Path tempTableDir = CommonFSUtils.getTableDir((Path)tempdir, (TableName)tableName);
        if (fs.exists(tableDir)) {
            if (!fs.exists(tempdir) && !fs.mkdirs(tempdir)) {
                throw new IOException("HBase temp directory '" + tempdir + "' creation failure.");
            }
            if (!fs.exists(tempTableDir.getParent()) && !fs.mkdirs(tempTableDir.getParent())) {
                throw new IOException("HBase temp directory '" + tempdir + "' creation failure.");
            }
            if (fs.exists(tempTableDir)) {
                FileStatus[] files = fs.listStatus(tempTableDir);
                if (files != null && files.length > 0) {
                    List<Path> regionDirList = Arrays.stream(files).filter(FileStatus::isDirectory).map(FileStatus::getPath).collect(Collectors.toList());
                    HFileArchiver.archiveRegions(env.getMasterConfiguration(), fs, mfs.getRootDir(), tempTableDir, regionDirList);
                }
                fs.delete(tempTableDir, true);
            }
            if (!fs.rename(tableDir, tempTableDir)) {
                throw new IOException("Unable to move '" + tableDir + "' to temp '" + tempTableDir + "'");
            }
        }
        if (archive) {
            List<Path> regionDirList = regions.stream().filter(RegionReplicaUtil::isDefaultReplica).map(region -> FSUtils.getRegionDirFromTableDir(tempTableDir, region)).collect(Collectors.toList());
            HFileArchiver.archiveRegions(env.getMasterConfiguration(), fs, mfs.getRootDir(), tempTableDir, regionDirList);
            if (!regionDirList.isEmpty()) {
                LOG.debug("Archived {} regions", (Object)tableName);
            }
        }
        if (fs.exists(regionDir = new Path(mobTableDir = CommonFSUtils.getTableDir((Path)new Path(mfs.getRootDir(), "mobdir"), (TableName)tableName), MobUtils.getMobRegionInfo(tableName).getEncodedName()))) {
            HFileArchiver.archiveRegion(fs, mfs.getRootDir(), mobTableDir, regionDir);
        }
        if (!fs.delete(tempTableDir, true) && fs.exists(tempTableDir)) {
            throw new IOException("Couldn't delete " + tempTableDir);
        }
        if (mobTableDir != null && fs.exists(mobTableDir) && !fs.delete(mobTableDir, true)) {
            throw new IOException("Couldn't delete mob dir " + mobTableDir);
        }
        FileSystem walFs = mfs.getWALFileSystem();
        if (walFs.exists(tableWALDir = CommonFSUtils.getWALTableDir((Configuration)env.getMasterConfiguration(), (TableName)tableName)) && !walFs.delete(tableWALDir, true)) {
            throw new IOException("Couldn't delete table dir on wal filesystem" + tableWALDir);
        }
    }

    private static void cleanRegionsInMeta(MasterProcedureEnv env, TableName tableName) throws IOException {
        Connection connection = env.getMasterServices().getConnection();
        Scan tableScan = MetaTableAccessor.getScanForTableName((Connection)connection, (TableName)tableName);
        try (Table metaTable = connection.getTable(TableName.META_TABLE_NAME);){
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            try (ResultScanner resScanner = metaTable.getScanner(tableScan);){
                for (Result result : resScanner) {
                    deletes.add(new Delete(result.getRow()));
                }
            }
            if (!deletes.isEmpty()) {
                LOG.warn("Deleting some vestigial " + deletes.size() + " rows of " + tableName + " from " + TableName.META_TABLE_NAME);
                metaTable.delete(deletes);
            }
        }
    }

    protected static void deleteFromMeta(MasterProcedureEnv env, TableName tableName, List<RegionInfo> regions) throws IOException {
        DeleteTableProcedure.cleanRegionsInMeta(env, tableName);
        env.getMasterServices().getServerManager().removeRegions(regions);
        FavoredNodesManager fnm = env.getMasterServices().getFavoredNodesManager();
        if (fnm != null) {
            fnm.deleteFavoredNodesForRegions(regions);
        }
        DeleteTableProcedure.deleteTableDescriptorCache(env, tableName);
    }

    protected static void deleteAssignmentState(MasterProcedureEnv env, TableName tableName) throws IOException {
        LOG.debug("Removing '" + tableName + "' from region states.");
        env.getMasterServices().getAssignmentManager().deleteTable(tableName);
        LOG.debug("Marking '" + tableName + "' as deleted.");
        env.getMasterServices().getTableStateManager().setDeletedTable(tableName);
    }

    protected static void deleteTableDescriptorCache(MasterProcedureEnv env, TableName tableName) throws IOException {
        LOG.debug("Removing '" + tableName + "' descriptor.");
        env.getMasterServices().getTableDescriptors().remove(tableName);
    }

    protected static void deleteTableStates(MasterProcedureEnv env, TableName tableName) throws IOException {
        if (!tableName.isSystemTable()) {
            ProcedureSyncWait.getMasterQuotaManager(env).removeTableFromNamespaceQuota(tableName);
        }
    }
}

