/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class InitMetaProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.InitMetaState> {
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public TableName getTableName() {
        return TableName.META_TABLE_NAME;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.CREATE;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.InitMetaState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        switch (state) {
            case INIT_META_ASSIGN_META: {
                this.addChildProcedure((Procedure[])env.getAssignmentManager().createAssignProcedures(Arrays.asList(RegionInfoBuilder.FIRST_META_REGIONINFO)));
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        return false;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.InitMetaState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected MasterProcedureProtos.InitMetaState getState(int stateId) {
        return MasterProcedureProtos.InitMetaState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.InitMetaState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.InitMetaState getInitialState() {
        return MasterProcedureProtos.InitMetaState.INIT_META_ASSIGN_META;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.InitMetaStateData.getDefaultInstance());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        serializer.deserialize(MasterProcedureProtos.InitMetaStateData.class);
    }

    protected void completionCleanup(MasterProcedureEnv env) {
        this.latch.countDown();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }
}

