/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.slowlog;

import com.lmax.disruptor.EventHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.SlowLogParams;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.regionserver.slowlog.LogHandlerUtils;
import org.apache.hadoop.hbase.regionserver.slowlog.RingBufferEnvelope;
import org.apache.hadoop.hbase.regionserver.slowlog.RpcLogDetails;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.slowlog.SlowLogTableAccessor;
import org.apache.hbase.thirdparty.com.google.common.collect.EvictingQueue;
import org.apache.hbase.thirdparty.com.google.common.collect.Queues;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class LogEventHandler
implements EventHandler<RingBufferEnvelope> {
    private static final Logger LOG = LoggerFactory.getLogger(LogEventHandler.class);
    private static final String SYS_TABLE_QUEUE_SIZE = "hbase.regionserver.slowlog.systable.queue.size";
    private static final int DEFAULT_SYS_TABLE_QUEUE_SIZE = 1000;
    private static final int SYSTABLE_PUT_BATCH_SIZE = 100;
    private final Queue<TooSlowLog.SlowLogPayload> queueForRingBuffer;
    private final Queue<TooSlowLog.SlowLogPayload> queueForSysTable;
    private final boolean isSlowLogTableEnabled;
    private Configuration configuration;
    private static final ReentrantLock LOCK = new ReentrantLock();

    LogEventHandler(int eventCount, boolean isSlowLogTableEnabled, Configuration conf) {
        this.configuration = conf;
        EvictingQueue evictingQueue = EvictingQueue.create((int)eventCount);
        this.queueForRingBuffer = Queues.synchronizedQueue((Queue)evictingQueue);
        this.isSlowLogTableEnabled = isSlowLogTableEnabled;
        if (isSlowLogTableEnabled) {
            int sysTableQueueSize = conf.getInt(SYS_TABLE_QUEUE_SIZE, 1000);
            EvictingQueue evictingQueueForTable = EvictingQueue.create((int)sysTableQueueSize);
            this.queueForSysTable = Queues.synchronizedQueue((Queue)evictingQueueForTable);
        } else {
            this.queueForSysTable = null;
        }
    }

    public void onEvent(RingBufferEnvelope event, long sequence, boolean endOfBatch) throws Exception {
        RpcLogDetails rpcCallDetails = event.getPayload();
        RpcCall rpcCall = rpcCallDetails.getRpcCall();
        String clientAddress = rpcCallDetails.getClientAddress();
        long responseSize = rpcCallDetails.getResponseSize();
        String className = rpcCallDetails.getClassName();
        TooSlowLog.SlowLogPayload.Type type = this.getLogType(rpcCallDetails);
        if (type == null) {
            return;
        }
        Descriptors.MethodDescriptor methodDescriptor = rpcCall.getMethod();
        Message param = rpcCallDetails.getParam();
        long receiveTime = rpcCall.getReceiveTime();
        long startTime = rpcCall.getStartTime();
        long endTime = System.currentTimeMillis();
        int processingTime = (int)(endTime - startTime);
        int qTime = (int)(startTime - receiveTime);
        SlowLogParams slowLogParams = ProtobufUtil.getSlowLogParams((Message)param);
        int numGets = 0;
        int numMutations = 0;
        int numServiceCalls = 0;
        if (param instanceof ClientProtos.MultiRequest) {
            ClientProtos.MultiRequest multi = (ClientProtos.MultiRequest)param;
            for (ClientProtos.RegionAction regionAction : multi.getRegionActionList()) {
                for (ClientProtos.Action action : regionAction.getActionList()) {
                    if (action.hasMutation()) {
                        ++numMutations;
                    }
                    if (action.hasGet()) {
                        ++numGets;
                    }
                    if (!action.hasServiceCall()) continue;
                    ++numServiceCalls;
                }
            }
        }
        String userName = rpcCall.getRequestUserName().orElse("");
        String methodDescriptorName = methodDescriptor != null ? methodDescriptor.getName() : "";
        TooSlowLog.SlowLogPayload slowLogPayload = TooSlowLog.SlowLogPayload.newBuilder().setCallDetails(methodDescriptorName + "(" + param.getClass().getName() + ")").setClientAddress(clientAddress).setMethodName(methodDescriptorName).setMultiGets(numGets).setMultiMutations(numMutations).setMultiServiceCalls(numServiceCalls).setParam(slowLogParams != null ? slowLogParams.getParams() : "").setProcessingTime(processingTime).setQueueTime(qTime).setRegionName(slowLogParams != null ? slowLogParams.getRegionName() : "").setResponseSize(responseSize).setServerClass(className).setStartTime(startTime).setType(type).setUserName(userName).build();
        this.queueForRingBuffer.add(slowLogPayload);
        if (this.isSlowLogTableEnabled && !slowLogPayload.getRegionName().startsWith("hbase:slowlog")) {
            this.queueForSysTable.add(slowLogPayload);
        }
    }

    private TooSlowLog.SlowLogPayload.Type getLogType(RpcLogDetails rpcCallDetails) {
        boolean isSlowLog = rpcCallDetails.isSlowLog();
        boolean isLargeLog = rpcCallDetails.isLargeLog();
        if (!isSlowLog && !isLargeLog) {
            LOG.error("slowLog and largeLog both are false. Ignoring the event. rpcCallDetails: {}", (Object)rpcCallDetails);
            return null;
        }
        TooSlowLog.SlowLogPayload.Type type = isSlowLog && isLargeLog ? TooSlowLog.SlowLogPayload.Type.ALL : (isSlowLog ? TooSlowLog.SlowLogPayload.Type.SLOW_LOG : TooSlowLog.SlowLogPayload.Type.LARGE_LOG);
        return type;
    }

    boolean clearSlowLogs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received request to clean up online slowlog buffer..");
        }
        this.queueForRingBuffer.clear();
        return true;
    }

    List<TooSlowLog.SlowLogPayload> getSlowLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        List<TooSlowLog.SlowLogPayload> slowLogPayloadList = Arrays.stream(this.queueForRingBuffer.toArray(new TooSlowLog.SlowLogPayload[0])).filter(e -> e.getType() == TooSlowLog.SlowLogPayload.Type.ALL || e.getType() == TooSlowLog.SlowLogPayload.Type.SLOW_LOG).collect(Collectors.toList());
        Collections.reverse(slowLogPayloadList);
        return LogHandlerUtils.getFilteredLogs(request, slowLogPayloadList);
    }

    List<TooSlowLog.SlowLogPayload> getLargeLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        List<TooSlowLog.SlowLogPayload> slowLogPayloadList = Arrays.stream(this.queueForRingBuffer.toArray(new TooSlowLog.SlowLogPayload[0])).filter(e -> e.getType() == TooSlowLog.SlowLogPayload.Type.ALL || e.getType() == TooSlowLog.SlowLogPayload.Type.LARGE_LOG).collect(Collectors.toList());
        Collections.reverse(slowLogPayloadList);
        return LogHandlerUtils.getFilteredLogs(request, slowLogPayloadList);
    }

    void addAllLogsToSysTable() {
        if (this.queueForSysTable == null) {
            return;
        }
        if (LOCK.isLocked()) {
            return;
        }
        LOCK.lock();
        try {
            ArrayList<TooSlowLog.SlowLogPayload> slowLogPayloads = new ArrayList<TooSlowLog.SlowLogPayload>();
            int i = 0;
            while (!this.queueForSysTable.isEmpty()) {
                slowLogPayloads.add(this.queueForSysTable.poll());
                if (++i != 100) continue;
                SlowLogTableAccessor.addSlowLogRecords(slowLogPayloads, (Configuration)this.configuration);
                slowLogPayloads.clear();
                i = 0;
            }
            if (slowLogPayloads.size() > 0) {
                SlowLogTableAccessor.addSlowLogRecords(slowLogPayloads, (Configuration)this.configuration);
            }
        }
        finally {
            LOCK.unlock();
        }
    }
}

