/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMalformedCellFromClient {
    private static final Logger LOG = LoggerFactory.getLogger(TestMalformedCellFromClient.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMalformedCellFromClient.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static final int CELL_SIZE = 100;
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestMalformedCellFromClient");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 0);
        TEST_UTIL.startMiniCluster(1);
    }

    @Before
    public void before() throws Exception {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setValue("hbase.server.keyvalue.maxsize", String.valueOf(100)).build();
        TEST_UTIL.getConnection().getAdmin().createTable(desc);
    }

    @After
    public void tearDown() throws Exception {
        for (TableDescriptor htd : TEST_UTIL.getAdmin().listTableDescriptors()) {
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRegionException() throws InterruptedException, IOException {
        ArrayList<Object> batches = new ArrayList<Object>();
        batches.add(new Put(Bytes.toBytes((String)"good")).addColumn(FAMILY, null, new byte[10]));
        RowMutations rm = new RowMutations(Bytes.toBytes((String)"fail"));
        rm.add(new Put(rm.getRow()).addColumn(FAMILY, null, new byte[100]));
        batches.add(rm);
        Object[] results = new Object[batches.size()];
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            Throwable exceptionByCaught = null;
            try {
                table.batch(batches, results);
                Assert.fail((String)"Where is the exception? We put the malformed cells!!!");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                for (Throwable throwable : e.getCauses()) {
                    Assert.assertNotNull((Object)throwable);
                }
                Assert.assertEquals((long)1L, (long)e.getNumExceptions());
                exceptionByCaught = e.getCause(0);
            }
            for (Object obj : results) {
                Assert.assertNotNull((Object)obj);
            }
            Assert.assertEquals(Result.class, results[0].getClass());
            Assert.assertEquals(exceptionByCaught.getClass(), results[1].getClass());
            Result result = table.get(new Get(Bytes.toBytes((String)"good")));
            Assert.assertEquals((long)1L, (long)result.size());
            Cell cell = result.getColumnLatestCell(FAMILY, null);
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)cell), (byte[])new byte[10]));
        }
    }

    @Test
    public void testRegionExceptionByAsync() throws Exception {
        ArrayList<Object> batches = new ArrayList<Object>();
        batches.add(new Put(Bytes.toBytes((String)"good")).addColumn(FAMILY, null, new byte[10]));
        RowMutations rm = new RowMutations(Bytes.toBytes((String)"fail"));
        rm.add(new Put(rm.getRow()).addColumn(FAMILY, null, new byte[100]));
        batches.add(rm);
        try (AsyncConnection asyncConnection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();){
            AsyncTable table = asyncConnection.getTable(TABLE_NAME);
            List results = table.batch(batches);
            Assert.assertEquals((long)2L, (long)results.size());
            try {
                ((CompletableFuture)results.get(1)).get();
                Assert.fail((String)"Where is the exception? We put the malformed cells!!!");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            Result result = (Result)table.get(new Get(Bytes.toBytes((String)"good"))).get();
            Assert.assertEquals((long)1L, (long)result.size());
            Cell cell = result.getColumnLatestCell(FAMILY, null);
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)cell), (byte[])new byte[10]));
        }
    }

    @Test
    public void testAtomicOperations() throws Exception {
        RowMutations rm = new RowMutations(Bytes.toBytes((String)"fail"));
        rm.add(new Put(rm.getRow()).addColumn(FAMILY, null, new byte[100]));
        rm.add(new Put(rm.getRow()).addColumn(FAMILY, null, new byte[10]));
        Put put = new Put(Bytes.toBytes((String)"good")).addColumn(FAMILY, null, new byte[10]);
        HRegion r = TEST_UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        ClientProtos.MultiRequest request = ClientProtos.MultiRequest.newBuilder((ClientProtos.MultiRequest)TestMalformedCellFromClient.createRequest(rm, r.getRegionInfo().getRegionName())).addRegionAction(ClientProtos.RegionAction.newBuilder().setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])r.getRegionInfo().getRegionName())).addAction(ClientProtos.Action.newBuilder().setMutation(ProtobufUtil.toMutationNoData((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)put)))).build();
        ArrayList cells = new ArrayList();
        for (Mutation m : rm.getMutations()) {
            cells.addAll(m.getCellList(FAMILY));
        }
        cells.addAll(put.getCellList(FAMILY));
        Assert.assertEquals((long)3L, (long)cells.size());
        HBaseRpcController controller = (HBaseRpcController)Mockito.mock(HBaseRpcController.class);
        Mockito.when((Object)controller.cellScanner()).thenReturn((Object)CellUtil.createCellScanner(cells));
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(TEST_UTIL.getMiniHBaseCluster().getServerHoldingRegion(TABLE_NAME, r.getRegionInfo().getRegionName()));
        ClientProtos.MultiResponse response = rs.getRSRpcServices().multi((RpcController)controller, request);
        Assert.assertEquals((long)2L, (long)response.getRegionActionResultCount());
        Assert.assertTrue((boolean)((ClientProtos.RegionActionResult)response.getRegionActionResultList().get(0)).hasException());
        Assert.assertFalse((boolean)((ClientProtos.RegionActionResult)response.getRegionActionResultList().get(1)).hasException());
        Assert.assertEquals((long)1L, (long)((ClientProtos.RegionActionResult)response.getRegionActionResultList().get(1)).getResultOrExceptionCount());
        Assert.assertTrue((boolean)((ClientProtos.ResultOrException)((ClientProtos.RegionActionResult)response.getRegionActionResultList().get(1)).getResultOrExceptionList().get(0)).hasResult());
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            Result result = table.get(new Get(Bytes.toBytes((String)"good")));
            Assert.assertEquals((long)1L, (long)result.size());
            Cell cell = result.getColumnLatestCell(FAMILY, null);
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)cell), (byte[])new byte[10]));
        }
    }

    private static ClientProtos.MultiRequest createRequest(RowMutations rm, byte[] regionName) throws IOException {
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion((ClientProtos.RegionAction.Builder)ClientProtos.RegionAction.newBuilder(), (byte[])regionName);
        builder.setAtomic(true);
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        ClientProtos.Condition condition = RequestConverter.buildCondition((byte[])rm.getRow(), (byte[])FAMILY, null, (CompareOperator)CompareOperator.EQUAL, (byte[])new byte[10], null, null);
        for (Mutation mutation : rm.getMutations()) {
            ClientProtos.MutationProto.MutationType mutateType = null;
            if (mutation instanceof Put) {
                mutateType = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                mutateType = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            mutationBuilder.clear();
            ClientProtos.MutationProto mp = ProtobufUtil.toMutationNoData((ClientProtos.MutationProto.MutationType)mutateType, (Mutation)mutation, (ClientProtos.MutationProto.Builder)mutationBuilder);
            actionBuilder.clear();
            actionBuilder.setMutation(mp);
            builder.addAction(actionBuilder.build());
        }
        ClientProtos.MultiRequest request = ClientProtos.MultiRequest.newBuilder().addRegionAction(builder.setCondition(condition).build()).build();
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAtomicOperations() throws InterruptedException, IOException {
        Increment inc = new Increment(Bytes.toBytes((String)"good")).addColumn(FAMILY, null, 100L);
        ArrayList<Object> batches = new ArrayList<Object>();
        batches.add(new Put(Bytes.toBytes((String)"fail")).addColumn(FAMILY, null, new byte[100]));
        batches.add(new Put(Bytes.toBytes((String)"fail")).addColumn(FAMILY, null, new byte[100]));
        batches.add(inc);
        batches.add(new Put(Bytes.toBytes((String)"good")).addColumn(FAMILY, null, new byte[1]));
        Object[] objs = new Object[batches.size()];
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            table.batch(batches, objs);
            Assert.fail((String)"Where is the exception? We put the malformed cells!!!");
        }
        catch (RetriesExhaustedWithDetailsException e) {
            Assert.assertEquals((long)2L, (long)e.getNumExceptions());
            for (int i = 0; i != e.getNumExceptions(); ++i) {
                Assert.assertNotNull((Object)e.getCause(i));
                Assert.assertEquals(DoNotRetryIOException.class, e.getCause(i).getClass());
                Assert.assertEquals((Object)"fail", (Object)Bytes.toString((byte[])e.getRow(i).getRow()));
            }
        }
        finally {
            TestMalformedCellFromClient.assertObjects(objs, batches.size());
            Assert.assertTrue((boolean)(objs[0] instanceof IOException));
            Assert.assertTrue((boolean)(objs[1] instanceof IOException));
            Assert.assertEquals(Result.class, objs[2].getClass());
            Assert.assertEquals(Result.class, objs[3].getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowMutations() throws InterruptedException, IOException {
        Put put = new Put(Bytes.toBytes((String)"good")).addColumn(FAMILY, null, new byte[1]);
        ArrayList<RowMutations> batches = new ArrayList<RowMutations>();
        RowMutations mutations = new RowMutations(Bytes.toBytes((String)"fail"));
        mutations.add(new Put(Bytes.toBytes((String)"fail")).addColumn(FAMILY, null, new byte[100]));
        mutations.add(new Put(Bytes.toBytes((String)"fail")).addColumn(FAMILY, null, new byte[100]));
        batches.add(mutations);
        mutations = new RowMutations(Bytes.toBytes((String)"good"));
        mutations.add(put);
        mutations.add(put);
        batches.add(mutations);
        Object[] objs = new Object[batches.size()];
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            table.batch(batches, objs);
            Assert.fail((String)"Where is the exception? We put the malformed cells!!!");
        }
        catch (RetriesExhaustedWithDetailsException e) {
            Assert.assertEquals((long)1L, (long)e.getNumExceptions());
            for (int i = 0; i != e.getNumExceptions(); ++i) {
                Assert.assertNotNull((Object)e.getCause(i));
                Assert.assertTrue((boolean)(e.getCause(i) instanceof IOException));
                Assert.assertEquals((Object)"fail", (Object)Bytes.toString((byte[])e.getRow(i).getRow()));
            }
        }
        finally {
            TestMalformedCellFromClient.assertObjects(objs, batches.size());
            Assert.assertTrue((boolean)(objs[0] instanceof IOException));
            Assert.assertEquals(Result.class, objs[1].getClass());
        }
    }

    private static void assertObjects(Object[] objs, int expectedSize) {
        int count = 0;
        for (Object obj : objs) {
            Assert.assertNotNull((Object)obj);
            ++count;
        }
        Assert.assertEquals((long)expectedSize, (long)count);
    }
}

