/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.ZKConnectionRegistry;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, MediumTests.class})
public class TestSeparateClientZKCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestSeparateClientZKCluster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final File clientZkDir = new File(TEST_UTIL.getDataTestDir("TestSeparateClientZKCluster").toString());
    private static final int ZK_SESSION_TIMEOUT = 5000;
    private static MiniZooKeeperCluster clientZkCluster;
    private final byte[] family = Bytes.toBytes((String)"cf");
    private final byte[] qualifier = Bytes.toBytes((String)"c1");
    private final byte[] row = Bytes.toBytes((String)"row");
    private final byte[] value = Bytes.toBytes((String)"v1");
    private final byte[] newVal = Bytes.toBytes((String)"v2");
    @Rule
    public TableNameTestRule name = new TableNameTestRule();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        int clientZkPort = 21828;
        clientZkCluster = new MiniZooKeeperCluster(TEST_UTIL.getConfiguration());
        clientZkCluster.setDefaultClientPort(clientZkPort);
        clientZkCluster.startup(clientZkDir);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", -1);
        TEST_UTIL.getConfiguration().setInt("zookeeper.recovery.retry", 1);
        TEST_UTIL.getConfiguration().setClass("hbase.client.registry.impl", ZKConnectionRegistry.class, ConnectionRegistry.class);
        TEST_UTIL.getConfiguration().set("hbase.client.zookeeper.quorum", "localhost");
        TEST_UTIL.getConfiguration().setInt("hbase.client.zookeeper.property.clientPort", clientZkPort);
        TEST_UTIL.getConfiguration().setInt("zookeeper.session.timeout", 5000);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(2).numRegionServers(3).numDataNodes(3).build();
        TEST_UTIL.startMiniCluster(option);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        clientZkCluster.shutdown();
        FileUtils.deleteDirectory((File)clientZkDir);
    }

    @Test
    public void testBasicOperation() throws Exception {
        TableName tn = this.name.getTableName();
        Connection conn = TEST_UTIL.getConnection();
        try (Admin admin = conn.getAdmin();
             Table table = conn.getTable(tn);){
            ColumnFamilyDescriptorBuilder cfDescBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family);
            TableDescriptorBuilder tableDescBuilder = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(cfDescBuilder.build());
            admin.createTable(tableDescBuilder.build());
            Put put = new Put(this.row);
            put.addColumn(this.family, this.qualifier, this.value);
            table.put(put);
            Get get = new Get(this.row);
            Result result = table.get(get);
            LOG.debug("Result: " + Bytes.toString((byte[])result.getValue(this.family, this.qualifier)));
            Assert.assertArrayEquals((byte[])this.value, (byte[])result.getValue(this.family, this.qualifier));
        }
    }

    @Test
    public void testMasterSwitch() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        try (Admin admin = conn.getAdmin();){
            LOG.debug("Tables: " + admin.listTableDescriptors());
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            HMaster master = cluster.getMaster();
            master.stopMaster();
            LOG.info("Stopped master {}", (Object)master.getServerName());
            while (!master.isShutDown()) {
                Thread.sleep(200L);
            }
            LOG.info("Shutdown master {}", (Object)master.getServerName());
            while (cluster.getMaster() == null || !cluster.getMaster().isInitialized()) {
                LOG.info("Get master {}", (Object)(cluster.getMaster() == null ? "null" : cluster.getMaster().getServerName()));
                Thread.sleep(200L);
            }
            LOG.info("Got master {}", (Object)cluster.getMaster().getServerName());
            Assert.assertTrue((boolean)admin.balance(false));
        }
    }

    @Test
    public void testMetaRegionMove() throws Exception {
        TableName tn = this.name.getTableName();
        Connection conn = TEST_UTIL.getConnection();
        try (Admin admin = conn.getAdmin();
             Table table = conn.getTable(tn);
             RegionLocator locator = conn.getRegionLocator(tn);){
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            ColumnFamilyDescriptorBuilder cfDescBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family);
            TableDescriptorBuilder tableDescBuilder = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(cfDescBuilder.build());
            admin.createTable(tableDescBuilder.build());
            Put put = new Put(this.row);
            put.addColumn(this.family, this.qualifier, this.value);
            table.put(put);
            Get get = new Get(this.row);
            Result result = table.get(get);
            ServerName destServerName = null;
            for (JVMClusterUtil.RegionServerThread rst : cluster.getLiveRegionServerThreads()) {
                ServerName name = rst.getRegionServer().getServerName();
                if (name.equals((Object)cluster.getServerHoldingMeta())) continue;
                destServerName = name;
                break;
            }
            admin.move(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), destServerName);
            LOG.debug("Finished moving meta");
            RegionInfo region = locator.getRegionLocation(this.row).getRegion();
            ServerName currentServer = cluster.getServerHoldingRegion(tn, region.getRegionName());
            for (JVMClusterUtil.RegionServerThread rst : cluster.getLiveRegionServerThreads()) {
                ServerName name = rst.getRegionServer().getServerName();
                if (name.equals((Object)currentServer)) continue;
                destServerName = name;
                break;
            }
            admin.move(region.getEncodedNameAsBytes(), destServerName);
            LOG.debug("Finished moving user region");
            put = new Put(this.row);
            put.addColumn(this.family, this.qualifier, this.newVal);
            table.put(put);
            result = table.get(get);
            LOG.debug("Result: " + Bytes.toString((byte[])result.getValue(this.family, this.qualifier)));
            Assert.assertArrayEquals((byte[])this.newVal, (byte[])result.getValue(this.family, this.qualifier));
        }
    }

    @Test
    public void testMetaMoveDuringClientZkClusterRestart() throws Exception {
        TableName tn = this.name.getTableName();
        Connection conn = TEST_UTIL.getConnection();
        try (Admin admin = conn.getAdmin();
             Table table = conn.getTable(tn);){
            ColumnFamilyDescriptorBuilder cfDescBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family);
            TableDescriptorBuilder tableDescBuilder = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(cfDescBuilder.build());
            admin.createTable(tableDescBuilder.build());
            Put put = new Put(this.row);
            put.addColumn(this.family, this.qualifier, this.value);
            table.put(put);
            conn.clearRegionLocationCache();
            clientZkCluster.shutdown();
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            int metaServerId = cluster.getServerWithMeta();
            HRegionServer metaServer = cluster.getRegionServer(metaServerId);
            metaServer.stop("Stop current RS holding meta region");
            while (!metaServer.isShutDown()) {
                Thread.sleep(200L);
            }
            AssignmentTestingUtil.waitForAssignment(cluster.getMaster().getAssignmentManager(), RegionInfoBuilder.FIRST_META_REGIONINFO);
            Thread.sleep(10000L);
            clientZkCluster.startup(clientZkDir);
            Get get = new Get(this.row);
            Result result = table.get(get);
            LOG.debug("Result: " + Bytes.toString((byte[])result.getValue(this.family, this.qualifier)));
            Assert.assertArrayEquals((byte[])this.value, (byte[])result.getValue(this.family, this.qualifier));
        }
    }

    @Test
    public void testAsyncTable() throws Exception {
        TableName tn = this.name.getTableName();
        ColumnFamilyDescriptorBuilder cfDescBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family);
        TableDescriptorBuilder tableDescBuilder = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(cfDescBuilder.build());
        try (AsyncConnection ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();){
            ASYNC_CONN.getAdmin().createTable(tableDescBuilder.build()).get();
            AsyncTable table = ASYNC_CONN.getTable(tn);
            Put put = new Put(this.row);
            put.addColumn(this.family, this.qualifier, this.value);
            table.put(put).get();
            Get get = new Get(this.row);
            Result result = (Result)table.get(get).get();
            LOG.debug("Result: " + Bytes.toString((byte[])result.getValue(this.family, this.qualifier)));
            Assert.assertArrayEquals((byte[])this.value, (byte[])result.getValue(this.family, this.qualifier));
        }
    }

    @Test
    public void testChangeMetaReplicaCount() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(TableName.META_TABLE_NAME);){
            Assert.assertEquals((long)1L, (long)locator.getAllRegionLocations().size());
            HBaseTestingUtility.setReplicas(admin, TableName.META_TABLE_NAME, 3);
            TEST_UTIL.waitFor(30000L, () -> locator.getAllRegionLocations().size() == 3);
            HBaseTestingUtility.setReplicas(admin, TableName.META_TABLE_NAME, 2);
            TEST_UTIL.waitFor(30000L, () -> locator.getAllRegionLocations().size() == 2);
            HBaseTestingUtility.setReplicas(admin, TableName.META_TABLE_NAME, 1);
            TEST_UTIL.waitFor(30000L, () -> locator.getAllRegionLocations().size() == 1);
        }
    }

    static {
        CLASS_RULE = HBaseClassTestRule.forClass(TestSeparateClientZKCluster.class);
    }
}

