/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.lang.reflect.Field;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.HbckChore;
import org.apache.hadoop.hbase.master.balancer.BalancerChore;
import org.apache.hadoop.hbase.master.balancer.ClusterStatusChore;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.cleaner.ReplicationBarrierCleaner;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterChoreScheduled {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterChoreScheduled.class);
    private static HMaster hMaster;
    private static final HBaseTestingUtility UTIL;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(StartMiniClusterOption.builder().numRegionServers(1).build());
        hMaster = UTIL.getMiniHBaseCluster().getMaster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testDefaultScheduledChores() {
        TestChoreField logCleanerTestChoreField = new TestChoreField();
        LogCleaner logCleaner = (LogCleaner)logCleanerTestChoreField.getChoreObj("logCleaner");
        logCleanerTestChoreField.testIfChoreScheduled((ScheduledChore)logCleaner);
        TestChoreField hFileCleanerTestChoreField = new TestChoreField();
        HFileCleaner hFileCleaner = (HFileCleaner)hFileCleanerTestChoreField.getChoreObj("hfileCleaner");
        hFileCleanerTestChoreField.testIfChoreScheduled((ScheduledChore)hFileCleaner);
        TestChoreField replicationBarrierCleanerTestChoreField = new TestChoreField();
        ReplicationBarrierCleaner replicationBarrierCleaner = (ReplicationBarrierCleaner)replicationBarrierCleanerTestChoreField.getChoreObj("replicationBarrierCleaner");
        replicationBarrierCleanerTestChoreField.testIfChoreScheduled((ScheduledChore)replicationBarrierCleaner);
        TestChoreField clusterStatusChoreTestChoreField = new TestChoreField();
        ClusterStatusChore clusterStatusChore = (ClusterStatusChore)clusterStatusChoreTestChoreField.getChoreObj("clusterStatusChore");
        clusterStatusChoreTestChoreField.testIfChoreScheduled((ScheduledChore)clusterStatusChore);
        TestChoreField balancerChoreTestChoreField = new TestChoreField();
        BalancerChore balancerChore = (BalancerChore)balancerChoreTestChoreField.getChoreObj("balancerChore");
        balancerChoreTestChoreField.testIfChoreScheduled((ScheduledChore)balancerChore);
        ScheduledChore regionNormalizerChore = hMaster.getRegionNormalizerManager().getRegionNormalizerChore();
        TestChoreField regionNormalizerChoreTestChoreField = new TestChoreField();
        regionNormalizerChoreTestChoreField.testIfChoreScheduled(regionNormalizerChore);
        TestChoreField catalogJanitorTestChoreField = new TestChoreField();
        CatalogJanitor catalogJanitor = (CatalogJanitor)catalogJanitorTestChoreField.getChoreObj("catalogJanitorChore");
        catalogJanitorTestChoreField.testIfChoreScheduled((ScheduledChore)catalogJanitor);
        TestChoreField hbckChoreTestChoreField = new TestChoreField();
        HbckChore hbckChore = (HbckChore)hbckChoreTestChoreField.getChoreObj("hbckChore");
        hbckChoreTestChoreField.testIfChoreScheduled((ScheduledChore)hbckChore);
    }

    static {
        UTIL = new HBaseTestingUtility();
    }

    private static class TestChoreField<E extends ScheduledChore> {
        private TestChoreField() {
        }

        private E getChoreObj(String fieldName) {
            try {
                Field masterField = HMaster.class.getDeclaredField(fieldName);
                masterField.setAccessible(true);
                return (E)((ScheduledChore)masterField.get(hMaster));
            }
            catch (Exception e) {
                throw new AssertionError("Unable to retrieve field '" + fieldName + "' from HMaster instance.", e);
            }
        }

        private void testIfChoreScheduled(E choreObj) {
            Assert.assertNotNull(choreObj);
            Assert.assertTrue((boolean)hMaster.getChoreService().isChoreScheduled(choreObj));
        }
    }
}

