/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorkQueue;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorker;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionNormalizerWorker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionNormalizerWorker.class);
    @Rule
    public TestName testName = new TestName();
    @Rule
    public TableNameTestRule tableName = new TableNameTestRule();
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MasterServices masterServices;
    @Mock
    private RegionNormalizer regionNormalizer;
    private HBaseCommonTestingUtility testingUtility;
    private RegionNormalizerWorkQueue<TableName> queue;
    private ExecutorService workerPool;
    private final AtomicReference<Throwable> workerThreadThrowable = new AtomicReference();

    @Before
    public void before() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.masterServices.skipRegionManagementAction((String)ArgumentMatchers.any())).thenReturn((Object)false);
        this.testingUtility = new HBaseCommonTestingUtility();
        this.queue = new RegionNormalizerWorkQueue();
        this.workerThreadThrowable.set(null);
        String threadNameFmt = TestRegionNormalizerWorker.class.getSimpleName() + "-" + this.testName.getMethodName() + "-%d";
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFmt).setDaemon(true).setUncaughtExceptionHandler((t, e) -> this.workerThreadThrowable.set(e)).build();
        this.workerPool = Executors.newSingleThreadExecutor(threadFactory);
    }

    @After
    public void after() throws Exception {
        this.workerPool.shutdownNow();
        Assert.assertTrue((String)"timeout waiting for worker thread to terminate", (boolean)this.workerPool.awaitTermination(30L, TimeUnit.SECONDS));
        Throwable workerThrowable = this.workerThreadThrowable.get();
        MatcherAssert.assertThat((String)"worker thread threw unexpected exception", (Object)workerThrowable, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testMergeCounter() throws Exception {
        TableName tn = this.tableName.getTableName();
        TableDescriptor tnDescriptor = TableDescriptorBuilder.newBuilder((TableName)tn).setNormalizationEnabled(true).build();
        Mockito.when((Object)this.masterServices.getTableDescriptors().get(tn)).thenReturn((Object)tnDescriptor);
        Mockito.when((Object)this.masterServices.mergeRegions((RegionInfo[])ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)1L);
        Mockito.when((Object)this.regionNormalizer.computePlansForTable(tn)).thenReturn(Collections.singletonList(new MergeNormalizationPlan.Builder().addTarget(RegionInfoBuilder.newBuilder((TableName)tn).build(), 10L).addTarget(RegionInfoBuilder.newBuilder((TableName)tn).build(), 20L).build()));
        RegionNormalizerWorker worker = new RegionNormalizerWorker(this.testingUtility.getConfiguration(), this.masterServices, this.regionNormalizer, this.queue);
        long beforeMergePlanCount = worker.getMergePlanCount();
        this.workerPool.submit((Runnable)worker);
        this.queue.put((Object)tn);
        this.assertThatEventually("executing work should see plan count increase", () -> ((RegionNormalizerWorker)worker).getMergePlanCount(), Matchers.greaterThan((Comparable)Long.valueOf(beforeMergePlanCount)));
    }

    @Test
    public void testSplitCounter() throws Exception {
        TableName tn = this.tableName.getTableName();
        TableDescriptor tnDescriptor = TableDescriptorBuilder.newBuilder((TableName)tn).setNormalizationEnabled(true).build();
        Mockito.when((Object)this.masterServices.getTableDescriptors().get(tn)).thenReturn((Object)tnDescriptor);
        Mockito.when((Object)this.masterServices.splitRegion((RegionInfo)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)1L);
        Mockito.when((Object)this.regionNormalizer.computePlansForTable(tn)).thenReturn(Collections.singletonList(new SplitNormalizationPlan(RegionInfoBuilder.newBuilder((TableName)tn).build(), 10L)));
        RegionNormalizerWorker worker = new RegionNormalizerWorker(this.testingUtility.getConfiguration(), this.masterServices, this.regionNormalizer, this.queue);
        long beforeSplitPlanCount = worker.getSplitPlanCount();
        this.workerPool.submit((Runnable)worker);
        this.queue.put((Object)tn);
        this.assertThatEventually("executing work should see plan count increase", () -> ((RegionNormalizerWorker)worker).getSplitPlanCount(), Matchers.greaterThan((Comparable)Long.valueOf(beforeSplitPlanCount)));
    }

    @Test
    public void testRateLimit() throws Exception {
        TableName tn = this.tableName.getTableName();
        TableDescriptor tnDescriptor = TableDescriptorBuilder.newBuilder((TableName)tn).setNormalizationEnabled(true).build();
        RegionInfo splitRegionInfo = RegionInfoBuilder.newBuilder((TableName)tn).build();
        RegionInfo mergeRegionInfo1 = RegionInfoBuilder.newBuilder((TableName)tn).build();
        RegionInfo mergeRegionInfo2 = RegionInfoBuilder.newBuilder((TableName)tn).build();
        Mockito.when((Object)this.masterServices.getTableDescriptors().get(tn)).thenReturn((Object)tnDescriptor);
        Mockito.when((Object)this.masterServices.splitRegion((RegionInfo)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)1L);
        Mockito.when((Object)this.masterServices.mergeRegions((RegionInfo[])ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)1L);
        Mockito.when((Object)this.regionNormalizer.computePlansForTable(tn)).thenReturn(Arrays.asList(new SplitNormalizationPlan(splitRegionInfo, 2L), new MergeNormalizationPlan.Builder().addTarget(mergeRegionInfo1, 1L).addTarget(mergeRegionInfo2, 2L).build(), new SplitNormalizationPlan(splitRegionInfo, 1L)));
        Configuration conf = this.testingUtility.getConfiguration();
        conf.set("hbase.normalizer.throughput.max_bytes_per_sec", "1m");
        RegionNormalizerWorker worker = new RegionNormalizerWorker(this.testingUtility.getConfiguration(), this.masterServices, this.regionNormalizer, this.queue);
        this.workerPool.submit((Runnable)worker);
        long startTime = System.nanoTime();
        this.queue.put((Object)tn);
        this.assertThatEventually("executing work should see split plan count increase", () -> ((RegionNormalizerWorker)worker).getSplitPlanCount(), Matchers.comparesEqualTo((Comparable)Long.valueOf(2L)));
        this.assertThatEventually("executing work should see merge plan count increase", () -> ((RegionNormalizerWorker)worker).getMergePlanCount(), Matchers.comparesEqualTo((Comparable)Long.valueOf(1L)));
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"rate limited normalizer should have taken at least 5 seconds", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Duration.ofSeconds(5L)));
    }

    private <T> void assertThatEventually(final String reason, final Supplier<? extends T> actualSupplier, final Matcher<? super T> matcher) throws Exception {
        this.testingUtility.waitFor(TimeUnit.SECONDS.toMillis(30L), (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){
            private T lastValue = null;

            public String explainFailure() {
                Description description = new StringDescription().appendText(reason).appendText("\nExpected: ").appendDescriptionOf((SelfDescribing)matcher).appendText("\n     but: ");
                matcher.describeMismatch(this.lastValue, description);
                return description.toString();
            }

            public boolean evaluate() {
                this.lastValue = actualSupplier.get();
                return matcher.matches(this.lastValue);
            }
        });
    }
}

