/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.compactions;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.compactions.MobCompactionRequest;
import org.apache.hadoop.hbase.mob.compactions.PartitionedMobCompactionRequest;
import org.apache.hadoop.hbase.mob.compactions.PartitionedMobCompactor;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestPartitionedMobCompactor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPartitionedMobCompactor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestPartitionedMobCompactor.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String family = "family";
    private static final String qf = "qf";
    private final long DAY_IN_MS = 86400000L;
    private static byte[] KEYS = Bytes.toBytes((String)"012");
    private HColumnDescriptor hcd = new HColumnDescriptor("family");
    private Configuration conf = TEST_UTIL.getConfiguration();
    private CacheConfig cacheConf = new CacheConfig(this.conf);
    private FileSystem fs;
    private List<FileStatus> mobFiles = new ArrayList<FileStatus>();
    private List<Path> delFiles = new ArrayList<Path>();
    private List<FileStatus> allFiles = new ArrayList<FileStatus>();
    private Path basePath;
    private String mobSuffix;
    private String delSuffix;
    private static ExecutorService pool;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.getConfiguration().setClass("fs.hdfs.impl", FaultyDistributedFileSystem.class, DistributedFileSystem.class);
        TEST_UTIL.startMiniCluster(1);
        pool = TestPartitionedMobCompactor.createThreadPool();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        pool.shutdown();
        TEST_UTIL.shutdownMiniCluster();
    }

    private void init(String tableName) throws Exception {
        this.fs = FileSystem.get((Configuration)this.conf);
        Path testDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        Path mobTestDir = new Path(testDir, "mobdir");
        this.basePath = new Path(new Path(mobTestDir, tableName), family);
        this.mobSuffix = TEST_UTIL.getRandomUUID().toString().replaceAll("-", "");
        this.delSuffix = TEST_UTIL.getRandomUUID().toString().replaceAll("-", "") + "_del";
        this.allFiles.clear();
        this.mobFiles.clear();
        this.delFiles.clear();
    }

    @Test
    public void testCompactionSelectAllFilesWeeklyPolicy() throws Exception {
        String tableName = "testCompactionSelectAllFilesWeeklyPolicy";
        this.testCompactionAtMergeSize(tableName, 0x50000000L, MobCompactionRequest.CompactionType.ALL_FILES, false, false, new Date(), MobCompactPartitionPolicy.WEEKLY, 1L);
    }

    @Test
    public void testCompactionSelectPartFilesWeeklyPolicy() throws Exception {
        String tableName = "testCompactionSelectPartFilesWeeklyPolicy";
        this.testCompactionAtMergeSize(tableName, 4000L, MobCompactionRequest.CompactionType.PART_FILES, false, false, new Date(), MobCompactPartitionPolicy.WEEKLY, 1L);
    }

    @Test
    public void testCompactionSelectPartFilesWeeklyPolicyWithPastWeek() throws Exception {
        String tableName = "testCompactionSelectPartFilesWeeklyPolicyWithPastWeek";
        Date dateLastWeek = new Date(System.currentTimeMillis() - 604800000L);
        this.testCompactionAtMergeSize(tableName, 700L, MobCompactionRequest.CompactionType.PART_FILES, false, false, dateLastWeek, MobCompactPartitionPolicy.WEEKLY, 7L);
    }

    @Test
    public void testCompactionSelectAllFilesWeeklyPolicyWithPastWeek() throws Exception {
        String tableName = "testCompactionSelectAllFilesWeeklyPolicyWithPastWeek";
        Date dateLastWeek = new Date(System.currentTimeMillis() - 604800000L);
        this.testCompactionAtMergeSize(tableName, 3000L, MobCompactionRequest.CompactionType.ALL_FILES, false, false, dateLastWeek, MobCompactPartitionPolicy.WEEKLY, 7L);
    }

    @Test
    public void testCompactionSelectAllFilesMonthlyPolicy() throws Exception {
        String tableName = "testCompactionSelectAllFilesMonthlyPolicy";
        Date dateLastWeek = new Date(System.currentTimeMillis() - 604800000L);
        this.testCompactionAtMergeSize(tableName, 0x50000000L, MobCompactionRequest.CompactionType.ALL_FILES, false, false, dateLastWeek, MobCompactPartitionPolicy.MONTHLY, 7L);
    }

    @Test
    public void testCompactionSelectNoFilesWithinCurrentWeekMonthlyPolicy() throws Exception {
        String tableName = "testCompactionSelectNoFilesWithinCurrentWeekMonthlyPolicy";
        this.testCompactionAtMergeSize(tableName, 0x50000000L, MobCompactionRequest.CompactionType.PART_FILES, false, false, new Date(), MobCompactPartitionPolicy.MONTHLY, 1L);
    }

    @Test
    public void testCompactionSelectPartFilesMonthlyPolicy() throws Exception {
        String tableName = "testCompactionSelectPartFilesMonthlyPolicy";
        this.testCompactionAtMergeSize(tableName, 4000L, MobCompactionRequest.CompactionType.PART_FILES, false, false, new Date(), MobCompactPartitionPolicy.MONTHLY, 1L);
    }

    @Test
    public void testCompactionSelectPartFilesMonthlyPolicyWithPastWeek() throws Exception {
        String tableName = "testCompactionSelectPartFilesMonthlyPolicyWithPastWeek";
        Date dateLastWeek = new Date(System.currentTimeMillis() - 604800000L);
        Calendar calendar = Calendar.getInstance();
        Date firstDayOfCurrentMonth = MobUtils.getFirstDayOfMonth((Calendar)calendar, (Date)new Date());
        MobCompactionRequest.CompactionType type = MobCompactionRequest.CompactionType.PART_FILES;
        long mergeSizeMultiFactor = 7L;
        if (dateLastWeek.before(firstDayOfCurrentMonth)) {
            type = MobCompactionRequest.CompactionType.ALL_FILES;
            mergeSizeMultiFactor *= 4L;
        }
        this.testCompactionAtMergeSize(tableName, 700L, type, false, false, dateLastWeek, MobCompactPartitionPolicy.MONTHLY, mergeSizeMultiFactor);
    }

    @Test
    public void testCompactionSelectAllFilesMonthlyPolicyWithPastWeek() throws Exception {
        String tableName = "testCompactionSelectAllFilesMonthlyPolicyWithPastWeek";
        Date dateLastWeek = new Date(System.currentTimeMillis() - 604800000L);
        this.testCompactionAtMergeSize(tableName, 3000L, MobCompactionRequest.CompactionType.ALL_FILES, false, false, dateLastWeek, MobCompactPartitionPolicy.MONTHLY, 7L);
    }

    @Test
    public void testCompactionSelectPartFilesMonthlyPolicyWithPastMonth() throws Exception {
        String tableName = "testCompactionSelectPartFilesMonthlyPolicyWithPastMonth";
        Date dateLastMonth = new Date(System.currentTimeMillis() - 3024000000L);
        this.testCompactionAtMergeSize(tableName, 200L, MobCompactionRequest.CompactionType.PART_FILES, false, false, dateLastMonth, MobCompactPartitionPolicy.MONTHLY, 28L);
    }

    @Test
    public void testCompactionSelectAllFilesMonthlyPolicyWithPastMonth() throws Exception {
        String tableName = "testCompactionSelectAllFilesMonthlyPolicyWithPastMonth";
        Date dateLastMonth = new Date(System.currentTimeMillis() - 3024000000L);
        this.testCompactionAtMergeSize(tableName, 750L, MobCompactionRequest.CompactionType.ALL_FILES, false, false, dateLastMonth, MobCompactPartitionPolicy.MONTHLY, 28L);
    }

    @Test
    public void testCompactionSelectWithAllFiles() throws Exception {
        String tableName = "testCompactionSelectWithAllFiles";
        this.testCompactionAtMergeSize(tableName, 0x50000000L, MobCompactionRequest.CompactionType.ALL_FILES, false, false);
    }

    @Test
    public void testCompactionSelectWithPartFiles() throws Exception {
        String tableName = "testCompactionSelectWithPartFiles";
        this.testCompactionAtMergeSize(tableName, 4000L, MobCompactionRequest.CompactionType.PART_FILES, false);
    }

    @Test
    public void testCompactionSelectWithForceAllFiles() throws Exception {
        String tableName = "testCompactionSelectWithForceAllFiles";
        this.testCompactionAtMergeSize(tableName, Long.MAX_VALUE, MobCompactionRequest.CompactionType.ALL_FILES, true);
    }

    private void testCompactionAtMergeSize(String tableName, long mergeSize, MobCompactionRequest.CompactionType type, boolean isForceAllFiles) throws Exception {
        this.testCompactionAtMergeSize(tableName, mergeSize, type, isForceAllFiles, true);
    }

    private void testCompactionAtMergeSize(String tableName, long mergeSize, MobCompactionRequest.CompactionType type, boolean isForceAllFiles, boolean createDelFiles) throws Exception {
        Date date = new Date();
        this.testCompactionAtMergeSize(tableName, mergeSize, type, isForceAllFiles, createDelFiles, date);
    }

    private void testCompactionAtMergeSize(String tableName, long mergeSize, MobCompactionRequest.CompactionType type, boolean isForceAllFiles, boolean createDelFiles, Date date) throws Exception {
        this.testCompactionAtMergeSize(tableName, mergeSize, type, isForceAllFiles, createDelFiles, date, MobCompactPartitionPolicy.DAILY, 1L);
    }

    private void testCompactionAtMergeSize(String tableName, long mergeSize, MobCompactionRequest.CompactionType type, boolean isForceAllFiles, boolean createDelFiles, Date date, MobCompactPartitionPolicy policy, long mergeSizeMultiFactor) throws Exception {
        this.resetConf();
        this.init(tableName);
        int count = 10;
        this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Put, date);
        if (createDelFiles) {
            this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Delete, date);
        }
        Calendar calendar = Calendar.getInstance();
        Date firstDayOfCurrentWeek = MobUtils.getFirstDayOfWeek((Calendar)calendar, (Date)new Date());
        this.listFiles();
        ArrayList<String> expectedStartKeys = new ArrayList<String>();
        for (FileStatus file : this.mobFiles) {
            if (file.getLen() >= mergeSize * mergeSizeMultiFactor) continue;
            String fileName = file.getPath().getName();
            String startKey = fileName.substring(0, 32);
            boolean skipCompaction = false;
            if (policy == MobCompactPartitionPolicy.MONTHLY) {
                Date fileDate;
                String fileDateStr = MobFileName.getDateFromName((String)fileName);
                try {
                    fileDate = MobUtils.parseDate((String)fileDateStr);
                }
                catch (ParseException e) {
                    LOG.warn("Failed to parse date " + fileDateStr, (Throwable)e);
                    fileDate = new Date();
                }
                if (!fileDate.before(firstDayOfCurrentWeek)) {
                    skipCompaction = true;
                }
            }
            if (!isForceAllFiles && (createDelFiles || skipCompaction)) continue;
            expectedStartKeys.add(startKey);
        }
        this.hcd.setMobCompactPartitionPolicy(policy);
        this.conf.setLong("hbase.mob.compaction.mergeable.threshold", mergeSize);
        this.testSelectFiles(tableName, type, isForceAllFiles, expectedStartKeys);
        this.hcd.setMobCompactPartitionPolicy(MobCompactPartitionPolicy.DAILY);
    }

    @Test
    public void testCompactDelFilesWithDefaultBatchSize() throws Exception {
        this.testCompactDelFilesAtBatchSize(this.name.getMethodName(), 100, 3);
    }

    @Test
    public void testCompactDelFilesWithSmallBatchSize() throws Exception {
        this.testCompactDelFilesAtBatchSize(this.name.getMethodName(), 4, 3);
    }

    @Test
    public void testCompactDelFilesChangeMaxDelFileCount() throws Exception {
        this.testCompactDelFilesAtBatchSize(this.name.getMethodName(), 4, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompactFilesWithDstDirFull() throws Exception {
        String tableName = this.name.getMethodName();
        this.fs = FileSystem.get((Configuration)this.conf);
        FaultyDistributedFileSystem faultyFs = (FaultyDistributedFileSystem)this.fs;
        Path testDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        Path mobTestDir = new Path(testDir, "mobdir");
        this.basePath = new Path(new Path(mobTestDir, tableName), family);
        try {
            int count = 2;
            this.createStoreFiles(this.basePath, family, qf, count, KeyValue.Type.Put, true, new Date());
            this.listFiles();
            TableName tName = TableName.valueOf((String)tableName);
            PartitionedMobCompactor compactor = new PartitionedMobCompactor(this.conf, (FileSystem)faultyFs, tName, (ColumnFamilyDescriptor)this.hcd, pool);
            faultyFs.setThrowException(true);
            try {
                compactor.compact(this.allFiles, true);
            }
            catch (IOException e) {
                System.out.println("Expected exception, ignore");
            }
            Path tempPath = new Path(MobUtils.getMobHome((Configuration)this.conf), ".tmp");
            FileStatus[] ls = faultyFs.listStatus(tempPath);
            Assert.assertTrue((ls.length == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)".bulkload".equalsIgnoreCase(ls[0].getPath().getName()));
            Path bulkloadPath = new Path(tempPath, new Path(".bulkload", new Path(tName.getNamespaceAsString(), tName.getQualifierAsString())));
            FileStatus[] lsBulkload = faultyFs.listStatus(bulkloadPath);
            Assert.assertTrue((lsBulkload.length == 0 ? 1 : 0) != 0);
        }
        finally {
            faultyFs.setThrowException(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMobFile(Path basePath) throws IOException {
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        MobFileName mobFileName = null;
        int ii = 0;
        Date today = new Date();
        for (byte k0 : KEYS) {
            byte[] startRow = Bytes.toBytes((int)ii++);
            mobFileName = MobFileName.create((byte[])startRow, (String)MobUtils.formatDate((Date)today), (String)this.mobSuffix);
            long now = System.currentTimeMillis();
            try (StoreFileWriter mobFileWriter = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFileContext(meta).withFilePath(new Path(basePath, mobFileName.getFileName())).build();){
                for (int i = 0; i < 10; ++i) {
                    byte[] key = Bytes.add((byte[])Bytes.toBytes((short)k0), (byte[])Bytes.toBytes((int)i));
                    byte[] dummyData = new byte[5000];
                    new Random().nextBytes(dummyData);
                    mobFileWriter.append((Cell)new KeyValue(key, Bytes.toBytes((String)family), Bytes.toBytes((String)qf), now, KeyValue.Type.Put, dummyData));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMobDelFile(Path basePath, int startKey) throws IOException {
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        MobFileName mobFileName = null;
        Date today = new Date();
        byte[] startRow = Bytes.toBytes((int)startKey);
        mobFileName = MobFileName.create((byte[])startRow, (String)MobUtils.formatDate((Date)today), (String)this.delSuffix);
        long now = System.currentTimeMillis();
        try (StoreFileWriter mobFileWriter = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFileContext(meta).withFilePath(new Path(basePath, mobFileName.getFileName())).build();){
            byte[] key = Bytes.add((byte[])Bytes.toBytes((short)KEYS[startKey]), (byte[])Bytes.toBytes((int)0));
            byte[] dummyData = new byte[5000];
            new Random().nextBytes(dummyData);
            mobFileWriter.append((Cell)new KeyValue(key, Bytes.toBytes((String)family), Bytes.toBytes((String)qf), now, KeyValue.Type.Delete, dummyData));
            key = Bytes.add((byte[])Bytes.toBytes((short)KEYS[startKey]), (byte[])Bytes.toBytes((int)2));
            mobFileWriter.append((Cell)new KeyValue(key, Bytes.toBytes((String)family), Bytes.toBytes((String)qf), now, KeyValue.Type.Delete, dummyData));
            key = Bytes.add((byte[])Bytes.toBytes((short)KEYS[startKey]), (byte[])Bytes.toBytes((int)4));
            mobFileWriter.append((Cell)new KeyValue(key, Bytes.toBytes((String)family), Bytes.toBytes((String)qf), now, KeyValue.Type.Delete, dummyData));
        }
    }

    @Test
    public void testCompactFilesWithoutDelFile() throws Exception {
        String tableName = "testCompactFilesWithoutDelFile";
        this.resetConf();
        this.init(tableName);
        this.createMobFile(this.basePath);
        this.listFiles();
        PartitionedMobCompactor compactor = new PartitionedMobCompactor(this.conf, this.fs, TableName.valueOf((String)tableName), (ColumnFamilyDescriptor)this.hcd, pool){

            public List<Path> compact(List<FileStatus> files, boolean isForceAllFiles) throws IOException {
                if (files == null || files.isEmpty()) {
                    return null;
                }
                PartitionedMobCompactionRequest request = this.select(files, isForceAllFiles);
                Assert.assertTrue((request.getDelPartitions().size() == 0 ? 1 : 0) != 0);
                for (PartitionedMobCompactionRequest.CompactionPartition p : request.getCompactionPartitions()) {
                    Assert.assertTrue((p.getStartKey() == null ? 1 : 0) != 0);
                    Assert.assertTrue((p.getEndKey() == null ? 1 : 0) != 0);
                }
                return null;
            }
        };
        compactor.compact(this.allFiles, true);
    }

    @Test
    public void testCompactFilesWithOneDelFile() throws Exception {
        String tableName = "testCompactFilesWithOneDelFile";
        this.resetConf();
        this.init(tableName);
        this.createMobFile(this.basePath);
        this.createMobDelFile(this.basePath, 2);
        this.listFiles();
        MyPartitionedMobCompactor compactor = new MyPartitionedMobCompactor(this.conf, this.fs, TableName.valueOf((String)tableName), (ColumnFamilyDescriptor)this.hcd, pool, 1, this.cacheConf, 1);
        compactor.compact(this.allFiles, true);
    }

    @Test
    public void testCompactFilesWithMultiDelFiles() throws Exception {
        String tableName = "testCompactFilesWithMultiDelFiles";
        this.resetConf();
        this.init(tableName);
        this.createMobFile(this.basePath);
        this.createMobDelFile(this.basePath, 0);
        this.createMobDelFile(this.basePath, 1);
        this.createMobDelFile(this.basePath, 2);
        this.listFiles();
        MyPartitionedMobCompactor compactor = new MyPartitionedMobCompactor(this.conf, this.fs, TableName.valueOf((String)tableName), (ColumnFamilyDescriptor)this.hcd, pool, 3, this.cacheConf, 3);
        compactor.compact(this.allFiles, true);
    }

    private void testCompactDelFilesAtBatchSize(String tableName, int batchSize, int delfileMaxCount) throws Exception {
        this.resetConf();
        this.init(tableName);
        this.createStoreFiles(this.basePath, family, qf, 20, KeyValue.Type.Put, new Date());
        this.createStoreFiles(this.basePath, family, qf, 13, KeyValue.Type.Delete, new Date());
        this.listFiles();
        this.conf.setInt("hbase.mob.delfile.max.count", delfileMaxCount);
        this.conf.setInt("hbase.mob.compaction.batch.size", batchSize);
        this.testCompactDelFiles(tableName, 1, 13, false);
    }

    private void testSelectFiles(String tableName, final MobCompactionRequest.CompactionType type, boolean isForceAllFiles, final List<String> expected) throws IOException {
        PartitionedMobCompactor compactor = new PartitionedMobCompactor(this.conf, this.fs, TableName.valueOf((String)tableName), (ColumnFamilyDescriptor)this.hcd, pool){

            public List<Path> compact(List<FileStatus> files, boolean isForceAllFiles) throws IOException {
                if (files == null || files.isEmpty()) {
                    return null;
                }
                PartitionedMobCompactionRequest request = this.select(files, isForceAllFiles);
                if (request.getDelPartitions().size() == 0) {
                    for (PartitionedMobCompactionRequest.CompactionPartition p : request.getCompactionPartitions()) {
                        Assert.assertTrue((p.getStartKey() == null ? 1 : 0) != 0);
                        Assert.assertTrue((p.getEndKey() == null ? 1 : 0) != 0);
                    }
                }
                Object prevDelP = null;
                for (PartitionedMobCompactionRequest.CompactionDelPartition delP : request.getDelPartitions()) {
                    Assert.assertTrue((Bytes.compareTo((byte[])delP.getId().getStartKey(), (byte[])delP.getId().getEndKey()) <= 0 ? 1 : 0) != 0);
                    if (prevDelP == null) continue;
                    Assert.assertTrue((Bytes.compareTo((byte[])prevDelP.getId().getEndKey(), (byte[])delP.getId().getStartKey()) < 0 ? 1 : 0) != 0);
                }
                for (PartitionedMobCompactionRequest.CompactionPartition partition : request.getCompactionPartitions()) {
                    List delFiles = this.getListOfDelFilesForPartition(partition, request.getDelPartitions());
                    if (request.getDelPartitions().isEmpty() || Bytes.compareTo((byte[])((PartitionedMobCompactionRequest.CompactionDelPartition)request.getDelPartitions().get(0)).getId().getStartKey(), (byte[])partition.getEndKey()) > 0 || Bytes.compareTo((byte[])((PartitionedMobCompactionRequest.CompactionDelPartition)request.getDelPartitions().get(request.getDelPartitions().size() - 1)).getId().getEndKey(), (byte[])partition.getStartKey()) < 0 || delFiles.size() <= 0) continue;
                    Assert.assertTrue((Bytes.compareTo((byte[])partition.getStartKey(), (byte[])((Cell)((HStoreFile)delFiles.get(0)).getFirstKey().get()).getRowArray()) >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((Bytes.compareTo((byte[])partition.getEndKey(), (byte[])((Cell)((HStoreFile)delFiles.get(delFiles.size() - 1)).getLastKey().get()).getRowArray()) <= 0 ? 1 : 0) != 0);
                }
                Assert.assertEquals((Object)type, (Object)request.type);
                TestPartitionedMobCompactor.this.compareCompactedPartitions(expected, request.compactionPartitions);
                TestPartitionedMobCompactor.this.compareDelFiles(request.getDelPartitions());
                return null;
            }
        };
        compactor.compact(this.allFiles, isForceAllFiles);
    }

    private void testCompactDelFiles(String tableName, final int expectedFileCount, final int expectedCellCount, boolean isForceAllFiles) throws IOException {
        PartitionedMobCompactor compactor = new PartitionedMobCompactor(this.conf, this.fs, TableName.valueOf((String)tableName), (ColumnFamilyDescriptor)this.hcd, pool){

            protected List<Path> performCompaction(PartitionedMobCompactionRequest request) throws IOException {
                ArrayList<Path> delFilePaths = new ArrayList<Path>();
                for (PartitionedMobCompactionRequest.CompactionDelPartition delPartition : request.getDelPartitions()) {
                    for (Path p : delPartition.listDelFiles()) {
                        delFilePaths.add(p);
                    }
                }
                List newDelPaths = this.compactDelFiles(request, delFilePaths);
                Assert.assertEquals((long)expectedFileCount, (long)newDelPaths.size());
                Assert.assertEquals((long)expectedCellCount, (long)TestPartitionedMobCompactor.this.countDelCellsInDelFiles(newDelPaths));
                return null;
            }
        };
        compactor.compact(this.allFiles, isForceAllFiles);
    }

    private void listFiles() throws IOException {
        for (FileStatus file : this.fs.listStatus(this.basePath)) {
            this.allFiles.add(file);
            if (file.getPath().getName().endsWith("_del")) {
                this.delFiles.add(file.getPath());
                continue;
            }
            this.mobFiles.add(file);
        }
    }

    private void compareCompactedPartitions(List<String> expected, Collection<PartitionedMobCompactionRequest.CompactionPartition> partitions) {
        ArrayList<String> actualKeys = new ArrayList<String>();
        for (PartitionedMobCompactionRequest.CompactionPartition partition : partitions) {
            actualKeys.add(partition.getPartitionId().getStartKey());
        }
        Collections.sort(expected);
        Collections.sort(actualKeys);
        Assert.assertEquals((long)expected.size(), (long)actualKeys.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), actualKeys.get(i));
        }
    }

    private void compareDelFiles(List<PartitionedMobCompactionRequest.CompactionDelPartition> delPartitions) {
        HashMap<Path, Path> delMap = new HashMap<Path, Path>();
        for (PartitionedMobCompactionRequest.CompactionDelPartition delPartition : delPartitions) {
            for (Path f : delPartition.listDelFiles()) {
                delMap.put(f, f);
            }
        }
        for (Path f : this.delFiles) {
            Assert.assertTrue((boolean)delMap.containsKey(f));
        }
    }

    private void createStoreFiles(Path basePath, String family, String qualifier, int count, KeyValue.Type type, Date date) throws IOException {
        this.createStoreFiles(basePath, family, qualifier, count, type, false, date);
    }

    private void createStoreFiles(Path basePath, String family, String qualifier, int count, KeyValue.Type type, boolean sameStartKey, Date date) throws IOException {
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        String startKey = "row_";
        MobFileName mobFileName = null;
        for (int i = 0; i < count; ++i) {
            byte[] startRow;
            if (sameStartKey) {
                startRow = Bytes.toBytes((String)startKey);
                this.mobSuffix = TEST_UTIL.getRandomUUID().toString().replaceAll("-", "");
                this.delSuffix = TEST_UTIL.getRandomUUID().toString().replaceAll("-", "") + "_del";
            } else {
                startRow = Bytes.toBytes((String)(startKey + i));
            }
            if (type.equals((Object)KeyValue.Type.Delete)) {
                mobFileName = MobFileName.create((byte[])startRow, (String)MobUtils.formatDate((Date)date), (String)this.delSuffix);
            }
            if (type.equals((Object)KeyValue.Type.Put)) {
                mobFileName = MobFileName.create((byte[])startRow, (String)MobUtils.formatDate((Date)date), (String)this.mobSuffix);
            }
            StoreFileWriter mobFileWriter = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFileContext(meta).withFilePath(new Path(basePath, mobFileName.getFileName())).build();
            TestPartitionedMobCompactor.writeStoreFile(mobFileWriter, startRow, Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier), type, (i + 1) * 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStoreFile(StoreFileWriter writer, byte[] row, byte[] family, byte[] qualifier, KeyValue.Type type, int size) throws IOException {
        long now = System.currentTimeMillis();
        try {
            byte[] dummyData = new byte[size];
            new Random().nextBytes(dummyData);
            writer.append((Cell)new KeyValue(row, family, qualifier, now, type, dummyData));
        }
        finally {
            writer.close();
        }
    }

    private int countDelCellsInDelFiles(List<Path> paths) throws IOException {
        ArrayList<HStoreFile> sfs = new ArrayList<HStoreFile>();
        int size = 0;
        for (Path path : paths) {
            HStoreFile sf = new HStoreFile(this.fs, path, this.conf, this.cacheConf, BloomType.NONE, true);
            sfs.add(sf);
        }
        ArrayList scanners = new ArrayList(StoreFileScanner.getScannersForStoreFiles(sfs, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (long)Long.MAX_VALUE));
        long timeToPurgeDeletes = Math.max(this.conf.getLong("hbase.hstore.time.to.purge.deletes", 0L), 0L);
        long ttl = HStore.determineTTLFromFamily((ColumnFamilyDescriptor)this.hcd);
        ScanInfo scanInfo = new ScanInfo(this.conf, (ColumnFamilyDescriptor)this.hcd, ttl, timeToPurgeDeletes, (CellComparator)CellComparatorImpl.COMPARATOR);
        StoreScanner scanner = new StoreScanner(scanInfo, ScanType.COMPACT_RETAIN_DELETES, scanners);
        ArrayList results = new ArrayList();
        boolean hasMore = true;
        while (hasMore) {
            hasMore = scanner.next(results);
            size += results.size();
            results.clear();
        }
        scanner.close();
        return size;
    }

    private static ExecutorService createThreadPool() {
        int maxThreads = 10;
        long keepAliveTime = 60L;
        SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, queue, new ThreadFactoryBuilder().setNameFormat("MobFileCompactionChore-pool-%d").setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), (r, executor) -> {
            try {
                queue.put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        });
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private void resetConf() {
        this.conf.setLong("hbase.mob.compaction.mergeable.threshold", 0x50000000L);
        this.conf.setInt("hbase.mob.delfile.max.count", 3);
        this.conf.setInt("hbase.mob.compaction.batch.size", 100);
    }

    static class FaultyDistributedFileSystem
    extends DistributedFileSystem {
        private volatile boolean throwException = false;

        public void setThrowException(boolean throwException) {
            this.throwException = throwException;
        }

        public boolean rename(Path src, Path dst) throws IOException {
            if (this.throwException) {
                throw new IOException("No more files allowed");
            }
            return super.rename(src, dst);
        }
    }

    static class MyPartitionedMobCompactor
    extends PartitionedMobCompactor {
        int delPartitionSize = 0;
        int PartitionsIncludeDelFiles = 0;
        CacheConfig cacheConfig = null;

        MyPartitionedMobCompactor(Configuration conf, FileSystem fs, TableName tableName, ColumnFamilyDescriptor column, ExecutorService pool, int delPartitionSize, CacheConfig cacheConf, int PartitionsIncludeDelFiles) throws IOException {
            super(conf, fs, tableName, column, pool);
            this.delPartitionSize = delPartitionSize;
            this.cacheConfig = cacheConf;
            this.PartitionsIncludeDelFiles = PartitionsIncludeDelFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Path> compact(List<FileStatus> files, boolean isForceAllFiles) throws IOException {
            if (files == null || files.isEmpty()) {
                return null;
            }
            PartitionedMobCompactionRequest request = this.select(files, isForceAllFiles);
            Assert.assertTrue((request.getDelPartitions().size() == this.delPartitionSize ? 1 : 0) != 0);
            if (request.getDelPartitions().size() > 0) {
                for (PartitionedMobCompactionRequest.CompactionPartition p : request.getCompactionPartitions()) {
                    Assert.assertTrue((p.getStartKey() != null ? 1 : 0) != 0);
                    Assert.assertTrue((p.getEndKey() != null ? 1 : 0) != 0);
                }
            }
            try {
                for (Object delPartition : request.getDelPartitions()) {
                    for (Path newDelPath : delPartition.listDelFiles()) {
                        HStoreFile sf = new HStoreFile(this.fs, newDelPath, this.conf, this.cacheConfig, BloomType.NONE, true);
                        sf.initReader();
                        delPartition.addStoreFile(sf);
                    }
                }
                Object prevDelP = null;
                for (PartitionedMobCompactionRequest.CompactionDelPartition delP : request.getDelPartitions()) {
                    Assert.assertTrue((Bytes.compareTo((byte[])delP.getId().getStartKey(), (byte[])delP.getId().getEndKey()) <= 0 ? 1 : 0) != 0);
                    if (prevDelP == null) continue;
                    Assert.assertTrue((Bytes.compareTo((byte[])prevDelP.getId().getEndKey(), (byte[])delP.getId().getStartKey()) < 0 ? 1 : 0) != 0);
                }
                int affectedPartitions = 0;
                for (PartitionedMobCompactionRequest.CompactionPartition partition : request.getCompactionPartitions()) {
                    List delFiles = this.getListOfDelFilesForPartition(partition, request.getDelPartitions());
                    if (request.getDelPartitions().isEmpty() || Bytes.compareTo((byte[])((PartitionedMobCompactionRequest.CompactionDelPartition)request.getDelPartitions().get(0)).getId().getStartKey(), (byte[])partition.getEndKey()) > 0 || Bytes.compareTo((byte[])((PartitionedMobCompactionRequest.CompactionDelPartition)request.getDelPartitions().get(request.getDelPartitions().size() - 1)).getId().getEndKey(), (byte[])partition.getStartKey()) < 0 || delFiles.size() <= 0) continue;
                    Assert.assertTrue((delFiles.size() == 1 ? 1 : 0) != 0);
                    affectedPartitions += delFiles.size();
                    Assert.assertTrue((Bytes.compareTo((byte[])partition.getStartKey(), (byte[])CellUtil.cloneRow((Cell)((Cell)((HStoreFile)delFiles.get(0)).getLastKey().get()))) <= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((Bytes.compareTo((byte[])partition.getEndKey(), (byte[])CellUtil.cloneRow((Cell)((Cell)((HStoreFile)delFiles.get(delFiles.size() - 1)).getFirstKey().get()))) >= 0 ? 1 : 0) != 0);
                }
                Assert.assertTrue((affectedPartitions == this.PartitionsIncludeDelFiles ? 1 : 0) != 0);
            }
            finally {
                for (PartitionedMobCompactionRequest.CompactionDelPartition delPartition : request.getDelPartitions()) {
                    for (HStoreFile storeFile : delPartition.getStoreFiles()) {
                        try {
                            storeFile.closeStoreFile(true);
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to close the reader on store file " + storeFile.getPath(), (Throwable)e);
                        }
                    }
                }
            }
            return null;
        }
    }
}

