/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestHRegionFileSystem {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionFileSystem.class);
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegionFileSystem.class);
    public static final byte[] FAMILY_NAME = Bytes.toBytes((String)"info");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.add((byte[])FAMILY_NAME, (byte[])Bytes.toBytes((String)"-A")), Bytes.add((byte[])FAMILY_NAME, (byte[])Bytes.toBytes((String)"-B"))};
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestTable");
    @Rule
    public TestName name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockStoragePolicy() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster();
        HTable table = (HTable)TEST_UTIL.createTable(TABLE_NAME, FAMILIES);
        Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)TEST_UTIL.countRows((Table)table));
        HRegionFileSystem regionFs = this.getHRegionFS(table, conf);
        String spA = regionFs.getStoragePolicyName(Bytes.toString((byte[])FAMILIES[0]));
        String spB = regionFs.getStoragePolicyName(Bytes.toString((byte[])FAMILIES[1]));
        LOG.debug("Storage policy of cf 0: [" + spA + "].");
        LOG.debug("Storage policy of cf 1: [" + spB + "].");
        Assert.assertEquals((Object)"HOT", (Object)spA);
        Assert.assertEquals((Object)"HOT", (Object)spB);
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.getConfiguration().set("hbase.hstore.block.storage.policy", "WARM");
        TEST_UTIL.startMiniCluster();
        table = (HTable)TEST_UTIL.createTable(TABLE_NAME, FAMILIES);
        regionFs = this.getHRegionFS(table, conf);
        try (Admin admin = TEST_UTIL.getConnection().getAdmin();){
            spA = regionFs.getStoragePolicyName(Bytes.toString((byte[])FAMILIES[0]));
            spB = regionFs.getStoragePolicyName(Bytes.toString((byte[])FAMILIES[1]));
            LOG.debug("Storage policy of cf 0: [" + spA + "].");
            LOG.debug("Storage policy of cf 1: [" + spB + "].");
            Assert.assertEquals((Object)"WARM", (Object)spA);
            Assert.assertEquals((Object)"WARM", (Object)spB);
            HColumnDescriptor hcdA = new HColumnDescriptor(Bytes.toString((byte[])FAMILIES[0]));
            hcdA.setValue("hbase.hstore.block.storage.policy", "ONE_SSD");
            admin.modifyColumnFamily(TABLE_NAME, (ColumnFamilyDescriptor)hcdA);
            while (TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().hasRegionsInTransition()) {
                Thread.sleep(200L);
                LOG.debug("Waiting on table to finish schema altering");
            }
            HColumnDescriptor hcdB = new HColumnDescriptor(Bytes.toString((byte[])FAMILIES[1]));
            hcdB.setStoragePolicy("ALL_SSD");
            admin.modifyColumnFamily(TABLE_NAME, (ColumnFamilyDescriptor)hcdB);
            while (TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().hasRegionsInTransition()) {
                Thread.sleep(200L);
                LOG.debug("Waiting on table to finish schema altering");
            }
            spA = regionFs.getStoragePolicyName(Bytes.toString((byte[])FAMILIES[0]));
            spB = regionFs.getStoragePolicyName(Bytes.toString((byte[])FAMILIES[1]));
            LOG.debug("Storage policy of cf 0: [" + spA + "].");
            LOG.debug("Storage policy of cf 1: [" + spB + "].");
            Assert.assertNotNull((Object)spA);
            Assert.assertEquals((Object)"ONE_SSD", (Object)spA);
            Assert.assertNotNull((Object)spB);
            Assert.assertEquals((Object)"ALL_SSD", (Object)spB);
            for (long i = 0L; i < 3L; ++i) {
                Put put = new Put(Bytes.toBytes((long)i));
                put.addColumn(FAMILIES[0], Bytes.toBytes((long)i), Bytes.toBytes((long)i));
                table.put(put);
                admin.flush(TABLE_NAME);
            }
            DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
            Path storePath = regionFs.getStoreDir(Bytes.toString((byte[])FAMILIES[0]));
            FileStatus[] storeFiles = CommonFSUtils.listStatus((FileSystem)fs, (Path)storePath);
            Assert.assertNotNull((Object)storeFiles);
            Assert.assertEquals((long)3L, (long)storeFiles.length);
            Path storeTempDir = new Path(regionFs.getTempDir(), Bytes.toString((byte[])FAMILIES[0]));
            Assert.assertTrue((boolean)fs.exists(storeTempDir));
            FileStatus[] tempFiles = CommonFSUtils.listStatus((FileSystem)fs, (Path)storeTempDir);
            Assert.assertNull((Object)tempFiles);
            Assert.assertEquals((Object)"ONE_SSD", (Object)((HFileSystem)regionFs.getFileSystem()).getStoragePolicyName(storeTempDir));
            for (FileStatus status : storeFiles) {
                Assert.assertEquals((Object)"ONE_SSD", (Object)((HFileSystem)regionFs.getFileSystem()).getStoragePolicyName(status.getPath()));
            }
            regionFs.setStoragePolicy(Bytes.toString((byte[])FAMILIES[0]), "ALL_SSD");
            regionFs.setStoragePolicy(Bytes.toString((byte[])FAMILIES[1]), "ONE_SSD");
            spA = regionFs.getStoragePolicyName(Bytes.toString((byte[])FAMILIES[0]));
            spB = regionFs.getStoragePolicyName(Bytes.toString((byte[])FAMILIES[1]));
            LOG.debug("Storage policy of cf 0: [" + spA + "].");
            LOG.debug("Storage policy of cf 1: [" + spB + "].");
            Assert.assertNotNull((Object)spA);
            Assert.assertEquals((Object)"ALL_SSD", (Object)spA);
            Assert.assertNotNull((Object)spB);
            Assert.assertEquals((Object)"ONE_SSD", (Object)spB);
        }
        finally {
            table.close();
            TEST_UTIL.deleteTable(TABLE_NAME);
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    private HRegionFileSystem getHRegionFS(HTable table, Configuration conf) throws IOException {
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        Path tableDir = CommonFSUtils.getTableDir((Path)TEST_UTIL.getDefaultRootDirPath(), (TableName)table.getName());
        List regionDirs = FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir);
        Assert.assertEquals((long)1L, (long)regionDirs.size());
        List familyDirs = FSUtils.getFamilyDirs((FileSystem)fs, (Path)((Path)regionDirs.get(0)));
        Assert.assertEquals((long)2L, (long)familyDirs.size());
        HRegionInfo hri = ((HRegionLocation)table.getRegionLocator().getAllRegionLocations().get(0)).getRegionInfo();
        HRegionFileSystem regionFs = new HRegionFileSystem(conf, (FileSystem)new HFileSystem((FileSystem)fs), tableDir, (RegionInfo)hri);
        return regionFs;
    }

    @Test
    public void testOnDiskRegionCreation() throws IOException {
        Path rootDir = TEST_UTIL.getDataTestDirOnTestFS(this.name.getMethodName());
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)conf, (FileSystem)fs, (Path)CommonFSUtils.getTableDir((Path)rootDir, (TableName)hri.getTable()), (RegionInfo)hri);
        Path regionDir = regionFs.getRegionDir();
        Assert.assertTrue((String)"The region folder should be created", (boolean)fs.exists(regionDir));
        RegionInfo hriVerify = HRegionFileSystem.loadRegionInfoFileContent((FileSystem)fs, (Path)regionDir);
        Assert.assertEquals((Object)hri, (Object)hriVerify);
        regionFs = HRegionFileSystem.openRegionFromFileSystem((Configuration)conf, (FileSystem)fs, (Path)CommonFSUtils.getTableDir((Path)rootDir, (TableName)hri.getTable()), (RegionInfo)hri, (boolean)false);
        Assert.assertEquals((Object)regionDir, (Object)regionFs.getRegionDir());
        HRegionFileSystem.deleteRegionFromFileSystem((Configuration)conf, (FileSystem)fs, (Path)CommonFSUtils.getTableDir((Path)rootDir, (TableName)hri.getTable()), (RegionInfo)hri);
        Assert.assertFalse((String)"The region folder should be removed", (boolean)fs.exists(regionDir));
        fs.delete(rootDir, true);
    }

    @Test
    public void testNonIdempotentOpsWithRetries() throws IOException {
        Path rootDir = TEST_UTIL.getDataTestDirOnTestFS(this.name.getMethodName());
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)conf, (FileSystem)fs, (Path)rootDir, (RegionInfo)hri);
        Assert.assertTrue((boolean)fs.exists(regionFs.getRegionDir()));
        regionFs = new HRegionFileSystem(conf, (FileSystem)new MockFileSystemForCreate(), rootDir, hri);
        boolean result = regionFs.createDir(new Path("/foo/bar"));
        Assert.assertTrue((String)"Couldn't create the directory", (boolean)result);
        regionFs = new HRegionFileSystem(conf, (FileSystem)new MockFileSystem(), rootDir, hri);
        result = regionFs.rename(new Path("/foo/bar"), new Path("/foo/bar2"));
        Assert.assertTrue((String)"Couldn't rename the directory", (boolean)result);
        regionFs = new HRegionFileSystem(conf, (FileSystem)new MockFileSystem(), rootDir, hri);
        result = regionFs.deleteDir(new Path("/foo/bar"));
        Assert.assertTrue((String)"Couldn't delete the directory", (boolean)result);
        fs.delete(rootDir, true);
    }

    @Test
    public void testTempAndCommit() throws IOException {
        Path rootDir = TEST_UTIL.getDataTestDirOnTestFS("testTempAndCommit");
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        String familyName = "cf";
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)conf, (FileSystem)fs, (Path)rootDir, (RegionInfo)hri);
        Collection storeFiles = regionFs.getStoreFiles(familyName);
        Assert.assertEquals((long)0L, (long)(storeFiles != null ? (long)storeFiles.size() : 0L));
        Path buildPath = regionFs.createTempName();
        fs.createNewFile(buildPath);
        storeFiles = regionFs.getStoreFiles(familyName);
        Assert.assertEquals((long)0L, (long)(storeFiles != null ? (long)storeFiles.size() : 0L));
        Path dstPath = regionFs.commitStoreFile(familyName, buildPath);
        storeFiles = regionFs.getStoreFiles(familyName);
        Assert.assertEquals((long)0L, (long)(storeFiles != null ? (long)storeFiles.size() : 0L));
        Assert.assertFalse((boolean)fs.exists(buildPath));
        fs.delete(rootDir, true);
    }

    static class MockFileSystem
    extends FileSystem {
        int retryCount = 0;
        static final int successRetryCount = 3;

        public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
            throw new IOException("");
        }

        public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
            LOG.debug((Object)("Create, " + this.retryCount));
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return null;
        }

        public boolean delete(Path arg0) throws IOException {
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return true;
        }

        public boolean delete(Path arg0, boolean arg1) throws IOException {
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return true;
        }

        public FileStatus getFileStatus(Path arg0) throws IOException {
            FileStatus fs = new FileStatus();
            return fs;
        }

        public boolean exists(Path path) {
            return true;
        }

        public URI getUri() {
            throw new RuntimeException("Something bad happen");
        }

        public Path getWorkingDirectory() {
            throw new RuntimeException("Something bad happen");
        }

        public FileStatus[] listStatus(Path arg0) throws IOException {
            throw new IOException("Something bad happen");
        }

        public boolean mkdirs(Path arg0, FsPermission arg1) throws IOException {
            LOG.debug((Object)("mkdirs, " + this.retryCount));
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return true;
        }

        public FSDataInputStream open(Path arg0, int arg1) throws IOException {
            throw new IOException("Something bad happen");
        }

        public boolean rename(Path arg0, Path arg1) throws IOException {
            LOG.debug((Object)("rename, " + this.retryCount));
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return true;
        }

        public void setWorkingDirectory(Path arg0) {
            throw new RuntimeException("Something bad happen");
        }
    }

    static class MockFileSystemForCreate
    extends MockFileSystem {
        MockFileSystemForCreate() {
        }

        @Override
        public boolean exists(Path path) {
            return false;
        }
    }
}

