/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.regionserver.MetricsTable;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperStub;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestMetricsTableAggregate {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsTableAggregate.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetricsTableAggregate.class);
    private static MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private String tableName = "testTableMetrics";
    private String pre = "Namespace_default_table_" + this.tableName + "_metric_";
    private MetricsTableWrapperStub tableWrapper;
    private MetricsTable mt;
    private MetricsRegionServerWrapper rsWrapper;
    private MetricsRegionServer rsm;
    private MetricsTableAggregateSource agg;

    @BeforeClass
    public static void classSetUp() {
        HELPER.init();
    }

    @Before
    public void setUp() {
        this.tableWrapper = new MetricsTableWrapperStub(this.tableName);
        this.mt = new MetricsTable((MetricsTableWrapperAggregate)this.tableWrapper);
        this.rsWrapper = new MetricsRegionServerWrapperStub();
        Configuration conf = new Configuration();
        this.rsm = new MetricsRegionServer(this.rsWrapper, conf, this.mt);
        this.agg = this.mt.getTableSourceAgg();
    }

    @Test
    public void testRequestMetrics() throws IOException {
        HELPER.assertCounter(this.pre + "readRequestCount", 10L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "writeRequestCount", 20L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "totalRequestCount", 30L, (BaseSource)this.agg);
    }

    @Test
    public void testRegionAndStoreMetrics() throws IOException {
        HELPER.assertGauge(this.pre + "memstoreSize", 1000L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "storeFileSize", 2000L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "tableSize", 3000L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "regionCount", 11L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "storeCount", 22L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "storeFileCount", 33L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "maxStoreFileAge", 44L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "minStoreFileAge", 55L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "avgStoreFileAge", 66L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "numReferenceFiles", 77L, (BaseSource)this.agg);
        HELPER.assertGauge(this.pre + "averageRegionSize", 88L, (BaseSource)this.agg);
    }

    @Test
    public void testFlush() {
        this.rsm.updateFlush(this.tableName, 1L, 2L, 3L);
        HELPER.assertCounter(this.pre + "flushTime_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "flushMemstoreSize_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "flushOutputSize_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "flushedMemstoreBytes", 2L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "flushedOutputBytes", 3L, (BaseSource)this.agg);
        this.rsm.updateFlush(this.tableName, 10L, 20L, 30L);
        HELPER.assertCounter(this.pre + "flushTime_num_ops", 2L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "flushMemstoreSize_num_ops", 2L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "flushOutputSize_num_ops", 2L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "flushedMemstoreBytes", 22L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "flushedOutputBytes", 33L, (BaseSource)this.agg);
    }

    @Test
    public void testCompaction() {
        this.rsm.updateCompaction(this.tableName, false, 1L, 2, 3, 4L, 5L);
        HELPER.assertCounter(this.pre + "compactionTime_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionInputFileCount_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionInputSize_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionOutputFileCount_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactedInputBytes", 4L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactedoutputBytes", 5L, (BaseSource)this.agg);
        this.rsm.updateCompaction(this.tableName, false, 10L, 20, 30, 40L, 50L);
        HELPER.assertCounter(this.pre + "compactionTime_num_ops", 2L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionInputFileCount_num_ops", 2L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionInputSize_num_ops", 2L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionOutputFileCount_num_ops", 2L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactedInputBytes", 44L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactedoutputBytes", 55L, (BaseSource)this.agg);
        this.rsm.updateCompaction(this.tableName, true, 100L, 200, 300, 400L, 500L);
        HELPER.assertCounter(this.pre + "compactionTime_num_ops", 3L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionInputFileCount_num_ops", 3L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionInputSize_num_ops", 3L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactionOutputFileCount_num_ops", 3L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactedInputBytes", 444L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "compactedoutputBytes", 555L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "majorCompactionTime_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "majorCompactionInputFileCount_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "majorCompactionInputSize_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "majorCompactionOutputFileCount_num_ops", 1L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "majorCompactedInputBytes", 400L, (BaseSource)this.agg);
        HELPER.assertCounter(this.pre + "majorCompactedoutputBytes", 500L, (BaseSource)this.agg);
    }

    private void update(AtomicBoolean succ, int round, CyclicBarrier barrier) {
        try {
            for (int i = 0; i < round; ++i) {
                String tn = this.tableName + "-" + i;
                barrier.await(10L, TimeUnit.SECONDS);
                this.rsm.updateFlush(tn, 100L, 1000L, 500L);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to update metrics", (Throwable)e);
            succ.set(false);
        }
    }

    @Test
    public void testConcurrentUpdate() throws InterruptedException {
        int threadNumber = 10;
        int round = 100;
        AtomicBoolean succ = new AtomicBoolean(true);
        CyclicBarrier barrier = new CyclicBarrier(threadNumber);
        Thread[] threads = (Thread[])IntStream.range(0, threadNumber).mapToObj(i -> new Thread(() -> this.update(succ, round, barrier), "Update-Worker-" + i)).toArray(Thread[]::new);
        Stream.of(threads).forEach(Thread::start);
        for (Thread t : threads) {
            t.join();
        }
        Assert.assertTrue((boolean)succ.get());
    }
}

